/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.znet;

import java.util.ArrayList;
import java.util.List;
import se.krka.kahlua.vm.KahluaTable;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.core.znet.GameServerDetails;
import zombie.core.znet.IServerBrowserCallback;
import zombie.core.znet.SteamUtils;
import zombie.network.Server;

public class ServerBrowser {
    private static IServerBrowserCallback m_callbackInterface = null;

    public static boolean init() {
        boolean bl = false;
        if (SteamUtils.isSteamModeEnabled()) {
            bl = ServerBrowser.n_Init();
        }
        return bl;
    }

    public static void shutdown() {
        if (SteamUtils.isSteamModeEnabled()) {
            ServerBrowser.n_Shutdown();
        }
    }

    public static void RefreshInternetServers() {
        if (SteamUtils.isSteamModeEnabled()) {
            ServerBrowser.n_RefreshInternetServers();
        }
    }

    public static int GetServerCount() {
        int n = 0;
        if (SteamUtils.isSteamModeEnabled()) {
            n = ServerBrowser.n_GetServerCount();
        }
        return n;
    }

    public static GameServerDetails GetServerDetails(int n) {
        GameServerDetails gameServerDetails = null;
        if (SteamUtils.isSteamModeEnabled()) {
            gameServerDetails = ServerBrowser.n_GetServerDetails(n);
        }
        return gameServerDetails;
    }

    public static void Release() {
        if (SteamUtils.isSteamModeEnabled()) {
            ServerBrowser.n_Release();
        }
    }

    public static boolean IsRefreshing() {
        boolean bl = false;
        if (SteamUtils.isSteamModeEnabled()) {
            bl = ServerBrowser.n_IsRefreshing();
        }
        return bl;
    }

    public static boolean QueryServer(String string, int n) {
        boolean bl = false;
        if (SteamUtils.isSteamModeEnabled()) {
            bl = ServerBrowser.n_QueryServer(string, n);
        }
        return bl;
    }

    public static GameServerDetails GetServerDetails(String string, int n) {
        GameServerDetails gameServerDetails = null;
        if (SteamUtils.isSteamModeEnabled()) {
            gameServerDetails = ServerBrowser.n_GetServerDetails(string, n);
        }
        return gameServerDetails;
    }

    public static void ReleaseServerQuery(String string, int n) {
        if (SteamUtils.isSteamModeEnabled()) {
            ServerBrowser.n_ReleaseServerQuery(string, n);
        }
    }

    public static List<GameServerDetails> GetServerList() {
        ArrayList<GameServerDetails> arrayList = new ArrayList<GameServerDetails>();
        if (SteamUtils.isSteamModeEnabled()) {
            try {
                while (ServerBrowser.IsRefreshing()) {
                    Thread.sleep(100L);
                    SteamUtils.runLoop();
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            for (int i = 0; i < ServerBrowser.GetServerCount(); ++i) {
                GameServerDetails gameServerDetails = ServerBrowser.GetServerDetails(i);
                if (gameServerDetails.steamId == 0L) continue;
                arrayList.add(gameServerDetails);
            }
        }
        return arrayList;
    }

    public static GameServerDetails GetServerDetailsSync(String string, int n) {
        GameServerDetails gameServerDetails = null;
        if (SteamUtils.isSteamModeEnabled() && (gameServerDetails = ServerBrowser.GetServerDetails(string, n)) == null) {
            ServerBrowser.QueryServer(string, n);
            try {
                while (gameServerDetails == null) {
                    Thread.sleep(100L);
                    SteamUtils.runLoop();
                    gameServerDetails = ServerBrowser.GetServerDetails(string, n);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return gameServerDetails;
    }

    public static boolean RequestServerRules(String string, int n) {
        return ServerBrowser.n_RequestServerRules(string, n);
    }

    public static void setCallbackInterface(IServerBrowserCallback iServerBrowserCallback) {
        m_callbackInterface = iServerBrowserCallback;
    }

    private static native boolean n_Init();

    private static native void n_Shutdown();

    private static native void n_RefreshInternetServers();

    private static native int n_GetServerCount();

    private static native GameServerDetails n_GetServerDetails(int var0);

    private static native void n_Release();

    private static native boolean n_IsRefreshing();

    private static native boolean n_QueryServer(String var0, int var1);

    private static native GameServerDetails n_GetServerDetails(String var0, int var1);

    private static native void n_ReleaseServerQuery(String var0, int var1);

    private static native boolean n_RequestServerRules(String var0, int var1);

    private static void onServerRespondedCallback(int n) {
        if (m_callbackInterface != null) {
            m_callbackInterface.OnServerResponded(n);
        }
        LuaEventManager.triggerEvent("OnSteamServerResponded", n);
    }

    private static void onServerFailedToRespondCallback(int n) {
        if (m_callbackInterface != null) {
            m_callbackInterface.OnServerFailedToRespond(n);
        }
    }

    private static void onRefreshCompleteCallback() {
        if (m_callbackInterface != null) {
            m_callbackInterface.OnRefreshComplete();
        }
        LuaEventManager.triggerEvent("OnSteamRefreshInternetServers");
    }

    private static void onServerRespondedCallback(String string, int n) {
        GameServerDetails gameServerDetails;
        if (m_callbackInterface != null) {
            m_callbackInterface.OnServerResponded(string, n);
        }
        if ((gameServerDetails = ServerBrowser.GetServerDetails(string, n)) == null) {
            return;
        }
        Server server = new Server();
        server.setName(gameServerDetails.name);
        server.setDescription("");
        server.setSteamId(Long.toString(gameServerDetails.steamId));
        server.setPing(Integer.toString(gameServerDetails.ping));
        server.setPlayers(Integer.toString(gameServerDetails.numPlayers));
        server.setMaxPlayers(Integer.toString(gameServerDetails.maxPlayers));
        server.setOpen(true);
        if (gameServerDetails.tags.contains("hidden")) {
            server.setOpen(false);
        }
        server.setIp(gameServerDetails.address);
        server.setPort(Integer.toString(gameServerDetails.port));
        server.setMods("");
        if (!gameServerDetails.tags.replace("hidden", "").replace("hosted", "").replace(";", "").isEmpty()) {
            server.setMods(gameServerDetails.tags.replace(";hosted", "").replace("hidden", ""));
        }
        server.setHosted(gameServerDetails.tags.endsWith(";hosted"));
        server.setVersion("");
        server.setLastUpdate(1);
        server.setPasswordProtected(gameServerDetails.passwordProtected);
        ServerBrowser.ReleaseServerQuery(string, n);
        LuaEventManager.triggerEvent("OnSteamServerResponded2", string, n, server);
    }

    private static void onServerFailedToRespondCallback(String string, int n) {
        if (m_callbackInterface != null) {
            m_callbackInterface.OnServerFailedToRespond(string, n);
        }
        LuaEventManager.triggerEvent("OnSteamServerFailedToRespond2", string, n);
    }

    private static void onRulesRefreshComplete(String string, int n, String[] stringArray) {
        if (m_callbackInterface != null) {
            m_callbackInterface.OnSteamRulesRefreshComplete(string, n);
        }
        KahluaTable kahluaTable = LuaManager.platform.newTable();
        for (int i = 0; i < stringArray.length; i += 2) {
            kahluaTable.rawset((Object)stringArray[i], (Object)stringArray[i + 1]);
        }
        LuaEventManager.triggerEvent("OnSteamRulesRefreshComplete", string, n, kahluaTable);
    }
}

