/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.utils;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;

public final class WrappedBuffer {
    private ByteBuffer buf;
    private final int capacity;
    private boolean disposed;

    public WrappedBuffer(int n) {
        this.buf = MemoryUtil.memAlloc((int)n);
        MemoryUtil.memSet((ByteBuffer)this.buf, (int)0);
        this.capacity = this.buf.capacity();
    }

    public ByteBuffer getBuffer() {
        if (this.disposed) {
            throw new IllegalStateException("Can't get buffer after disposal");
        }
        return this.buf;
    }

    public int capacity() {
        return this.capacity;
    }

    public void dispose() {
        if (this.disposed) {
            throw new IllegalStateException("WrappedBuffer was already disposed");
        }
        this.disposed = true;
        MemoryUtil.memFree((Buffer)this.buf);
        this.buf = null;
    }

    public boolean isDisposed() {
        return this.disposed;
    }
}

