/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.utils;

import zombie.GameTime;
import zombie.core.Rand;

public final class OnceEvery {
    private long initialDelayMillis = 0L;
    private long triggerIntervalMillis;
    private static float milliFraction = 0.0f;
    private static long currentMillis = 0L;
    private static long prevMillis = 0L;

    public OnceEvery(float f) {
        this(f, false);
    }

    public OnceEvery(float f, boolean bl) {
        this.triggerIntervalMillis = (long)(f * 1000.0f);
        this.initialDelayMillis = 0L;
        if (bl) {
            this.initialDelayMillis = Rand.Next(this.triggerIntervalMillis);
        }
    }

    public static long getElapsedMillis() {
        return currentMillis;
    }

    public boolean Check() {
        if (currentMillis < this.initialDelayMillis) {
            return false;
        }
        if (this.triggerIntervalMillis == 0L) {
            return true;
        }
        long l = (prevMillis - this.initialDelayMillis) % this.triggerIntervalMillis;
        long l2 = (currentMillis - this.initialDelayMillis) % this.triggerIntervalMillis;
        if (l > l2) {
            return true;
        }
        long l3 = currentMillis - prevMillis;
        return this.triggerIntervalMillis < l3;
    }

    public static void update() {
        long l = currentMillis;
        float f = milliFraction;
        float f2 = GameTime.instance.getTimeDelta();
        float f3 = f2 * 1000.0f + f;
        long l2 = (long)f3;
        float f4 = f3 - (float)l2;
        long l3 = l + l2;
        prevMillis = l;
        currentMillis = l3;
        milliFraction = f4;
    }
}

