/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.utils;

import java.io.Serializable;
import java.util.Arrays;

public class ObjectGrid<T>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final int width;
    private final int height;
    private final Object[] value;

    public ObjectGrid(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.value = new Object[n * n2];
    }

    public ObjectGrid<T> clone() throws CloneNotSupportedException {
        ObjectGrid<T> objectGrid = new ObjectGrid<T>(this.width, this.height);
        System.arraycopy(this.value, 0, objectGrid.value, 0, this.value.length);
        return objectGrid;
    }

    public void clear() {
        Arrays.fill(this.value, (Object)0);
    }

    public void fill(T t) {
        Arrays.fill(this.value, t);
    }

    private int getIndex(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return -1;
        }
        return n + n2 * this.width;
    }

    public T getValue(int n, int n2) {
        int n3 = this.getIndex(n, n2);
        if (n3 == -1) {
            return null;
        }
        return (T)this.value[n3];
    }

    public void setValue(int n, int n2, T t) {
        int n3 = this.getIndex(n, n2);
        if (n3 == -1) {
            return;
        }
        this.value[n3] = t;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }
}

