/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.utils;

import java.util.Arrays;
import zombie.debug.DebugLog;

public class ObjectCube<T>
implements Cloneable {
    private final int width;
    private final int height;
    private final int depth;
    private final Object[] value;

    public ObjectCube(int n, int n2, int n3) {
        DebugLog.log("Created object cube of size " + n + "x" + n2 + "x" + n3 + " (" + n * n2 * n3 * 4 + " bytes)");
        this.width = n;
        this.height = n2;
        this.depth = n3;
        this.value = new Object[n * n2 * n3];
    }

    public ObjectCube<T> clone() throws CloneNotSupportedException {
        ObjectCube<T> objectCube = new ObjectCube<T>(this.width, this.height, this.depth);
        System.arraycopy(this.value, 0, objectCube.value, 0, this.value.length);
        return objectCube;
    }

    public void clear() {
        Arrays.fill(this.value, null);
    }

    public void fill(T t) {
        Arrays.fill(this.value, t);
    }

    private int getIndex(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n3 < 0 || n >= this.width || n2 >= this.height || n3 >= this.depth) {
            return -1;
        }
        return n + n2 * this.width + n3 * this.width * this.height;
    }

    public T getValue(int n, int n2, int n3) {
        int n4 = this.getIndex(n, n2, n3);
        if (n4 == -1) {
            return null;
        }
        return (T)this.value[n4];
    }

    public void setValue(int n, int n2, int n3, T t) {
        int n4 = this.getIndex(n, n2, n3);
        if (n4 == -1) {
            return;
        }
        this.value[n4] = t;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }
}

