/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.utils;

public class HashMap {
    private int capacity = 2;
    private int elements = 0;
    private Bucket[] buckets = new Bucket[this.capacity];

    public HashMap() {
        for (int i = 0; i < this.capacity; ++i) {
            this.buckets[i] = new Bucket();
        }
    }

    public void clear() {
        this.elements = 0;
        for (int i = 0; i < this.capacity; ++i) {
            this.buckets[i].clear();
        }
    }

    private void grow() {
        int n;
        Bucket[] bucketArray = this.buckets;
        this.capacity *= 2;
        this.elements = 0;
        this.buckets = new Bucket[this.capacity];
        for (n = 0; n < this.capacity; ++n) {
            this.buckets[n] = new Bucket();
        }
        for (n = 0; n < bucketArray.length; ++n) {
            Bucket bucket = bucketArray[n];
            for (int i = 0; i < bucket.size(); ++i) {
                if (bucket.keys[i] == null) continue;
                this.put(bucket.keys[i], bucket.values[i]);
            }
        }
    }

    public Object get(Object object) {
        Bucket bucket = this.buckets[Math.abs(object.hashCode()) % this.capacity];
        for (int i = 0; i < bucket.size(); ++i) {
            if (bucket.keys[i] == null || !bucket.keys[i].equals(object)) continue;
            return bucket.values[i];
        }
        return null;
    }

    public Object remove(Object object) {
        Bucket bucket = this.buckets[Math.abs(object.hashCode()) % this.capacity];
        Object object2 = bucket.remove(object);
        if (object2 != null) {
            --this.elements;
            return object2;
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        if (this.elements + 1 >= this.buckets.length) {
            this.grow();
        }
        Object object3 = this.remove(object);
        Bucket bucket = this.buckets[Math.abs(object.hashCode()) % this.capacity];
        bucket.put(object, object2);
        ++this.elements;
        return object3;
    }

    public int size() {
        return this.elements;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    public String toString() {
        Object object = new String();
        for (int i = 0; i < this.buckets.length; ++i) {
            Bucket bucket = this.buckets[i];
            for (int j = 0; j < bucket.size(); ++j) {
                if (bucket.keys[j] == null) continue;
                if (((String)object).length() > 0) {
                    object = (String)object + ", ";
                }
                object = (String)object + bucket.keys[j] + "=" + bucket.values[j];
            }
        }
        object = "HashMap[" + (String)object + "]";
        return object;
    }

    private static class Bucket {
        public Object[] keys;
        public Object[] values;
        public int count;
        public int nextIndex;

        private Bucket() {
        }

        public void put(Object object, Object object2) throws IllegalStateException {
            if (this.keys == null) {
                this.grow();
                this.keys[0] = object;
                this.values[0] = object2;
                this.nextIndex = 1;
                this.count = 1;
                return;
            }
            if (this.count == this.keys.length) {
                this.grow();
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] != null) continue;
                this.keys[i] = object;
                this.values[i] = object2;
                ++this.count;
                this.nextIndex = Math.max(this.nextIndex, i + 1);
                return;
            }
            throw new IllegalStateException("bucket is full");
        }

        public Object remove(Object object) {
            for (int i = 0; i < this.nextIndex; ++i) {
                if (this.keys[i] == null || !this.keys[i].equals(object)) continue;
                Object object2 = this.values[i];
                this.keys[i] = null;
                this.values[i] = null;
                --this.count;
                return object2;
            }
            return null;
        }

        private void grow() {
            if (this.keys == null) {
                this.keys = new Object[2];
                this.values = new Object[2];
            } else {
                Object[] objectArray = this.keys;
                Object[] objectArray2 = this.values;
                this.keys = new Object[objectArray.length * 2];
                this.values = new Object[objectArray2.length * 2];
                System.arraycopy(objectArray, 0, this.keys, 0, objectArray.length);
                System.arraycopy(objectArray2, 0, this.values, 0, objectArray2.length);
            }
        }

        public int size() {
            return this.nextIndex;
        }

        public void clear() {
            for (int i = 0; i < this.nextIndex; ++i) {
                this.keys[i] = null;
                this.values[i] = null;
            }
            this.count = 0;
            this.nextIndex = 0;
        }
    }

    public static class Iterator {
        private HashMap hashMap;
        private int bucketIdx;
        private int keyValuePairIdx;
        private int elementIdx;
        private Object currentKey;
        private Object currentValue;

        public Iterator(HashMap hashMap) {
            this.hashMap = hashMap;
            this.reset();
        }

        public Iterator reset() {
            this.bucketIdx = 0;
            this.keyValuePairIdx = 0;
            this.elementIdx = 0;
            this.currentKey = null;
            this.currentValue = null;
            return this;
        }

        public boolean hasNext() {
            return this.elementIdx < this.hashMap.elements;
        }

        public boolean advance() {
            while (this.bucketIdx < this.hashMap.buckets.length) {
                Bucket bucket = this.hashMap.buckets[this.bucketIdx];
                if (this.keyValuePairIdx == bucket.size()) {
                    this.keyValuePairIdx = 0;
                    ++this.bucketIdx;
                    continue;
                }
                while (this.keyValuePairIdx < bucket.size()) {
                    if (bucket.keys[this.keyValuePairIdx] != null) {
                        this.currentKey = bucket.keys[this.keyValuePairIdx];
                        this.currentValue = bucket.values[this.keyValuePairIdx];
                        ++this.keyValuePairIdx;
                        ++this.elementIdx;
                        return true;
                    }
                    ++this.keyValuePairIdx;
                }
                this.keyValuePairIdx = 0;
                ++this.bucketIdx;
            }
            return false;
        }

        public Object getKey() {
            return this.currentKey;
        }

        public Object getValue() {
            return this.currentValue;
        }
    }
}

