/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.utils;

import java.io.Serializable;
import java.util.Arrays;

public class ExpandableBooleanList
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private int width;
    private int bitWidth;
    private int[] value;

    public ExpandableBooleanList(int n) {
        this.bitWidth = n;
        this.width = n / 32 + (n % 32 != 0 ? 1 : 0);
        this.value = new int[this.width];
    }

    public ExpandableBooleanList clone() throws CloneNotSupportedException {
        ExpandableBooleanList expandableBooleanList = new ExpandableBooleanList(this.bitWidth);
        System.arraycopy(this.value, 0, expandableBooleanList.value, 0, this.value.length);
        return expandableBooleanList;
    }

    public void clear() {
        Arrays.fill(this.value, 0);
    }

    public void fill() {
        Arrays.fill(this.value, -1);
    }

    public boolean getValue(int n) {
        if (n < 0 || n >= this.bitWidth) {
            return false;
        }
        int n2 = n >> 5;
        int n3 = this.value[n2];
        int n4 = 1 << (n & 0x1F);
        return (n3 & n4) != 0;
    }

    public void setValue(int n, boolean bl) {
        if (n < 0) {
            return;
        }
        if (n >= this.bitWidth) {
            int[] nArray = this.value;
            this.bitWidth = Math.max(this.bitWidth * 2, n + 1);
            this.width = this.bitWidth / 32 + (this.width % 32 != 0 ? 1 : 0);
            this.value = new int[this.width];
            System.arraycopy(nArray, 0, this.value, 0, nArray.length);
        }
        int n2 = n >> 5;
        int n3 = 1 << (n & 0x1F);
        if (bl) {
            int n4 = n2;
            this.value[n4] = this.value[n4] | n3;
        } else {
            int n5 = n2;
            this.value[n5] = this.value[n5] & ~n3;
        }
    }

    public final int getWidth() {
        return this.width;
    }
}

