/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.utils;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BufferUtils {
    private static boolean trackDirectMemory = false;
    private static final ReferenceQueue<Buffer> removeCollected = new ReferenceQueue();
    private static final ConcurrentHashMap<BufferInfo, BufferInfo> trackedBuffers = new ConcurrentHashMap();
    static ClearReferences cleanupThread;
    private static final AtomicBoolean loadedMethods;
    private static Method cleanerMethod;
    private static Method cleanMethod;
    private static Method viewedBufferMethod;
    private static Method freeMethod;

    public static void setTrackDirectMemoryEnabled(boolean bl) {
        trackDirectMemory = bl;
    }

    private static void onBufferAllocated(Buffer buffer) {
        if (trackDirectMemory) {
            if (cleanupThread == null) {
                cleanupThread = new ClearReferences();
                cleanupThread.start();
            }
            if (buffer instanceof ByteBuffer) {
                BufferInfo bufferInfo = new BufferInfo(ByteBuffer.class, buffer.capacity(), buffer, removeCollected);
                trackedBuffers.put(bufferInfo, bufferInfo);
            } else if (buffer instanceof FloatBuffer) {
                BufferInfo bufferInfo = new BufferInfo(FloatBuffer.class, buffer.capacity() * 4, buffer, removeCollected);
                trackedBuffers.put(bufferInfo, bufferInfo);
            } else if (buffer instanceof IntBuffer) {
                BufferInfo bufferInfo = new BufferInfo(IntBuffer.class, buffer.capacity() * 4, buffer, removeCollected);
                trackedBuffers.put(bufferInfo, bufferInfo);
            } else if (buffer instanceof ShortBuffer) {
                BufferInfo bufferInfo = new BufferInfo(ShortBuffer.class, buffer.capacity() * 2, buffer, removeCollected);
                trackedBuffers.put(bufferInfo, bufferInfo);
            } else if (buffer instanceof DoubleBuffer) {
                BufferInfo bufferInfo = new BufferInfo(DoubleBuffer.class, buffer.capacity() * 8, buffer, removeCollected);
                trackedBuffers.put(bufferInfo, bufferInfo);
            }
        }
    }

    public static void printCurrentDirectMemory(StringBuilder stringBuilder) {
        boolean bl;
        long l = 0L;
        long l2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        boolean bl2 = bl = stringBuilder == null;
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        if (trackDirectMemory) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            for (BufferInfo bufferInfo : trackedBuffers.values()) {
                if (bufferInfo.type == ByteBuffer.class) {
                    l += (long)bufferInfo.size;
                    n7 += bufferInfo.size;
                    ++n2;
                    continue;
                }
                if (bufferInfo.type == FloatBuffer.class) {
                    l += (long)bufferInfo.size;
                    n6 += bufferInfo.size;
                    ++n;
                    continue;
                }
                if (bufferInfo.type == IntBuffer.class) {
                    l += (long)bufferInfo.size;
                    n8 += bufferInfo.size;
                    ++n3;
                    continue;
                }
                if (bufferInfo.type == ShortBuffer.class) {
                    l += (long)bufferInfo.size;
                    n9 += bufferInfo.size;
                    ++n4;
                    continue;
                }
                if (bufferInfo.type != DoubleBuffer.class) continue;
                l += (long)bufferInfo.size;
                n10 += bufferInfo.size;
                ++n5;
            }
            stringBuilder.append("Existing buffers: ").append(trackedBuffers.size()).append("\n");
            stringBuilder.append("(b: ").append(n2).append("  f: ").append(n).append("  i: ").append(n3).append("  s: ").append(n4).append("  d: ").append(n5).append(")").append("\n");
            stringBuilder.append("Total   heap memory held: ").append(l2 / 1024L).append("kb\n");
            stringBuilder.append("Total direct memory held: ").append(l / 1024L).append("kb\n");
            stringBuilder.append("(b: ").append(n7 / 1024).append("kb  f: ").append(n6 / 1024).append("kb  i: ").append(n8 / 1024).append("kb  s: ").append(n9 / 1024).append("kb  d: ").append(n10 / 1024).append("kb)").append("\n");
        } else {
            stringBuilder.append("Total   heap memory held: ").append(l2 / 1024L).append("kb\n");
            stringBuilder.append("Only heap memory available, if you want to monitor direct memory use BufferUtils.setTrackDirectMemoryEnabled(true) during initialization.").append("\n");
        }
        if (bl) {
            System.out.println(stringBuilder.toString());
        }
    }

    private static Method loadMethod(String string, String string2) {
        try {
            Method method = Class.forName(string).getMethod(string2, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
            return null;
        }
    }

    public static ByteBuffer createByteBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n).order(ByteOrder.nativeOrder());
        byteBuffer.clear();
        BufferUtils.onBufferAllocated(byteBuffer);
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadCleanerMethods() {
        if (loadedMethods.getAndSet(true)) {
            return;
        }
        AtomicBoolean atomicBoolean = loadedMethods;
        synchronized (atomicBoolean) {
            cleanerMethod = BufferUtils.loadMethod("sun.nio.ch.DirectBuffer", "cleaner");
            viewedBufferMethod = BufferUtils.loadMethod("sun.nio.ch.DirectBuffer", "viewedBuffer");
            if (viewedBufferMethod == null) {
                viewedBufferMethod = BufferUtils.loadMethod("sun.nio.ch.DirectBuffer", "attachment");
            }
            ByteBuffer byteBuffer = BufferUtils.createByteBuffer(1);
            Class<?> clazz = byteBuffer.getClass();
            try {
                freeMethod = clazz.getMethod("free", new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
    }

    public static void destroyDirectBuffer(Buffer buffer) {
        if (!buffer.isDirect()) {
            return;
        }
        BufferUtils.loadCleanerMethods();
        try {
            if (freeMethod != null) {
                freeMethod.invoke((Object)buffer, new Object[0]);
            } else {
                Object object = cleanerMethod.invoke((Object)buffer, new Object[0]);
                if (object == null) {
                    Object object2 = viewedBufferMethod.invoke((Object)buffer, new Object[0]);
                    if (object2 != null) {
                        BufferUtils.destroyDirectBuffer((Buffer)object2);
                    } else {
                        Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "Buffer cannot be destroyed: {0}", buffer);
                    }
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
            Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "{0}", exception);
        }
    }

    static {
        loadedMethods = new AtomicBoolean(false);
        cleanerMethod = null;
        cleanMethod = null;
        viewedBufferMethod = null;
        freeMethod = null;
    }

    private static class ClearReferences
    extends Thread {
        ClearReferences() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Reference<Buffer> reference = removeCollected.remove();
                    trackedBuffers.remove(reference);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return;
            }
        }
    }

    private static class BufferInfo
    extends PhantomReference<Buffer> {
        private final Class type;
        private final int size;

        public BufferInfo(Class clazz, int n, Buffer buffer, ReferenceQueue<? super Buffer> referenceQueue) {
            super(buffer, referenceQueue);
            this.type = clazz;
            this.size = n;
        }
    }
}

