/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.utils;

import java.util.NoSuchElementException;

public class BoundedQueue<E> {
    private int numElements;
    private int front;
    private int rear;
    private E[] elements;

    public BoundedQueue(int n) {
        this.numElements = n;
        int n2 = Math.max(n, 16);
        n2 = Integer.highestOneBit(n2 - 1) << 1;
        this.elements = new Object[n2];
    }

    public void add(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.size() == this.numElements) {
            this.removeFirst();
        }
        this.elements[this.rear] = e;
        this.rear = this.rear + 1 & this.elements.length - 1;
    }

    public E removeFirst() {
        E e = this.elements[this.front];
        if (e == null) {
            throw new NoSuchElementException();
        }
        this.elements[this.front] = null;
        this.front = this.front + 1 & this.elements.length - 1;
        return e;
    }

    public E remove(int n) {
        int n2 = this.front + n & this.elements.length - 1;
        E e = this.elements[n2];
        if (e == null) {
            throw new NoSuchElementException();
        }
        int n3 = n2;
        while (n3 != this.front) {
            int n4 = n3 - 1 & this.elements.length - 1;
            this.elements[n3] = this.elements[n4];
            n3 = n4;
        }
        this.front = this.front + 1 & this.elements.length - 1;
        this.elements[n3] = null;
        return e;
    }

    public E get(int n) {
        int n2 = this.front + n & this.elements.length - 1;
        E e = this.elements[n2];
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    public void clear() {
        while (this.front != this.rear) {
            this.elements[this.front] = null;
            this.front = this.front + 1 & this.elements.length - 1;
        }
        this.rear = 0;
        this.front = 0;
    }

    public int capacity() {
        return this.numElements;
    }

    public int size() {
        return this.front <= this.rear ? this.rear - this.front : this.rear + this.elements.length - this.front;
    }

    public boolean isEmpty() {
        return this.front == this.rear;
    }

    public boolean isFull() {
        return this.size() == this.capacity();
    }
}

