/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.textures;

import java.io.BufferedInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjglx.BufferUtils;
import zombie.IndieGL;
import zombie.SystemDisabler;
import zombie.asset.Asset;
import zombie.asset.AssetManager;
import zombie.asset.AssetPath;
import zombie.asset.AssetType;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.math.PZMath;
import zombie.core.opengl.PZGLUtil;
import zombie.core.opengl.RenderThread;
import zombie.core.textures.AlphaColorIndex;
import zombie.core.textures.ImageData;
import zombie.core.textures.MipMapLevel;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureIDAssetManager;
import zombie.core.utils.BooleanGrid;
import zombie.core.utils.DirectBufferAllocator;
import zombie.core.utils.WrappedBuffer;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.fileSystem.FileSystem;
import zombie.interfaces.IDestroyable;

public final class TextureID
extends Asset
implements IDestroyable,
Serializable {
    private static final long serialVersionUID = 4409253583065563738L;
    public static long totalGraphicMemory = 0L;
    public static boolean UseFiltering = false;
    public static boolean bUseCompression = true;
    public static boolean bUseCompressionOption = true;
    public static float totalMemUsed = 0.0f;
    private static boolean FREE_MEMORY = true;
    private static final HashMap<Integer, String> TextureIDMap = new HashMap();
    protected String pathFileName;
    protected boolean solid;
    protected int width;
    protected int widthHW;
    protected int height;
    protected int heightHW;
    protected transient ImageData data;
    protected transient int id = -1;
    private int m_glMagFilter = -1;
    private int m_glMinFilter = -1;
    ArrayList<AlphaColorIndex> alphaList;
    int referenceCount = 0;
    BooleanGrid mask;
    protected int flags = 0;
    public TextureIDAssetParams assetParams;
    public static final IntBuffer deleteTextureIDS = BufferUtils.createIntBuffer((int)20);
    public static final AssetType ASSET_TYPE = new AssetType("TextureID");

    public TextureID(AssetPath assetPath, AssetManager assetManager, TextureIDAssetParams textureIDAssetParams) {
        super(assetPath, assetManager);
        this.assetParams = textureIDAssetParams;
        this.flags = textureIDAssetParams == null ? 0 : this.assetParams.flags;
    }

    protected TextureID() {
        super(null, TextureIDAssetManager.instance);
        this.assetParams = null;
        this.onCreated(Asset.State.READY);
    }

    public TextureID(int n, int n2, int n3) {
        super(null, TextureIDAssetManager.instance);
        this.assetParams = new TextureIDAssetParams();
        this.assetParams.flags = n3;
        if ((n3 & 0x10) != 0) {
            if ((n3 & 4) != 0) {
                DebugLog.General.warn("FBO incompatible with COMPRESS");
                this.assetParams.flags &= 0xFFFFFFFB;
            }
            this.data = new ImageData(n, n2, null);
        } else {
            this.data = new ImageData(n, n2);
        }
        this.width = this.data.getWidth();
        this.height = this.data.getHeight();
        this.widthHW = this.data.getWidthHW();
        this.heightHW = this.data.getHeightHW();
        this.solid = this.data.isSolid();
        RenderThread.queueInvokeOnRenderContext(() -> this.createTexture(false));
        this.onCreated(Asset.State.READY);
    }

    public TextureID(ImageData imageData) {
        super(null, TextureIDAssetManager.instance);
        this.assetParams = null;
        this.data = imageData;
        RenderThread.invokeOnRenderContext(this::createTexture);
        this.onCreated(Asset.State.READY);
    }

    public TextureID(String string, String string2) {
        super(null, TextureIDAssetManager.instance);
        this.assetParams = null;
        this.data = new ImageData(string, string2);
        this.pathFileName = string;
        RenderThread.invokeOnRenderContext(this::createTexture);
        this.onCreated(Asset.State.READY);
    }

    public TextureID(String string, int[] nArray) {
        super(null, TextureIDAssetManager.instance);
        this.assetParams = null;
        this.data = new ImageData(string, nArray);
        this.pathFileName = string;
        RenderThread.invokeOnRenderContext(this::createTexture);
        this.onCreated(Asset.State.READY);
    }

    public TextureID(String object, int n, int n2, int n3) throws Exception {
        super(null, TextureIDAssetManager.instance);
        int n4;
        this.assetParams = null;
        if (((String)object).startsWith("/")) {
            object = ((String)object).substring(1);
        }
        while ((n4 = ((String)object).indexOf("\\")) != -1) {
            object = ((String)object).substring(0, n4) + "/" + ((String)object).substring(n4 + 1);
        }
        this.data = new ImageData((String)object);
        this.data.makeTransp((byte)n, (byte)n2, (byte)n3);
        if (this.alphaList == null) {
            this.alphaList = new ArrayList();
        }
        this.alphaList.add(new AlphaColorIndex(n, n2, n3, 0));
        this.pathFileName = object;
        RenderThread.invokeOnRenderContext(this::createTexture);
        this.onCreated(Asset.State.READY);
    }

    public TextureID(String string) throws Exception {
        super(null, TextureIDAssetManager.instance);
        this.assetParams = null;
        this.data = string.toLowerCase().contains(".pcx") ? new ImageData(string, string) : new ImageData(string);
        if (this.data.getHeight() == -1) {
            return;
        }
        this.pathFileName = string;
        RenderThread.invokeOnRenderContext(this::createTexture);
        this.onCreated(Asset.State.READY);
    }

    public TextureID(BufferedInputStream bufferedInputStream, String string, boolean bl, Texture.PZFileformat pZFileformat) {
        super(null, TextureIDAssetManager.instance);
        this.assetParams = null;
        this.data = new ImageData(bufferedInputStream, bl, pZFileformat);
        if (this.data.id != -1) {
            this.id = this.data.id;
            this.width = this.data.getWidth();
            this.height = this.data.getHeight();
            this.widthHW = this.data.getWidthHW();
            this.heightHW = this.data.getHeightHW();
            this.solid = this.data.isSolid();
        } else {
            if (bl) {
                this.mask = this.data.mask;
                this.data.mask = null;
            }
            this.createTexture();
        }
        this.pathFileName = string;
        this.onCreated(Asset.State.READY);
    }

    public TextureID(BufferedInputStream bufferedInputStream, String string, boolean bl) throws Exception {
        super(null, TextureIDAssetManager.instance);
        this.assetParams = null;
        this.data = new ImageData(bufferedInputStream, bl);
        if (bl) {
            this.mask = this.data.mask;
            this.data.mask = null;
        }
        this.pathFileName = string;
        RenderThread.invokeOnRenderContext(this::createTexture);
        this.onCreated(Asset.State.READY);
    }

    public static TextureID createSteamAvatar(long l) {
        ImageData imageData = ImageData.createSteamAvatar(l);
        if (imageData == null) {
            return null;
        }
        TextureID textureID = new TextureID(imageData);
        return textureID;
    }

    public int getID() {
        return this.id;
    }

    public boolean bind() {
        if (this.id == -1 && this.data == null) {
            Texture.getErrorTexture().bind();
            return true;
        }
        this.debugBoundTexture();
        if (this.id == -1 || this.id != Texture.lastTextureID) {
            return this.bindalways();
        }
        return false;
    }

    public boolean bindalways() {
        this.bindInternal();
        return true;
    }

    private void bindInternal() {
        if (this.id == -1) {
            this.generateHwId(this.data != null && this.data.data != null);
        }
        this.assignFilteringFlags();
        Texture.lastlastTextureID = Texture.lastTextureID;
        Texture.lastTextureID = this.id;
        ++Texture.BindCount;
    }

    private void debugBoundTexture() {
        int n;
        int n2;
        if (DebugOptions.instance.Checks.BoundTextures.getValue() && Texture.lastTextureID != -1 && (n2 = GL11.glGetInteger((int)34016)) == 33984 && (n = GL11.glGetInteger((int)32873)) != Texture.lastTextureID) {
            String string = null;
            for (Asset asset : TextureIDAssetManager.instance.getAssetTable().values()) {
                TextureID textureID = (TextureID)asset;
                if (textureID.id != Texture.lastTextureID) continue;
                string = textureID.getPath().getPath();
                break;
            }
            DebugLog.General.error("Texture.lastTextureID %d != GL_TEXTURE_BINDING_2D %d name=%s", Texture.lastTextureID, n, string);
        }
    }

    @Override
    public void destroy() {
        assert (Thread.currentThread() == RenderThread.RenderThread);
        if (this.id == -1) {
            return;
        }
        if (deleteTextureIDS.position() == deleteTextureIDS.capacity()) {
            deleteTextureIDS.flip();
            GL11.glDeleteTextures((IntBuffer)deleteTextureIDS);
            deleteTextureIDS.clear();
        }
        deleteTextureIDS.put(this.id);
        this.id = -1;
    }

    public void freeMemory() {
        this.data = null;
    }

    public WrappedBuffer getData() {
        this.bind();
        WrappedBuffer wrappedBuffer = DirectBufferAllocator.allocate(this.heightHW * this.widthHW * 4);
        GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)wrappedBuffer.getBuffer());
        Texture.lastTextureID = 0;
        GL11.glBindTexture((int)3553, (int)0);
        return wrappedBuffer;
    }

    public void setData(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            this.freeMemory();
            return;
        }
        this.bind();
        GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)this.widthHW, (int)this.heightHW, (int)6408, (int)5121, (ByteBuffer)byteBuffer);
        if (this.data != null) {
            MipMapLevel mipMapLevel = this.data.getData();
            ByteBuffer byteBuffer2 = mipMapLevel.getBuffer();
            byteBuffer.flip();
            byteBuffer2.clear();
            byteBuffer2.put(byteBuffer);
            byteBuffer2.flip();
        }
    }

    public ImageData getImageData() {
        return this.data;
    }

    public void setImageData(ImageData imageData) {
        this.data = imageData = this.limitMaxSize(imageData);
        this.width = imageData.getWidth();
        this.height = imageData.getHeight();
        this.widthHW = imageData.getWidthHW();
        this.heightHW = imageData.getHeightHW();
        if (imageData.mask != null) {
            this.mask = imageData.mask;
            imageData.mask = null;
        }
        RenderThread.queueInvokeOnRenderContext(this::createTexture);
    }

    private ImageData limitMaxSize(ImageData imageData) {
        if (this.assetParams == null) {
            return imageData;
        }
        int n = this.assetParams.flags;
        int n2 = 384;
        if ((n & n2) == 0) {
            return imageData;
        }
        int n3 = Core.getInstance().getMaxTextureSizeFromFlags(n);
        if (imageData.getWidth() <= n3 && imageData.getHeight() <= n3) {
            return imageData;
        }
        imageData.bPreserveTransparentColor = true;
        MipMapLevel mipMapLevel = imageData.getData();
        int n4 = 0;
        while (mipMapLevel.width > n3 || mipMapLevel.height > n3) {
            mipMapLevel = imageData.getMipMapData(++n4);
        }
        WrappedBuffer wrappedBuffer = DirectBufferAllocator.allocate(mipMapLevel.getBuffer().capacity());
        mipMapLevel.getBuffer().rewind();
        wrappedBuffer.getBuffer().put(mipMapLevel.getBuffer());
        wrappedBuffer.getBuffer().rewind();
        ImageData imageData2 = new ImageData(imageData.getWidth() >> n4, imageData.getHeight() >> n4, wrappedBuffer);
        imageData2.alphaPaddingDone = true;
        if (FREE_MEMORY) {
            imageData.dispose();
        }
        return imageData2;
    }

    public String getPathFileName() {
        return this.pathFileName;
    }

    @Override
    public boolean isDestroyed() {
        return this.id == -1;
    }

    public boolean isSolid() {
        return this.solid;
    }

    private void createTexture() {
        if (this.data == null) {
            return;
        }
        this.createTexture(true);
    }

    private void createTexture(boolean bl) {
        if (this.id != -1) {
            return;
        }
        this.width = this.data.getWidth();
        this.height = this.data.getHeight();
        this.widthHW = this.data.getWidthHW();
        this.heightHW = this.data.getHeightHW();
        this.solid = this.data.isSolid();
        this.generateHwId(bl);
    }

    private void generateHwId(boolean bl) {
        this.id = GL11.glGenTextures();
        ++Texture.totalTextureID;
        Texture.lastTextureID = this.id;
        GL11.glBindTexture((int)3553, (int)Texture.lastTextureID);
        SpriteRenderer.ringBuffer.restoreBoundTextures = true;
        int n = this.assetParams == null ? (bUseCompressionOption ? 4 : 0) : this.assetParams.flags;
        boolean bl2 = (n & 1) != 0;
        boolean bl3 = (n & 2) != 0;
        boolean bl4 = (n & 0x10) != 0;
        boolean bl5 = (n & 0x40) != 0 && !bl4 && bl;
        boolean bl6 = (n & 4) != 0;
        int n2 = bl6 && GL.getCapabilities().GL_ARB_texture_compression ? 34030 : 6408;
        int n3 = this.m_glMagFilter = bl3 ? 9728 : 9729;
        this.m_glMinFilter = bl5 ? 9987 : (bl2 ? 9728 : 9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)this.m_glMinFilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)this.m_glMagFilter);
        if ((n & 0x20) != 0) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        } else {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
        if (bl) {
            if (bl5) {
                PZGLUtil.checkGLErrorThrow("TextureID.mipMaps.start", new Object[0]);
                int n4 = this.data.getMipMapCount();
                int n5 = PZMath.min(0, n4 - 1);
                int n6 = n4;
                for (int i = n5; i < n6; ++i) {
                    MipMapLevel mipMapLevel = this.data.getMipMapData(i);
                    int n7 = mipMapLevel.width;
                    int n8 = mipMapLevel.height;
                    totalMemUsed += (float)mipMapLevel.getDataSize();
                    GL11.glTexImage2D((int)3553, (int)(i - n5), (int)n2, (int)n7, (int)n8, (int)0, (int)6408, (int)5121, (ByteBuffer)mipMapLevel.getBuffer());
                    PZGLUtil.checkGLErrorThrow("TextureID.mipMaps[%d].end", i);
                }
                PZGLUtil.checkGLErrorThrow("TextureID.mipMaps.end", new Object[0]);
            } else {
                PZGLUtil.checkGLErrorThrow("TextureID.noMips.start", new Object[0]);
                totalMemUsed += (float)(this.widthHW * this.heightHW * 4);
                GL11.glTexImage2D((int)3553, (int)0, (int)n2, (int)this.widthHW, (int)this.heightHW, (int)0, (int)6408, (int)5121, (ByteBuffer)this.data.getData().getBuffer());
                PZGLUtil.checkGLErrorThrow("TextureID.noMips.end", new Object[0]);
            }
        } else {
            GL11.glTexImage2D((int)3553, (int)0, (int)n2, (int)this.widthHW, (int)this.heightHW, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
            totalMemUsed += (float)(this.widthHW * this.heightHW * 4);
        }
        if (FREE_MEMORY) {
            if (this.data != null) {
                this.data.dispose();
            }
            this.data = null;
            if (this.assetParams != null) {
                this.assetParams.subTexture = null;
                this.assetParams = null;
            }
        }
        TextureIDMap.put(this.id, this.pathFileName);
        if (SystemDisabler.doEnableDetectOpenGLErrorsInTexture) {
            PZGLUtil.checkGLErrorThrow("generateHwId id:%d pathFileName:%s", this.id, this.pathFileName);
        }
    }

    private void assignFilteringFlags() {
        GL11.glBindTexture((int)3553, (int)this.id);
        if (this.width == 1 && this.height == 1) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            return;
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)this.m_glMinFilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)this.m_glMagFilter);
        if ((this.flags & 0x40) != 0 && DebugOptions.instance.IsoSprite.NearestMagFilterAtMinZoom.getValue() && this.isMinZoomLevel() && this.m_glMagFilter != 9728) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        if (DebugOptions.instance.IsoSprite.ForceLinearMagFilter.getValue() && this.m_glMagFilter != 9729) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        }
        if (DebugOptions.instance.IsoSprite.ForceNearestMagFilter.getValue() && this.m_glMagFilter != 9728) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        if (DebugOptions.instance.IsoSprite.ForceNearestMipMapping.getValue() && this.m_glMinFilter == 9987) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9986);
        }
        if (DebugOptions.instance.IsoSprite.TextureWrapClampToEdge.getValue()) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        }
        if (DebugOptions.instance.IsoSprite.TextureWrapRepeat.getValue()) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
        if (SystemDisabler.doEnableDetectOpenGLErrorsInTexture) {
            PZGLUtil.checkGLErrorThrow("assignFilteringFlags id:%d pathFileName:%s", this.id, this.pathFileName);
        }
    }

    public void setMagFilter(int n) {
        this.m_glMagFilter = n;
    }

    public void setMinFilter(int n) {
        this.m_glMinFilter = n;
    }

    public boolean hasMipMaps() {
        return this.m_glMinFilter == 9987;
    }

    private boolean isMaxZoomLevel() {
        return IndieGL.isMaxZoomLevel();
    }

    private boolean isMinZoomLevel() {
        return IndieGL.isMinZoomLevel();
    }

    @Override
    public void setAssetParams(AssetManager.AssetParams assetParams) {
        this.assetParams = (TextureIDAssetParams)assetParams;
        this.flags = this.assetParams == null ? 0 : this.assetParams.flags;
    }

    @Override
    public AssetType getType() {
        return ASSET_TYPE;
    }

    public static final class TextureIDAssetParams
    extends AssetManager.AssetParams {
        FileSystem.SubTexture subTexture;
        int flags = 0;
    }
}

