/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.textures;

import gnu.trove.stack.array.TIntArrayStack;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import zombie.core.opengl.PZGLUtil;
import zombie.core.opengl.RenderThread;
import zombie.core.textures.GLFramebufferObject30;
import zombie.core.textures.GLFramebufferObjectARB;
import zombie.core.textures.GLFramebufferObjectEXT;
import zombie.core.textures.IGLFramebufferObject;
import zombie.core.textures.Texture;
import zombie.debug.DebugLog;
import zombie.interfaces.ITexture;

public final class TextureFBO {
    private static IGLFramebufferObject funcs;
    private static int lastID;
    private static final TIntArrayStack stack;
    private int id = 0;
    ITexture texture;
    private int depth = 0;
    private int width;
    private int height;
    private static Boolean checked;

    public void swapTexture(ITexture iTexture) {
        assert (lastID == this.id);
        if (iTexture == null || iTexture == this.texture) {
            return;
        }
        if (iTexture.getWidth() != this.width || iTexture.getHeight() != this.height) {
            return;
        }
        if (iTexture.getID() == -1) {
            iTexture.bind();
        }
        IGLFramebufferObject iGLFramebufferObject = TextureFBO.getFuncs();
        iGLFramebufferObject.glFramebufferTexture2D(iGLFramebufferObject.GL_FRAMEBUFFER(), iGLFramebufferObject.GL_COLOR_ATTACHMENT0(), 3553, iTexture.getID(), 0);
        this.texture = iTexture;
    }

    public TextureFBO(ITexture iTexture) {
        this(iTexture, true);
    }

    public TextureFBO(ITexture iTexture, boolean bl) {
        RenderThread.invokeOnRenderContext(iTexture, bl, this::init);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(ITexture iTexture, boolean bl) {
        int n = lastID;
        try {
            this.initInternal(iTexture, bl);
        }
        finally {
            IGLFramebufferObject iGLFramebufferObject = TextureFBO.getFuncs();
            lastID = n;
            iGLFramebufferObject.glBindFramebuffer(iGLFramebufferObject.GL_FRAMEBUFFER(), lastID);
        }
    }

    public static IGLFramebufferObject getFuncs() {
        if (funcs == null) {
            TextureFBO.checkFBOSupport();
        }
        return funcs;
    }

    private void initInternal(ITexture iTexture, boolean bl) {
        IGLFramebufferObject iGLFramebufferObject = TextureFBO.getFuncs();
        try {
            PZGLUtil.checkGLErrorThrow("Enter.", new Object[0]);
            this.texture = iTexture;
            this.width = this.texture.getWidth();
            this.height = this.texture.getHeight();
            if (!TextureFBO.checkFBOSupport()) {
                throw new RuntimeException("Could not create FBO. FBO's not supported.");
            }
            if (this.texture == null) {
                throw new NullPointerException("Could not create FBO. Texture is null.");
            }
            this.texture.bind();
            PZGLUtil.checkGLErrorThrow("Binding texture. %s", this.texture);
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.texture.getWidthHW(), (int)this.texture.getHeightHW(), (int)0, (int)6408, (int)5121, (IntBuffer)null);
            PZGLUtil.checkGLErrorThrow("glTexImage2D(width: %d, height: %d)", this.texture.getWidthHW(), this.texture.getHeightHW());
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            Texture.lastTextureID = 0;
            GL11.glBindTexture((int)3553, (int)0);
            this.id = iGLFramebufferObject.glGenFramebuffers();
            PZGLUtil.checkGLErrorThrow("glGenFrameBuffers", new Object[0]);
            iGLFramebufferObject.glBindFramebuffer(iGLFramebufferObject.GL_FRAMEBUFFER(), this.id);
            PZGLUtil.checkGLErrorThrow("glBindFramebuffer(%d)", this.id);
            iGLFramebufferObject.glFramebufferTexture2D(iGLFramebufferObject.GL_FRAMEBUFFER(), iGLFramebufferObject.GL_COLOR_ATTACHMENT0(), 3553, this.texture.getID(), 0);
            PZGLUtil.checkGLErrorThrow("glFramebufferTexture2D texture: %s", this.texture);
            this.depth = iGLFramebufferObject.glGenRenderbuffers();
            PZGLUtil.checkGLErrorThrow("glGenRenderbuffers", new Object[0]);
            iGLFramebufferObject.glBindRenderbuffer(iGLFramebufferObject.GL_RENDERBUFFER(), this.depth);
            PZGLUtil.checkGLErrorThrow("glBindRenderbuffer depth: %d", this.depth);
            if (bl) {
                iGLFramebufferObject.glRenderbufferStorage(iGLFramebufferObject.GL_RENDERBUFFER(), iGLFramebufferObject.GL_DEPTH24_STENCIL8(), this.texture.getWidthHW(), this.texture.getHeightHW());
                PZGLUtil.checkGLErrorThrow("glRenderbufferStorage(width: %d, height: %d)", this.texture.getWidthHW(), this.texture.getHeightHW());
                iGLFramebufferObject.glBindRenderbuffer(iGLFramebufferObject.GL_RENDERBUFFER(), 0);
                iGLFramebufferObject.glFramebufferRenderbuffer(iGLFramebufferObject.GL_FRAMEBUFFER(), iGLFramebufferObject.GL_DEPTH_ATTACHMENT(), iGLFramebufferObject.GL_RENDERBUFFER(), this.depth);
                PZGLUtil.checkGLErrorThrow("glFramebufferRenderbuffer(depth: %d)", this.depth);
                iGLFramebufferObject.glFramebufferRenderbuffer(iGLFramebufferObject.GL_FRAMEBUFFER(), iGLFramebufferObject.GL_STENCIL_ATTACHMENT(), iGLFramebufferObject.GL_RENDERBUFFER(), this.depth);
                PZGLUtil.checkGLErrorThrow("glFramebufferRenderbuffer(stencil: %d)", this.depth);
            } else {
                iGLFramebufferObject.glRenderbufferStorage(iGLFramebufferObject.GL_RENDERBUFFER(), 6402, this.texture.getWidthHW(), this.texture.getHeightHW());
                PZGLUtil.checkGLErrorThrow("glRenderbufferStorage(width: %d, height: %d)", this.texture.getWidthHW(), this.texture.getHeightHW());
                iGLFramebufferObject.glBindRenderbuffer(iGLFramebufferObject.GL_RENDERBUFFER(), 0);
                iGLFramebufferObject.glFramebufferRenderbuffer(iGLFramebufferObject.GL_FRAMEBUFFER(), iGLFramebufferObject.GL_DEPTH_ATTACHMENT(), iGLFramebufferObject.GL_RENDERBUFFER(), this.depth);
                PZGLUtil.checkGLErrorThrow("glFramebufferRenderbuffer(depth: %d)", this.depth);
            }
            int n = iGLFramebufferObject.glCheckFramebufferStatus(iGLFramebufferObject.GL_FRAMEBUFFER());
            if (n != iGLFramebufferObject.GL_FRAMEBUFFER_COMPLETE()) {
                if (n == iGLFramebufferObject.GL_FRAMEBUFFER_UNDEFINED()) {
                    DebugLog.General.error("glCheckFramebufferStatus = GL_FRAMEBUFFER_UNDEFINED");
                }
                if (n == iGLFramebufferObject.GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT()) {
                    DebugLog.General.error("glCheckFramebufferStatus = GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
                }
                if (n == iGLFramebufferObject.GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT()) {
                    DebugLog.General.error("glCheckFramebufferStatus = GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT");
                }
                if (n == iGLFramebufferObject.GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS()) {
                    DebugLog.General.error("glCheckFramebufferStatus = GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS");
                }
                if (n == iGLFramebufferObject.GL_FRAMEBUFFER_INCOMPLETE_FORMATS()) {
                    DebugLog.General.error("glCheckFramebufferStatus = GL_FRAMEBUFFER_INCOMPLETE_FORMATS");
                }
                if (n == iGLFramebufferObject.GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER()) {
                    DebugLog.General.error("glCheckFramebufferStatus = GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER");
                }
                if (n == iGLFramebufferObject.GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER()) {
                    DebugLog.General.error("glCheckFramebufferStatus = GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER");
                }
                if (n == iGLFramebufferObject.GL_FRAMEBUFFER_UNSUPPORTED()) {
                    DebugLog.General.error("glCheckFramebufferStatus = GL_FRAMEBUFFER_UNSUPPORTED");
                }
                if (n == iGLFramebufferObject.GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE()) {
                    DebugLog.General.error("glCheckFramebufferStatus = GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE");
                }
                throw new RuntimeException("Could not create FBO!");
            }
        }
        catch (Exception exception) {
            iGLFramebufferObject.glDeleteFramebuffers(this.id);
            iGLFramebufferObject.glDeleteRenderbuffers(this.depth);
            this.id = 0;
            this.depth = 0;
            this.texture = null;
            throw exception;
        }
    }

    public static boolean checkFBOSupport() {
        if (checked != null) {
            return checked;
        }
        if (GL.getCapabilities().OpenGL30) {
            DebugLog.General.debugln("OpenGL 3.0 framebuffer objects supported");
            funcs = new GLFramebufferObject30();
            checked = Boolean.TRUE;
            return checked;
        }
        if (GL.getCapabilities().GL_ARB_framebuffer_object) {
            DebugLog.General.debugln("GL_ARB_framebuffer_object supported");
            funcs = new GLFramebufferObjectARB();
            checked = Boolean.TRUE;
            return checked;
        }
        if (GL.getCapabilities().GL_EXT_framebuffer_object) {
            DebugLog.General.debugln("GL_EXT_framebuffer_object supported");
            if (!GL.getCapabilities().GL_EXT_packed_depth_stencil) {
                DebugLog.General.debugln("GL_EXT_packed_depth_stencil not supported");
            }
            funcs = new GLFramebufferObjectEXT();
            checked = Boolean.TRUE;
            return checked;
        }
        DebugLog.General.debugln("None of OpenGL 3.0, GL_ARB_framebuffer_object or GL_EXT_framebuffer_object are supported, zoom disabled");
        checked = Boolean.TRUE;
        return checked;
    }

    public void destroy() {
        if (this.id == 0 || this.depth == 0) {
            return;
        }
        if (lastID == this.id) {
            lastID = 0;
        }
        RenderThread.invokeOnRenderContext(() -> {
            if (this.texture != null) {
                this.texture.destroy();
                this.texture = null;
            }
            IGLFramebufferObject iGLFramebufferObject = TextureFBO.getFuncs();
            iGLFramebufferObject.glDeleteFramebuffers(this.id);
            iGLFramebufferObject.glDeleteRenderbuffers(this.depth);
            this.id = 0;
            this.depth = 0;
        });
    }

    public void destroyLeaveTexture() {
        if (this.id == 0 || this.depth == 0) {
            return;
        }
        RenderThread.invokeOnRenderContext(() -> {
            this.texture = null;
            IGLFramebufferObject iGLFramebufferObject = TextureFBO.getFuncs();
            iGLFramebufferObject.glDeleteFramebuffers(this.id);
            iGLFramebufferObject.glDeleteRenderbuffers(this.depth);
            this.id = 0;
            this.depth = 0;
        });
    }

    public void releaseTexture() {
        IGLFramebufferObject iGLFramebufferObject = TextureFBO.getFuncs();
        iGLFramebufferObject.glFramebufferTexture2D(iGLFramebufferObject.GL_FRAMEBUFFER(), iGLFramebufferObject.GL_COLOR_ATTACHMENT0(), 3553, 0, 0);
        this.texture = null;
    }

    public void endDrawing() {
        lastID = stack.size() != 0 ? stack.pop() : 0;
        IGLFramebufferObject iGLFramebufferObject = TextureFBO.getFuncs();
        iGLFramebufferObject.glBindFramebuffer(iGLFramebufferObject.GL_FRAMEBUFFER(), lastID);
    }

    public ITexture getTexture() {
        return this.texture;
    }

    public int getBufferId() {
        return this.id;
    }

    public boolean isDestroyed() {
        return this.texture == null || this.id == 0 || this.depth == 0;
    }

    public void startDrawing() {
        this.startDrawing(false, false);
    }

    public void startDrawing(boolean bl, boolean bl2) {
        stack.push(lastID);
        lastID = this.id;
        IGLFramebufferObject iGLFramebufferObject = TextureFBO.getFuncs();
        iGLFramebufferObject.glBindFramebuffer(iGLFramebufferObject.GL_FRAMEBUFFER(), this.id);
        if (this.texture == null) {
            return;
        }
        if (bl) {
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)(bl2 ? 0.0f : 1.0f));
            GL11.glClear((int)16640);
            if (bl2) {
                GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    public void setTexture(Texture texture) {
        int n = lastID;
        IGLFramebufferObject iGLFramebufferObject = TextureFBO.getFuncs();
        lastID = this.id;
        iGLFramebufferObject.glBindFramebuffer(iGLFramebufferObject.GL_FRAMEBUFFER(), lastID);
        this.swapTexture(texture);
        lastID = n;
        iGLFramebufferObject.glBindFramebuffer(iGLFramebufferObject.GL_FRAMEBUFFER(), lastID);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static int getCurrentID() {
        return lastID;
    }

    public static void reset() {
        stack.clear();
        if (lastID != 0) {
            IGLFramebufferObject iGLFramebufferObject = TextureFBO.getFuncs();
            lastID = 0;
            iGLFramebufferObject.glBindFramebuffer(iGLFramebufferObject.GL_FRAMEBUFFER(), 0);
        }
    }

    static {
        lastID = 0;
        stack = new TIntArrayStack();
        checked = null;
    }
}

