/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.textures;

import java.util.function.Consumer;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import zombie.IndieGL;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.opengl.Shader;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.model.ModelSlotRenderData;
import zombie.core.textures.Texture;
import zombie.iso.IsoWorld;
import zombie.iso.weather.fx.WeatherFxMask;
import zombie.ui.UIManager;
import zombie.util.list.PZArrayUtil;

public final class TextureDraw {
    public Type type = Type.glDraw;
    public int a = 0;
    public int b = 0;
    public float f1 = 0.0f;
    public float[] vars;
    public int c = 0;
    public int d = 0;
    public int col0;
    public int col1;
    public int col2;
    public int col3;
    public float x0;
    public float x1;
    public float x2;
    public float x3;
    public float y0;
    public float y1;
    public float y2;
    public float y3;
    public float u0;
    public float u1;
    public float u2;
    public float u3;
    public float v0;
    public float v1;
    public float v2;
    public float v3;
    public Texture tex;
    public Texture tex1;
    public byte useAttribArray;
    public float tex1_u0;
    public float tex1_u1;
    public float tex1_u2;
    public float tex1_u3;
    public float tex1_v0;
    public float tex1_v1;
    public float tex1_v2;
    public float tex1_v3;
    public int tex1_col0;
    public int tex1_col1;
    public int tex1_col2;
    public int tex1_col3;
    public boolean bSingleCol = false;
    public boolean flipped = false;
    public GenericDrawer drawer;

    public static void glStencilFunc(TextureDraw textureDraw, int n, int n2, int n3) {
        textureDraw.type = Type.glStencilFunc;
        textureDraw.a = n;
        textureDraw.b = n2;
        textureDraw.c = n3;
    }

    public static void glBuffer(TextureDraw textureDraw, int n, int n2) {
        textureDraw.type = Type.glBuffer;
        textureDraw.a = n;
        textureDraw.b = n2;
    }

    public static void glStencilOp(TextureDraw textureDraw, int n, int n2, int n3) {
        textureDraw.type = Type.glStencilOp;
        textureDraw.a = n;
        textureDraw.b = n2;
        textureDraw.c = n3;
    }

    public static void glDisable(TextureDraw textureDraw, int n) {
        textureDraw.type = Type.glDisable;
        textureDraw.a = n;
    }

    public static void glClear(TextureDraw textureDraw, int n) {
        textureDraw.type = Type.glClear;
        textureDraw.a = n;
    }

    public static void glClearColor(TextureDraw textureDraw, int n, int n2, int n3, int n4) {
        textureDraw.type = Type.glClearColor;
        textureDraw.col0 = n;
        textureDraw.col1 = n2;
        textureDraw.col2 = n3;
        textureDraw.col3 = n4;
    }

    public static void glEnable(TextureDraw textureDraw, int n) {
        textureDraw.type = Type.glEnable;
        textureDraw.a = n;
    }

    public static void glAlphaFunc(TextureDraw textureDraw, int n, float f) {
        textureDraw.type = Type.glAlphaFunc;
        textureDraw.a = n;
        textureDraw.f1 = f;
    }

    public static void glColorMask(TextureDraw textureDraw, int n, int n2, int n3, int n4) {
        textureDraw.type = Type.glColorMask;
        textureDraw.a = n;
        textureDraw.b = n2;
        textureDraw.c = n3;
        textureDraw.x0 = n4;
    }

    public static void glStencilMask(TextureDraw textureDraw, int n) {
        textureDraw.type = Type.glStencilMask;
        textureDraw.a = n;
    }

    public static void glBlendFunc(TextureDraw textureDraw, int n, int n2) {
        textureDraw.type = Type.glBlendFunc;
        textureDraw.a = n;
        textureDraw.b = n2;
    }

    public static void glBlendFuncSeparate(TextureDraw textureDraw, int n, int n2, int n3, int n4) {
        textureDraw.type = Type.glBlendFuncSeparate;
        textureDraw.a = n;
        textureDraw.b = n2;
        textureDraw.c = n3;
        textureDraw.d = n4;
    }

    public static void glBlendEquation(TextureDraw textureDraw, int n) {
        textureDraw.type = Type.glBlendEquation;
        textureDraw.a = n;
    }

    public static void glDoEndFrame(TextureDraw textureDraw) {
        textureDraw.type = Type.glDoEndFrame;
    }

    public static void glDoEndFrameFx(TextureDraw textureDraw, int n) {
        textureDraw.type = Type.glDoEndFrameFx;
        textureDraw.c = n;
    }

    public static void glIgnoreStyles(TextureDraw textureDraw, boolean bl) {
        textureDraw.type = Type.glIgnoreStyles;
        textureDraw.a = bl ? 1 : 0;
    }

    public static void glDoStartFrame(TextureDraw textureDraw, int n, int n2, float f, int n3) {
        TextureDraw.glDoStartFrame(textureDraw, n, n2, f, n3, false);
    }

    public static void glDoStartFrame(TextureDraw textureDraw, int n, int n2, float f, int n3, boolean bl) {
        textureDraw.type = bl ? Type.glDoStartFrameText : Type.glDoStartFrame;
        textureDraw.a = n;
        textureDraw.b = n2;
        textureDraw.f1 = f;
        textureDraw.c = n3;
    }

    public static void glDoStartFrameFx(TextureDraw textureDraw, int n, int n2, int n3) {
        textureDraw.type = Type.glDoStartFrameFx;
        textureDraw.a = n;
        textureDraw.b = n2;
        textureDraw.c = n3;
    }

    public static void glTexParameteri(TextureDraw textureDraw, int n, int n2, int n3) {
        textureDraw.type = Type.glTexParameteri;
        textureDraw.a = n;
        textureDraw.b = n2;
        textureDraw.c = n3;
    }

    public static void drawModel(TextureDraw textureDraw, ModelManager.ModelSlot modelSlot) {
        textureDraw.type = Type.DrawModel;
        textureDraw.a = modelSlot.ID;
        textureDraw.drawer = ModelSlotRenderData.alloc().init(modelSlot);
    }

    public static void drawSkyBox(TextureDraw textureDraw, Shader shader, int n, int n2, int n3) {
        textureDraw.type = Type.DrawSkyBox;
        textureDraw.a = shader.getID();
        textureDraw.b = n;
        textureDraw.c = n2;
        textureDraw.d = n3;
        textureDraw.drawer = null;
    }

    public static void drawWater(TextureDraw textureDraw, Shader shader, int n, int n2, boolean bl) {
        textureDraw.type = Type.DrawWater;
        textureDraw.a = shader.getID();
        textureDraw.b = n;
        textureDraw.c = n2;
        textureDraw.d = bl ? 1 : 0;
        textureDraw.drawer = null;
    }

    public static void drawPuddles(TextureDraw textureDraw, Shader shader, int n, int n2, int n3) {
        textureDraw.type = Type.DrawPuddles;
        textureDraw.a = shader.getID();
        textureDraw.b = n;
        textureDraw.c = n2;
        textureDraw.d = n3;
        textureDraw.drawer = null;
    }

    public static void drawParticles(TextureDraw textureDraw, int n, int n2, int n3) {
        textureDraw.type = Type.DrawParticles;
        textureDraw.b = n;
        textureDraw.c = n2;
        textureDraw.d = n3;
        textureDraw.drawer = null;
    }

    public static void StartShader(TextureDraw textureDraw, int n) {
        textureDraw.type = Type.StartShader;
        textureDraw.a = n;
    }

    public static void ShaderUpdate1i(TextureDraw textureDraw, int n, int n2, int n3) {
        textureDraw.type = Type.ShaderUpdate;
        textureDraw.a = n;
        textureDraw.b = n2;
        textureDraw.c = -1;
        textureDraw.d = n3;
    }

    public static void ShaderUpdate1f(TextureDraw textureDraw, int n, int n2, float f) {
        textureDraw.type = Type.ShaderUpdate;
        textureDraw.a = n;
        textureDraw.b = n2;
        textureDraw.c = 1;
        textureDraw.u0 = f;
    }

    public static void ShaderUpdate2f(TextureDraw textureDraw, int n, int n2, float f, float f2) {
        textureDraw.type = Type.ShaderUpdate;
        textureDraw.a = n;
        textureDraw.b = n2;
        textureDraw.c = 2;
        textureDraw.u0 = f;
        textureDraw.u1 = f2;
    }

    public static void ShaderUpdate3f(TextureDraw textureDraw, int n, int n2, float f, float f2, float f3) {
        textureDraw.type = Type.ShaderUpdate;
        textureDraw.a = n;
        textureDraw.b = n2;
        textureDraw.c = 3;
        textureDraw.u0 = f;
        textureDraw.u1 = f2;
        textureDraw.u2 = f3;
    }

    public static void ShaderUpdate4f(TextureDraw textureDraw, int n, int n2, float f, float f2, float f3, float f4) {
        textureDraw.type = Type.ShaderUpdate;
        textureDraw.a = n;
        textureDraw.b = n2;
        textureDraw.c = 4;
        textureDraw.u0 = f;
        textureDraw.u1 = f2;
        textureDraw.u2 = f3;
        textureDraw.u3 = f4;
    }

    public void run() {
        switch (this.type) {
            case StartShader: {
                ARBShaderObjects.glUseProgramObjectARB((int)this.a);
                if (Shader.ShaderMap.containsKey(this.a)) {
                    Shader.ShaderMap.get(this.a).startRenderThread(this);
                }
                if (this.a != 0) break;
                SpriteRenderer.ringBuffer.checkShaderChangedTexture1();
                break;
            }
            case ShaderUpdate: {
                if (this.c == 1) {
                    ARBShaderObjects.glUniform1fARB((int)this.b, (float)this.u0);
                }
                if (this.c == 2) {
                    ARBShaderObjects.glUniform2fARB((int)this.b, (float)this.u0, (float)this.u1);
                }
                if (this.c == 3) {
                    ARBShaderObjects.glUniform3fARB((int)this.b, (float)this.u0, (float)this.u1, (float)this.u2);
                }
                if (this.c == 4) {
                    ARBShaderObjects.glUniform4fARB((int)this.b, (float)this.u0, (float)this.u1, (float)this.u2, (float)this.u3);
                }
                if (this.c != -1) break;
                ARBShaderObjects.glUniform1iARB((int)this.b, (int)this.d);
                break;
            }
            case BindActiveTexture: {
                GL13.glActiveTexture((int)this.a);
                if (this.b != -1) {
                    GL11.glBindTexture((int)3553, (int)this.b);
                }
                GL13.glActiveTexture((int)33984);
                break;
            }
            case DrawModel: {
                if (this.drawer == null) break;
                this.drawer.render();
                break;
            }
            case DrawSkyBox: {
                try {
                    ModelManager.instance.RenderSkyBox(this, this.a, this.b, this.c, this.d);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case DrawWater: {
                try {
                    ModelManager.instance.RenderWater(this, this.a, this.b, this.d == 1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case DrawPuddles: {
                try {
                    ModelManager.instance.RenderPuddles(this.a, this.b, this.d);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case DrawParticles: {
                try {
                    ModelManager.instance.RenderParticles(this, this.b, this.c);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case glClear: {
                IndieGL.glClearA(this.a);
                break;
            }
            case glClearColor: {
                GL11.glClearColor((float)((float)this.col0 / 255.0f), (float)((float)this.col1 / 255.0f), (float)((float)this.col2 / 255.0f), (float)((float)this.col3 / 255.0f));
                break;
            }
            case glBlendFunc: {
                IndieGL.glBlendFuncA(this.a, this.b);
                break;
            }
            case glBlendFuncSeparate: {
                GL14.glBlendFuncSeparate((int)this.a, (int)this.b, (int)this.c, (int)this.d);
                break;
            }
            case glColorMask: {
                IndieGL.glColorMaskA(this.a == 1, this.b == 1, this.c == 1, this.x0 == 1.0f);
                break;
            }
            case glTexParameteri: {
                IndieGL.glTexParameteriActual(this.a, this.b, this.c);
                break;
            }
            case glStencilMask: {
                IndieGL.glStencilMaskA(this.a);
                break;
            }
            case glDoEndFrame: {
                Core.getInstance().DoEndFrameStuff(this.a, this.b);
                break;
            }
            case glDoEndFrameFx: {
                Core.getInstance().DoEndFrameStuffFx(this.a, this.b, this.c);
                break;
            }
            case glDoStartFrame: {
                Core.getInstance().DoStartFrameStuff(this.a, this.b, this.f1, this.c);
                break;
            }
            case glDoStartFrameText: {
                Core.getInstance().DoStartFrameStuff(this.a, this.b, this.f1, this.c, true);
                break;
            }
            case glDoStartFrameFx: {
                Core.getInstance().DoStartFrameStuffSmartTextureFx(this.a, this.b, this.c);
                break;
            }
            case glStencilFunc: {
                IndieGL.glStencilFuncA(this.a, this.b, this.c);
                break;
            }
            case glBuffer: {
                if (!Core.getInstance().supportsFBO()) break;
                if (this.a == 1) {
                    SpriteRenderer.instance.getRenderingState().fbo.startDrawing(false, false);
                    break;
                }
                if (this.a == 2) {
                    UIManager.UIFBO.startDrawing(true, true);
                    break;
                }
                if (this.a == 3) {
                    UIManager.UIFBO.endDrawing();
                    break;
                }
                if (this.a == 4) {
                    WeatherFxMask.getFboMask().startDrawing(true, true);
                    break;
                }
                if (this.a == 5) {
                    WeatherFxMask.getFboMask().endDrawing();
                    break;
                }
                if (this.a == 6) {
                    WeatherFxMask.getFboParticles().startDrawing(true, true);
                    break;
                }
                if (this.a == 7) {
                    WeatherFxMask.getFboParticles().endDrawing();
                    break;
                }
                SpriteRenderer.instance.getRenderingState().fbo.endDrawing();
                break;
            }
            case glStencilOp: {
                IndieGL.glStencilOpA(this.a, this.b, this.c);
                break;
            }
            case glLoadIdentity: {
                GL11.glLoadIdentity();
                break;
            }
            case glBind: {
                GL11.glBindTexture((int)3553, (int)this.a);
                Texture.lastlastTextureID = Texture.lastTextureID;
                Texture.lastTextureID = this.a;
                break;
            }
            case glViewport: {
                GL11.glViewport((int)this.a, (int)this.b, (int)this.c, (int)this.d);
                break;
            }
            case drawTerrain: {
                IsoWorld.instance.renderTerrain();
                break;
            }
            case doCoreIntParam: {
                Core.getInstance().FloatParamMap.put(this.a, Float.valueOf(this.f1));
                break;
            }
            case glDepthMask: {
                GL11.glDepthMask((this.a == 1 ? 1 : 0) != 0);
                break;
            }
            case glGenerateMipMaps: {
                break;
            }
            case glAlphaFunc: {
                IndieGL.glAlphaFuncA(this.a, this.f1);
                break;
            }
            case glEnable: {
                IndieGL.glEnableA(this.a);
                break;
            }
            case glDisable: {
                IndieGL.glDisableA(this.a);
                break;
            }
            case glBlendEquation: {
                GL14.glBlendEquation((int)this.a);
                break;
            }
            case glIgnoreStyles: {
                SpriteRenderer.RingBuffer.IGNORE_STYLES = this.a == 1;
            }
        }
    }

    public static void glDepthMask(TextureDraw textureDraw, boolean bl) {
        textureDraw.type = Type.glDepthMask;
        textureDraw.a = bl ? 1 : 0;
    }

    public static void doCoreIntParam(TextureDraw textureDraw, int n, float f) {
        textureDraw.type = Type.doCoreIntParam;
        textureDraw.a = n;
        textureDraw.f1 = f;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ " + this.type + ", a:" + this.a + ", b:" + this.b + ", f1:" + this.f1 + ", vars:" + (this.vars != null ? PZArrayUtil.arrayToString(this.vars, "{", "}", ", ") : "null") + ", c:" + this.c + ", d:" + this.d + ", col0:" + this.col0 + ", col1:" + this.col1 + ", col2:" + this.col2 + ", col3:" + this.col3 + ", x0:" + this.x0 + ", x1:" + this.x1 + ", x2:" + this.x2 + ", x3:" + this.x3 + ", x0:" + this.x0 + ", x1:" + this.x1 + ", x2:" + this.x2 + ", x3:" + this.x3 + ", y0:" + this.y0 + ", y1:" + this.y1 + ", y2:" + this.y2 + ", y3:" + this.y3 + ", u0:" + this.u0 + ", u1:" + this.u1 + ", u2:" + this.u2 + ", u3:" + this.u3 + ", v0:" + this.v0 + ", v1:" + this.v1 + ", v2:" + this.v2 + ", v3:" + this.v3 + ", tex:" + this.tex + ", tex1:" + this.tex1 + ", useAttribArray:" + this.useAttribArray + ", tex1_u0:" + this.tex1_u0 + ", tex1_u1:" + this.tex1_u1 + ", tex1_u2:" + this.tex1_u2 + ", tex1_u3:" + this.tex1_u3 + ", tex1_u0:" + this.tex1_u0 + ", tex1_u1:" + this.tex1_u1 + ", tex1_u2:" + this.tex1_u2 + ", tex1_u3:" + this.tex1_u3 + ", tex1_col0:" + this.tex1_col0 + ", tex1_col1:" + this.tex1_col1 + ", tex1_col2:" + this.tex1_col2 + ", tex1_col3:" + this.tex1_col3 + ", bSingleCol:" + this.bSingleCol + " }";
    }

    public static TextureDraw Create(TextureDraw textureDraw, Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, Consumer<TextureDraw> consumer) {
        int n = Color.colorToABGR(f5, f6, f7, f8);
        TextureDraw.Create(textureDraw, texture, f, f2, f + f3, f2, f + f3, f2 + f4, f, f2 + f4, n, n, n, n, consumer);
        return textureDraw;
    }

    public static TextureDraw Create(TextureDraw textureDraw, Texture texture, SpriteRenderer.WallShaderTexRender wallShaderTexRender, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, Consumer<TextureDraw> consumer) {
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        int n = Color.colorToABGR(f5, f6, f7, f8);
        float f17 = 0.0f;
        float f18 = 0.0f;
        float f19 = 1.0f;
        float f20 = 0.0f;
        float f21 = 1.0f;
        float f22 = 1.0f;
        float f23 = 0.0f;
        float f24 = 1.0f;
        switch (wallShaderTexRender) {
            case LeftOnly: {
                f15 = f16 = f;
                f13 = f14 = f2;
                f11 = f12 = f + f3 / 2.0f;
                f9 = f10 = f2 + f4;
                if (texture == null) break;
                float f25 = texture.getXEnd();
                float f26 = texture.getXStart();
                float f27 = texture.getYEnd();
                float f28 = texture.getYStart();
                float f29 = 0.5f * (f25 - f26);
                f17 = f26;
                f19 = f26 + f29;
                f21 = f26 + f29;
                f23 = f26;
                f18 = f28;
                f20 = f28;
                f22 = f27;
                f24 = f27;
                break;
            }
            case RightOnly: {
                f15 = f16 = f + f3 / 2.0f;
                f13 = f14 = f2;
                f11 = f12 = f + f3;
                f9 = f10 = f2 + f4;
                if (texture == null) break;
                float f30 = texture.getXEnd();
                float f31 = texture.getXStart();
                float f32 = texture.getYEnd();
                float f33 = texture.getYStart();
                float f34 = 0.5f * (f30 - f31);
                f17 = f31 + f34;
                f19 = f30;
                f21 = f30;
                f23 = f31 + f34;
                f18 = f33;
                f20 = f33;
                f22 = f32;
                f24 = f32;
                break;
            }
            default: {
                f15 = f16 = f;
                f13 = f14 = f2;
                f11 = f12 = f + f3;
                f9 = f10 = f2 + f4;
                if (texture == null) break;
                float f35 = texture.getXEnd();
                float f36 = texture.getXStart();
                float f37 = texture.getYEnd();
                float f38 = texture.getYStart();
                f17 = f36;
                f19 = f35;
                f21 = f35;
                f23 = f36;
                f18 = f38;
                f20 = f38;
                f22 = f37;
                f24 = f37;
            }
        }
        TextureDraw.Create(textureDraw, texture, f15, f13, f11, f14, f12, f9, f16, f10, n, n, n, n, f17, f18, f19, f20, f21, f22, f23, f24, consumer);
        return textureDraw;
    }

    public static TextureDraw Create(TextureDraw textureDraw, Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, Consumer<TextureDraw> consumer) {
        int n = Color.colorToABGR(f5, f6, f7, f8);
        TextureDraw.Create(textureDraw, texture, f, f2, f + f3, f2, f + f3, f2 + f4, f, f2 + f4, n, n, n, n, f9, f10, f11, f12, f13, f14, f15, f16, consumer);
        return textureDraw;
    }

    public static void Create(TextureDraw textureDraw, Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20, float f21, float f22, float f23, float f24, Consumer<TextureDraw> consumer) {
        int n = Color.colorToABGR(f9, f10, f11, f12);
        int n2 = Color.colorToABGR(f13, f14, f15, f16);
        int n3 = Color.colorToABGR(f17, f18, f19, f20);
        int n4 = Color.colorToABGR(f21, f22, f23, f24);
        TextureDraw.Create(textureDraw, texture, f, f2, f3, f4, f5, f6, f7, f8, n, n2, n3, n4, consumer);
    }

    public static void Create(TextureDraw textureDraw, Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        int n = Color.colorToABGR(f9, f10, f11, f12);
        TextureDraw.Create(textureDraw, texture, f, f2, f3, f4, f5, f6, f7, f8, n, n, n, n, null);
    }

    public static void Create(TextureDraw textureDraw, Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n, int n2, int n3, int n4) {
        TextureDraw.Create(textureDraw, texture, f, f2, f3, f4, f5, f6, f7, f8, n, n2, n3, n4, null);
    }

    public static TextureDraw Create(TextureDraw textureDraw, Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n, int n2, int n3, int n4, Consumer<TextureDraw> consumer) {
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 1.0f;
        float f12 = 0.0f;
        float f13 = 1.0f;
        float f14 = 1.0f;
        float f15 = 0.0f;
        float f16 = 1.0f;
        if (texture != null) {
            float f17 = texture.getXEnd();
            float f18 = texture.getXStart();
            float f19 = texture.getYEnd();
            float f20 = texture.getYStart();
            f9 = f18;
            f10 = f20;
            f11 = f17;
            f12 = f20;
            f13 = f17;
            f14 = f19;
            f15 = f18;
            f16 = f19;
        }
        return TextureDraw.Create(textureDraw, texture, f, f2, f3, f4, f5, f6, f7, f8, n, n2, n3, n4, f9, f10, f11, f12, f13, f14, f15, f16, consumer);
    }

    public static TextureDraw Create(TextureDraw textureDraw, Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n, int n2, int n3, int n4, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, Consumer<TextureDraw> consumer) {
        textureDraw.bSingleCol = n == n2 && n == n3 && n == n4;
        textureDraw.tex = texture;
        textureDraw.x0 = f;
        textureDraw.y0 = f2;
        textureDraw.x1 = f3;
        textureDraw.y1 = f4;
        textureDraw.x2 = f5;
        textureDraw.y2 = f6;
        textureDraw.x3 = f7;
        textureDraw.y3 = f8;
        textureDraw.col0 = n;
        textureDraw.col1 = n2;
        textureDraw.col2 = n3;
        textureDraw.col3 = n4;
        textureDraw.u0 = f9;
        textureDraw.u1 = f11;
        textureDraw.u2 = f13;
        textureDraw.u3 = f15;
        textureDraw.v0 = f10;
        textureDraw.v1 = f12;
        textureDraw.v2 = f14;
        textureDraw.v3 = f16;
        if (texture != null) {
            textureDraw.flipped = texture.flip;
        }
        if (consumer != null) {
            consumer.accept(textureDraw);
            textureDraw.bSingleCol = textureDraw.col0 == textureDraw.col1 && textureDraw.col0 == textureDraw.col2 && textureDraw.col0 == textureDraw.col3;
        }
        return textureDraw;
    }

    public int getColor(int n) {
        if (this.bSingleCol) {
            return this.col0;
        }
        if (n == 0) {
            return this.col0;
        }
        if (n == 1) {
            return this.col1;
        }
        if (n == 2) {
            return this.col2;
        }
        if (n == 3) {
            return this.col3;
        }
        return this.col0;
    }

    public void reset() {
        this.type = Type.glDraw;
        this.flipped = false;
        this.tex = null;
        this.tex1 = null;
        this.useAttribArray = (byte)-1;
        this.col0 = -1;
        this.col1 = -1;
        this.col2 = -1;
        this.col3 = -1;
        this.bSingleCol = true;
        this.y3 = -1.0f;
        this.y2 = -1.0f;
        this.y1 = -1.0f;
        this.y0 = -1.0f;
        this.x3 = -1.0f;
        this.x2 = -1.0f;
        this.x1 = -1.0f;
        this.x0 = -1.0f;
        this.drawer = null;
    }

    public static void glLoadIdentity(TextureDraw textureDraw) {
        textureDraw.type = Type.glLoadIdentity;
    }

    public static void glGenerateMipMaps(TextureDraw textureDraw, int n) {
        textureDraw.type = Type.glGenerateMipMaps;
        textureDraw.a = n;
    }

    public static void glBind(TextureDraw textureDraw, int n) {
        textureDraw.type = Type.glBind;
        textureDraw.a = n;
    }

    public static void glViewport(TextureDraw textureDraw, int n, int n2, int n3, int n4) {
        textureDraw.type = Type.glViewport;
        textureDraw.a = n;
        textureDraw.b = n2;
        textureDraw.c = n3;
        textureDraw.d = n4;
    }

    public void postRender() {
        Shader shader;
        if (this.type == Type.StartShader && (shader = Shader.ShaderMap.get(this.a)) != null) {
            shader.postRender(this);
        }
        if (this.drawer != null) {
            this.drawer.postRender();
            this.drawer = null;
        }
    }

    public static enum Type {
        glDraw,
        glBuffer,
        glStencilFunc,
        glAlphaFunc,
        glStencilOp,
        glEnable,
        glDisable,
        glColorMask,
        glStencilMask,
        glClear,
        glBlendFunc,
        glDoStartFrame,
        glDoStartFrameText,
        glDoEndFrame,
        glTexParameteri,
        StartShader,
        glLoadIdentity,
        glGenerateMipMaps,
        glBind,
        glViewport,
        DrawModel,
        DrawSkyBox,
        DrawWater,
        DrawPuddles,
        DrawParticles,
        ShaderUpdate,
        BindActiveTexture,
        glBlendEquation,
        glDoStartFrameFx,
        glDoEndFrameFx,
        glIgnoreStyles,
        glClearColor,
        glBlendFuncSeparate,
        glDepthMask,
        doCoreIntParam,
        drawTerrain;

    }

    public static abstract class GenericDrawer {
        public abstract void render();

        public void postRender() {
        }
    }
}

