/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.textures;

import java.nio.IntBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL30;
import org.lwjglx.opengl.OpenGLException;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.SpriteRenderer;
import zombie.core.opengl.PZGLUtil;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureCombinerCommand;
import zombie.core.textures.TextureCombinerShaderParam;
import zombie.core.textures.TextureFBO;
import zombie.core.utils.ImageUtils;

public final class TextureCombiner {
    public static final TextureCombiner instance = new TextureCombiner();
    public static int count = 0;
    private TextureFBO fbo;
    private final float m_coordinateSpaceMax = 256.0f;
    private final ArrayList<CombinerFBO> fboPool = new ArrayList();

    public void init() throws Exception {
    }

    public void combineStart() {
        this.clear();
        count = 33984;
        GL13.glEnable((int)3042);
        GL13.glEnable((int)3553);
        GL13.glTexEnvi((int)8960, (int)8704, (int)7681);
    }

    public void combineEnd() {
        GL13.glActiveTexture((int)33984);
    }

    public void clear() {
        for (int i = 33985; i <= count; ++i) {
            GL13.glActiveTexture((int)i);
            GL13.glDisable((int)3553);
        }
        GL13.glActiveTexture((int)33984);
    }

    public void overlay(Texture texture) {
        GL13.glActiveTexture((int)count);
        GL13.glEnable((int)3553);
        GL13.glEnable((int)3042);
        texture.bind();
        if (count > 33984) {
            GL13.glTexEnvi((int)8960, (int)8704, (int)34160);
            GL13.glTexEnvi((int)8960, (int)34161, (int)34165);
            GL13.glTexEnvi((int)8960, (int)34176, (int)34168);
            GL13.glTexEnvi((int)8960, (int)34177, (int)5890);
            GL13.glTexEnvi((int)8960, (int)34178, (int)34168);
            GL13.glTexEnvi((int)8960, (int)34192, (int)768);
            GL13.glTexEnvi((int)8960, (int)34193, (int)768);
            GL13.glTexEnvi((int)8960, (int)34194, (int)770);
            GL13.glTexEnvi((int)8960, (int)34162, (int)34165);
            GL13.glTexEnvi((int)8960, (int)34184, (int)34168);
            GL13.glTexEnvi((int)8960, (int)34185, (int)5890);
            GL13.glTexEnvi((int)8960, (int)34186, (int)34168);
            GL13.glTexEnvi((int)8960, (int)34200, (int)770);
            GL13.glTexEnvi((int)8960, (int)34201, (int)770);
            GL13.glTexEnvi((int)8960, (int)34202, (int)770);
        }
        ++count;
    }

    public Texture combine(Texture texture, Texture texture2) throws Exception {
        Core.getInstance().DoStartFrameStuff(texture.width, texture2.width, 1.0f, 0);
        Texture texture3 = new Texture(texture.width, texture2.height, 16);
        if (this.fbo == null) {
            this.fbo = new TextureFBO(texture3);
        } else {
            this.fbo.setTexture(texture3);
        }
        GL13.glActiveTexture((int)33984);
        GL13.glEnable((int)3553);
        GL13.glBindTexture((int)3553, (int)texture.getID());
        this.fbo.startDrawing(true, true);
        GL13.glBegin((int)7);
        GL13.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL13.glTexCoord2f((float)0.0f, (float)0.0f);
        GL13.glVertex2d((double)0.0, (double)0.0);
        GL13.glTexCoord2f((float)0.0f, (float)1.0f);
        GL13.glVertex2d((double)0.0, (double)texture.height);
        GL13.glTexCoord2f((float)1.0f, (float)1.0f);
        GL13.glVertex2d((double)texture.width, (double)texture.height);
        GL13.glTexCoord2f((float)1.0f, (float)0.0f);
        GL13.glVertex2d((double)texture.width, (double)0.0);
        GL13.glEnd();
        GL13.glBindTexture((int)3553, (int)texture2.getID());
        GL13.glBegin((int)7);
        GL13.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL13.glTexCoord2f((float)0.0f, (float)0.0f);
        GL13.glVertex2d((double)0.0, (double)0.0);
        GL13.glTexCoord2f((float)0.0f, (float)1.0f);
        GL13.glVertex2d((double)0.0, (double)texture.height);
        GL13.glTexCoord2f((float)1.0f, (float)1.0f);
        GL13.glVertex2d((double)texture.width, (double)texture.height);
        GL13.glTexCoord2f((float)1.0f, (float)0.0f);
        GL13.glVertex2d((double)texture.width, (double)0.0);
        GL13.glEnd();
        this.fbo.endDrawing();
        Core.getInstance().DoEndFrameStuff(texture.width, texture2.width);
        return texture3;
    }

    public static int[] flipPixels(int[] nArray, int n, int n2) {
        int[] nArray2 = null;
        if (nArray != null) {
            nArray2 = new int[n * n2];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    nArray2[(n2 - i - 1) * n + j] = nArray[i * n + j];
                }
            }
        }
        return nArray2;
    }

    private CombinerFBO getFBO(int n, int n2) {
        for (int i = 0; i < this.fboPool.size(); ++i) {
            CombinerFBO combinerFBO = this.fboPool.get(i);
            if (combinerFBO.fbo.getWidth() != n || combinerFBO.fbo.getHeight() != n2) continue;
            return combinerFBO;
        }
        return null;
    }

    private Texture createTexture(int n, int n2) {
        Texture texture;
        CombinerFBO combinerFBO = this.getFBO(n, n2);
        if (combinerFBO == null) {
            combinerFBO = new CombinerFBO();
            texture = new Texture(n, n2, 16);
            combinerFBO.fbo = new TextureFBO(texture);
            this.fboPool.add(combinerFBO);
        } else {
            texture = combinerFBO.textures.isEmpty() ? new Texture(n, n2, 16) : combinerFBO.textures.pop();
            texture.bind();
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)texture.getWidthHW(), (int)texture.getHeightHW(), (int)0, (int)6408, (int)5121, (IntBuffer)null);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            texture.dataid.setMinFilter(9729);
            Texture.lastTextureID = 0;
            GL13.glBindTexture((int)3553, (int)0);
            combinerFBO.fbo.setTexture(texture);
        }
        this.fbo = combinerFBO.fbo;
        return texture;
    }

    public void releaseTexture(Texture texture) {
        CombinerFBO combinerFBO = this.getFBO(texture.getWidth(), texture.getHeight());
        if (combinerFBO != null && combinerFBO.textures.size() < 100) {
            combinerFBO.textures.push(texture);
        } else {
            texture.destroy();
        }
    }

    public Texture combine(ArrayList<TextureCombinerCommand> arrayList) throws Exception, OpenGLException {
        PZGLUtil.checkGLErrorThrow("Enter", new Object[0]);
        int n = TextureCombiner.getResultingWidth(arrayList);
        int n2 = TextureCombiner.getResultingHeight(arrayList);
        Texture texture = this.createTexture(n, n2);
        GL13.glPushAttrib((int)24576);
        GL11.glDisable((int)3089);
        GL11.glDisable((int)2960);
        this.fbo.startDrawing(true, true);
        PZGLUtil.checkGLErrorThrow("FBO.startDrawing %s", this.fbo);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        Core.getInstance().DoStartFrameStuffSmartTextureFx(n, n2, -1);
        PZGLUtil.checkGLErrorThrow("Core.DoStartFrameStuffFx w:%d, h:%d", n, n2);
        for (int i = 0; i < arrayList.size(); ++i) {
            TextureCombinerCommand textureCombinerCommand = arrayList.get(i);
            if (textureCombinerCommand.shader != null) {
                textureCombinerCommand.shader.Start();
            }
            GL13.glActiveTexture((int)33984);
            GL11.glEnable((int)3553);
            Texture texture2 = textureCombinerCommand.tex == null ? Texture.getErrorTexture() : textureCombinerCommand.tex;
            texture2.bind();
            if (textureCombinerCommand.mask != null) {
                GL13.glActiveTexture((int)33985);
                GL13.glEnable((int)3553);
                int n3 = Texture.lastTextureID;
                if (textureCombinerCommand.mask.getTextureId() != null) {
                    textureCombinerCommand.mask.getTextureId().setMagFilter(9728);
                    textureCombinerCommand.mask.getTextureId().setMinFilter(9728);
                }
                textureCombinerCommand.mask.bind();
                Texture.lastTextureID = n3;
            } else {
                GL13.glActiveTexture((int)33985);
                GL13.glDisable((int)3553);
            }
            if (textureCombinerCommand.shader != null) {
                if (textureCombinerCommand.shaderParams != null) {
                    ArrayList<TextureCombinerShaderParam> arrayList2 = textureCombinerCommand.shaderParams;
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        TextureCombinerShaderParam textureCombinerShaderParam = arrayList2.get(j);
                        float f = Rand.Next(textureCombinerShaderParam.min, textureCombinerShaderParam.max);
                        textureCombinerCommand.shader.setValue(textureCombinerShaderParam.name, f);
                    }
                }
                textureCombinerCommand.shader.setValue("DIFFUSE", texture2, 0);
                if (textureCombinerCommand.mask != null) {
                    textureCombinerCommand.shader.setValue("MASK", textureCombinerCommand.mask, 1);
                }
            }
            GL14.glBlendFuncSeparate((int)textureCombinerCommand.blendSrc, (int)textureCombinerCommand.blendDest, (int)textureCombinerCommand.blendSrcA, (int)textureCombinerCommand.blendDestA);
            if (textureCombinerCommand.x != -1) {
                float f = (float)n / 256.0f;
                float f2 = (float)n2 / 256.0f;
                GL13.glBegin((int)7);
                GL13.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL13.glTexCoord2f((float)0.0f, (float)1.0f);
                GL13.glVertex2d((double)((float)textureCombinerCommand.x * f), (double)((float)textureCombinerCommand.y * f2));
                GL13.glTexCoord2f((float)0.0f, (float)0.0f);
                GL13.glVertex2d((double)((float)textureCombinerCommand.x * f), (double)((float)(textureCombinerCommand.y + textureCombinerCommand.h) * f2));
                GL13.glTexCoord2f((float)1.0f, (float)0.0f);
                GL13.glVertex2d((double)((float)(textureCombinerCommand.x + textureCombinerCommand.w) * f), (double)((float)(textureCombinerCommand.y + textureCombinerCommand.h) * f2));
                GL13.glTexCoord2f((float)1.0f, (float)1.0f);
                GL13.glVertex2d((double)((float)(textureCombinerCommand.x + textureCombinerCommand.w) * f), (double)((float)textureCombinerCommand.y * f2));
                GL13.glEnd();
            } else {
                GL13.glBegin((int)7);
                GL13.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL13.glTexCoord2f((float)0.0f, (float)1.0f);
                GL13.glVertex2d((double)0.0, (double)0.0);
                GL13.glTexCoord2f((float)0.0f, (float)0.0f);
                GL13.glVertex2d((double)0.0, (double)n2);
                GL13.glTexCoord2f((float)1.0f, (float)0.0f);
                GL13.glVertex2d((double)n, (double)n2);
                GL13.glTexCoord2f((float)1.0f, (float)1.0f);
                GL13.glVertex2d((double)n, (double)0.0);
                GL13.glEnd();
            }
            if (textureCombinerCommand.shader != null) {
                textureCombinerCommand.shader.End();
            }
            PZGLUtil.checkGLErrorThrow("TextureCombinerCommand[%d}: %s", i, textureCombinerCommand);
        }
        Core.getInstance().DoEndFrameStuffFx(n, n2, -1);
        this.fbo.releaseTexture();
        this.fbo.endDrawing();
        PZGLUtil.checkGLErrorThrow("FBO.endDrawing: %s", this.fbo);
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL13.glBlendFunc((int)770, (int)771);
        GL13.glActiveTexture((int)33985);
        GL13.glDisable((int)3553);
        if (Core.OptionModelTextureMipmaps) {
            // empty if block
        }
        GL13.glActiveTexture((int)33984);
        Texture.lastTextureID = 0;
        GL13.glBindTexture((int)3553, (int)0);
        SpriteRenderer.ringBuffer.restoreBoundTextures = true;
        GL13.glPopAttrib();
        PZGLUtil.checkGLErrorThrow("Exit.", new Object[0]);
        return texture;
    }

    public static int getResultingHeight(ArrayList<TextureCombinerCommand> arrayList) {
        if (arrayList.isEmpty()) {
            return 32;
        }
        TextureCombinerCommand textureCombinerCommand2 = TextureCombiner.findDominantCommand(arrayList, Comparator.comparingInt(textureCombinerCommand -> textureCombinerCommand.tex.height));
        if (textureCombinerCommand2 == null) {
            return 32;
        }
        Texture texture = textureCombinerCommand2.tex;
        return ImageUtils.getNextPowerOfTwoHW(texture.height);
    }

    public static int getResultingWidth(ArrayList<TextureCombinerCommand> arrayList) {
        if (arrayList.isEmpty()) {
            return 32;
        }
        TextureCombinerCommand textureCombinerCommand2 = TextureCombiner.findDominantCommand(arrayList, Comparator.comparingInt(textureCombinerCommand -> textureCombinerCommand.tex.width));
        if (textureCombinerCommand2 == null) {
            return 32;
        }
        Texture texture = textureCombinerCommand2.tex;
        return ImageUtils.getNextPowerOfTwoHW(texture.width);
    }

    private static TextureCombinerCommand findDominantCommand(ArrayList<TextureCombinerCommand> arrayList, Comparator<TextureCombinerCommand> comparator) {
        TextureCombinerCommand textureCombinerCommand = null;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            TextureCombinerCommand textureCombinerCommand2 = arrayList.get(i);
            if (textureCombinerCommand2.tex == null || textureCombinerCommand != null && comparator.compare(textureCombinerCommand2, textureCombinerCommand) <= 0) continue;
            textureCombinerCommand = textureCombinerCommand2;
        }
        return textureCombinerCommand;
    }

    private void createMipMaps(Texture texture) {
        if (!GL.getCapabilities().OpenGL30) {
            return;
        }
        GL13.glActiveTexture((int)33984);
        texture.bind();
        GL30.glGenerateMipmap((int)3553);
        int n = 9987;
        GL11.glTexParameteri((int)3553, (int)10241, (int)n);
        texture.dataid.setMinFilter(n);
    }

    private static final class CombinerFBO {
        TextureFBO fbo;
        final ArrayDeque<Texture> textures = new ArrayDeque();

        private CombinerFBO() {
        }
    }
}

