/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.textures;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public final class PNGSize {
    private static final byte[] SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final int IHDR = 1229472850;
    public int width;
    public int height;
    private int bitdepth;
    private int colorType;
    private int bytesPerPixel;
    private InputStream input;
    private final CRC32 crc = new CRC32();
    private final byte[] buffer = new byte[4096];
    private int chunkLength;
    private int chunkType;
    private int chunkRemaining;

    public void readSize(String string) {
        try (FileInputStream fileInputStream = new FileInputStream(string);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            this.readSize(bufferedInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void readSize(InputStream inputStream) throws IOException {
        this.input = inputStream;
        this.readFully(this.buffer, 0, SIGNATURE.length);
        if (!this.checkSignature(this.buffer)) {
            throw new IOException("Not a valid PNG file");
        }
        this.openChunk(1229472850);
        this.readIHDR();
        this.closeChunk();
    }

    private void readIHDR() throws IOException {
        this.checkChunkLength(13);
        this.readChunk(this.buffer, 0, 13);
        this.width = this.readInt(this.buffer, 0);
        this.height = this.readInt(this.buffer, 4);
        this.bitdepth = this.buffer[8] & 0xFF;
        this.colorType = this.buffer[9] & 0xFF;
    }

    private void openChunk() throws IOException {
        this.readFully(this.buffer, 0, 8);
        this.chunkLength = this.readInt(this.buffer, 0);
        this.chunkType = this.readInt(this.buffer, 4);
        this.chunkRemaining = this.chunkLength;
        this.crc.reset();
        this.crc.update(this.buffer, 4, 4);
    }

    private void openChunk(int n) throws IOException {
        this.openChunk();
        if (this.chunkType != n) {
            throw new IOException("Expected chunk: " + Integer.toHexString(n));
        }
    }

    private void closeChunk() throws IOException {
        if (this.chunkRemaining > 0) {
            this.skip(this.chunkRemaining + 4);
        } else {
            this.readFully(this.buffer, 0, 4);
            int n = this.readInt(this.buffer, 0);
            int n2 = (int)this.crc.getValue();
            if (n2 != n) {
                throw new IOException("Invalid CRC");
            }
        }
        this.chunkRemaining = 0;
        this.chunkLength = 0;
        this.chunkType = 0;
    }

    private void checkChunkLength(int n) throws IOException {
        if (this.chunkLength != n) {
            throw new IOException("Chunk has wrong size");
        }
    }

    private int readChunk(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > this.chunkRemaining) {
            n2 = this.chunkRemaining;
        }
        this.readFully(byArray, n, n2);
        this.crc.update(byArray, n, n2);
        this.chunkRemaining -= n2;
        return n2;
    }

    private void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        do {
            if ((n3 = this.input.read(byArray, n, n2)) < 0) {
                throw new EOFException();
            }
            n += n3;
        } while ((n2 -= n3) > 0);
    }

    private int readInt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private void skip(long l) throws IOException {
        while (l > 0L) {
            long l2 = this.input.skip(l);
            if (l2 < 0L) {
                throw new EOFException();
            }
            l -= l2;
        }
    }

    private boolean checkSignature(byte[] byArray) {
        for (int i = 0; i < SIGNATURE.length; ++i) {
            if (byArray[i] == SIGNATURE[i]) continue;
            return false;
        }
        return true;
    }
}

