/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.textures;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import zombie.core.opengl.RenderThread;
import zombie.core.textures.Texture;
import zombie.core.utils.BooleanGrid;
import zombie.core.utils.WrappedBuffer;
import zombie.interfaces.ITexture;

public final class Mask
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5679205580926696806L;
    private boolean full;
    private int height;
    BooleanGrid mask;
    private int width;

    protected Mask() {
    }

    public Mask(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.mask = new BooleanGrid(n, n2);
        this.full();
    }

    public Mask(Texture texture, Texture texture2, int n, int n2, int n3, int n4) {
        if (texture.getMask() == null) {
            return;
        }
        n3 = texture2.getWidth();
        n4 = texture2.getHeight();
        texture2.setMask(this);
        this.mask = new BooleanGrid(n3, n4);
        for (int i = n; i < n + n3; ++i) {
            for (int j = n2; j < n2 + n4; ++j) {
                this.mask.setValue(i - n, j - n2, texture.getMask().mask.getValue(i, j));
            }
        }
    }

    public Mask(Mask mask, int n, int n2, int n3, int n4) {
        this.width = n3;
        this.height = n4;
        this.mask = new BooleanGrid(n3, n4);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                this.mask.setValue(i, j, mask.mask.getValue(n + i, n2 + j));
            }
        }
    }

    public Mask(boolean[] blArray, int n, int n2, int n3, int n4, int n5, int n6) {
        this.width = n5;
        this.height = n6;
        this.mask = new BooleanGrid(n5, n6);
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n6; ++j) {
                this.mask.setValue(i, j, blArray[n3 + i + (n4 + j) * n]);
            }
        }
    }

    public Mask(BooleanGrid booleanGrid, int n, int n2, int n3, int n4, int n5, int n6) {
        this.width = n5;
        this.height = n6;
        this.mask = new BooleanGrid(n5, n6);
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n6; ++j) {
                this.mask.setValue(i, j, booleanGrid.getValue(n3 + i, n4 + j));
            }
        }
    }

    protected Mask(Texture texture, WrappedBuffer wrappedBuffer) {
        this.width = texture.getWidth();
        this.height = texture.getHeight();
        int n = texture.getWidthHW();
        int n2 = texture.getHeightHW();
        int n3 = (int)(texture.getXStart() * (float)n);
        int n4 = (int)(texture.getXEnd() * (float)n);
        int n5 = (int)(texture.getYStart() * (float)n2);
        int n6 = (int)(texture.getYEnd() * (float)n2);
        this.mask = new BooleanGrid(this.width, this.height);
        texture.setMask(this);
        ByteBuffer byteBuffer = wrappedBuffer.getBuffer();
        byteBuffer.rewind();
        block0: for (int i = 0; i < texture.getHeightHW(); ++i) {
            for (int j = 0; j < texture.getWidthHW(); ++j) {
                byteBuffer.get();
                byteBuffer.get();
                byteBuffer.get();
                byte by = byteBuffer.get();
                if (j >= n3 && j < n4 && i >= n5 && i < n6) {
                    if (by == 0) {
                        this.mask.setValue(j - n3, i - n5, false);
                        this.full = false;
                    } else {
                        if (by < 127) {
                            this.mask.setValue(j - n3, i - n5, true);
                        }
                        this.mask.setValue(j - n3, i - n5, true);
                    }
                }
                if (i >= n6) continue block0;
            }
        }
        wrappedBuffer.dispose();
    }

    public Mask(ITexture iTexture, boolean[] blArray) {
        this.width = iTexture.getWidth();
        this.height = iTexture.getHeight();
        int n = iTexture.getWidthHW();
        int n2 = (int)(iTexture.getXStart() * (float)n);
        int n3 = (int)(iTexture.getXEnd() * (float)n);
        n = iTexture.getHeightHW();
        int n4 = (int)(iTexture.getYStart() * (float)n);
        int n5 = (int)(iTexture.getYEnd() * (float)n);
        iTexture.setMask(this);
        this.mask = new BooleanGrid(this.width, this.height);
        for (int i = 0; i < iTexture.getHeight(); ++i) {
            for (int j = 0; j < iTexture.getWidth(); ++j) {
                this.mask.setValue(j, i, blArray[i * iTexture.getWidth() + j]);
            }
        }
    }

    public Mask(ITexture iTexture, BooleanGrid booleanGrid) {
        this.width = iTexture.getWidth();
        this.height = iTexture.getHeight();
        iTexture.setMask(this);
        this.mask = new BooleanGrid(this.width, this.height);
        for (int i = 0; i < iTexture.getHeight(); ++i) {
            for (int j = 0; j < iTexture.getWidth(); ++j) {
                this.mask.setValue(j, i, booleanGrid.getValue(j, i));
            }
        }
    }

    public Mask(ITexture iTexture) {
        this.width = iTexture.getWidth();
        this.height = iTexture.getHeight();
        int n = iTexture.getWidthHW();
        int n2 = (int)(iTexture.getXStart() * (float)n);
        int n3 = (int)(iTexture.getXEnd() * (float)n);
        n = iTexture.getHeightHW();
        int n4 = (int)(iTexture.getYStart() * (float)n);
        int n5 = (int)(iTexture.getYEnd() * (float)n);
        iTexture.setMask(this);
        this.mask = new BooleanGrid(this.width, this.height);
        RenderThread.invokeOnRenderContext(() -> {
            WrappedBuffer wrappedBuffer = iTexture.getData();
            ByteBuffer byteBuffer = wrappedBuffer.getBuffer();
            byteBuffer.rewind();
            block0: for (int i = 0; i < iTexture.getHeightHW(); ++i) {
                for (int j = 0; j < iTexture.getWidthHW(); ++j) {
                    byteBuffer.get();
                    byteBuffer.get();
                    byteBuffer.get();
                    byte by = byteBuffer.get();
                    if (j >= n2 && j < n3 && i >= n4 && i < n5) {
                        if (by == 0) {
                            this.mask.setValue(j - n2, i - n4, false);
                            this.full = false;
                        } else {
                            if (by < 127) {
                                this.mask.setValue(j - n2, i - n4, true);
                            } else {
                                boolean bl = false;
                            }
                            this.mask.setValue(j - n2, i - n4, true);
                        }
                    }
                    if (i >= n5) continue block0;
                }
            }
            wrappedBuffer.dispose();
        });
    }

    public Mask(Mask mask) {
        this.width = mask.width;
        this.height = mask.height;
        this.full = mask.full;
        try {
            this.mask = mask.mask.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace(System.err);
        }
    }

    public Object clone() {
        return new Mask(this);
    }

    public void full() {
        this.mask.fill();
        this.full = true;
    }

    public void set(int n, int n2, boolean bl) {
        this.mask.setValue(n, n2, bl);
        if (!bl && this.full) {
            this.full = false;
        }
    }

    public boolean get(int n, int n2) {
        if (this.full) {
            return true;
        }
        return this.mask.getValue(n, n2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.width = objectInputStream.readInt();
        this.height = objectInputStream.readInt();
        this.full = objectInputStream.readBoolean();
        if (objectInputStream.readBoolean()) {
            this.mask = (BooleanGrid)objectInputStream.readObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.width);
        objectOutputStream.writeInt(this.height);
        objectOutputStream.writeBoolean(this.full);
        if (this.mask != null) {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(this.mask);
        } else {
            objectOutputStream.writeBoolean(false);
        }
    }

    public void save(String string) {
    }
}

