/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.stash;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import se.krka.kahlua.j2se.KahluaTableImpl;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaManager;
import zombie.SandboxOptions;
import zombie.VirtualZombieManager;
import zombie.ZombieSpawnRecorder;
import zombie.characters.IsoZombie;
import zombie.core.Rand;
import zombie.core.stash.Stash;
import zombie.core.stash.StashAnnotation;
import zombie.core.stash.StashBuilding;
import zombie.core.stash.StashContainer;
import zombie.debug.DebugLog;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.ItemPickerJava;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.InventoryContainer;
import zombie.inventory.types.MapItem;
import zombie.iso.BuildingDef;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.RoomDef;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoTrap;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.interfaces.BarricadeAble;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.ui.UIFont;
import zombie.util.Type;
import zombie.worldMap.symbols.WorldMapBaseSymbol;

public final class StashSystem {
    public static ArrayList<Stash> allStashes;
    public static ArrayList<StashBuilding> possibleStashes;
    public static ArrayList<StashBuilding> buildingsToDo;
    private static final ArrayList<String> possibleTrap;
    private static ArrayList<String> alreadyReadMap;

    public static void init() {
        if (possibleStashes == null) {
            StashSystem.initAllStashes();
            buildingsToDo = new ArrayList();
            possibleTrap.add("Base.FlameTrapSensorV1");
            possibleTrap.add("Base.SmokeBombSensorV1");
            possibleTrap.add("Base.NoiseTrapSensorV1");
            possibleTrap.add("Base.NoiseTrapSensorV2");
            possibleTrap.add("Base.AerosolbombSensorV1");
        }
    }

    public static void initAllStashes() {
        allStashes = new ArrayList();
        possibleStashes = new ArrayList();
        KahluaTable kahluaTable = (KahluaTable)LuaManager.env.rawget((Object)"StashDescriptions");
        KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
        while (kahluaTableIterator.advance()) {
            KahluaTableImpl kahluaTableImpl = (KahluaTableImpl)kahluaTableIterator.getValue();
            Stash stash = new Stash(kahluaTableImpl.rawgetStr((Object)"name"));
            stash.load(kahluaTableImpl);
            allStashes.add(stash);
        }
    }

    public static void checkStashItem(InventoryItem inventoryItem) {
        if (GameClient.bClient || possibleStashes.isEmpty()) {
            return;
        }
        int n = 60;
        if (inventoryItem.getStashChance() > 0) {
            n = inventoryItem.getStashChance();
        }
        switch (SandboxOptions.instance.AnnotatedMapChance.getValue()) {
            case 1: {
                return;
            }
            case 2: {
                n += 15;
                break;
            }
            case 3: {
                n += 10;
                break;
            }
            case 5: {
                n -= 10;
                break;
            }
            case 6: {
                n -= 20;
            }
        }
        if (Rand.Next(100) > 100 - n) {
            return;
        }
        ArrayList<Stash> arrayList = new ArrayList<Stash>();
        for (int i = 0; i < allStashes.size(); ++i) {
            Stash stash = allStashes.get(i);
            if (!stash.item.equals(inventoryItem.getFullType()) || !StashSystem.checkSpecificSpawnProperties(stash, inventoryItem)) continue;
            boolean bl = false;
            for (int j = 0; j < possibleStashes.size(); ++j) {
                StashBuilding stashBuilding = possibleStashes.get(j);
                if (!stashBuilding.stashName.equals(stash.name)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList.add(stash);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        Stash stash = (Stash)arrayList.get(Rand.Next(0, arrayList.size()));
        StashSystem.doStashItem(stash, inventoryItem);
    }

    public static void doStashItem(Stash stash, InventoryItem inventoryItem) {
        if (stash.customName != null) {
            inventoryItem.setName(stash.customName);
        }
        if ("Map".equals(stash.type)) {
            MapItem mapItem = Type.tryCastTo(inventoryItem, MapItem.class);
            if (mapItem == null) {
                throw new IllegalArgumentException(inventoryItem + " is not a MapItem");
            }
            if (stash.annotations != null) {
                for (int i = 0; i < stash.annotations.size(); ++i) {
                    StashAnnotation stashAnnotation = stash.annotations.get(i);
                    if (stashAnnotation.symbol != null) {
                        mapItem.getSymbols().addTexture(stashAnnotation.symbol, stashAnnotation.x, stashAnnotation.y, 0.5f, 0.5f, WorldMapBaseSymbol.DEFAULT_SCALE, stashAnnotation.r, stashAnnotation.g, stashAnnotation.b, 1.0f);
                        continue;
                    }
                    if (stashAnnotation.text == null) continue;
                    mapItem.getSymbols().addUntranslatedText(stashAnnotation.text, UIFont.Handwritten, stashAnnotation.x, stashAnnotation.y, stashAnnotation.r, stashAnnotation.g, stashAnnotation.b, 1.0f);
                }
            }
            StashSystem.removeFromPossibleStash(stash);
            inventoryItem.setStashMap(stash.name);
        }
    }

    public static void prepareBuildingStash(String string) {
        if (string == null) {
            return;
        }
        Stash stash = StashSystem.getStash(string);
        if (stash != null && !alreadyReadMap.contains(string)) {
            alreadyReadMap.add(string);
            buildingsToDo.add(new StashBuilding(stash.name, stash.buildingX, stash.buildingY));
            RoomDef roomDef = IsoWorld.instance.getMetaGrid().getRoomAt(stash.buildingX, stash.buildingY, 0);
            if (roomDef != null && roomDef.getBuilding() != null && roomDef.getBuilding().isFullyStreamedIn()) {
                StashSystem.doBuildingStash(roomDef.getBuilding());
            }
        }
    }

    private static boolean checkSpecificSpawnProperties(Stash stash, InventoryItem inventoryItem) {
        if (stash.spawnOnlyOnZed && (inventoryItem.getContainer() == null || !(inventoryItem.getContainer().getParent() instanceof IsoDeadBody))) {
            return false;
        }
        return (stash.minDayToSpawn <= -1 || GameTime.instance.getDaysSurvived() >= stash.minDayToSpawn) && (stash.maxDayToSpawn <= -1 || GameTime.instance.getDaysSurvived() <= stash.maxDayToSpawn);
    }

    private static void removeFromPossibleStash(Stash stash) {
        for (int i = 0; i < possibleStashes.size(); ++i) {
            StashBuilding stashBuilding = possibleStashes.get(i);
            if (stashBuilding.buildingX != stash.buildingX || stashBuilding.buildingY != stash.buildingY) continue;
            possibleStashes.remove(i);
            --i;
        }
    }

    public static void doBuildingStash(BuildingDef buildingDef) {
        if (buildingsToDo == null) {
            StashSystem.init();
        }
        for (int i = 0; i < buildingsToDo.size(); ++i) {
            ItemPickerJava.ItemPickerRoom itemPickerRoom;
            StashBuilding stashBuilding = buildingsToDo.get(i);
            if (stashBuilding.buildingX <= buildingDef.x || stashBuilding.buildingX >= buildingDef.x2 || stashBuilding.buildingY <= buildingDef.y || stashBuilding.buildingY >= buildingDef.y2) continue;
            if (buildingDef.hasBeenVisited) {
                buildingsToDo.remove(i);
                --i;
                continue;
            }
            Stash stash = StashSystem.getStash(stashBuilding.stashName);
            if (stash == null || (itemPickerRoom = (ItemPickerJava.ItemPickerRoom)ItemPickerJava.rooms.get((Object)stash.spawnTable)) == null) continue;
            buildingDef.setAllExplored(true);
            StashSystem.doSpecificBuildingProperties(stash, buildingDef);
            for (int j = buildingDef.x - 1; j < buildingDef.x2 + 1; ++j) {
                for (int k = buildingDef.y - 1; k < buildingDef.y2 + 1; ++k) {
                    for (int i2 = 0; i2 < 8; ++i2) {
                        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(j, k, i2);
                        if (isoGridSquare == null) continue;
                        for (int i3 = 0; i3 < isoGridSquare.getObjects().size(); ++i3) {
                            Object object;
                            IsoObject isoObject = isoGridSquare.getObjects().get(i3);
                            if (isoObject.getContainer() != null && isoGridSquare.getRoom() != null && isoGridSquare.getRoom().getBuilding().getDef() == buildingDef && isoGridSquare.getRoom().getName() != null && itemPickerRoom.Containers.containsKey((Object)isoObject.getContainer().getType())) {
                                object = (ItemPickerJava.ItemPickerRoom)ItemPickerJava.rooms.get((Object)isoGridSquare.getRoom().getName());
                                boolean bl = false;
                                if (object == null || !((ItemPickerJava.ItemPickerRoom)object).Containers.containsKey((Object)isoObject.getContainer().getType())) {
                                    isoObject.getContainer().clear();
                                    bl = true;
                                }
                                ItemPickerJava.fillContainerType(itemPickerRoom, isoObject.getContainer(), "", null);
                                ItemPickerJava.updateOverlaySprite(isoObject);
                                if (bl) {
                                    isoObject.getContainer().setExplored(true);
                                }
                            }
                            object = Type.tryCastTo(isoObject, BarricadeAble.class);
                            if (stash.barricades <= -1 || object == null || !object.isBarricadeAllowed() || Rand.Next(100) >= stash.barricades) continue;
                            if (isoObject instanceof IsoDoor) {
                                ((IsoDoor)isoObject).addRandomBarricades();
                                continue;
                            }
                            if (!(isoObject instanceof IsoWindow)) continue;
                            ((IsoWindow)isoObject).addRandomBarricades();
                        }
                    }
                }
            }
            buildingsToDo.remove(i);
            --i;
        }
    }

    private static void doSpecificBuildingProperties(Stash stash, BuildingDef buildingDef) {
        Object object;
        Object object2;
        if (stash.containers != null) {
            ArrayList<RoomDef> arrayList = new ArrayList<RoomDef>();
            for (int i = 0; i < stash.containers.size(); ++i) {
                Object object3;
                object2 = stash.containers.get(i);
                object = null;
                if (!"all".equals(((StashContainer)object2).room)) {
                    for (int j = 0; j < buildingDef.rooms.size(); ++j) {
                        object3 = buildingDef.rooms.get(j);
                        if (!((StashContainer)object2).room.equals(((RoomDef)object3).name)) continue;
                        arrayList.add((RoomDef)object3);
                    }
                } else {
                    object = ((StashContainer)object2).contX > -1 && ((StashContainer)object2).contY > -1 && ((StashContainer)object2).contZ > -1 ? IsoWorld.instance.getCell().getGridSquare(((StashContainer)object2).contX, ((StashContainer)object2).contY, ((StashContainer)object2).contZ) : buildingDef.getFreeSquareInRoom();
                }
                if (!arrayList.isEmpty()) {
                    RoomDef roomDef = (RoomDef)arrayList.get(Rand.Next(0, arrayList.size()));
                    object = roomDef.getFreeSquare();
                }
                if (object != null) {
                    if (((StashContainer)object2).containerItem != null && !((StashContainer)object2).containerItem.isEmpty()) {
                        ItemPickerJava.ItemPickerRoom itemPickerRoom = (ItemPickerJava.ItemPickerRoom)ItemPickerJava.rooms.get((Object)stash.spawnTable);
                        if (itemPickerRoom == null) {
                            DebugLog.log("Container distribution " + stash.spawnTable + " not found");
                            return;
                        }
                        object3 = InventoryItemFactory.CreateItem(((StashContainer)object2).containerItem);
                        if (object3 == null) {
                            DebugLog.General.error("Item " + ((StashContainer)object2).containerItem + " Doesn't exist.");
                            return;
                        }
                        ItemPickerJava.ItemPickerContainer itemPickerContainer = (ItemPickerJava.ItemPickerContainer)itemPickerRoom.Containers.get((Object)((InventoryItem)object3).getType());
                        ItemPickerJava.rollContainerItem((InventoryContainer)object3, null, itemPickerContainer);
                        ((IsoGridSquare)object).AddWorldInventoryItem((InventoryItem)object3, 0.0f, 0.0f, 0.0f);
                        continue;
                    }
                    IsoThumpable isoThumpable = new IsoThumpable(((IsoGridSquare)object).getCell(), (IsoGridSquare)object, ((StashContainer)object2).containerSprite, false, null);
                    isoThumpable.setIsThumpable(false);
                    isoThumpable.container = new ItemContainer(((StashContainer)object2).containerType, (IsoGridSquare)object, isoThumpable);
                    ((IsoGridSquare)object).AddSpecialObject(isoThumpable);
                    ((IsoGridSquare)object).RecalcAllWithNeighbours(true);
                    continue;
                }
                DebugLog.log("No free room was found to spawn special container for stash " + stash.name);
            }
        }
        if (stash.minTrapToSpawn > -1) {
            for (int i = stash.minTrapToSpawn; i < stash.maxTrapToSpawn; ++i) {
                IsoGridSquare isoGridSquare = buildingDef.getFreeSquareInRoom();
                if (isoGridSquare == null) continue;
                object2 = (HandWeapon)InventoryItemFactory.CreateItem(possibleTrap.get(Rand.Next(0, possibleTrap.size())));
                if (GameServer.bServer) {
                    GameServer.AddExplosiveTrap((HandWeapon)object2, isoGridSquare, ((HandWeapon)object2).getSensorRange() > 0);
                    continue;
                }
                object = new IsoTrap((HandWeapon)object2, isoGridSquare.getCell(), isoGridSquare);
                isoGridSquare.AddTileObject((IsoObject)object);
            }
        }
        if (stash.zombies > -1) {
            for (int i = 0; i < buildingDef.rooms.size(); ++i) {
                RoomDef roomDef = buildingDef.rooms.get(i);
                if (!IsoWorld.getZombiesEnabled()) continue;
                int n = 1;
                int n2 = 0;
                for (int j = 0; j < roomDef.area; ++j) {
                    if (Rand.Next(100) >= stash.zombies) continue;
                    ++n2;
                }
                if (SandboxOptions.instance.Zombies.getValue() == 1) {
                    n2 += 4;
                } else if (SandboxOptions.instance.Zombies.getValue() == 2) {
                    n2 += 3;
                } else if (SandboxOptions.instance.Zombies.getValue() == 3) {
                    n2 += 2;
                } else if (SandboxOptions.instance.Zombies.getValue() == 5) {
                    n2 -= 4;
                }
                if (n2 > roomDef.area / 2) {
                    n2 = roomDef.area / 2;
                }
                if (n2 < n) {
                    n2 = n;
                }
                ArrayList<IsoZombie> arrayList = VirtualZombieManager.instance.addZombiesToMap(n2, roomDef, false);
                ZombieSpawnRecorder.instance.record(arrayList, "StashSystem");
            }
        }
    }

    public static Stash getStash(String string) {
        for (int i = 0; i < allStashes.size(); ++i) {
            Stash stash = allStashes.get(i);
            if (!stash.name.equals(string)) continue;
            return stash;
        }
        return null;
    }

    public static void visitedBuilding(BuildingDef buildingDef) {
        if (GameClient.bClient) {
            return;
        }
        for (int i = 0; i < possibleStashes.size(); ++i) {
            StashBuilding stashBuilding = possibleStashes.get(i);
            if (stashBuilding.buildingX <= buildingDef.x || stashBuilding.buildingX >= buildingDef.x2 || stashBuilding.buildingY <= buildingDef.y || stashBuilding.buildingY >= buildingDef.y2) continue;
            possibleStashes.remove(i);
            --i;
        }
    }

    public static void load(ByteBuffer byteBuffer, int n) {
        int n2;
        int n3;
        StashSystem.init();
        alreadyReadMap = new ArrayList();
        possibleStashes = new ArrayList();
        buildingsToDo = new ArrayList();
        int n4 = byteBuffer.getInt();
        for (n3 = 0; n3 < n4; ++n3) {
            possibleStashes.add(new StashBuilding(GameWindow.ReadString(byteBuffer), byteBuffer.getInt(), byteBuffer.getInt()));
        }
        n3 = byteBuffer.getInt();
        for (n2 = 0; n2 < n3; ++n2) {
            buildingsToDo.add(new StashBuilding(GameWindow.ReadString(byteBuffer), byteBuffer.getInt(), byteBuffer.getInt()));
        }
        if (n >= 109) {
            n2 = byteBuffer.getInt();
            for (int i = 0; i < n2; ++i) {
                alreadyReadMap.add(GameWindow.ReadString(byteBuffer));
            }
        }
    }

    public static void save(ByteBuffer byteBuffer) {
        StashBuilding stashBuilding;
        int n;
        if (allStashes == null) {
            return;
        }
        byteBuffer.putInt(possibleStashes.size());
        for (n = 0; n < possibleStashes.size(); ++n) {
            stashBuilding = possibleStashes.get(n);
            GameWindow.WriteString(byteBuffer, stashBuilding.stashName);
            byteBuffer.putInt(stashBuilding.buildingX);
            byteBuffer.putInt(stashBuilding.buildingY);
        }
        byteBuffer.putInt(buildingsToDo.size());
        for (n = 0; n < buildingsToDo.size(); ++n) {
            stashBuilding = buildingsToDo.get(n);
            GameWindow.WriteString(byteBuffer, stashBuilding.stashName);
            byteBuffer.putInt(stashBuilding.buildingX);
            byteBuffer.putInt(stashBuilding.buildingY);
        }
        byteBuffer.putInt(alreadyReadMap.size());
        for (n = 0; n < alreadyReadMap.size(); ++n) {
            GameWindow.WriteString(byteBuffer, alreadyReadMap.get(n));
        }
    }

    public static ArrayList<StashBuilding> getPossibleStashes() {
        return possibleStashes;
    }

    public static void reinit() {
        possibleStashes = null;
        alreadyReadMap = new ArrayList();
        StashSystem.init();
    }

    public static void Reset() {
        allStashes = null;
        possibleStashes = null;
        buildingsToDo = null;
        possibleTrap.clear();
        alreadyReadMap.clear();
    }

    static {
        possibleTrap = new ArrayList();
        alreadyReadMap = new ArrayList();
    }
}

