/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.stash;

import java.util.ArrayList;
import se.krka.kahlua.j2se.KahluaTableImpl;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.core.Translator;
import zombie.core.stash.StashAnnotation;
import zombie.core.stash.StashBuilding;
import zombie.core.stash.StashContainer;
import zombie.core.stash.StashSystem;
import zombie.debug.DebugLog;
import zombie.scripting.ScriptManager;

public final class Stash {
    public String name;
    public String type;
    public String item;
    public String customName;
    public int buildingX;
    public int buildingY;
    public String spawnTable;
    public ArrayList<StashAnnotation> annotations;
    public boolean spawnOnlyOnZed;
    public int minDayToSpawn = -1;
    public int maxDayToSpawn = -1;
    public int minTrapToSpawn = -1;
    public int maxTrapToSpawn = -1;
    public int zombies;
    public ArrayList<StashContainer> containers;
    public int barricades;

    public Stash(String string) {
        this.name = string;
    }

    public void load(KahluaTableImpl kahluaTableImpl) {
        Object object;
        KahluaTableImpl kahluaTableImpl2;
        KahluaTableIterator kahluaTableIterator;
        KahluaTable kahluaTable;
        Object object2;
        this.type = kahluaTableImpl.rawgetStr((Object)"type");
        this.item = kahluaTableImpl.rawgetStr((Object)"item");
        StashBuilding stashBuilding = new StashBuilding(this.name, kahluaTableImpl.rawgetInt((Object)"buildingX"), kahluaTableImpl.rawgetInt((Object)"buildingY"));
        StashSystem.possibleStashes.add(stashBuilding);
        this.buildingX = stashBuilding.buildingX;
        this.buildingY = stashBuilding.buildingY;
        this.spawnTable = kahluaTableImpl.rawgetStr((Object)"spawnTable");
        this.customName = Translator.getText(kahluaTableImpl.rawgetStr((Object)"customName"));
        this.zombies = kahluaTableImpl.rawgetInt((Object)"zombies");
        this.barricades = kahluaTableImpl.rawgetInt((Object)"barricades");
        this.spawnOnlyOnZed = kahluaTableImpl.rawgetBool((Object)"spawnOnlyOnZed");
        String string = kahluaTableImpl.rawgetStr((Object)"daysToSpawn");
        if (string != null) {
            object2 = string.split("-");
            if (((String[])object2).length == 2) {
                this.minDayToSpawn = Integer.parseInt((String)object2[0]);
                this.maxDayToSpawn = Integer.parseInt((String)object2[1]);
            } else {
                this.minDayToSpawn = Integer.parseInt((String)object2[0]);
            }
        }
        if ((object2 = kahluaTableImpl.rawgetStr((Object)"traps")) != null) {
            kahluaTable = ((String)object2).split("-");
            if (((KahluaTable)kahluaTable).length == 2) {
                this.minTrapToSpawn = Integer.parseInt((String)kahluaTable[0]);
                this.maxTrapToSpawn = Integer.parseInt((String)kahluaTable[1]);
            } else {
                this.maxTrapToSpawn = this.minTrapToSpawn = Integer.parseInt((String)kahluaTable[0]);
            }
        }
        if ((kahluaTable = (KahluaTable)kahluaTableImpl.rawget((Object)"containers")) != null) {
            this.containers = new ArrayList();
            kahluaTableIterator = kahluaTable.iterator();
            while (kahluaTableIterator.advance()) {
                kahluaTableImpl2 = (KahluaTableImpl)kahluaTableIterator.getValue();
                object = new StashContainer(kahluaTableImpl2.rawgetStr((Object)"room"), kahluaTableImpl2.rawgetStr((Object)"containerSprite"), kahluaTableImpl2.rawgetStr((Object)"containerType"));
                object.contX = kahluaTableImpl2.rawgetInt((Object)"contX");
                object.contY = kahluaTableImpl2.rawgetInt((Object)"contY");
                object.contZ = kahluaTableImpl2.rawgetInt((Object)"contZ");
                object.containerItem = kahluaTableImpl2.rawgetStr((Object)"containerItem");
                if (object.containerItem != null && ScriptManager.instance.getItem(object.containerItem) == null) {
                    DebugLog.General.error("Stash containerItem \"%s\" doesn't exist.", object.containerItem);
                }
                this.containers.add((StashContainer)object);
            }
        }
        if ("Map".equals(this.type) && (kahluaTableIterator = (KahluaTableImpl)kahluaTableImpl.rawget((Object)"annotations")) != null) {
            this.annotations = new ArrayList();
            kahluaTableImpl2 = kahluaTableIterator.iterator();
            while (kahluaTableImpl2.advance()) {
                object = (KahluaTable)kahluaTableImpl2.getValue();
                StashAnnotation stashAnnotation = new StashAnnotation();
                stashAnnotation.fromLua((KahluaTable)object);
                this.annotations.add(stashAnnotation);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getItem() {
        return this.item;
    }

    public int getBuildingX() {
        return this.buildingX;
    }

    public int getBuildingY() {
        return this.buildingY;
    }
}

