/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.sprite;

import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.Styles.TransparentStyle;
import zombie.core.opengl.GLState;
import zombie.core.opengl.RenderSettings;
import zombie.core.sprite.GenericSpriteRenderState;
import zombie.core.sprite.SpriteRenderStateUI;
import zombie.core.textures.TextureFBO;
import zombie.input.Mouse;
import zombie.iso.PlayerCamera;

public final class SpriteRenderState
extends GenericSpriteRenderState {
    public TextureFBO fbo = null;
    public long time;
    public final SpriteRenderStateUI stateUI;
    public int playerIndex;
    public final PlayerCamera[] playerCamera = new PlayerCamera[4];
    public final float[] playerAmbient = new float[4];
    public float maxZoomLevel = 0.0f;
    public float minZoomLevel = 0.0f;
    public final float[] zoomLevel = new float[4];

    public SpriteRenderState(int n) {
        super(n);
        for (int i = 0; i < 4; ++i) {
            this.playerCamera[i] = new PlayerCamera(i);
        }
        this.stateUI = new SpriteRenderStateUI(n);
    }

    @Override
    public void onRendered() {
        super.onRendered();
        this.stateUI.onRendered();
    }

    @Override
    public void onReady() {
        super.onReady();
        this.stateUI.onReady();
    }

    @Override
    public void CheckSpriteSlots() {
        if (this.stateUI.bActive) {
            this.stateUI.CheckSpriteSlots();
        } else {
            super.CheckSpriteSlots();
        }
    }

    @Override
    public void clear() {
        this.stateUI.clear();
        super.clear();
    }

    public GenericSpriteRenderState getActiveState() {
        return this.stateUI.bActive ? this.stateUI : this;
    }

    public void prePopulating() {
        this.clear();
        this.fbo = Core.getInstance().getOffscreenBuffer();
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null) continue;
            this.playerCamera[i].initFromIsoCamera(i);
            this.playerAmbient[i] = RenderSettings.getInstance().getAmbientForPlayer(i);
            this.zoomLevel[i] = Core.getInstance().getZoom(i);
            this.maxZoomLevel = Core.getInstance().getMaxZoom();
            this.minZoomLevel = Core.getInstance().getMinZoom();
        }
        this.defaultStyle = TransparentStyle.instance;
        this.bCursorVisible = Mouse.isCursorVisible();
        GLState.startFrame();
    }
}

