/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.sprite;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import zombie.core.Color;
import zombie.core.SpriteRenderer;
import zombie.core.Styles.AbstractStyle;
import zombie.core.Styles.Style;
import zombie.core.Styles.TransparentStyle;
import zombie.core.opengl.Shader;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureDraw;
import zombie.core.textures.TextureFBO;

public abstract class GenericSpriteRenderState {
    public final int index;
    public TextureDraw[] sprite = new TextureDraw[2048];
    public Style[] style = new Style[2048];
    public int numSprites;
    public TextureFBO fbo;
    public boolean bRendered;
    private boolean m_isRendering;
    public final ArrayList<TextureDraw> postRender = new ArrayList();
    public AbstractStyle defaultStyle = TransparentStyle.instance;
    public boolean bCursorVisible = true;
    public static final byte UVCA_NONE = -1;
    public static final byte UVCA_CIRCLE = 1;
    public static final byte UVCA_NOCIRCLE = 2;
    private byte useVertColorsArray = (byte)-1;
    private int texture2_color0;
    private int texture2_color1;
    private int texture2_color2;
    private int texture2_color3;
    private SpriteRenderer.WallShaderTexRender wallShaderTexRender;
    private Texture texture1_cutaway;
    private int texture1_cutaway_x;
    private int texture1_cutaway_y;
    private int texture1_cutaway_w;
    private int texture1_cutaway_h;

    protected GenericSpriteRenderState(int n) {
        this.index = n;
        for (int i = 0; i < this.sprite.length; ++i) {
            this.sprite[i] = new TextureDraw();
        }
    }

    public void onRendered() {
        this.m_isRendering = false;
        this.bRendered = true;
    }

    public void onRenderAcquired() {
        this.m_isRendering = true;
    }

    public boolean isRendering() {
        return this.m_isRendering;
    }

    public void onReady() {
        this.bRendered = false;
    }

    public boolean isReady() {
        return !this.bRendered;
    }

    public boolean isRendered() {
        return this.bRendered;
    }

    public void CheckSpriteSlots() {
        if (this.numSprites != this.sprite.length) {
            return;
        }
        TextureDraw[] textureDrawArray = this.sprite;
        this.sprite = new TextureDraw[this.numSprites * 3 / 2 + 1];
        for (int i = this.numSprites; i < this.sprite.length; ++i) {
            this.sprite[i] = new TextureDraw();
        }
        System.arraycopy(textureDrawArray, 0, this.sprite, 0, this.numSprites);
        Style[] styleArray = this.style;
        this.style = new Style[this.numSprites * 3 / 2 + 1];
        System.arraycopy(styleArray, 0, this.style, 0, this.numSprites);
    }

    public static void clearSprites(List<TextureDraw> list) {
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).postRender();
        }
        list.clear();
    }

    public void clear() {
        GenericSpriteRenderState.clearSprites(this.postRender);
        this.numSprites = 0;
    }

    public void glDepthMask(boolean bl) {
        this.CheckSpriteSlots();
        TextureDraw.glDepthMask(this.sprite[this.numSprites], bl);
        this.style[this.numSprites] = this.defaultStyle;
        ++this.numSprites;
    }

    public void renderflipped(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, Consumer<TextureDraw> consumer) {
        this.render(texture, f, f2, f3, f4, f5, f6, f7, f8, consumer);
        this.sprite[this.numSprites - 1].flipped = true;
    }

    public void drawSkyBox(Shader shader, int n, int n2, int n3) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.drawSkyBox(this.sprite[this.numSprites], shader, n, n2, n3);
        this.style[this.numSprites] = this.defaultStyle;
        ++this.numSprites;
    }

    public void drawWater(Shader shader, int n, int n2, boolean bl) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        shader.startMainThread(this.sprite[this.numSprites], n);
        TextureDraw.drawWater(this.sprite[this.numSprites], shader, n, n2, bl);
        this.style[this.numSprites] = this.defaultStyle;
        ++this.numSprites;
    }

    public void drawPuddles(Shader shader, int n, int n2, int n3) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.drawPuddles(this.sprite[this.numSprites], shader, n, n2, n3);
        this.style[this.numSprites] = this.defaultStyle;
        ++this.numSprites;
    }

    public void drawParticles(int n, int n2, int n3) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.drawParticles(this.sprite[this.numSprites], n, n2, n3);
        this.style[this.numSprites] = this.defaultStyle;
        ++this.numSprites;
    }

    public void glDisable(int n) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glDisable(this.sprite[this.numSprites], n);
        this.style[this.numSprites] = this.defaultStyle;
        ++this.numSprites;
    }

    public void glEnable(int n) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glEnable(this.sprite[this.numSprites], n);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void glStencilMask(int n) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glStencilMask(this.sprite[this.numSprites], n);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void glClear(int n) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glClear(this.sprite[this.numSprites], n);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void glClearColor(int n, int n2, int n3, int n4) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glClearColor(this.sprite[this.numSprites], n, n2, n3, n4);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void glStencilFunc(int n, int n2, int n3) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glStencilFunc(this.sprite[this.numSprites], n, n2, n3);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void glStencilOp(int n, int n2, int n3) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glStencilOp(this.sprite[this.numSprites], n, n2, n3);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void glColorMask(int n, int n2, int n3, int n4) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glColorMask(this.sprite[this.numSprites], n, n2, n3, n4);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void glAlphaFunc(int n, float f) {
        if (!SpriteRenderer.GL_BLENDFUNC_ENABLED) {
            return;
        }
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glAlphaFunc(this.sprite[this.numSprites], n, f);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void glBlendFunc(int n, int n2) {
        if (!SpriteRenderer.GL_BLENDFUNC_ENABLED) {
            return;
        }
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glBlendFunc(this.sprite[this.numSprites], n, n2);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void glBlendFuncSeparate(int n, int n2, int n3, int n4) {
        if (!SpriteRenderer.GL_BLENDFUNC_ENABLED) {
            return;
        }
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glBlendFuncSeparate(this.sprite[this.numSprites], n, n2, n3, n4);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void glBlendEquation(int n) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glBlendEquation(this.sprite[this.numSprites], n);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void render(Texture texture, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, float f, float f2, float f3, float f4, Consumer<TextureDraw> consumer) {
        this.render(texture, d, d2, d3, d4, d5, d6, d7, d8, f, f2, f3, f4, f, f2, f3, f4, f, f2, f3, f4, f, f2, f3, f4, consumer);
    }

    public void render(Texture texture, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, Consumer<TextureDraw> consumer) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        this.sprite[this.numSprites].reset();
        TextureDraw.Create(this.sprite[this.numSprites], texture, (float)d, (float)d2, (float)d3, (float)d4, (float)d5, (float)d6, (float)d7, (float)d8, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, consumer);
        if (this.useVertColorsArray != -1) {
            TextureDraw textureDraw = this.sprite[this.numSprites];
            textureDraw.useAttribArray = this.useVertColorsArray;
            textureDraw.tex1_col0 = this.texture2_color0;
            textureDraw.tex1_col1 = this.texture2_color1;
            textureDraw.tex1_col2 = this.texture2_color2;
            textureDraw.tex1_col3 = this.texture2_color3;
        }
        this.style[this.numSprites] = this.defaultStyle;
        ++this.numSprites;
    }

    public void setUseVertColorsArray(byte by, int n, int n2, int n3, int n4) {
        this.useVertColorsArray = by;
        this.texture2_color0 = n;
        this.texture2_color1 = n2;
        this.texture2_color2 = n3;
        this.texture2_color3 = n4;
    }

    public void clearUseVertColorsArray() {
        this.useVertColorsArray = (byte)-1;
    }

    public void renderdebug(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20, float f21, float f22, float f23, float f24, Consumer<TextureDraw> consumer) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        this.sprite[this.numSprites].reset();
        TextureDraw.Create(this.sprite[this.numSprites], texture, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19, f20, f21, f22, f23, f24, consumer);
        this.style[this.numSprites] = this.defaultStyle;
        ++this.numSprites;
    }

    public void renderline(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        this.sprite[this.numSprites].reset();
        if (f <= f3 && f2 <= f4) {
            TextureDraw.Create(this.sprite[this.numSprites], texture, f + (float)n, f2 - (float)n, f3 + (float)n, f4 - (float)n, f3 - (float)n, f4 + (float)n, f - (float)n, f2 + (float)n, f5, f6, f7, f8);
        } else if (f >= f3 && f2 >= f4) {
            TextureDraw.Create(this.sprite[this.numSprites], texture, f + (float)n, f2 - (float)n, f - (float)n, f2 + (float)n, f3 - (float)n, f4 + (float)n, f3 + (float)n, f4 - (float)n, f5, f6, f7, f8);
        } else if (f >= f3 && f2 <= f4) {
            TextureDraw.Create(this.sprite[this.numSprites], texture, f3 - (float)n, f4 - (float)n, f - (float)n, f2 - (float)n, f + (float)n, f2 + (float)n, f3 + (float)n, f4 + (float)n, f5, f6, f7, f8);
        } else if (f <= f3 && f2 >= f4) {
            TextureDraw.Create(this.sprite[this.numSprites], texture, f - (float)n, f2 - (float)n, f + (float)n, f2 + (float)n, f3 + (float)n, f4 + (float)n, f3 - (float)n, f4 - (float)n, f5, f6, f7, f8);
        }
        this.style[this.numSprites] = this.defaultStyle;
        ++this.numSprites;
    }

    public void renderline(Texture texture, int n, int n2, int n3, int n4, float f, float f2, float f3, float f4) {
        this.renderline(texture, n, n2, n3, n4, f, f2, f3, f4, 1);
    }

    public void render(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n, int n2, int n3, int n4) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        this.sprite[this.numSprites].reset();
        TextureDraw.Create(this.sprite[this.numSprites], texture, f, f2, f3, f4, f5, f6, f7, f8, n, n2, n3, n4);
        this.style[this.numSprites] = this.defaultStyle;
        ++this.numSprites;
    }

    public void render(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, Consumer<TextureDraw> consumer) {
        if (texture != null && !texture.isReady()) {
            return;
        }
        if (f8 == 0.0f) {
            return;
        }
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        this.sprite[this.numSprites].reset();
        int n = Color.colorToABGR(f5, f6, f7, f8);
        float f9 = f;
        float f10 = f2;
        float f11 = f + f3;
        float f12 = f2 + f4;
        TextureDraw textureDraw = this.wallShaderTexRender == null ? TextureDraw.Create(this.sprite[this.numSprites], texture, f9, f10, f11, f10, f11, f12, f, f12, n, n, n, n, consumer) : TextureDraw.Create(this.sprite[this.numSprites], texture, this.wallShaderTexRender, f9, f10, f11 - f9, f12 - f10, f5, f6, f7, f8, consumer);
        if (this.useVertColorsArray != -1) {
            textureDraw.useAttribArray = this.useVertColorsArray;
            textureDraw.tex1_col0 = this.texture2_color0;
            textureDraw.tex1_col1 = this.texture2_color1;
            textureDraw.tex1_col2 = this.texture2_color2;
            textureDraw.tex1_col3 = this.texture2_color3;
        }
        if (this.texture1_cutaway != null) {
            textureDraw.tex1 = this.texture1_cutaway;
            float f13 = this.texture1_cutaway.xEnd - this.texture1_cutaway.xStart;
            float f14 = this.texture1_cutaway.yEnd - this.texture1_cutaway.yStart;
            float f15 = (float)this.texture1_cutaway_x / (float)this.texture1_cutaway.getWidth();
            float f16 = (float)(this.texture1_cutaway_x + this.texture1_cutaway_w) / (float)this.texture1_cutaway.getWidth();
            float f17 = (float)this.texture1_cutaway_y / (float)this.texture1_cutaway.getHeight();
            float f18 = (float)(this.texture1_cutaway_y + this.texture1_cutaway_h) / (float)this.texture1_cutaway.getHeight();
            textureDraw.tex1_u0 = textureDraw.tex1_u3 = this.texture1_cutaway.xStart + f15 * f13;
            textureDraw.tex1_v0 = textureDraw.tex1_v1 = this.texture1_cutaway.yStart + f17 * f14;
            textureDraw.tex1_u1 = textureDraw.tex1_u2 = this.texture1_cutaway.xStart + f16 * f13;
            textureDraw.tex1_v2 = textureDraw.tex1_v3 = this.texture1_cutaway.yStart + f18 * f14;
        }
        this.style[this.numSprites] = this.defaultStyle;
        ++this.numSprites;
    }

    public void renderRect(int n, int n2, int n3, int n4, float f, float f2, float f3, float f4) {
        if (f4 == 0.0f) {
            return;
        }
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        this.sprite[this.numSprites].reset();
        TextureDraw.Create(this.sprite[this.numSprites], null, n, n2, n3, n4, f, f2, f3, f4, null);
        this.style[this.numSprites] = this.defaultStyle;
        ++this.numSprites;
    }

    public void renderPoly(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        this.sprite[this.numSprites].reset();
        TextureDraw.Create(this.sprite[this.numSprites], null, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
        this.style[this.numSprites] = this.defaultStyle;
        ++this.numSprites;
    }

    public void renderPoly(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        if (texture != null && !texture.isReady()) {
            return;
        }
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        this.sprite[this.numSprites].reset();
        TextureDraw.Create(this.sprite[this.numSprites], texture, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
        if (texture != null) {
            float f13 = texture.getXEnd();
            float f14 = texture.getXStart();
            float f15 = texture.getYEnd();
            float f16 = texture.getYStart();
            TextureDraw textureDraw = this.sprite[this.numSprites];
            textureDraw.u0 = f14;
            textureDraw.u1 = f13;
            textureDraw.u2 = f13;
            textureDraw.u3 = f14;
            textureDraw.v0 = f16;
            textureDraw.v1 = f16;
            textureDraw.v2 = f15;
            textureDraw.v3 = f15;
        }
        this.style[this.numSprites] = this.defaultStyle;
        ++this.numSprites;
    }

    public void renderPoly(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20) {
        if (texture != null && !texture.isReady()) {
            return;
        }
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        this.sprite[this.numSprites].reset();
        TextureDraw.Create(this.sprite[this.numSprites], texture, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
        if (texture != null) {
            TextureDraw textureDraw = this.sprite[this.numSprites];
            textureDraw.u0 = f13;
            textureDraw.u1 = f15;
            textureDraw.u2 = f17;
            textureDraw.u3 = f19;
            textureDraw.v0 = f14;
            textureDraw.v1 = f16;
            textureDraw.v2 = f18;
            textureDraw.v3 = f20;
        }
        this.style[this.numSprites] = this.defaultStyle;
        ++this.numSprites;
    }

    public void render(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, Consumer<TextureDraw> consumer) {
        if (f8 == 0.0f) {
            return;
        }
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        this.sprite[this.numSprites].reset();
        TextureDraw.Create(this.sprite[this.numSprites], texture, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, consumer);
        this.style[this.numSprites] = this.defaultStyle;
        ++this.numSprites;
    }

    public void glBuffer(int n, int n2) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glBuffer(this.sprite[this.numSprites], n, n2);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void glDoStartFrame(int n, int n2, float f, int n3) {
        this.glDoStartFrame(n, n2, f, n3, false);
    }

    public void glDoStartFrame(int n, int n2, float f, int n3, boolean bl) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glDoStartFrame(this.sprite[this.numSprites], n, n2, f, n3, bl);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void glDoStartFrameFx(int n, int n2, int n3) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glDoStartFrameFx(this.sprite[this.numSprites], n, n2, n3);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void glIgnoreStyles(boolean bl) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glIgnoreStyles(this.sprite[this.numSprites], bl);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void glDoEndFrame() {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glDoEndFrame(this.sprite[this.numSprites]);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void glDoEndFrameFx(int n) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glDoEndFrameFx(this.sprite[this.numSprites], n);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void doCoreIntParam(int n, float f) {
        this.CheckSpriteSlots();
        TextureDraw.doCoreIntParam(this.sprite[this.numSprites], n, f);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void glTexParameteri(int n, int n2, int n3) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glTexParameteri(this.sprite[this.numSprites], n, n2, n3);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void setCutawayTexture(Texture texture, int n, int n2, int n3, int n4) {
        this.texture1_cutaway = texture;
        this.texture1_cutaway_x = n;
        this.texture1_cutaway_y = n2;
        this.texture1_cutaway_w = n3;
        this.texture1_cutaway_h = n4;
    }

    public void clearCutawayTexture() {
        this.texture1_cutaway = null;
    }

    public void setExtraWallShaderParams(SpriteRenderer.WallShaderTexRender wallShaderTexRender) {
        this.wallShaderTexRender = wallShaderTexRender;
    }

    public void ShaderUpdate1i(int n, int n2, int n3) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.ShaderUpdate1i(this.sprite[this.numSprites], n, n2, n3);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void ShaderUpdate1f(int n, int n2, float f) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.ShaderUpdate1f(this.sprite[this.numSprites], n, n2, f);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void ShaderUpdate2f(int n, int n2, float f, float f2) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.ShaderUpdate2f(this.sprite[this.numSprites], n, n2, f, f2);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void ShaderUpdate3f(int n, int n2, float f, float f2, float f3) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.ShaderUpdate3f(this.sprite[this.numSprites], n, n2, f, f2, f3);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void ShaderUpdate4f(int n, int n2, float f, float f2, float f3, float f4) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.ShaderUpdate4f(this.sprite[this.numSprites], n, n2, f, f2, f3, f4);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void glLoadIdentity() {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glLoadIdentity(this.sprite[this.numSprites]);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void glGenerateMipMaps(int n) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glGenerateMipMaps(this.sprite[this.numSprites], n);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void glBind(int n) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glBind(this.sprite[this.numSprites], n);
        this.style[this.numSprites] = this.defaultStyle;
        ++this.numSprites;
    }

    public void glViewport(int n, int n2, int n3, int n4) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.glViewport(this.sprite[this.numSprites], n, n2, n3, n4);
        this.style[this.numSprites] = this.defaultStyle;
        ++this.numSprites;
    }

    public void drawModel(ModelManager.ModelSlot modelSlot) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.drawModel(this.sprite[this.numSprites], modelSlot);
        assert (this.sprite[this.numSprites].drawer != null);
        ArrayList<TextureDraw> arrayList = this.postRender;
        arrayList.add(this.sprite[this.numSprites]);
        this.style[this.numSprites] = this.defaultStyle;
        ++this.numSprites;
        ++modelSlot.renderRefCount;
    }

    public void drawGeneric(TextureDraw.GenericDrawer genericDrawer) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        this.sprite[this.numSprites].type = TextureDraw.Type.DrawModel;
        this.sprite[this.numSprites].drawer = genericDrawer;
        this.style[this.numSprites] = this.defaultStyle;
        ArrayList<TextureDraw> arrayList = this.postRender;
        arrayList.add(this.sprite[this.numSprites]);
        ++this.numSprites;
    }

    public void StartShader(int n, int n2) {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.StartShader(this.sprite[this.numSprites], n);
        if (n != 0 && Shader.ShaderMap.containsKey(n)) {
            Shader.ShaderMap.get(n).startMainThread(this.sprite[this.numSprites], n2);
            ArrayList<TextureDraw> arrayList = this.postRender;
            arrayList.add(this.sprite[this.numSprites]);
        }
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }

    public void EndShader() {
        if (this.numSprites == this.sprite.length) {
            this.CheckSpriteSlots();
        }
        TextureDraw.StartShader(this.sprite[this.numSprites], 0);
        this.style[this.numSprites] = TransparentStyle.instance;
        ++this.numSprites;
    }
}

