/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.population;

import java.util.List;
import zombie.core.Color;
import zombie.core.ImmutableColor;
import zombie.util.LocationRNG;

public final class OutfitRNG {
    private static final ThreadLocal<LocationRNG> RNG = ThreadLocal.withInitial(LocationRNG::new);

    public static void setSeed(long l) {
        RNG.get().setSeed(l);
    }

    public static long getSeed() {
        return RNG.get().getSeed();
    }

    public static int Next(int n) {
        return RNG.get().nextInt(n);
    }

    public static int Next(int n, int n2) {
        int n3;
        if (n2 == n) {
            return n;
        }
        if (n > n2) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        n3 = RNG.get().nextInt(n2 - n);
        return n3 + n;
    }

    public static float Next(float f, float f2) {
        if (f2 == f) {
            return f;
        }
        if (f > f2) {
            float f3 = f;
            f = f2;
            f2 = f3;
        }
        return f + RNG.get().nextFloat() * (f2 - f);
    }

    public static boolean NextBool(int n) {
        return OutfitRNG.Next(n) == 0;
    }

    public static <E> E pickRandom(List<E> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        int n = OutfitRNG.Next(list.size());
        return list.get(n);
    }

    public static ImmutableColor randomImmutableColor() {
        float f = OutfitRNG.Next(0.0f, 1.0f);
        float f2 = OutfitRNG.Next(0.0f, 0.6f);
        float f3 = OutfitRNG.Next(0.0f, 0.9f);
        Color color = Color.HSBtoRGB(f, f2, f3);
        return new ImmutableColor(color);
    }
}

