/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.population;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.TreeMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import zombie.DebugFileWatcher;
import zombie.PredicatedFileWatcher;
import zombie.ZomboidFileSystem;
import zombie.asset.AssetPath;
import zombie.core.Rand;
import zombie.core.logger.ExceptionLogger;
import zombie.core.skinnedmodel.population.ClothingItem;
import zombie.core.skinnedmodel.population.ClothingItemAssetManager;
import zombie.core.skinnedmodel.population.ClothingItemReference;
import zombie.core.skinnedmodel.population.IClothingItemListener;
import zombie.core.skinnedmodel.population.Outfit;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.gameStates.ChooseGameInfo;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.util.PZXmlParserException;
import zombie.util.PZXmlUtil;
import zombie.util.StringUtils;
import zombie.util.list.PZArrayUtil;

@XmlRootElement
public class OutfitManager {
    public ArrayList<Outfit> m_MaleOutfits = new ArrayList();
    public ArrayList<Outfit> m_FemaleOutfits = new ArrayList();
    @XmlTransient
    public static OutfitManager instance;
    @XmlTransient
    private final Hashtable<String, ClothingItemEntry> m_cachedClothingItems = new Hashtable();
    @XmlTransient
    private final ArrayList<IClothingItemListener> m_clothingItemListeners = new ArrayList();
    @XmlTransient
    private final TreeMap<String, Outfit> m_femaleOutfitMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    @XmlTransient
    private final TreeMap<String, Outfit> m_maleOutfitMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    public static void init() {
        if (instance != null) {
            throw new IllegalStateException("OutfitManager Already Initialized.");
        }
        instance = OutfitManager.tryParse("game", "media/clothing/clothing.xml");
        if (instance == null) {
            return;
        }
        instance.loaded();
    }

    public static void Reset() {
        if (instance == null) {
            return;
        }
        instance.unload();
        instance = null;
    }

    private void loaded() {
        for (String object : ZomboidFileSystem.instance.getModIDs()) {
            Outfit outfit;
            OutfitManager outfitManager;
            ChooseGameInfo.Mod mod = ChooseGameInfo.getAvailableModDetails(object);
            if (mod == null || (outfitManager = OutfitManager.tryParse(object, "media/clothing/clothing.xml")) == null) continue;
            for (Outfit outfit2 : outfitManager.m_MaleOutfits) {
                outfit = this.FindMaleOutfit(outfit2.m_Name);
                if (outfit == null) {
                    this.m_MaleOutfits.add(outfit2);
                } else {
                    if (DebugLog.isEnabled(DebugType.Clothing)) {
                        DebugLog.Clothing.println("mod \"%s\" overrides male outfit \"%s\"", object, outfit2.m_Name);
                    }
                    this.m_MaleOutfits.set(this.m_MaleOutfits.indexOf(outfit), outfit2);
                }
                this.m_maleOutfitMap.put(outfit2.m_Name, outfit2);
            }
            for (Outfit outfit2 : outfitManager.m_FemaleOutfits) {
                outfit = this.FindFemaleOutfit(outfit2.m_Name);
                if (outfit == null) {
                    this.m_FemaleOutfits.add(outfit2);
                } else {
                    if (DebugLog.isEnabled(DebugType.Clothing)) {
                        DebugLog.Clothing.println("mod \"%s\" overrides female outfit \"%s\"", object, outfit2.m_Name);
                    }
                    this.m_FemaleOutfits.set(this.m_FemaleOutfits.indexOf(outfit), outfit2);
                }
                this.m_femaleOutfitMap.put(outfit2.m_Name, outfit2);
            }
        }
        DebugFileWatcher.instance.add(new PredicatedFileWatcher(ZomboidFileSystem.instance.getString("media/clothing/clothing.xml"), string -> OutfitManager.onClothingXmlFileChanged()));
        this.loadAllClothingItems();
        for (Outfit outfit : this.m_MaleOutfits) {
            outfit.m_Immutable = true;
            for (ClothingItemReference clothingItemReference : outfit.m_items) {
                clothingItemReference.m_Immutable = true;
            }
        }
        for (Outfit outfit : this.m_FemaleOutfits) {
            outfit.m_Immutable = true;
            for (ClothingItemReference clothingItemReference : outfit.m_items) {
                clothingItemReference.m_Immutable = true;
            }
        }
        Collections.shuffle(this.m_MaleOutfits);
        Collections.shuffle(this.m_FemaleOutfits);
    }

    private static void onClothingXmlFileChanged() {
        DebugLog.Clothing.println("OutfitManager.onClothingXmlFileChanged> Detected change in media/clothing/clothing.xml");
        OutfitManager.Reload();
    }

    public static void Reload() {
        DebugLog.Clothing.println("Reloading OutfitManager");
        OutfitManager outfitManager = instance;
        instance = OutfitManager.tryParse("game", "media/clothing/clothing.xml");
        if (instance != null) {
            instance.loaded();
        }
        if (outfitManager != null && instance != null) {
            instance.onReloaded(outfitManager);
        }
    }

    private void onReloaded(OutfitManager outfitManager) {
        PZArrayUtil.copy(this.m_clothingItemListeners, outfitManager.m_clothingItemListeners);
        outfitManager.unload();
        this.loadAllClothingItems();
    }

    private void unload() {
        for (ClothingItemEntry clothingItemEntry : this.m_cachedClothingItems.values()) {
            DebugFileWatcher.instance.remove(clothingItemEntry.m_fileWatcher);
        }
        this.m_cachedClothingItems.clear();
        this.m_clothingItemListeners.clear();
    }

    public void addClothingItemListener(IClothingItemListener iClothingItemListener) {
        if (iClothingItemListener == null) {
            return;
        }
        if (this.m_clothingItemListeners.contains(iClothingItemListener)) {
            return;
        }
        this.m_clothingItemListeners.add(iClothingItemListener);
    }

    public void removeClothingItemListener(IClothingItemListener iClothingItemListener) {
        this.m_clothingItemListeners.remove(iClothingItemListener);
    }

    private void invokeClothingItemChangedEvent(String string) {
        for (IClothingItemListener iClothingItemListener : this.m_clothingItemListeners) {
            iClothingItemListener.clothingItemChanged(string);
        }
    }

    public Outfit GetRandomOutfit(boolean bl) {
        Outfit outfit = bl ? PZArrayUtil.pickRandom(this.m_FemaleOutfits) : PZArrayUtil.pickRandom(this.m_MaleOutfits);
        return outfit;
    }

    public Outfit GetRandomNonProfessionalOutfit(boolean bl) {
        Object object = "Generic0" + (Rand.Next(5) + 1);
        if (Rand.NextBool(4)) {
            if (bl) {
                int n = Rand.Next(3);
                switch (n) {
                    case 0: {
                        object = "Mannequin1";
                        break;
                    }
                    case 1: {
                        object = "Mannequin2";
                        break;
                    }
                    case 2: {
                        object = "Classy";
                    }
                }
            } else {
                int n = Rand.Next(3);
                switch (n) {
                    case 0: {
                        object = "Classy";
                        break;
                    }
                    case 1: {
                        object = "Tourist";
                        break;
                    }
                    case 2: {
                        object = "MallSecurity";
                    }
                }
            }
        }
        return this.GetSpecificOutfit(bl, (String)object);
    }

    public Outfit GetSpecificOutfit(boolean bl, String string) {
        Outfit outfit = bl ? this.FindFemaleOutfit(string) : this.FindMaleOutfit(string);
        return outfit;
    }

    private static OutfitManager tryParse(String string, String string2) {
        try {
            return OutfitManager.parse(string, string2);
        }
        catch (PZXmlParserException pZXmlParserException) {
            pZXmlParserException.printStackTrace();
            return null;
        }
    }

    private static OutfitManager parse(String string, String object) throws PZXmlParserException {
        Object object2;
        if ("game".equals(string)) {
            object = ZomboidFileSystem.instance.base.getAbsolutePath() + File.separator + ZomboidFileSystem.processFilePath((String)object, File.separatorChar);
        } else {
            object2 = ZomboidFileSystem.instance.getModDir(string);
            object = (String)object2 + File.separator + ZomboidFileSystem.processFilePath((String)object, File.separatorChar);
        }
        if (!new File((String)object).exists()) {
            return null;
        }
        object2 = PZXmlUtil.parse(OutfitManager.class, (String)object);
        if (object2 != null) {
            PZArrayUtil.forEach(((OutfitManager)object2).m_MaleOutfits, outfit -> outfit.setModID(string));
            PZArrayUtil.forEach(((OutfitManager)object2).m_FemaleOutfits, outfit -> outfit.setModID(string));
            PZArrayUtil.forEach(((OutfitManager)object2).m_MaleOutfits, arg_0 -> OutfitManager.lambda$parse$3((OutfitManager)object2, arg_0));
            PZArrayUtil.forEach(((OutfitManager)object2).m_FemaleOutfits, arg_0 -> OutfitManager.lambda$parse$4((OutfitManager)object2, arg_0));
        }
        return object2;
    }

    private static void tryWrite(OutfitManager outfitManager, String string) {
        try {
            OutfitManager.write(outfitManager, string);
        }
        catch (IOException | JAXBException throwable) {
            throwable.printStackTrace();
        }
    }

    private static void write(OutfitManager outfitManager, String string) throws IOException, JAXBException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(string);){
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{OutfitManager.class});
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)outfitManager, (OutputStream)fileOutputStream);
        }
    }

    public Outfit FindMaleOutfit(String string) {
        return this.m_maleOutfitMap.get(string);
    }

    public Outfit FindFemaleOutfit(String string) {
        return this.m_femaleOutfitMap.get(string);
    }

    private Outfit FindOutfit(ArrayList<Outfit> arrayList, String string) {
        Outfit outfit = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            Outfit outfit2 = arrayList.get(i);
            if (!outfit2.m_Name.equalsIgnoreCase(string)) continue;
            outfit = outfit2;
            break;
        }
        return outfit;
    }

    public ClothingItem getClothingItem(String string) {
        Object object;
        String string2 = ZomboidFileSystem.instance.getFilePathFromGuid(string);
        if (string2 == null) {
            return null;
        }
        ClothingItemEntry clothingItemEntry = this.m_cachedClothingItems.get(string);
        if (clothingItemEntry == null) {
            clothingItemEntry = new ClothingItemEntry();
            clothingItemEntry.m_filePath = string2;
            clothingItemEntry.m_guid = string;
            clothingItemEntry.m_item = null;
            this.m_cachedClothingItems.put(string, clothingItemEntry);
        }
        if (clothingItemEntry.m_item != null) {
            clothingItemEntry.m_item.m_GUID = string;
            return clothingItemEntry.m_item;
        }
        try {
            object = ZomboidFileSystem.instance.resolveFileOrGUID(string2);
            clothingItemEntry.m_item = (ClothingItem)ClothingItemAssetManager.instance.load(new AssetPath((String)object));
            clothingItemEntry.m_item.m_Name = this.extractClothingItemName(string2);
            clothingItemEntry.m_item.m_GUID = string;
        }
        catch (Exception exception) {
            System.err.println("Failed to load ClothingItem: " + string2);
            ExceptionLogger.logException(exception);
            return null;
        }
        if (clothingItemEntry.m_fileWatcher == null) {
            object = clothingItemEntry;
            String string3 = ((ClothingItemEntry)object).m_filePath;
            string3 = ZomboidFileSystem.instance.getString(string3);
            clothingItemEntry.m_fileWatcher = new PredicatedFileWatcher(string3, arg_0 -> this.lambda$getClothingItem$5((ClothingItemEntry)object, arg_0));
            DebugFileWatcher.instance.add(clothingItemEntry.m_fileWatcher);
        }
        return clothingItemEntry.m_item;
    }

    private String extractClothingItemName(String string) {
        String string2 = string;
        string2 = StringUtils.trimPrefix(string2, "media/clothing/clothingItems/");
        string2 = StringUtils.trimSuffix(string2, ".xml");
        return string2;
    }

    private void onClothingItemFileChanged(ClothingItemEntry clothingItemEntry) {
        ClothingItemAssetManager.instance.reload(clothingItemEntry.m_item);
    }

    public void onClothingItemStateChanged(ClothingItem clothingItem) {
        if (clothingItem.isReady()) {
            this.invokeClothingItemChangedEvent(clothingItem.m_GUID);
        }
    }

    public void loadAllClothingItems() {
        ArrayList<Item> arrayList = ScriptManager.instance.getAllItems();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string;
            Item item = arrayList.get(i);
            if (item.replacePrimaryHand != null && (string = ZomboidFileSystem.instance.getGuidFromFilePath("media/clothing/clothingItems/" + item.replacePrimaryHand.clothingItemName + ".xml")) != null) {
                item.replacePrimaryHand.clothingItem = this.getClothingItem(string);
            }
            if (item.replaceSecondHand != null && (string = ZomboidFileSystem.instance.getGuidFromFilePath("media/clothing/clothingItems/" + item.replaceSecondHand.clothingItemName + ".xml")) != null) {
                item.replaceSecondHand.clothingItem = this.getClothingItem(string);
            }
            if (StringUtils.isNullOrWhitespace(item.getClothingItem()) || (string = ZomboidFileSystem.instance.getGuidFromFilePath("media/clothing/clothingItems/" + item.getClothingItem() + ".xml")) == null) continue;
            ClothingItem clothingItem = this.getClothingItem(string);
            item.setClothingItemAsset(clothingItem);
        }
    }

    public boolean isLoadingClothingItems() {
        for (ClothingItemEntry clothingItemEntry : this.m_cachedClothingItems.values()) {
            if (!clothingItemEntry.m_item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void debugOutfits() {
        this.debugOutfits(this.m_FemaleOutfits);
        this.debugOutfits(this.m_MaleOutfits);
    }

    private void debugOutfits(ArrayList<Outfit> arrayList) {
        for (Outfit outfit : arrayList) {
            this.debugOutfit(outfit);
        }
    }

    private void debugOutfit(Outfit outfit) {
        String string = null;
        for (ClothingItemReference clothingItemReference : outfit.m_items) {
            String string2;
            Item item;
            String string3;
            ClothingItem clothingItem = this.getClothingItem(clothingItemReference.itemGUID);
            if (clothingItem == null || clothingItem.isEmpty() || (string3 = ScriptManager.instance.getItemTypeForClothingItem(clothingItem.m_Name)) == null || (item = ScriptManager.instance.getItem(string3)) == null || item.getType() != Item.Type.Container) continue;
            String string4 = string2 = StringUtils.isNullOrWhitespace(item.getBodyLocation()) ? item.CanBeEquipped : item.getBodyLocation();
            if (string != null && string.equals(string2)) {
                DebugLog.Clothing.warn("outfit \"%s\" has multiple bags", outfit.m_Name);
            }
            string = string2;
        }
    }

    private /* synthetic */ void lambda$getClothingItem$5(ClothingItemEntry clothingItemEntry, String string) {
        this.onClothingItemFileChanged(clothingItemEntry);
    }

    private static /* synthetic */ void lambda$parse$4(OutfitManager outfitManager, Outfit outfit) {
        outfitManager.m_femaleOutfitMap.put(outfit.m_Name, outfit);
    }

    private static /* synthetic */ void lambda$parse$3(OutfitManager outfitManager, Outfit outfit) {
        outfitManager.m_maleOutfitMap.put(outfit.m_Name, outfit);
    }

    private static final class ClothingItemEntry {
        public ClothingItem m_item;
        public String m_guid;
        public String m_filePath;
        public PredicatedFileWatcher m_fileWatcher;

        private ClothingItemEntry() {
        }
    }
}

