/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.population;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlTransient;
import zombie.characters.HairOutfitDefinitions;
import zombie.core.ImmutableColor;
import zombie.core.skinnedmodel.model.CharacterMask;
import zombie.core.skinnedmodel.population.BeardStyles;
import zombie.core.skinnedmodel.population.ClothingItem;
import zombie.core.skinnedmodel.population.ClothingItemReference;
import zombie.core.skinnedmodel.population.HairStyles;
import zombie.core.skinnedmodel.population.OutfitManager;
import zombie.core.skinnedmodel.population.OutfitRNG;
import zombie.debug.DebugLog;
import zombie.util.list.PZArrayUtil;

public class Outfit
implements Cloneable {
    public String m_Name = "Outfit";
    public boolean m_Top = true;
    public boolean m_Pants = true;
    public final ArrayList<String> m_TopTextures = new ArrayList();
    public final ArrayList<String> m_PantsTextures = new ArrayList();
    public final ArrayList<ClothingItemReference> m_items = new ArrayList();
    public boolean m_AllowPantsHue = true;
    public boolean m_AllowPantsTint = false;
    public boolean m_AllowTopTint = true;
    public boolean m_AllowTShirtDecal = true;
    @XmlTransient
    public String m_modID;
    @XmlTransient
    public boolean m_Immutable = false;
    @XmlTransient
    public final RandomData RandomData = new RandomData();

    public void setModID(String string) {
        this.m_modID = string;
        for (ClothingItemReference clothingItemReference : this.m_items) {
            clothingItemReference.setModID(string);
        }
    }

    public void AddItem(ClothingItemReference clothingItemReference) {
        this.m_items.add(clothingItemReference);
    }

    public void Randomize() {
        if (this.m_Immutable) {
            throw new RuntimeException("trying to randomize an immutable Outfit");
        }
        for (int i = 0; i < this.m_items.size(); ++i) {
            ClothingItemReference clothingItemReference = this.m_items.get(i);
            clothingItemReference.randomize();
        }
        this.RandomData.m_hairColor = HairOutfitDefinitions.instance.getRandomHaircutColor(this.m_Name);
        this.RandomData.m_femaleHairName = HairStyles.instance.getRandomFemaleStyle(this.m_Name);
        this.RandomData.m_maleHairName = HairStyles.instance.getRandomMaleStyle(this.m_Name);
        this.RandomData.m_beardName = BeardStyles.instance.getRandomStyle(this.m_Name);
        this.RandomData.m_topTint = OutfitRNG.randomImmutableColor();
        this.RandomData.m_pantsTint = OutfitRNG.randomImmutableColor();
        this.RandomData.m_pantsHue = OutfitRNG.Next(4) == 0 ? (float)OutfitRNG.Next(200) / 100.0f - 1.0f : 0.0f;
        this.RandomData.m_hasTop = OutfitRNG.Next(16) != 0;
        this.RandomData.m_hasTShirt = OutfitRNG.Next(2) == 0;
        boolean bl = this.RandomData.m_hasTShirtDecal = OutfitRNG.Next(4) == 0;
        if (this.m_Top) {
            this.RandomData.m_hasTop = true;
        }
        this.RandomData.m_topTexture = OutfitRNG.pickRandom(this.m_TopTextures);
        this.RandomData.m_pantsTexture = OutfitRNG.pickRandom(this.m_PantsTextures);
    }

    public void randomizeItem(String string) {
        ClothingItemReference clothingItemReference2 = PZArrayUtil.find(this.m_items, clothingItemReference -> clothingItemReference.itemGUID.equals(string));
        if (clothingItemReference2 != null) {
            clothingItemReference2.randomize();
        } else {
            DebugLog.Clothing.println("Outfit.randomizeItem> Could not find itemGuid: " + string);
        }
    }

    public CharacterMask GetMask() {
        CharacterMask characterMask = new CharacterMask();
        for (int i = 0; i < this.m_items.size(); ++i) {
            ClothingItemReference clothingItemReference = this.m_items.get(i);
            if (!clothingItemReference.RandomData.m_Active) continue;
            ClothingItem.tryGetCombinedMask(clothingItemReference, characterMask);
        }
        return characterMask;
    }

    public boolean containsItemGuid(String string) {
        boolean bl = false;
        for (int i = 0; i < this.m_items.size(); ++i) {
            ClothingItemReference clothingItemReference = this.m_items.get(i);
            if (!clothingItemReference.itemGUID.equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public ClothingItemReference findItemByGUID(String string) {
        for (int i = 0; i < this.m_items.size(); ++i) {
            ClothingItemReference clothingItemReference = this.m_items.get(i);
            if (!clothingItemReference.itemGUID.equals(string)) continue;
            return clothingItemReference;
        }
        return null;
    }

    public Outfit clone() {
        try {
            Outfit outfit = new Outfit();
            outfit.m_Name = this.m_Name;
            outfit.m_Top = this.m_Top;
            outfit.m_Pants = this.m_Pants;
            outfit.m_PantsTextures.addAll(this.m_PantsTextures);
            outfit.m_TopTextures.addAll(this.m_TopTextures);
            PZArrayUtil.copy(outfit.m_items, this.m_items, ClothingItemReference::clone);
            outfit.m_AllowPantsHue = this.m_AllowPantsHue;
            outfit.m_AllowPantsTint = this.m_AllowPantsTint;
            outfit.m_AllowTopTint = this.m_AllowTopTint;
            outfit.m_AllowTShirtDecal = this.m_AllowTShirtDecal;
            return outfit;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Outfit clone failed.", cloneNotSupportedException);
        }
    }

    public ClothingItemReference findHat() {
        for (ClothingItemReference clothingItemReference : this.m_items) {
            ClothingItem clothingItem;
            if (!clothingItemReference.RandomData.m_Active || (clothingItem = clothingItemReference.getClothingItem()) == null || !clothingItem.isHat()) continue;
            return clothingItemReference;
        }
        return null;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.m_items.size(); ++i) {
            ClothingItemReference clothingItemReference = this.m_items.get(i);
            ClothingItem clothingItem = OutfitManager.instance.getClothingItem(clothingItemReference.itemGUID);
            if (clothingItem != null && clothingItem.isEmpty()) {
                return true;
            }
            for (int j = 0; j < clothingItemReference.subItems.size(); ++j) {
                ClothingItemReference clothingItemReference2 = clothingItemReference.subItems.get(j);
                clothingItem = OutfitManager.instance.getClothingItem(clothingItemReference2.itemGUID);
                if (clothingItem == null || !clothingItem.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public void loadItems() {
        for (int i = 0; i < this.m_items.size(); ++i) {
            ClothingItemReference clothingItemReference = this.m_items.get(i);
            OutfitManager.instance.getClothingItem(clothingItemReference.itemGUID);
            for (int j = 0; j < clothingItemReference.subItems.size(); ++j) {
                ClothingItemReference clothingItemReference2 = clothingItemReference.subItems.get(j);
                OutfitManager.instance.getClothingItem(clothingItemReference2.itemGUID);
            }
        }
    }

    public static class RandomData {
        public ImmutableColor m_hairColor;
        public String m_maleHairName;
        public String m_femaleHairName;
        public String m_beardName;
        public ImmutableColor m_topTint;
        public ImmutableColor m_pantsTint;
        public float m_pantsHue;
        public boolean m_hasTop;
        public boolean m_hasTShirt;
        public boolean m_hasTShirtDecal;
        public String m_topTexture;
        public String m_pantsTexture;
    }
}

