/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.population;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import zombie.ZomboidFileSystem;
import zombie.core.Rand;
import zombie.core.skinnedmodel.population.CarriedItem;

@XmlRootElement
public class ItemManager {
    public ArrayList<CarriedItem> m_Items = new ArrayList();
    @XmlTransient
    public static ItemManager instance;

    public static void init() {
        File file = ZomboidFileSystem.instance.getMediaFile("items" + File.separator + "items.xml");
        instance = ItemManager.Parse(file.getPath());
    }

    public CarriedItem GetRandomItem() {
        int n = Rand.Next(this.m_Items.size() + 1);
        if (n < this.m_Items.size()) {
            return this.m_Items.get(n);
        }
        return null;
    }

    public static ItemManager Parse(String string) {
        try {
            return ItemManager.parse(string);
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public static ItemManager parse(String string) throws JAXBException, IOException {
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            ItemManager itemManager;
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{ItemManager.class});
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            ItemManager itemManager2 = itemManager = (ItemManager)unmarshaller.unmarshal((InputStream)fileInputStream);
            return itemManager2;
        }
    }

    public static void Write(ItemManager itemManager, String string) {
        try {
            ItemManager.write(itemManager, string);
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void write(ItemManager itemManager, String string) throws IOException, JAXBException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(string);){
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{ItemManager.class});
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)itemManager, (OutputStream)fileOutputStream);
        }
    }
}

