/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.population;

import java.util.ArrayList;
import se.krka.kahlua.j2se.KahluaTableImpl;
import se.krka.kahlua.vm.KahluaTable;
import zombie.Lua.LuaManager;
import zombie.core.skinnedmodel.population.OutfitRNG;
import zombie.util.Type;

public final class DefaultClothing {
    public static final DefaultClothing instance = new DefaultClothing();
    public final Clothing Pants = new Clothing();
    public final Clothing TShirt = new Clothing();
    public final Clothing TShirtDecal = new Clothing();
    public final Clothing Vest = new Clothing();
    public boolean m_dirty = true;

    private void checkDirty() {
        if (this.m_dirty) {
            this.m_dirty = false;
            this.init();
        }
    }

    private void init() {
        this.Pants.clear();
        this.TShirt.clear();
        this.TShirtDecal.clear();
        this.Vest.clear();
        KahluaTable kahluaTable = Type.tryCastTo(LuaManager.env.rawget((Object)"DefaultClothing"), KahluaTable.class);
        if (kahluaTable == null) {
            return;
        }
        this.initClothing(kahluaTable, this.Pants, "Pants");
        this.initClothing(kahluaTable, this.TShirt, "TShirt");
        this.initClothing(kahluaTable, this.TShirtDecal, "TShirtDecal");
        this.initClothing(kahluaTable, this.Vest, "Vest");
    }

    private void initClothing(KahluaTable kahluaTable, Clothing clothing, String string) {
        KahluaTable kahluaTable2 = Type.tryCastTo(kahluaTable.rawget((Object)string), KahluaTable.class);
        if (kahluaTable2 == null) {
            return;
        }
        this.tableToArrayList(kahluaTable2, "hue", clothing.hue);
        this.tableToArrayList(kahluaTable2, "texture", clothing.texture);
        this.tableToArrayList(kahluaTable2, "tint", clothing.tint);
    }

    private void tableToArrayList(KahluaTable kahluaTable, String string, ArrayList<String> arrayList) {
        KahluaTableImpl kahluaTableImpl = (KahluaTableImpl)kahluaTable.rawget((Object)string);
        if (kahluaTableImpl == null) {
            return;
        }
        int n = kahluaTableImpl.len();
        for (int i = 1; i <= n; ++i) {
            Object object = kahluaTableImpl.rawget(i);
            if (object == null) continue;
            arrayList.add(object.toString());
        }
    }

    public String pickPantsHue() {
        this.checkDirty();
        return OutfitRNG.pickRandom(this.Pants.hue);
    }

    public String pickPantsTexture() {
        this.checkDirty();
        return OutfitRNG.pickRandom(this.Pants.texture);
    }

    public String pickPantsTint() {
        this.checkDirty();
        return OutfitRNG.pickRandom(this.Pants.tint);
    }

    public String pickTShirtTexture() {
        this.checkDirty();
        return OutfitRNG.pickRandom(this.TShirt.texture);
    }

    public String pickTShirtTint() {
        this.checkDirty();
        return OutfitRNG.pickRandom(this.TShirt.tint);
    }

    public String pickTShirtDecalTexture() {
        this.checkDirty();
        return OutfitRNG.pickRandom(this.TShirtDecal.texture);
    }

    public String pickTShirtDecalTint() {
        this.checkDirty();
        return OutfitRNG.pickRandom(this.TShirtDecal.tint);
    }

    public String pickVestTexture() {
        this.checkDirty();
        return OutfitRNG.pickRandom(this.Vest.texture);
    }

    public String pickVestTint() {
        this.checkDirty();
        return OutfitRNG.pickRandom(this.Vest.tint);
    }

    private static final class Clothing {
        final ArrayList<String> hue = new ArrayList();
        final ArrayList<String> texture = new ArrayList();
        final ArrayList<String> tint = new ArrayList();

        private Clothing() {
        }

        void clear() {
            this.hue.clear();
            this.texture.clear();
            this.tint.clear();
        }
    }
}

