/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.population;

import java.util.ArrayList;
import zombie.asset.Asset;
import zombie.asset.AssetManager;
import zombie.asset.AssetPath;
import zombie.asset.AssetTask;
import zombie.asset.AssetTask_RunFileTask;
import zombie.asset.FileTask_ParseXML;
import zombie.core.skinnedmodel.population.ClothingItem;
import zombie.core.skinnedmodel.population.ClothingItemXML;
import zombie.core.skinnedmodel.population.OutfitManager;
import zombie.fileSystem.FileSystem;
import zombie.util.list.PZArrayUtil;

public class ClothingItemAssetManager
extends AssetManager {
    public static final ClothingItemAssetManager instance = new ClothingItemAssetManager();

    @Override
    protected void startLoading(Asset asset) {
        FileSystem fileSystem = asset.getAssetManager().getOwner().getFileSystem();
        FileTask_ParseXML fileTask_ParseXML = new FileTask_ParseXML(ClothingItemXML.class, asset.getPath().getPath(), object -> this.onFileTaskFinished((ClothingItem)asset, object), fileSystem);
        AssetTask_RunFileTask assetTask_RunFileTask = new AssetTask_RunFileTask(fileTask_ParseXML, asset);
        this.setTask(asset, assetTask_RunFileTask);
        ((AssetTask)assetTask_RunFileTask).execute();
    }

    private void onFileTaskFinished(ClothingItem clothingItem, Object object) {
        if (object instanceof ClothingItemXML) {
            ClothingItem clothingItem2 = clothingItem;
            ClothingItemXML clothingItemXML = (ClothingItemXML)object;
            clothingItem2.m_MaleModel = this.fixPath(clothingItemXML.m_MaleModel);
            clothingItem2.m_FemaleModel = this.fixPath(clothingItemXML.m_FemaleModel);
            clothingItem2.m_Static = clothingItemXML.m_Static;
            PZArrayUtil.arrayCopy(clothingItem2.m_BaseTextures, this.fixPaths(clothingItemXML.m_BaseTextures));
            clothingItem2.m_AttachBone = clothingItemXML.m_AttachBone;
            PZArrayUtil.arrayCopy(clothingItem2.m_Masks, clothingItemXML.m_Masks);
            clothingItem2.m_MasksFolder = this.fixPath(clothingItemXML.m_MasksFolder);
            clothingItem2.m_UnderlayMasksFolder = this.fixPath(clothingItemXML.m_UnderlayMasksFolder);
            PZArrayUtil.arrayCopy(clothingItem2.textureChoices, this.fixPaths(clothingItemXML.textureChoices));
            clothingItem2.m_AllowRandomHue = clothingItemXML.m_AllowRandomHue;
            clothingItem2.m_AllowRandomTint = clothingItemXML.m_AllowRandomTint;
            clothingItem2.m_DecalGroup = clothingItemXML.m_DecalGroup;
            clothingItem2.m_Shader = clothingItemXML.m_Shader;
            clothingItem2.m_HatCategory = clothingItemXML.m_HatCategory;
            this.onLoadingSucceeded(clothingItem);
        } else {
            this.onLoadingFailed(clothingItem);
        }
    }

    private String fixPath(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("\\\\", "/");
    }

    private ArrayList<String> fixPaths(ArrayList<String> arrayList) {
        if (arrayList == null) {
            return null;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.set(i, this.fixPath(arrayList.get(i)));
        }
        return arrayList;
    }

    @Override
    public void onStateChanged(Asset.State state, Asset.State state2, Asset asset) {
        super.onStateChanged(state, state2, asset);
        if (state2 == Asset.State.READY) {
            OutfitManager.instance.onClothingItemStateChanged((ClothingItem)asset);
        }
    }

    @Override
    protected Asset createAsset(AssetPath assetPath, AssetManager.AssetParams assetParams) {
        return new ClothingItem(assetPath, this);
    }

    @Override
    protected void destroyAsset(Asset asset) {
    }
}

