/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.population;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import zombie.ZomboidFileSystem;
import zombie.core.logger.ExceptionLogger;
import zombie.core.skinnedmodel.population.ClothingDecal;
import zombie.core.skinnedmodel.population.ClothingDecalGroup;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.gameStates.ChooseGameInfo;
import zombie.util.PZXmlParserException;
import zombie.util.PZXmlUtil;
import zombie.util.StringUtils;

@XmlRootElement
public class ClothingDecals {
    @XmlElement(name="group")
    public final ArrayList<ClothingDecalGroup> m_Groups = new ArrayList();
    @XmlTransient
    public static ClothingDecals instance;
    private final HashMap<String, CachedDecal> m_cachedDecals = new HashMap();

    public static void init() {
        if (instance != null) {
            throw new IllegalStateException("ClothingDecals Already Initialized.");
        }
        instance = ClothingDecals.Parse(ZomboidFileSystem.instance.base.getAbsolutePath() + File.separator + ZomboidFileSystem.processFilePath("media/clothing/clothingDecals.xml", File.separatorChar));
        if (instance == null) {
            return;
        }
        for (String string : ZomboidFileSystem.instance.getModIDs()) {
            String string2;
            ClothingDecals clothingDecals;
            ChooseGameInfo.Mod mod = ChooseGameInfo.getAvailableModDetails(string);
            if (mod == null || (clothingDecals = ClothingDecals.Parse((string2 = ZomboidFileSystem.instance.getModDir(string)) + File.separator + ZomboidFileSystem.processFilePath("media/clothing/clothingDecals.xml", File.separatorChar))) == null) continue;
            for (ClothingDecalGroup clothingDecalGroup : clothingDecals.m_Groups) {
                ClothingDecalGroup clothingDecalGroup2 = instance.FindGroup(clothingDecalGroup.m_Name);
                if (clothingDecalGroup2 == null) {
                    ClothingDecals.instance.m_Groups.add(clothingDecalGroup);
                    continue;
                }
                if (DebugLog.isEnabled(DebugType.Clothing)) {
                    DebugLog.Clothing.println("mod \"%s\" overrides decal group \"%s\"", string, clothingDecalGroup.m_Name);
                }
                int n = ClothingDecals.instance.m_Groups.indexOf(clothingDecalGroup2);
                ClothingDecals.instance.m_Groups.set(n, clothingDecalGroup);
            }
        }
    }

    public static void Reset() {
        if (instance == null) {
            return;
        }
        ClothingDecals.instance.m_cachedDecals.clear();
        ClothingDecals.instance.m_Groups.clear();
        instance = null;
    }

    public static ClothingDecals Parse(String string) {
        try {
            return ClothingDecals.parse(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException | JAXBException throwable) {
            ExceptionLogger.logException(throwable);
        }
        return null;
    }

    public static ClothingDecals parse(String string) throws JAXBException, IOException {
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{ClothingDecals.class});
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            ClothingDecals clothingDecals = (ClothingDecals)unmarshaller.unmarshal((InputStream)fileInputStream);
            return clothingDecals;
        }
    }

    public ClothingDecal getDecal(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return null;
        }
        CachedDecal cachedDecal = this.m_cachedDecals.get(string);
        if (cachedDecal == null) {
            cachedDecal = new CachedDecal();
            this.m_cachedDecals.put(string, cachedDecal);
        }
        if (cachedDecal.m_decal != null) {
            return cachedDecal.m_decal;
        }
        String string2 = ZomboidFileSystem.instance.getString("media/clothing/clothingDecals/" + string + ".xml");
        try {
            cachedDecal.m_decal = PZXmlUtil.parse(ClothingDecal.class, string2);
            cachedDecal.m_decal.name = string;
        }
        catch (PZXmlParserException pZXmlParserException) {
            System.err.println("Failed to load ClothingDecal: " + string2);
            ExceptionLogger.logException(pZXmlParserException);
            return null;
        }
        return cachedDecal.m_decal;
    }

    public ClothingDecalGroup FindGroup(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return null;
        }
        for (int i = 0; i < this.m_Groups.size(); ++i) {
            ClothingDecalGroup clothingDecalGroup = this.m_Groups.get(i);
            if (!clothingDecalGroup.m_Name.equalsIgnoreCase(string)) continue;
            return clothingDecalGroup;
        }
        return null;
    }

    public String getRandomDecal(String string) {
        ClothingDecalGroup clothingDecalGroup = this.FindGroup(string);
        if (clothingDecalGroup == null) {
            return null;
        }
        return clothingDecalGroup.getRandomDecal();
    }

    private static final class CachedDecal {
        ClothingDecal m_decal;

        private CachedDecal() {
        }
    }
}

