/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.model.jassimp;

import gnu.trove.list.array.TFloatArrayList;
import jassimp.AiAnimation;
import jassimp.AiBone;
import jassimp.AiBuiltInWrapperProvider;
import jassimp.AiMatrix4f;
import jassimp.AiMesh;
import jassimp.AiNode;
import jassimp.AiNodeAnim;
import jassimp.AiQuaternion;
import jassimp.AiScene;
import jassimp.AiWrapperProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector3f;
import zombie.core.skinnedmodel.HelperFunctions;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.animation.AnimationClip;
import zombie.core.skinnedmodel.animation.Keyframe;
import zombie.core.skinnedmodel.animation.StaticAnimation;
import zombie.core.skinnedmodel.model.SkinningData;
import zombie.core.skinnedmodel.model.jassimp.ImportedSkeletonParams;
import zombie.core.skinnedmodel.model.jassimp.JAssImpImporter;
import zombie.debug.DebugLog;
import zombie.util.StringUtils;

public final class ImportedSkeleton {
    final HashMap<String, Integer> boneIndices = new HashMap();
    final ArrayList<Integer> SkeletonHierarchy = new ArrayList();
    final ArrayList<Matrix4f> bindPose = new ArrayList();
    final ArrayList<Matrix4f> invBindPose = new ArrayList();
    final ArrayList<Matrix4f> skinOffsetMatrices = new ArrayList();
    AiNode rootBoneNode = null;
    final HashMap<String, AnimationClip> clips = new HashMap();
    final AiBuiltInWrapperProvider wrapper = new AiBuiltInWrapperProvider();
    final Quaternion end = new Quaternion();

    private ImportedSkeleton() {
    }

    public static ImportedSkeleton process(ImportedSkeletonParams importedSkeletonParams) {
        ImportedSkeleton importedSkeleton = new ImportedSkeleton();
        importedSkeleton.processAiScene(importedSkeletonParams);
        return importedSkeleton;
    }

    private void processAiScene(ImportedSkeletonParams importedSkeletonParams) {
        int n;
        AiMatrix4f aiMatrix4f;
        int n2;
        Object object;
        boolean bl;
        AiScene aiScene = importedSkeletonParams.scene;
        JAssImpImporter.LoadMode loadMode = importedSkeletonParams.mode;
        SkinningData skinningData = importedSkeletonParams.skinnedTo;
        float f = importedSkeletonParams.animBonesScaleModifier;
        Quaternion quaternion = importedSkeletonParams.animBonesRotateModifier;
        AiMesh aiMesh = importedSkeletonParams.mesh;
        AiNode aiNode = (AiNode)aiScene.getSceneRoot((AiWrapperProvider)this.wrapper);
        this.rootBoneNode = JAssImpImporter.FindNode("Dummy01", aiNode);
        if (this.rootBoneNode == null) {
            this.rootBoneNode = JAssImpImporter.FindNode("VehicleSkeleton", aiNode);
            bl = true;
        } else {
            bl = false;
        }
        while (this.rootBoneNode != null && this.rootBoneNode.getParent() != null && this.rootBoneNode.getParent() != aiNode) {
            this.rootBoneNode = this.rootBoneNode.getParent();
        }
        if (this.rootBoneNode == null) {
            this.rootBoneNode = aiNode;
        }
        ArrayList<AiNode> arrayList = new ArrayList<AiNode>();
        JAssImpImporter.CollectBoneNodes(arrayList, this.rootBoneNode);
        AiNode aiNode2 = JAssImpImporter.FindNode("Translation_Data", aiNode);
        if (aiNode2 != null) {
            arrayList.add(aiNode2);
            for (AiNode aiNode3 = aiNode2.getParent(); aiNode3 != null && aiNode3 != aiNode; aiNode3 = aiNode3.getParent()) {
                arrayList.add(aiNode3);
            }
        }
        if (skinningData != null) {
            this.boneIndices.putAll(skinningData.BoneIndices);
            this.SkeletonHierarchy.addAll(skinningData.SkeletonHierarchy);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            AiNode aiNode4 = arrayList.get(i);
            String string = aiNode4.getName();
            if (this.boneIndices.containsKey(string)) continue;
            int n3 = this.boneIndices.size();
            this.boneIndices.put(string, n3);
            if (aiNode4 == this.rootBoneNode) {
                this.SkeletonHierarchy.add(-1);
                continue;
            }
            for (object = aiNode4.getParent(); object != null && !this.boneIndices.containsKey(object.getName()); object = object.getParent()) {
            }
            if (object != null) {
                this.SkeletonHierarchy.add(this.boneIndices.get(object.getName()));
                continue;
            }
            this.SkeletonHierarchy.add(0);
        }
        Matrix4f matrix4f = new Matrix4f();
        for (int i = 0; i < this.boneIndices.size(); ++i) {
            this.bindPose.add(matrix4f);
            this.skinOffsetMatrices.add(matrix4f);
        }
        List list = aiMesh.getBones();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            Matrix4f matrix4f2;
            AiNode aiNode5 = arrayList.get(n2);
            object = aiNode5.getName();
            AiBone aiBone = JAssImpImporter.FindAiBone((String)object, list);
            if (aiBone == null || (aiMatrix4f = (AiMatrix4f)aiBone.getOffsetMatrix((AiWrapperProvider)this.wrapper)) == null) continue;
            Matrix4f matrix4f3 = JAssImpImporter.getMatrixFromAiMatrix(aiMatrix4f);
            Matrix4f matrix4f4 = new Matrix4f(matrix4f3);
            matrix4f4.invert();
            Matrix4f matrix4f5 = new Matrix4f();
            matrix4f5.setIdentity();
            String string = aiNode5.getParent().getName();
            AiBone aiBone2 = JAssImpImporter.FindAiBone(string, list);
            if (aiBone2 != null && (matrix4f2 = (AiMatrix4f)aiBone2.getOffsetMatrix((AiWrapperProvider)this.wrapper)) != null) {
                JAssImpImporter.getMatrixFromAiMatrix((AiMatrix4f)matrix4f2, matrix4f5);
            }
            matrix4f2 = new Matrix4f(matrix4f5);
            matrix4f2.invert();
            Matrix4f matrix4f6 = new Matrix4f();
            Matrix4f.mul((Matrix4f)matrix4f4, (Matrix4f)matrix4f2, (Matrix4f)matrix4f6);
            matrix4f6.invert();
            int n4 = this.boneIndices.get(object);
            this.bindPose.set(n4, matrix4f6);
            this.skinOffsetMatrices.set(n4, matrix4f3);
        }
        n2 = this.bindPose.size();
        for (n = 0; n < n2; ++n) {
            object = new Matrix4f(this.bindPose.get(n));
            object.invert();
            this.invBindPose.add(n, (Matrix4f)object);
        }
        if (loadMode != JAssImpImporter.LoadMode.AnimationOnly && skinningData != null) {
            return;
        }
        n = aiScene.getNumAnimations();
        if (n <= 0) {
            return;
        }
        object = aiScene.getAnimations();
        for (int i = 0; i < n; ++i) {
            aiMatrix4f = (AiAnimation)object.get(i);
            if (bl) {
                this.processAnimation((AiAnimation)aiMatrix4f, bl, 1.0f, null);
                continue;
            }
            this.processAnimation((AiAnimation)aiMatrix4f, bl, f, quaternion);
        }
    }

    @Deprecated
    void processAnimationOld(AiAnimation aiAnimation, boolean bl) {
        int n;
        ArrayList<Keyframe> arrayList = new ArrayList<Keyframe>();
        float f = (float)aiAnimation.getDuration();
        float f2 = f / (float)aiAnimation.getTicksPerSecond();
        ArrayList<Float> arrayList2 = new ArrayList<Float>();
        List list = aiAnimation.getChannels();
        for (n = 0; n < list.size(); ++n) {
            float f3;
            int n2;
            AiNodeAnim aiNodeAnim = (AiNodeAnim)list.get(n);
            for (n2 = 0; n2 < aiNodeAnim.getNumPosKeys(); ++n2) {
                f3 = (float)aiNodeAnim.getPosKeyTime(n2);
                if (arrayList2.contains(Float.valueOf(f3))) continue;
                arrayList2.add(Float.valueOf(f3));
            }
            for (n2 = 0; n2 < aiNodeAnim.getNumRotKeys(); ++n2) {
                f3 = (float)aiNodeAnim.getRotKeyTime(n2);
                if (arrayList2.contains(Float.valueOf(f3))) continue;
                arrayList2.add(Float.valueOf(f3));
            }
            for (n2 = 0; n2 < aiNodeAnim.getNumScaleKeys(); ++n2) {
                f3 = (float)aiNodeAnim.getScaleKeyTime(n2);
                if (arrayList2.contains(Float.valueOf(f3))) continue;
                arrayList2.add(Float.valueOf(f3));
            }
        }
        Collections.sort(arrayList2);
        for (n = 0; n < arrayList2.size(); ++n) {
            for (int i = 0; i < list.size(); ++i) {
                AiNodeAnim aiNodeAnim = (AiNodeAnim)list.get(i);
                Keyframe keyframe = new Keyframe();
                keyframe.clear();
                keyframe.BoneName = aiNodeAnim.getNodeName();
                Integer n3 = this.boneIndices.get(keyframe.BoneName);
                if (n3 == null) {
                    DebugLog.General.error("Could not find bone index for node name: \"%s\"", keyframe.BoneName);
                    continue;
                }
                keyframe.Bone = n3;
                keyframe.Time = ((Float)arrayList2.get(n)).floatValue() / (float)aiAnimation.getTicksPerSecond();
                if (!bl) {
                    keyframe.Position = JAssImpImporter.GetKeyFramePosition(aiNodeAnim, ((Float)arrayList2.get(n)).floatValue());
                    keyframe.Rotation = JAssImpImporter.GetKeyFrameRotation(aiNodeAnim, ((Float)arrayList2.get(n)).floatValue());
                    keyframe.Scale = JAssImpImporter.GetKeyFrameScale(aiNodeAnim, ((Float)arrayList2.get(n)).floatValue());
                } else {
                    keyframe.Position = this.GetKeyFramePosition(aiNodeAnim, ((Float)arrayList2.get(n)).floatValue(), aiAnimation.getDuration());
                    keyframe.Rotation = this.GetKeyFrameRotation(aiNodeAnim, ((Float)arrayList2.get(n)).floatValue(), aiAnimation.getDuration());
                    keyframe.Scale = this.GetKeyFrameScale(aiNodeAnim, ((Float)arrayList2.get(n)).floatValue(), aiAnimation.getDuration());
                }
                if (keyframe.Bone < 0) continue;
                arrayList.add(keyframe);
            }
        }
        String string = aiAnimation.getName();
        int n4 = string.indexOf(124);
        if (n4 > 0) {
            string = string.substring(n4 + 1);
        }
        AnimationClip animationClip = new AnimationClip(f2, arrayList, string, true);
        arrayList.clear();
        if (ModelManager.instance.bCreateSoftwareMeshes) {
            animationClip.staticClip = new StaticAnimation(animationClip);
        }
        this.clips.put(string, animationClip);
    }

    private void processAnimation(AiAnimation aiAnimation, boolean bl, float f, Quaternion quaternion) {
        Object object;
        boolean bl2;
        ArrayList<Keyframe> arrayList = new ArrayList<Keyframe>();
        float f2 = (float)aiAnimation.getDuration();
        float f3 = f2 / (float)aiAnimation.getTicksPerSecond();
        Object[] objectArray = new TFloatArrayList[this.boneIndices.size()];
        Arrays.fill(objectArray, null);
        ArrayList<ArrayList<AiNodeAnim>> arrayList2 = new ArrayList<ArrayList<AiNodeAnim>>(this.boneIndices.size());
        for (int i = 0; i < this.boneIndices.size(); ++i) {
            arrayList2.add(null);
        }
        this.collectBoneFrames(aiAnimation, (TFloatArrayList[])objectArray, arrayList2);
        Quaternion quaternion2 = null;
        boolean bl3 = bl2 = quaternion != null;
        if (bl2) {
            quaternion2 = new Quaternion();
            Quaternion.mulInverse((Quaternion)quaternion2, (Quaternion)quaternion, (Quaternion)quaternion2);
        }
        for (int i = 0; i < this.boneIndices.size(); ++i) {
            ArrayList<AiNodeAnim> arrayList3 = arrayList2.get(i);
            if (arrayList3 == null) {
                if (i != 0 || quaternion == null) continue;
                object = new Quaternion();
                object.set((ReadableVector4f)quaternion);
                this.addDefaultAnimTrack("RootNode", i, (Quaternion)object, new Vector3f(0.0f, 0.0f, 0.0f), arrayList, f3);
                continue;
            }
            object = objectArray[i];
            if (object == null) continue;
            object.sort();
            int n = this.getParentBoneIdx(i);
            boolean bl4 = bl2 && (n == 0 || this.doesParentBoneHaveAnimFrames((TFloatArrayList[])objectArray, arrayList2, i));
            for (int j = 0; j < object.size(); ++j) {
                float f4 = object.get(j);
                float f5 = f4 / (float)aiAnimation.getTicksPerSecond();
                for (int k = 0; k < arrayList3.size(); ++k) {
                    AiNodeAnim aiNodeAnim = arrayList3.get(k);
                    Keyframe keyframe = new Keyframe();
                    keyframe.clear();
                    keyframe.BoneName = aiNodeAnim.getNodeName();
                    keyframe.Bone = i;
                    keyframe.Time = f5;
                    if (!bl) {
                        keyframe.Position = JAssImpImporter.GetKeyFramePosition(aiNodeAnim, f4);
                        keyframe.Rotation = JAssImpImporter.GetKeyFrameRotation(aiNodeAnim, f4);
                        keyframe.Scale = JAssImpImporter.GetKeyFrameScale(aiNodeAnim, f4);
                    } else {
                        keyframe.Position = this.GetKeyFramePosition(aiNodeAnim, f4, f2);
                        keyframe.Rotation = this.GetKeyFrameRotation(aiNodeAnim, f4, f2);
                        keyframe.Scale = this.GetKeyFrameScale(aiNodeAnim, f4, f2);
                    }
                    keyframe.Position.x *= f;
                    keyframe.Position.y *= f;
                    keyframe.Position.z *= f;
                    if (bl2) {
                        if (bl4) {
                            Quaternion.mul((Quaternion)quaternion2, (Quaternion)keyframe.Rotation, (Quaternion)keyframe.Rotation);
                            boolean bl5 = StringUtils.startsWithIgnoreCase(keyframe.BoneName, "Translation_Data");
                            if (!bl5) {
                                HelperFunctions.transform(quaternion2, keyframe.Position, keyframe.Position);
                            }
                        }
                        Quaternion.mul((Quaternion)keyframe.Rotation, (Quaternion)quaternion, (Quaternion)keyframe.Rotation);
                    }
                    arrayList.add(keyframe);
                }
            }
        }
        String string = aiAnimation.getName();
        int n = string.indexOf(124);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        string = string.trim();
        object = new AnimationClip(f3, arrayList, string, true);
        arrayList.clear();
        if (ModelManager.instance.bCreateSoftwareMeshes) {
            ((AnimationClip)object).staticClip = new StaticAnimation((AnimationClip)object);
        }
        this.clips.put(string, (AnimationClip)object);
    }

    private void addDefaultAnimTrack(String string, int n, Quaternion quaternion, Vector3f vector3f, ArrayList<Keyframe> arrayList, float f) {
        Vector3f vector3f2 = new Vector3f(1.0f, 1.0f, 1.0f);
        Keyframe keyframe = new Keyframe();
        keyframe.clear();
        keyframe.BoneName = string;
        keyframe.Bone = n;
        keyframe.Time = 0.0f;
        keyframe.Position = vector3f;
        keyframe.Rotation = quaternion;
        keyframe.Scale = vector3f2;
        arrayList.add(keyframe);
        Keyframe keyframe2 = new Keyframe();
        keyframe2.clear();
        keyframe2.BoneName = string;
        keyframe2.Bone = n;
        keyframe2.Time = f;
        keyframe2.Position = vector3f;
        keyframe2.Rotation = quaternion;
        keyframe2.Scale = vector3f2;
        arrayList.add(keyframe2);
    }

    private boolean doesParentBoneHaveAnimFrames(TFloatArrayList[] tFloatArrayListArray, ArrayList<ArrayList<AiNodeAnim>> arrayList, int n) {
        int n2 = this.getParentBoneIdx(n);
        if (n2 < 0) {
            return false;
        }
        return this.doesBoneHaveAnimFrames(tFloatArrayListArray, arrayList, n2);
    }

    private boolean doesBoneHaveAnimFrames(TFloatArrayList[] tFloatArrayListArray, ArrayList<ArrayList<AiNodeAnim>> arrayList, int n) {
        TFloatArrayList tFloatArrayList = tFloatArrayListArray[n];
        if (tFloatArrayList == null || tFloatArrayList.size() <= 0) {
            return false;
        }
        ArrayList<AiNodeAnim> arrayList2 = arrayList.get(n);
        return arrayList2.size() > 0;
    }

    private void collectBoneFrames(AiAnimation aiAnimation, TFloatArrayList[] tFloatArrayListArray, ArrayList<ArrayList<AiNodeAnim>> arrayList) {
        List list = aiAnimation.getChannels();
        for (int i = 0; i < list.size(); ++i) {
            float f;
            int n;
            AiNodeAnim aiNodeAnim = (AiNodeAnim)list.get(i);
            String string = aiNodeAnim.getNodeName();
            Integer n2 = this.boneIndices.get(string);
            if (n2 == null) {
                DebugLog.General.error("Could not find bone index for node name: \"%s\"", string);
                continue;
            }
            ArrayList<Object> arrayList2 = arrayList.get(n2);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList();
                arrayList.set(n2, arrayList2);
            }
            arrayList2.add(aiNodeAnim);
            TFloatArrayList tFloatArrayList = tFloatArrayListArray[n2];
            if (tFloatArrayList == null) {
                tFloatArrayListArray[n2.intValue()] = tFloatArrayList = new TFloatArrayList();
            }
            for (n = 0; n < aiNodeAnim.getNumPosKeys(); ++n) {
                f = (float)aiNodeAnim.getPosKeyTime(n);
                if (tFloatArrayList.contains(f)) continue;
                tFloatArrayList.add(f);
            }
            for (n = 0; n < aiNodeAnim.getNumRotKeys(); ++n) {
                f = (float)aiNodeAnim.getRotKeyTime(n);
                if (tFloatArrayList.contains(f)) continue;
                tFloatArrayList.add(f);
            }
            for (n = 0; n < aiNodeAnim.getNumScaleKeys(); ++n) {
                f = (float)aiNodeAnim.getScaleKeyTime(n);
                if (tFloatArrayList.contains(f)) continue;
                tFloatArrayList.add(f);
            }
        }
    }

    private int getParentBoneIdx(int n) {
        if (n > -1) {
            return this.SkeletonHierarchy.get(n);
        }
        return -1;
    }

    public int getNumBoneAncestors(int n) {
        int n2 = 0;
        int n3 = this.getParentBoneIdx(n);
        while (n3 > -1) {
            ++n2;
            n3 = this.getParentBoneIdx(n3);
        }
        return n2;
    }

    private Vector3f GetKeyFramePosition(AiNodeAnim aiNodeAnim, float f, double d) {
        int n;
        Vector3f vector3f = new Vector3f();
        if (aiNodeAnim.getNumPosKeys() == 0) {
            return vector3f;
        }
        for (n = 0; n < aiNodeAnim.getNumPosKeys() - 1 && !((double)f < aiNodeAnim.getPosKeyTime(n + 1)); ++n) {
        }
        int n2 = (n + 1) % aiNodeAnim.getNumPosKeys();
        float f2 = (float)aiNodeAnim.getPosKeyTime(n);
        float f3 = (float)aiNodeAnim.getPosKeyTime(n2);
        float f4 = f3 - f2;
        if (f4 < 0.0f) {
            f4 = (float)((double)f4 + d);
        }
        if (f4 > 0.0f) {
            float f5 = f3 - f2;
            float f6 = f - f2;
            float f7 = aiNodeAnim.getPosKeyX(n);
            float f8 = aiNodeAnim.getPosKeyX(n2);
            float f9 = f7 + (f6 /= f5) * (f8 - f7);
            float f10 = aiNodeAnim.getPosKeyY(n);
            float f11 = aiNodeAnim.getPosKeyY(n2);
            float f12 = f10 + f6 * (f11 - f10);
            float f13 = aiNodeAnim.getPosKeyZ(n);
            float f14 = aiNodeAnim.getPosKeyZ(n2);
            float f15 = f13 + f6 * (f14 - f13);
            vector3f.set(f9, f12, f15);
        } else {
            vector3f.set(aiNodeAnim.getPosKeyX(n), aiNodeAnim.getPosKeyY(n), aiNodeAnim.getPosKeyZ(n));
        }
        return vector3f;
    }

    private Quaternion GetKeyFrameRotation(AiNodeAnim aiNodeAnim, float f, double d) {
        int n;
        Quaternion quaternion = new Quaternion();
        if (aiNodeAnim.getNumRotKeys() == 0) {
            return quaternion;
        }
        for (n = 0; n < aiNodeAnim.getNumRotKeys() - 1 && !((double)f < aiNodeAnim.getRotKeyTime(n + 1)); ++n) {
        }
        int n2 = (n + 1) % aiNodeAnim.getNumRotKeys();
        float f2 = (float)aiNodeAnim.getRotKeyTime(n);
        float f3 = (float)aiNodeAnim.getRotKeyTime(n2);
        float f4 = f3 - f2;
        if (f4 < 0.0f) {
            f4 = (float)((double)f4 + d);
        }
        if (f4 > 0.0f) {
            double d2;
            double d3;
            float f5 = (f - f2) / f4;
            AiQuaternion aiQuaternion = (AiQuaternion)aiNodeAnim.getRotKeyQuaternion(n, (AiWrapperProvider)this.wrapper);
            AiQuaternion aiQuaternion2 = (AiQuaternion)aiNodeAnim.getRotKeyQuaternion(n2, (AiWrapperProvider)this.wrapper);
            double d4 = aiQuaternion.getX() * aiQuaternion2.getX() + aiQuaternion.getY() * aiQuaternion2.getY() + aiQuaternion.getZ() * aiQuaternion2.getZ() + aiQuaternion.getW() * aiQuaternion2.getW();
            this.end.set(aiQuaternion2.getX(), aiQuaternion2.getY(), aiQuaternion2.getZ(), aiQuaternion2.getW());
            if (d4 < 0.0) {
                d4 *= -1.0;
                this.end.setX(-this.end.getX());
                this.end.setY(-this.end.getY());
                this.end.setZ(-this.end.getZ());
                this.end.setW(-this.end.getW());
            }
            if (1.0 - d4 > 1.0E-4) {
                double d5 = Math.acos(d4);
                double d6 = Math.sin(d5);
                d3 = Math.sin((1.0 - (double)f5) * d5) / d6;
                d2 = Math.sin((double)f5 * d5) / d6;
            } else {
                d3 = 1.0 - (double)f5;
                d2 = f5;
            }
            quaternion.set((float)(d3 * (double)aiQuaternion.getX() + d2 * (double)this.end.getX()), (float)(d3 * (double)aiQuaternion.getY() + d2 * (double)this.end.getY()), (float)(d3 * (double)aiQuaternion.getZ() + d2 * (double)this.end.getZ()), (float)(d3 * (double)aiQuaternion.getW() + d2 * (double)this.end.getW()));
        } else {
            float f6 = aiNodeAnim.getRotKeyX(n);
            float f7 = aiNodeAnim.getRotKeyY(n);
            float f8 = aiNodeAnim.getRotKeyZ(n);
            float f9 = aiNodeAnim.getRotKeyW(n);
            quaternion.set(f6, f7, f8, f9);
        }
        return quaternion;
    }

    private Vector3f GetKeyFrameScale(AiNodeAnim aiNodeAnim, float f, double d) {
        int n;
        Vector3f vector3f = new Vector3f(1.0f, 1.0f, 1.0f);
        if (aiNodeAnim.getNumScaleKeys() == 0) {
            return vector3f;
        }
        for (n = 0; n < aiNodeAnim.getNumScaleKeys() - 1 && !((double)f < aiNodeAnim.getScaleKeyTime(n + 1)); ++n) {
        }
        vector3f.set(aiNodeAnim.getScaleKeyX(n), aiNodeAnim.getScaleKeyY(n), aiNodeAnim.getScaleKeyZ(n));
        return vector3f;
    }
}

