/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.model;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import zombie.asset.Asset;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.ImmutableColor;
import zombie.core.SpriteRenderer;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.core.opengl.PZGLUtil;
import zombie.core.opengl.RenderThread;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.model.Model;
import zombie.core.skinnedmodel.model.ModelInstanceRenderData;
import zombie.core.skinnedmodel.population.ClothingItem;
import zombie.core.skinnedmodel.shader.Shader;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureDraw;
import zombie.core.textures.TextureFBO;
import zombie.debug.DebugOptions;
import zombie.input.GameKeyboard;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.Clothing;
import zombie.inventory.types.Food;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.WeaponPart;
import zombie.iso.IsoGridSquare;
import zombie.popman.ObjectPool;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.ModelAttachment;
import zombie.scripting.objects.ModelScript;
import zombie.scripting.objects.ModelWeaponPart;
import zombie.util.StringUtils;
import zombie.util.Type;

public final class WorldItemAtlas {
    public static final int ATLAS_SIZE = 512;
    public static final int MATRIX_SIZE = 1024;
    private static final float MAX_ZOOM = 2.5f;
    private TextureFBO fbo;
    public static final WorldItemAtlas instance = new WorldItemAtlas();
    private final HashMap<String, ItemTexture> itemTextureMap = new HashMap();
    private final ArrayList<Atlas> AtlasList = new ArrayList();
    private final ItemParams itemParams = new ItemParams();
    private final Checksummer checksummer = new Checksummer();
    private static final Stack<RenderJob> JobPool = new Stack();
    private final ArrayList<RenderJob> RenderJobs = new ArrayList();
    private final ObjectPool<ItemTextureDrawer> itemTextureDrawerPool = new ObjectPool<ItemTextureDrawer>(ItemTextureDrawer::new);
    private final ObjectPool<WeaponPartParams> weaponPartParamPool = new ObjectPool<WeaponPartParams>(WeaponPartParams::new);
    private final ArrayList<WeaponPart> m_tempWeaponPartList = new ArrayList();
    private static final Matrix4f s_attachmentXfrm = new Matrix4f();
    private static final ImmutableColor ROTTEN_FOOD_COLOR = new ImmutableColor(0.5f, 0.5f, 0.5f);

    public ItemTexture getItemTexture(InventoryItem inventoryItem) {
        if (this.itemParams.init(inventoryItem)) {
            return this.getItemTexture(this.itemParams);
        }
        return null;
    }

    public ItemTexture getItemTexture(ItemParams itemParams) {
        String string = this.getItemKey(itemParams);
        ItemTexture itemTexture = this.itemTextureMap.get(string);
        if (itemTexture != null) {
            return itemTexture;
        }
        AtlasEntry atlasEntry = new AtlasEntry();
        atlasEntry.key = string;
        itemTexture = new ItemTexture();
        itemTexture.itemParams.copyFrom(itemParams);
        itemTexture.entry = atlasEntry;
        this.itemTextureMap.put(string, itemTexture);
        this.RenderJobs.add(RenderJob.getNew().init(itemParams, atlasEntry));
        return itemTexture;
    }

    private void assignEntryToAtlas(AtlasEntry atlasEntry, int n, int n2) {
        if (atlasEntry.atlas != null) {
            return;
        }
        for (int i = 0; i < this.AtlasList.size(); ++i) {
            Atlas atlas = this.AtlasList.get(i);
            if (atlas.isFull() || atlas.ENTRY_WID != n || atlas.ENTRY_HGT != n2) continue;
            atlas.addEntry(atlasEntry);
            return;
        }
        Atlas atlas = new Atlas(512, 512, n, n2);
        atlas.addEntry(atlasEntry);
        this.AtlasList.add(atlas);
    }

    private String getItemKey(ItemParams itemParams) {
        try {
            this.checksummer.reset();
            this.checksummer.update(itemParams.m_model.Name);
            if (itemParams.m_weaponParts != null) {
                for (int i = 0; i < itemParams.m_weaponParts.size(); ++i) {
                    WeaponPartParams weaponPartParams = itemParams.m_weaponParts.get(i);
                    this.checksummer.update(weaponPartParams.m_model.Name);
                }
            }
            this.checksummer.update((int)(itemParams.worldScale * 1000.0f));
            this.checksummer.update((byte)(itemParams.m_tintR * 255.0f));
            this.checksummer.update((byte)(itemParams.m_tintG * 255.0f));
            this.checksummer.update((byte)(itemParams.m_tintB * 255.0f));
            this.checksummer.update((int)(itemParams.m_angle.x * 1000.0f));
            this.checksummer.update((int)(itemParams.m_angle.y * 1000.0f));
            this.checksummer.update((int)(itemParams.m_angle.z * 1000.0f));
            this.checksummer.update((byte)itemParams.m_foodState.ordinal());
            return this.checksummer.checksumToString();
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
            return "bogus";
        }
    }

    public void render() {
        Object object;
        int n;
        for (n = 0; n < this.AtlasList.size(); ++n) {
            object = this.AtlasList.get(n);
            if (!((Atlas)object).clear) continue;
            SpriteRenderer.instance.drawGeneric(new ClearAtlasTexture((Atlas)object));
        }
        if (this.RenderJobs.isEmpty()) {
            return;
        }
        for (n = 0; n < this.RenderJobs.size(); ++n) {
            object = this.RenderJobs.get(n);
            if (((RenderJob)object).done == 1 && ((RenderJob)object).renderRefCount > 0) continue;
            if (((RenderJob)object).done == 1 && ((RenderJob)object).renderRefCount == 0) {
                this.RenderJobs.remove(n--);
                assert (!JobPool.contains(object));
                JobPool.push((RenderJob)object);
                continue;
            }
            ((RenderJob)object).entry.bRenderMainOK = ((RenderJob)object).renderMain();
            if (!((RenderJob)object).entry.bRenderMainOK) continue;
            ++((RenderJob)object).renderRefCount;
            SpriteRenderer.instance.drawGeneric((TextureDraw.GenericDrawer)object);
        }
    }

    public void renderUI() {
        if (DebugOptions.instance.WorldItemAtlasRender.getValue() && GameKeyboard.isKeyPressed(209)) {
            this.Reset();
        }
        if (DebugOptions.instance.WorldItemAtlasRender.getValue()) {
            int n = 512 / Core.TileScale;
            n /= 2;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < this.AtlasList.size(); ++i) {
                int n4;
                Atlas atlas = this.AtlasList.get(i);
                SpriteRenderer.instance.renderi(null, n2, n3, n, n, 1.0f, 1.0f, 1.0f, 0.75f, null);
                SpriteRenderer.instance.renderi(atlas.tex, n2, n3, n, n, 1.0f, 1.0f, 1.0f, 1.0f, null);
                float f = (float)n / (float)atlas.tex.getWidth();
                for (n4 = 0; n4 <= atlas.tex.getWidth() / atlas.ENTRY_WID; ++n4) {
                    SpriteRenderer.instance.renderline(null, (int)((float)n2 + (float)(n4 * atlas.ENTRY_WID) * f), n3, (int)((float)n2 + (float)(n4 * atlas.ENTRY_WID) * f), n3 + n, 0.5f, 0.5f, 0.5f, 1.0f);
                }
                for (n4 = 0; n4 <= atlas.tex.getHeight() / atlas.ENTRY_HGT; ++n4) {
                    SpriteRenderer.instance.renderline(null, n2, (int)((float)(n3 + n) - (float)(n4 * atlas.ENTRY_HGT) * f), n2 + n, (int)((float)(n3 + n) - (float)(n4 * atlas.ENTRY_HGT) * f), 0.5f, 0.5f, 0.5f, 1.0f);
                }
                if ((n3 += n) + n <= Core.getInstance().getScreenHeight()) continue;
                n3 = 0;
                n2 += n;
            }
        }
    }

    public void Reset() {
        if (this.fbo != null) {
            this.fbo.destroyLeaveTexture();
            this.fbo = null;
        }
        this.AtlasList.forEach(Atlas::Reset);
        this.AtlasList.clear();
        this.itemTextureMap.values().forEach(ItemTexture::Reset);
        this.itemTextureMap.clear();
        JobPool.forEach(RenderJob::Reset);
        JobPool.clear();
        this.RenderJobs.clear();
    }

    private static final class ItemParams {
        float worldScale = 1.0f;
        float worldZRotation = 0.0f;
        FoodState m_foodState = FoodState.Normal;
        private Model m_model;
        private ArrayList<WeaponPartParams> m_weaponParts;
        private float m_hue;
        private float m_tintR;
        private float m_tintG;
        private float m_tintB;
        private final Vector3f m_angle = new Vector3f();
        private final Matrix4f m_transform = new Matrix4f();
        private float m_ambientR = 1.0f;
        private float m_ambientG = 1.0f;
        private float m_ambientB = 1.0f;
        private float alpha = 1.0f;

        ItemParams() {
        }

        void copyFrom(ItemParams itemParams) {
            this.worldScale = itemParams.worldScale;
            this.worldZRotation = itemParams.worldZRotation;
            this.m_foodState = itemParams.m_foodState;
            this.m_model = itemParams.m_model;
            if (this.m_weaponParts != null) {
                WorldItemAtlas.instance.weaponPartParamPool.release((List<WeaponPartParams>)this.m_weaponParts);
                this.m_weaponParts.clear();
            }
            if (itemParams.m_weaponParts != null) {
                if (this.m_weaponParts == null) {
                    this.m_weaponParts = new ArrayList();
                }
                for (int i = 0; i < itemParams.m_weaponParts.size(); ++i) {
                    WeaponPartParams weaponPartParams = itemParams.m_weaponParts.get(i);
                    this.m_weaponParts.add(WorldItemAtlas.instance.weaponPartParamPool.alloc().init(weaponPartParams));
                }
            }
            this.m_hue = itemParams.m_hue;
            this.m_tintR = itemParams.m_tintR;
            this.m_tintG = itemParams.m_tintG;
            this.m_tintB = itemParams.m_tintB;
            this.m_angle.set((Vector3fc)itemParams.m_angle);
            this.m_transform.set((Matrix4fc)itemParams.m_transform);
        }

        boolean init(InventoryItem inventoryItem) {
            this.Reset();
            this.worldScale = inventoryItem.worldScale;
            this.worldZRotation = inventoryItem.worldZRotation;
            float f = 0.0f;
            String string = StringUtils.discardNullOrWhitespace(inventoryItem.getWorldStaticItem());
            if (string != null) {
                boolean bl;
                Object object;
                Object object2;
                Object object3 = ScriptManager.instance.getModelScript(string);
                if (object3 == null) {
                    return false;
                }
                String string2 = ((ModelScript)object3).getMeshName();
                String string3 = ((ModelScript)object3).getTextureName();
                String string4 = ((ModelScript)object3).getShaderName();
                ImmutableColor immutableColor = ImmutableColor.white;
                float f2 = 1.0f;
                Food food = Type.tryCastTo(inventoryItem, Food.class);
                if (food != null) {
                    this.m_foodState = this.getFoodState(food);
                    if (food.isCooked() && (object2 = ScriptManager.instance.getModelScript(inventoryItem.getWorldStaticItem() + "Cooked")) != null) {
                        string3 = ((ModelScript)object2).getTextureName();
                        string2 = ((ModelScript)object2).getMeshName();
                        string4 = ((ModelScript)object2).getShaderName();
                        object3 = object2;
                    }
                    if (food.isBurnt() && (object2 = ScriptManager.instance.getModelScript(inventoryItem.getWorldStaticItem() + "Burnt")) != null) {
                        string3 = ((ModelScript)object2).getTextureName();
                        string2 = ((ModelScript)object2).getMeshName();
                        string4 = ((ModelScript)object2).getShaderName();
                        object3 = object2;
                    }
                    if (food.isRotten()) {
                        object2 = ScriptManager.instance.getModelScript(inventoryItem.getWorldStaticItem() + "Rotten");
                        if (object2 != null) {
                            string3 = ((ModelScript)object2).getTextureName();
                            string2 = ((ModelScript)object2).getMeshName();
                            string4 = ((ModelScript)object2).getShaderName();
                            object3 = object2;
                        } else {
                            immutableColor = ROTTEN_FOOD_COLOR;
                        }
                    }
                }
                if ((object2 = Type.tryCastTo(inventoryItem, Clothing.class)) != null || inventoryItem.getClothingItem() != null) {
                    String string5 = ((ModelScript)object3).getTextureName(true);
                    object = inventoryItem.getVisual();
                    ClothingItem clothingItem = inventoryItem.getClothingItem();
                    ImmutableColor immutableColor2 = ((ItemVisual)object).getTint(clothingItem);
                    if (string5 == null) {
                        string5 = clothingItem.textureChoices.isEmpty() ? ((ItemVisual)object).getBaseTexture(clothingItem) : ((ItemVisual)object).getTextureChoice(clothingItem);
                    }
                    if (string5 != null) {
                        string3 = string5;
                        immutableColor = immutableColor2;
                    }
                }
                if ((object = ModelManager.instance.tryGetLoadedModel(string2, string3, bl = ((ModelScript)object3).bStatic, string4, true)) == null) {
                    ModelManager.instance.loadAdditionalModel(string2, string3, bl, string4);
                }
                if ((object = ModelManager.instance.getLoadedModel(string2, string3, bl, string4)) == null || !((Asset)object).isReady() || ((Model)object).Mesh == null || !((Model)object).Mesh.isReady()) {
                    return false;
                }
                this.init(inventoryItem, (Model)object, (ModelScript)object3, f2, immutableColor, f, false);
                if (this.worldScale != 1.0f) {
                    this.m_transform.scale(((ModelScript)object3).scale * this.worldScale);
                } else if (((ModelScript)object3).scale != 1.0f) {
                    this.m_transform.scale(((ModelScript)object3).scale);
                }
                this.m_angle.x = 0.0f;
                this.m_angle.y = this.worldZRotation;
                this.m_angle.z = 0.0f;
                return true;
            }
            Clothing clothing = Type.tryCastTo(inventoryItem, Clothing.class);
            if (clothing != null) {
                ClothingItem clothingItem = inventoryItem.getClothingItem();
                ItemVisual itemVisual = inventoryItem.getVisual();
                boolean bl = false;
                String string6 = clothingItem.getModel(bl);
                if (clothingItem != null && itemVisual != null && !StringUtils.isNullOrWhitespace(string6) && "Bip01_Head".equalsIgnoreCase(clothingItem.m_AttachBone) && (!clothing.isCosmetic() || "Eyes".equals(inventoryItem.getBodyLocation()))) {
                    String string7;
                    boolean bl2;
                    String string8 = itemVisual.getTextureChoice(clothingItem);
                    Model model = ModelManager.instance.tryGetLoadedModel(string6, string8, bl2 = clothingItem.m_Static, string7 = clothingItem.m_Shader, false);
                    if (model == null) {
                        ModelManager.instance.loadAdditionalModel(string6, string8, bl2, string7);
                    }
                    if ((model = ModelManager.instance.getLoadedModel(string6, string8, bl2, string7)) == null || !model.isReady() || model.Mesh == null || !model.Mesh.isReady()) {
                        return false;
                    }
                    float f3 = itemVisual.getHue(clothingItem);
                    ImmutableColor immutableColor = itemVisual.getTint(clothingItem);
                    this.init(inventoryItem, model, null, f3, immutableColor, f, false);
                    this.m_angle.x = 180.0f + f;
                    this.m_angle.y = this.worldZRotation;
                    this.m_angle.z = -90.0f;
                    this.m_transform.translate(-0.08f, 0.0f, 0.05f);
                    return true;
                }
                return false;
            }
            HandWeapon handWeapon = Type.tryCastTo(inventoryItem, HandWeapon.class);
            if (handWeapon != null) {
                String string9;
                boolean bl;
                String string10;
                String string11 = StringUtils.discardNullOrWhitespace(handWeapon.getStaticModel());
                if (string11 == null) {
                    return false;
                }
                ModelScript modelScript = ScriptManager.instance.getModelScript(string11);
                if (modelScript == null) {
                    return false;
                }
                String string12 = modelScript.getMeshName();
                Model model = ModelManager.instance.tryGetLoadedModel(string12, string10 = modelScript.getTextureName(), bl = modelScript.bStatic, string9 = modelScript.getShaderName(), false);
                if (model == null) {
                    ModelManager.instance.loadAdditionalModel(string12, string10, bl, string9);
                }
                if ((model = ModelManager.instance.getLoadedModel(string12, string10, bl, string9)) == null || !model.isReady() || model.Mesh == null || !model.Mesh.isReady()) {
                    return false;
                }
                float f4 = 1.0f;
                ImmutableColor immutableColor = ImmutableColor.white;
                this.init(inventoryItem, model, modelScript, f4, immutableColor, f, true);
                if (this.worldScale != 1.0f) {
                    this.m_transform.scale(modelScript.scale * this.worldScale);
                } else if (modelScript.scale != 1.0f) {
                    this.m_transform.scale(modelScript.scale);
                }
                this.m_angle.x = 0.0f;
                this.m_angle.y = this.worldZRotation;
                return this.initWeaponParts(handWeapon, modelScript);
            }
            return false;
        }

        boolean initWeaponParts(HandWeapon handWeapon, ModelScript modelScript) {
            ArrayList<ModelWeaponPart> arrayList = handWeapon.getModelWeaponPart();
            if (arrayList == null) {
                return true;
            }
            ArrayList<WeaponPart> arrayList2 = handWeapon.getAllWeaponParts(WorldItemAtlas.instance.m_tempWeaponPartList);
            block0: for (int i = 0; i < arrayList2.size(); ++i) {
                WeaponPart weaponPart = arrayList2.get(i);
                for (int j = 0; j < arrayList.size(); ++j) {
                    ModelWeaponPart modelWeaponPart = arrayList.get(j);
                    if (!weaponPart.getFullType().equals(modelWeaponPart.partType)) continue;
                    if (this.initWeaponPart(modelWeaponPart, modelScript)) continue block0;
                    return false;
                }
            }
            return true;
        }

        boolean initWeaponPart(ModelWeaponPart modelWeaponPart, ModelScript modelScript) {
            String string;
            boolean bl;
            String string2;
            String string3 = StringUtils.discardNullOrWhitespace(modelWeaponPart.modelName);
            if (string3 == null) {
                return false;
            }
            ModelScript modelScript2 = ScriptManager.instance.getModelScript(string3);
            if (modelScript2 == null) {
                return false;
            }
            String string4 = modelScript2.getMeshName();
            Model model = ModelManager.instance.tryGetLoadedModel(string4, string2 = modelScript2.getTextureName(), bl = modelScript2.bStatic, string = modelScript2.getShaderName(), false);
            if (model == null) {
                ModelManager.instance.loadAdditionalModel(string4, string2, bl, string);
            }
            if ((model = ModelManager.instance.getLoadedModel(string4, string2, bl, string)) == null || !model.isReady() || model.Mesh == null || !model.Mesh.isReady()) {
                return false;
            }
            WeaponPartParams weaponPartParams = WorldItemAtlas.instance.weaponPartParamPool.alloc();
            weaponPartParams.m_model = model;
            weaponPartParams.m_attachmentNameSelf = modelWeaponPart.attachmentNameSelf;
            weaponPartParams.m_attachmentNameParent = modelWeaponPart.attachmentParent;
            weaponPartParams.initTransform(modelScript, modelScript2);
            if (this.m_weaponParts == null) {
                this.m_weaponParts = new ArrayList();
            }
            this.m_weaponParts.add(weaponPartParams);
            return true;
        }

        void init(InventoryItem inventoryItem, Model model, ModelScript modelScript, float f, ImmutableColor immutableColor, float f2, boolean bl) {
            ModelAttachment modelAttachment;
            this.m_model = model;
            this.m_tintR = immutableColor.r;
            this.m_tintG = immutableColor.g;
            this.m_tintB = immutableColor.b;
            this.m_hue = f;
            this.m_angle.set(0.0f);
            this.m_transform.identity();
            this.m_ambientB = 1.0f;
            this.m_ambientG = 1.0f;
            this.m_ambientR = 1.0f;
            if (bl) {
                this.m_transform.rotateXYZ(0.0f, (float)Math.PI, 1.5707964f);
            }
            if (modelScript != null && (modelAttachment = modelScript.getAttachmentById("world")) != null) {
                ModelInstanceRenderData.makeAttachmentTransform(modelAttachment, s_attachmentXfrm);
                s_attachmentXfrm.invert();
                this.m_transform.mul((Matrix4fc)s_attachmentXfrm);
            }
            if (model.Mesh != null && model.Mesh.isReady() && model.Mesh.m_transform != null) {
                model.Mesh.m_transform.transpose();
                this.m_transform.mul((Matrix4fc)model.Mesh.m_transform);
                model.Mesh.m_transform.transpose();
            }
        }

        FoodState getFoodState(Food food) {
            FoodState foodState = FoodState.Normal;
            if (food.isCooked()) {
                foodState = FoodState.Cooked;
            }
            if (food.isBurnt()) {
                foodState = FoodState.Burnt;
            }
            if (food.isRotten()) {
                foodState = FoodState.Rotten;
            }
            return foodState;
        }

        boolean isStillValid(InventoryItem inventoryItem) {
            if (inventoryItem.worldScale != this.worldScale || (float)inventoryItem.worldZRotation != this.worldZRotation) {
                return false;
            }
            Food food = Type.tryCastTo(inventoryItem, Food.class);
            return food == null || this.getFoodState(food) == this.m_foodState;
        }

        void Reset() {
            this.m_model = null;
            this.m_foodState = FoodState.Normal;
            if (this.m_weaponParts != null) {
                WorldItemAtlas.instance.weaponPartParamPool.release((List<WeaponPartParams>)this.m_weaponParts);
                this.m_weaponParts.clear();
            }
        }

        static enum FoodState {
            Normal,
            Cooked,
            Burnt,
            Rotten;

        }
    }

    private static final class Checksummer {
        private MessageDigest md;
        private final StringBuilder sb = new StringBuilder();

        private Checksummer() {
        }

        public void reset() throws NoSuchAlgorithmException {
            if (this.md == null) {
                this.md = MessageDigest.getInstance("MD5");
            }
            this.md.reset();
        }

        public void update(byte by) {
            this.md.update(by);
        }

        public void update(boolean bl) {
            this.md.update((byte)(bl ? 1 : 0));
        }

        public void update(int n) {
            this.md.update((byte)(n & 0xFF));
            this.md.update((byte)(n >> 8 & 0xFF));
            this.md.update((byte)(n >> 16 & 0xFF));
            this.md.update((byte)(n >> 24 & 0xFF));
        }

        public void update(String string) {
            if (string == null || string.isEmpty()) {
                return;
            }
            this.md.update(string.getBytes());
        }

        public void update(ImmutableColor immutableColor) {
            this.update((byte)(immutableColor.r * 255.0f));
            this.update((byte)(immutableColor.g * 255.0f));
            this.update((byte)(immutableColor.b * 255.0f));
        }

        public void update(IsoGridSquare.ResultLight resultLight, float f, float f2, float f3) {
            if (resultLight == null || resultLight.radius <= 0) {
                return;
            }
            this.update((int)((float)resultLight.x - f));
            this.update((int)((float)resultLight.y - f2));
            this.update((int)((float)resultLight.z - f3));
            this.update((byte)(resultLight.r * 255.0f));
            this.update((byte)(resultLight.g * 255.0f));
            this.update((byte)(resultLight.b * 255.0f));
            this.update((byte)resultLight.radius);
        }

        public String checksumToString() {
            byte[] byArray = this.md.digest();
            this.sb.setLength(0);
            for (int i = 0; i < byArray.length; ++i) {
                this.sb.append(byArray[i] & 0xFF);
            }
            return this.sb.toString();
        }
    }

    public static final class ItemTexture {
        final ItemParams itemParams = new ItemParams();
        AtlasEntry entry;

        public boolean isStillValid(InventoryItem inventoryItem) {
            if (this.entry == null) {
                return false;
            }
            return this.itemParams.isStillValid(inventoryItem);
        }

        public boolean isRenderMainOK() {
            return this.entry.bRenderMainOK;
        }

        public boolean isTooBig() {
            return this.entry.bTooBig;
        }

        public void render(float f, float f2, float f3, float f4, float f5, float f6) {
            if (!this.entry.ready || !this.entry.tex.isReady()) {
                SpriteRenderer.instance.drawGeneric(WorldItemAtlas.instance.itemTextureDrawerPool.alloc().init(this, f, f2, f3, f4, f5, f6));
                return;
            }
            SpriteRenderer.instance.m_states.getPopulatingActiveState().render(this.entry.tex, f - ((float)this.entry.w / 2.0f - this.entry.offsetX) / 2.5f, f2 - ((float)this.entry.h / 2.0f - this.entry.offsetY) / 2.5f, (float)this.entry.w / 2.5f, (float)this.entry.h / 2.5f, f3, f4, f5, f6, null);
        }

        void Reset() {
            this.itemParams.Reset();
            this.entry = null;
        }
    }

    private static final class AtlasEntry {
        public Atlas atlas;
        public String key;
        public int x;
        public int y;
        public int w;
        public int h;
        public float offsetX;
        public float offsetY;
        public Texture tex;
        public boolean ready = false;
        public boolean bRenderMainOK = false;
        public boolean bTooBig = false;

        private AtlasEntry() {
        }

        public void Reset() {
            this.atlas = null;
            this.tex.destroy();
            this.tex = null;
            this.ready = false;
            this.bRenderMainOK = false;
            this.bTooBig = false;
        }
    }

    private static final class RenderJob
    extends TextureDraw.GenericDrawer {
        public final ItemParams itemParams = new ItemParams();
        public AtlasEntry entry;
        public int done = 0;
        public int renderRefCount;
        public boolean bClearThisSlotOnly;
        int entryW;
        int entryH;
        final int[] m_viewport = new int[4];
        final Matrix4f m_matri4f = new Matrix4f();
        final Matrix4f m_projection = new Matrix4f();
        final Matrix4f m_modelView = new Matrix4f();
        final Vector3f m_scenePos = new Vector3f();
        final float[] m_bounds = new float[4];
        static final Vector3f tempVector3f = new Vector3f(0.0f, 5.0f, -2.0f);
        static final Matrix4f tempMatrix4f_1 = new Matrix4f();
        static final Matrix4f tempMatrix4f_2 = new Matrix4f();
        static final float[] xs = new float[8];
        static final float[] ys = new float[8];

        private RenderJob() {
        }

        public static RenderJob getNew() {
            if (JobPool.isEmpty()) {
                return new RenderJob();
            }
            return JobPool.pop();
        }

        public RenderJob init(ItemParams itemParams, AtlasEntry atlasEntry) {
            this.itemParams.copyFrom(itemParams);
            this.entry = atlasEntry;
            this.bClearThisSlotOnly = false;
            this.entryW = 0;
            this.entryH = 0;
            this.done = 0;
            this.renderRefCount = 0;
            return this;
        }

        public boolean renderMain() {
            Model model = this.itemParams.m_model;
            return model != null && model.isReady() && model.Mesh != null && model.Mesh.isReady();
        }

        @Override
        public void render() {
            if (this.done == 1) {
                return;
            }
            Model model = this.itemParams.m_model;
            if (model == null || model.Mesh == null || !model.Mesh.isReady()) {
                return;
            }
            float f = 0.0f;
            float f2 = 0.0f;
            this.calcMatrices(this.m_projection, this.m_modelView, f, f2);
            this.calcModelBounds(this.m_bounds);
            this.calcModelOffset();
            this.calcEntrySize();
            if (this.entryW <= 0 || this.entryH <= 0) {
                return;
            }
            if (this.entryW > 512 || this.entryH > 512) {
                this.entry.bTooBig = true;
                this.done = 1;
                return;
            }
            instance.assignEntryToAtlas(this.entry, this.entryW, this.entryH);
            GL11.glPushAttrib((int)1048575);
            GL11.glPushClientAttrib((int)-1);
            GL11.glDepthMask((boolean)true);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glDisable((int)3089);
            TextureFBO textureFBO = WorldItemAtlas.instance.fbo;
            if (textureFBO.getTexture() != this.entry.atlas.tex) {
                textureFBO.setTexture(this.entry.atlas.tex);
            }
            textureFBO.startDrawing(this.entry.atlas.clear, this.entry.atlas.clear);
            if (this.entry.atlas.clear) {
                this.entry.atlas.clear = false;
            }
            this.clearColorAndDepth();
            int n = this.entry.x - (int)this.entry.offsetX - (1024 - this.entry.w) / 2;
            int n2 = -((int)this.entry.offsetY) - (1024 - this.entry.h) / 2;
            GL11.glViewport((int)n, (int)(n2 += 512 - (this.entry.y + this.entry.h)), (int)1024, (int)1024);
            boolean bl = this.renderModel(this.itemParams.m_model, null);
            if (this.itemParams.m_weaponParts != null && !this.itemParams.m_weaponParts.isEmpty()) {
                for (int i = 0; i < this.itemParams.m_weaponParts.size(); ++i) {
                    WeaponPartParams weaponPartParams = this.itemParams.m_weaponParts.get(i);
                    if (this.renderModel(weaponPartParams.m_model, weaponPartParams.m_transform)) continue;
                    bl = false;
                    break;
                }
            }
            textureFBO.endDrawing();
            if (!bl) {
                GL11.glPopAttrib();
                GL11.glPopClientAttrib();
                return;
            }
            this.entry.ready = true;
            this.done = 1;
            Texture.lastTextureID = -1;
            SpriteRenderer.ringBuffer.restoreBoundTextures = true;
            SpriteRenderer.ringBuffer.restoreVBOs = true;
            GL11.glPopAttrib();
            GL11.glPopClientAttrib();
        }

        @Override
        public void postRender() {
            if (this.entry == null) {
                return;
            }
            assert (this.renderRefCount > 0);
            --this.renderRefCount;
        }

        void clearColorAndDepth() {
            GL11.glEnable((int)3089);
            GL11.glScissor((int)this.entry.x, (int)(512 - (this.entry.y + this.entry.h)), (int)this.entry.w, (int)this.entry.h);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glClear((int)16640);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.restoreScreenStencil();
            GL11.glDisable((int)3089);
        }

        void restoreScreenStencil() {
            int n = SpriteRenderer.instance.getRenderingPlayerIndex();
            int n2 = n == 0 || n == 2 ? 0 : Core.getInstance().getOffscreenTrueWidth() / 2;
            int n3 = n == 0 || n == 1 ? 0 : Core.getInstance().getOffscreenTrueHeight() / 2;
            int n4 = Core.getInstance().getOffscreenTrueWidth();
            int n5 = Core.getInstance().getOffscreenTrueHeight();
            if (IsoPlayer.numPlayers > 1) {
                n4 /= 2;
            }
            if (IsoPlayer.numPlayers > 2) {
                n5 /= 2;
            }
            GL11.glScissor((int)n2, (int)n3, (int)n4, (int)n5);
        }

        boolean renderModel(Model model, Matrix4f matrix4f) {
            Shader shader;
            if (!model.bStatic) {
                return false;
            }
            if (model.Effect == null) {
                model.CreateShader("basicEffect");
            }
            if ((shader = model.Effect) == null || model.Mesh == null || !model.Mesh.isReady()) {
                return false;
            }
            if (model.tex != null && !model.tex.isReady()) {
                return false;
            }
            PZGLUtil.pushAndLoadMatrix(5889, this.m_projection);
            Matrix4f matrix4f2 = tempMatrix4f_1.set((Matrix4fc)this.m_modelView);
            Matrix4f matrix4f3 = tempMatrix4f_2.set((Matrix4fc)this.itemParams.m_transform).invert();
            matrix4f2.mul((Matrix4fc)matrix4f3);
            PZGLUtil.pushAndLoadMatrix(5888, matrix4f2);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDepthFunc((int)513);
            GL11.glDepthMask((boolean)true);
            GL11.glDepthRange((double)0.0, (double)1.0);
            GL11.glEnable((int)2929);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            shader.Start();
            if (model.tex == null) {
                shader.setTexture(Texture.getErrorTexture(), "Texture", 0);
            } else {
                shader.setTexture(model.tex, "Texture", 0);
            }
            shader.setDepthBias(0.0f);
            shader.setAmbient(this.itemParams.m_ambientR * 0.4f, this.itemParams.m_ambientG * 0.4f, this.itemParams.m_ambientB * 0.4f);
            shader.setLightingAmount(1.0f);
            shader.setHueShift(this.itemParams.m_hue);
            shader.setTint(this.itemParams.m_tintR, this.itemParams.m_tintG, this.itemParams.m_tintB);
            shader.setAlpha(this.itemParams.alpha);
            for (int i = 0; i < 5; ++i) {
                shader.setLight(i, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, Float.NaN, 0.0f, 0.0f, 0.0f, null);
            }
            Vector3f vector3f = tempVector3f;
            vector3f.x = 0.0f;
            vector3f.y = 5.0f;
            vector3f.z = -2.0f;
            vector3f.rotateY(this.itemParams.m_angle.y * ((float)Math.PI / 180));
            float f = 1.5f;
            shader.setLight(4, vector3f.x, vector3f.z, vector3f.y, this.itemParams.m_ambientR / 4.0f * f, this.itemParams.m_ambientG / 4.0f * f, this.itemParams.m_ambientB / 4.0f * f, 5000.0f, Float.NaN, 0.0f, 0.0f, 0.0f, null);
            if (matrix4f == null) {
                shader.setTransformMatrix(this.itemParams.m_transform, false);
            } else {
                tempMatrix4f_1.set((Matrix4fc)this.itemParams.m_transform);
                tempMatrix4f_1.mul((Matrix4fc)matrix4f);
                shader.setTransformMatrix(tempMatrix4f_1, false);
            }
            model.Mesh.Draw(shader);
            shader.End();
            if (Core.bDebug && DebugOptions.instance.ModelRenderAxis.getValue()) {
                Model.debugDrawAxis(0.0f, 0.0f, 0.0f, 0.5f, 1.0f);
            }
            PZGLUtil.popMatrix(5889);
            PZGLUtil.popMatrix(5888);
            return true;
        }

        void calcMatrices(Matrix4f matrix4f, Matrix4f matrix4f2, float f, float f2) {
            matrix4f.setOrtho(-0.26666668f, 0.26666668f, 0.26666668f, -0.26666668f, -10.0f, 10.0f);
            matrix4f2.identity();
            float f3 = 0.047085002f;
            matrix4f2.scale(f3 * (float)Core.TileScale / 2.0f);
            boolean bl = true;
            if (bl) {
                matrix4f2.rotate(0.5235988f, 1.0f, 0.0f, 0.0f);
                matrix4f2.rotate(2.3561945f, 0.0f, 1.0f, 0.0f);
            } else {
                matrix4f2.rotate(1.5707964f, 0.0f, 1.0f, 0.0f);
            }
            matrix4f2.scale(-3.75f, 3.75f, 3.75f);
            matrix4f2.rotateXYZ(this.itemParams.m_angle.x * ((float)Math.PI / 180), this.itemParams.m_angle.y * ((float)Math.PI / 180), this.itemParams.m_angle.z * ((float)Math.PI / 180));
            matrix4f2.translate(f, 0.0f, f2);
            matrix4f2.mul((Matrix4fc)this.itemParams.m_transform);
        }

        void calcModelBounds(float[] fArray) {
            fArray[0] = Float.MAX_VALUE;
            fArray[1] = Float.MAX_VALUE;
            fArray[2] = -3.4028235E38f;
            fArray[3] = -3.4028235E38f;
            this.calcModelBounds(this.itemParams.m_model, this.m_modelView, fArray);
            if (this.itemParams.m_weaponParts != null) {
                for (int i = 0; i < this.itemParams.m_weaponParts.size(); ++i) {
                    WeaponPartParams weaponPartParams = this.itemParams.m_weaponParts.get(i);
                    Matrix4f matrix4f = tempMatrix4f_1.set((Matrix4fc)this.m_modelView).mul((Matrix4fc)weaponPartParams.m_transform);
                    this.calcModelBounds(weaponPartParams.m_model, matrix4f, fArray);
                }
            }
            float f = 2.0f;
            fArray[0] = fArray[0] * f;
            fArray[1] = fArray[1] * f;
            fArray[2] = fArray[2] * f;
            fArray[3] = fArray[3] * f;
        }

        void calcModelBounds(Model model, Matrix4f matrix4f, float[] fArray) {
            Vector3f vector3f = model.Mesh.minXYZ;
            Vector3f vector3f2 = model.Mesh.maxXYZ;
            RenderJob.xs[0] = vector3f.x;
            RenderJob.ys[0] = vector3f.y;
            RenderJob.xs[1] = vector3f.x;
            RenderJob.ys[1] = vector3f2.y;
            RenderJob.xs[2] = vector3f2.x;
            RenderJob.ys[2] = vector3f2.y;
            RenderJob.xs[3] = vector3f2.x;
            RenderJob.ys[3] = vector3f.y;
            for (int i = 0; i < 4; ++i) {
                this.sceneToUI(xs[i], ys[i], vector3f.z, this.m_projection, matrix4f, this.m_scenePos);
                fArray[0] = PZMath.min(fArray[0], this.m_scenePos.x);
                fArray[2] = PZMath.max(fArray[2], this.m_scenePos.x);
                fArray[1] = PZMath.min(fArray[1], this.m_scenePos.y);
                fArray[3] = PZMath.max(fArray[3], this.m_scenePos.y);
                this.sceneToUI(xs[i], ys[i], vector3f2.z, this.m_projection, matrix4f, this.m_scenePos);
                fArray[0] = PZMath.min(fArray[0], this.m_scenePos.x);
                fArray[2] = PZMath.max(fArray[2], this.m_scenePos.x);
                fArray[1] = PZMath.min(fArray[1], this.m_scenePos.y);
                fArray[3] = PZMath.max(fArray[3], this.m_scenePos.y);
            }
        }

        void calcModelOffset() {
            float f = this.m_bounds[0];
            float f2 = this.m_bounds[1];
            float f3 = this.m_bounds[2];
            float f4 = this.m_bounds[3];
            this.entry.offsetX = f + (f3 - f) / 2.0f - 512.0f;
            this.entry.offsetY = f2 + (f4 - f2) / 2.0f - 512.0f;
        }

        void calcEntrySize() {
            float f = this.m_bounds[0];
            float f2 = this.m_bounds[1];
            float f3 = this.m_bounds[2];
            float f4 = this.m_bounds[3];
            float f5 = 2.0f;
            f -= f5;
            f2 -= f5;
            f3 += f5;
            f4 += f5;
            int n = 16;
            f = (float)Math.floor(f / (float)n) * (float)n;
            f3 = (float)Math.ceil(f3 / (float)n) * (float)n;
            f2 = (float)Math.floor(f2 / (float)n) * (float)n;
            f4 = (float)Math.ceil(f4 / (float)n) * (float)n;
            this.entryW = (int)(f3 - f);
            this.entryH = (int)(f4 - f2);
        }

        Vector3f sceneToUI(float f, float f2, float f3, Matrix4f matrix4f, Matrix4f matrix4f2, Vector3f vector3f) {
            Matrix4f matrix4f3 = this.m_matri4f;
            matrix4f3.set((Matrix4fc)matrix4f);
            matrix4f3.mul((Matrix4fc)matrix4f2);
            this.m_viewport[0] = 0;
            this.m_viewport[1] = 0;
            this.m_viewport[2] = 512;
            this.m_viewport[3] = 512;
            matrix4f3.project(f, f2, f3, this.m_viewport, vector3f);
            return vector3f;
        }

        public void Reset() {
            this.itemParams.Reset();
            this.entry = null;
        }
    }

    private final class Atlas {
        public final int ENTRY_WID;
        public final int ENTRY_HGT;
        public Texture tex;
        public final ArrayList<AtlasEntry> EntryList = new ArrayList();
        public boolean clear = true;

        public Atlas(int n, int n2, int n3, int n4) {
            this.ENTRY_WID = n3;
            this.ENTRY_HGT = n4;
            this.tex = new Texture(n, n2, 16);
            if (WorldItemAtlas.this.fbo != null) {
                return;
            }
            WorldItemAtlas.this.fbo = new TextureFBO(this.tex, false);
        }

        public boolean isFull() {
            int n = this.tex.getWidth() / this.ENTRY_WID;
            int n2 = this.tex.getHeight() / this.ENTRY_HGT;
            return this.EntryList.size() >= n * n2;
        }

        public AtlasEntry addItem(String string) {
            int n = this.tex.getWidth() / this.ENTRY_WID;
            int n2 = this.EntryList.size();
            int n3 = n2 % n;
            int n4 = n2 / n;
            AtlasEntry atlasEntry = new AtlasEntry();
            atlasEntry.atlas = this;
            atlasEntry.key = string;
            atlasEntry.x = n3 * this.ENTRY_WID;
            atlasEntry.y = n4 * this.ENTRY_HGT;
            atlasEntry.w = this.ENTRY_WID;
            atlasEntry.h = this.ENTRY_HGT;
            atlasEntry.tex = this.tex.split(string, atlasEntry.x, this.tex.getHeight() - (atlasEntry.y + this.ENTRY_HGT), atlasEntry.w, atlasEntry.h);
            atlasEntry.tex.setName(string);
            this.EntryList.add(atlasEntry);
            return atlasEntry;
        }

        public void addEntry(AtlasEntry atlasEntry) {
            int n = this.tex.getWidth() / this.ENTRY_WID;
            int n2 = this.EntryList.size();
            int n3 = n2 % n;
            int n4 = n2 / n;
            atlasEntry.atlas = this;
            atlasEntry.x = n3 * this.ENTRY_WID;
            atlasEntry.y = n4 * this.ENTRY_HGT;
            atlasEntry.w = this.ENTRY_WID;
            atlasEntry.h = this.ENTRY_HGT;
            atlasEntry.tex = this.tex.split(atlasEntry.key, atlasEntry.x, this.tex.getHeight() - (atlasEntry.y + this.ENTRY_HGT), atlasEntry.w, atlasEntry.h);
            atlasEntry.tex.setName(atlasEntry.key);
            this.EntryList.add(atlasEntry);
        }

        public void Reset() {
            this.EntryList.forEach(AtlasEntry::Reset);
            this.EntryList.clear();
            if (!this.tex.isDestroyed()) {
                RenderThread.invokeOnRenderContext(() -> GL11.glDeleteTextures((int)this.tex.getID()));
            }
            this.tex = null;
        }
    }

    private static final class WeaponPartParams {
        Model m_model;
        String m_attachmentNameSelf;
        String m_attachmentNameParent;
        final Matrix4f m_transform = new Matrix4f();

        private WeaponPartParams() {
        }

        WeaponPartParams init(WeaponPartParams weaponPartParams) {
            this.m_model = weaponPartParams.m_model;
            this.m_attachmentNameSelf = weaponPartParams.m_attachmentNameSelf;
            this.m_attachmentNameParent = weaponPartParams.m_attachmentNameParent;
            this.m_transform.set((Matrix4fc)weaponPartParams.m_transform);
            return this;
        }

        void initTransform(ModelScript modelScript, ModelScript modelScript2) {
            this.m_transform.identity();
            Matrix4f matrix4f = s_attachmentXfrm;
            ModelAttachment modelAttachment = modelScript.getAttachmentById(this.m_attachmentNameParent);
            if (modelAttachment != null) {
                ModelInstanceRenderData.makeAttachmentTransform(modelAttachment, matrix4f);
                this.m_transform.mul((Matrix4fc)matrix4f);
            }
            ModelAttachment modelAttachment2 = modelScript2.getAttachmentById(this.m_attachmentNameSelf);
            if (modelAttachment2 != null) {
                ModelInstanceRenderData.makeAttachmentTransform(modelAttachment2, matrix4f);
                matrix4f.invert();
                this.m_transform.mul((Matrix4fc)matrix4f);
            }
        }
    }

    private static final class ClearAtlasTexture
    extends TextureDraw.GenericDrawer {
        Atlas m_atlas;

        ClearAtlasTexture(Atlas atlas) {
            this.m_atlas = atlas;
        }

        @Override
        public void render() {
            TextureFBO textureFBO = WorldItemAtlas.instance.fbo;
            if (textureFBO == null || this.m_atlas.tex == null) {
                return;
            }
            if (!this.m_atlas.clear) {
                return;
            }
            if (textureFBO.getTexture() != this.m_atlas.tex) {
                textureFBO.setTexture(this.m_atlas.tex);
            }
            textureFBO.startDrawing(false, false);
            GL11.glPushAttrib((int)2048);
            GL11.glViewport((int)0, (int)0, (int)textureFBO.getWidth(), (int)textureFBO.getHeight());
            GL11.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            int n = this.m_atlas.tex.getWidth();
            int n2 = this.m_atlas.tex.getHeight();
            GLU.gluOrtho2D((float)0.0f, (float)n, (float)n2, (float)0.0f);
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glDisable((int)3089);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glClear((int)16640);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            textureFBO.endDrawing();
            GL11.glEnable((int)3089);
            GL11.glMatrixMode((int)5889);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glPopMatrix();
            GL11.glPopAttrib();
            this.m_atlas.clear = false;
        }
    }

    private static final class ItemTextureDrawer
    extends TextureDraw.GenericDrawer {
        ItemTexture itemTexture;
        float x;
        float y;
        float r;
        float g;
        float b;
        float a;

        private ItemTextureDrawer() {
        }

        ItemTextureDrawer init(ItemTexture itemTexture, float f, float f2, float f3, float f4, float f5, float f6) {
            this.itemTexture = itemTexture;
            this.x = f;
            this.y = f2;
            this.r = f3;
            this.g = f4;
            this.b = f5;
            this.a = f6;
            return this;
        }

        @Override
        public void render() {
            AtlasEntry atlasEntry = this.itemTexture.entry;
            if (atlasEntry == null || !atlasEntry.ready || !atlasEntry.tex.isReady()) {
                return;
            }
            int n = (int)(this.x - ((float)atlasEntry.w / 2.0f - atlasEntry.offsetX) / 2.5f);
            int n2 = (int)(this.y - ((float)atlasEntry.h / 2.0f - atlasEntry.offsetY) / 2.5f);
            int n3 = (int)((float)atlasEntry.w / 2.5f);
            int n4 = (int)((float)atlasEntry.h / 2.5f);
            atlasEntry.tex.bind();
            GL11.glBegin((int)7);
            GL11.glColor4f((float)this.r, (float)this.g, (float)this.b, (float)this.a);
            GL11.glTexCoord2f((float)atlasEntry.tex.xStart, (float)atlasEntry.tex.yStart);
            GL11.glVertex2i((int)n, (int)n2);
            GL11.glTexCoord2f((float)atlasEntry.tex.xEnd, (float)atlasEntry.tex.yStart);
            GL11.glVertex2i((int)(n + n3), (int)n2);
            GL11.glTexCoord2f((float)atlasEntry.tex.xEnd, (float)atlasEntry.tex.yEnd);
            GL11.glVertex2i((int)(n + n3), (int)(n2 + n4));
            GL11.glTexCoord2f((float)atlasEntry.tex.xStart, (float)atlasEntry.tex.yEnd);
            GL11.glVertex2i((int)n, (int)(n2 + n4));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnd();
            SpriteRenderer.ringBuffer.restoreBoundTextures = true;
        }

        @Override
        public void postRender() {
            this.itemTexture = null;
            WorldItemAtlas.instance.itemTextureDrawerPool.release(this);
        }
    }
}

