/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.model;

import gnu.trove.list.array.TFloatArrayList;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.util.vector.Matrix4f;
import zombie.core.Color;
import zombie.core.math.PZMath;
import zombie.core.opengl.PZGLUtil;
import zombie.core.skinnedmodel.HelperFunctions;
import zombie.core.skinnedmodel.animation.AnimationPlayer;
import zombie.core.skinnedmodel.model.Model;
import zombie.core.skinnedmodel.model.ModelInstanceDebugRenderData;
import zombie.core.skinnedmodel.model.ModelInstanceRenderData;
import zombie.core.skinnedmodel.model.ModelSlotRenderData;
import zombie.core.skinnedmodel.model.VehicleSubModelInstance;
import zombie.debug.DebugOptions;
import zombie.inventory.types.HandWeapon;
import zombie.iso.IsoCamera;
import zombie.iso.IsoGridSquare;
import zombie.util.Pool;
import zombie.util.PooledObject;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;

public final class ModelSlotDebugRenderData
extends PooledObject {
    private static final Pool<ModelSlotDebugRenderData> s_pool = new Pool<ModelSlotDebugRenderData>(ModelSlotDebugRenderData::new);
    private ModelSlotRenderData m_slotData;
    private final TFloatArrayList m_boneCoords = new TFloatArrayList();
    private final ArrayList<Matrix4f> m_boneMatrices = new ArrayList();
    private final TFloatArrayList m_squareLights = new TFloatArrayList();
    private org.joml.Matrix4f m_weaponMatrix;
    private float m_weaponLength;

    public static ModelSlotDebugRenderData alloc() {
        return s_pool.alloc();
    }

    public ModelSlotDebugRenderData init(ModelSlotRenderData modelSlotRenderData) {
        this.m_slotData = modelSlotRenderData;
        this.initBoneAxis();
        this.initSkeleton();
        this.initLights();
        this.initWeaponHitPoint();
        for (int i = 0; i < modelSlotRenderData.modelData.size(); ++i) {
            ModelInstanceRenderData modelInstanceRenderData = (ModelInstanceRenderData)modelSlotRenderData.modelData.get(i);
            modelInstanceRenderData.m_debugRenderData = ModelInstanceDebugRenderData.alloc().init(modelSlotRenderData, modelInstanceRenderData);
        }
        return this;
    }

    private void initBoneAxis() {
        for (int i = 0; i < this.m_boneMatrices.size(); ++i) {
            HelperFunctions.returnMatrix(this.m_boneMatrices.get(i));
        }
        this.m_boneMatrices.clear();
        if (this.m_slotData.animPlayer == null || !this.m_slotData.animPlayer.hasSkinningData()) {
            return;
        }
        if (DebugOptions.instance.Character.Debug.Render.Bip01.getValue()) {
            this.initBoneAxis("Bip01");
        }
        if (DebugOptions.instance.Character.Debug.Render.PrimaryHandBone.getValue()) {
            this.initBoneAxis("Bip01_Prop1");
        }
        if (DebugOptions.instance.Character.Debug.Render.SecondaryHandBone.getValue()) {
            this.initBoneAxis("Bip01_Prop2");
        }
        if (DebugOptions.instance.Character.Debug.Render.TranslationData.getValue()) {
            this.initBoneAxis("Translation_Data");
        }
    }

    private void initBoneAxis(String string) {
        Integer n = this.m_slotData.animPlayer.getSkinningData().BoneIndices.get(string);
        if (n != null) {
            Matrix4f matrix4f = HelperFunctions.getMatrix();
            matrix4f.load(this.m_slotData.animPlayer.modelTransforms[n]);
            this.m_boneMatrices.add(matrix4f);
        }
    }

    private void initSkeleton() {
        this.m_boneCoords.clear();
        if (!DebugOptions.instance.ModelRenderBones.getValue()) {
            return;
        }
        this.initSkeleton(this.m_slotData.animPlayer);
        if (this.m_slotData.object instanceof BaseVehicle) {
            for (int i = 0; i < this.m_slotData.modelData.size(); ++i) {
                ModelInstanceRenderData modelInstanceRenderData = (ModelInstanceRenderData)this.m_slotData.modelData.get(i);
                VehicleSubModelInstance vehicleSubModelInstance = Type.tryCastTo(modelInstanceRenderData.modelInstance, VehicleSubModelInstance.class);
                if (vehicleSubModelInstance == null) continue;
                this.initSkeleton(vehicleSubModelInstance.AnimPlayer);
            }
        }
    }

    private void initSkeleton(AnimationPlayer animationPlayer) {
        if (animationPlayer == null || !animationPlayer.hasSkinningData() || animationPlayer.isBoneTransformsNeedFirstFrame()) {
            return;
        }
        Integer n = animationPlayer.getSkinningData().BoneIndices.get("Translation_Data");
        for (int i = 0; i < animationPlayer.modelTransforms.length; ++i) {
            int n2;
            if (n != null && i == n || (n2 = animationPlayer.getSkinningData().SkeletonHierarchy.get(i).intValue()) < 0) continue;
            this.initSkeleton(animationPlayer.modelTransforms, i);
            this.initSkeleton(animationPlayer.modelTransforms, n2);
        }
    }

    private void initSkeleton(Matrix4f[] matrix4fArray, int n) {
        float f = matrix4fArray[n].m03;
        float f2 = matrix4fArray[n].m13;
        float f3 = matrix4fArray[n].m23;
        this.m_boneCoords.add(f);
        this.m_boneCoords.add(f2);
        this.m_boneCoords.add(f3);
    }

    private void initLights() {
        this.m_squareLights.clear();
        if (!DebugOptions.instance.ModelRenderLights.getValue()) {
            return;
        }
        if (this.m_slotData.character == null) {
            return;
        }
        if (this.m_slotData.character.getCurrentSquare() == null) {
            return;
        }
        int n = IsoCamera.frameState.playerIndex;
        IsoGridSquare.ILighting iLighting = this.m_slotData.character.getCurrentSquare().lighting[n];
        for (int i = 0; i < iLighting.resultLightCount(); ++i) {
            IsoGridSquare.ResultLight resultLight = iLighting.getResultLight(i);
            this.m_squareLights.add((float)resultLight.x);
            this.m_squareLights.add((float)resultLight.y);
            this.m_squareLights.add((float)resultLight.z);
        }
    }

    private void initWeaponHitPoint() {
        if (this.m_weaponMatrix != null) {
            BaseVehicle.TL_matrix4f_pool.get().release(this.m_weaponMatrix);
            this.m_weaponMatrix = null;
        }
        if (!DebugOptions.instance.ModelRenderWeaponHitPoint.getValue()) {
            return;
        }
        if (this.m_slotData.animPlayer == null || !this.m_slotData.animPlayer.hasSkinningData()) {
            return;
        }
        if (this.m_slotData.character == null) {
            return;
        }
        Integer n = this.m_slotData.animPlayer.getSkinningData().BoneIndices.get("Bip01_Prop1");
        if (n == null) {
            return;
        }
        HandWeapon handWeapon = Type.tryCastTo(this.m_slotData.character.getPrimaryHandItem(), HandWeapon.class);
        if (handWeapon == null) {
            return;
        }
        this.m_weaponLength = handWeapon.WeaponLength;
        Matrix4f matrix4f = this.m_slotData.animPlayer.modelTransforms[n];
        this.m_weaponMatrix = (org.joml.Matrix4f)BaseVehicle.TL_matrix4f_pool.get().alloc();
        PZMath.convertMatrix(matrix4f, this.m_weaponMatrix);
        this.m_weaponMatrix.transpose();
    }

    public void render() {
        this.renderBonesAxis();
        this.renderSkeleton();
        this.renderLights();
        this.renderWeaponHitPoint();
    }

    private void renderBonesAxis() {
        for (int i = 0; i < this.m_boneMatrices.size(); ++i) {
            Model.drawBoneMtx(this.m_boneMatrices.get(i));
        }
    }

    private void renderSkeleton() {
        int n;
        if (this.m_boneCoords.isEmpty()) {
            return;
        }
        GL11.glDisable((int)2929);
        for (n = 7; n >= 0; --n) {
            GL13.glActiveTexture((int)(33984 + n));
            GL11.glDisable((int)3553);
        }
        GL11.glLineWidth((float)1.0f);
        GL11.glBegin((int)1);
        for (n = 0; n < this.m_boneCoords.size(); n += 6) {
            Color color = Model.debugDrawColours[n % Model.debugDrawColours.length];
            GL11.glColor3f((float)color.r, (float)color.g, (float)color.b);
            float f = this.m_boneCoords.get(n);
            float f2 = this.m_boneCoords.get(n + 1);
            float f3 = this.m_boneCoords.get(n + 2);
            GL11.glVertex3f((float)f, (float)f2, (float)f3);
            f = this.m_boneCoords.get(n + 3);
            f2 = this.m_boneCoords.get(n + 4);
            f3 = this.m_boneCoords.get(n + 5);
            GL11.glVertex3f((float)f, (float)f2, (float)f3);
        }
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2929);
    }

    private void renderLights() {
        for (int i = 0; i < this.m_squareLights.size(); i += 3) {
            float f = this.m_squareLights.get(i);
            float f2 = this.m_squareLights.get(i + 1);
            float f3 = this.m_squareLights.get(i + 2);
            Model.debugDrawLightSource(f, f2, f3, this.m_slotData.x, this.m_slotData.y, this.m_slotData.z, -this.m_slotData.animPlayerAngle);
        }
    }

    private void renderWeaponHitPoint() {
        if (this.m_weaponMatrix == null) {
            return;
        }
        PZGLUtil.pushAndMultMatrix(5888, this.m_weaponMatrix);
        Model.debugDrawAxis(0.0f, this.m_weaponLength, 0.0f, 0.05f, 1.0f);
        PZGLUtil.popMatrix(5888);
    }
}

