/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.model;

import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.util.glu.GLU;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.math.PZMath;
import zombie.core.opengl.CharacterModelCamera;
import zombie.core.opengl.ShaderProgram;
import zombie.core.skinnedmodel.ModelCamera;
import zombie.core.skinnedmodel.model.ModelSlotRenderData;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureDraw;
import zombie.core.textures.TextureFBO;
import zombie.interfaces.ITexture;
import zombie.iso.IsoCamera;
import zombie.popman.ObjectPool;

public final class ModelOutlines {
    public static final ModelOutlines instance = new ModelOutlines();
    public TextureFBO m_fboA;
    public TextureFBO m_fboB;
    public TextureFBO m_fboC;
    public boolean m_dirty = false;
    private int m_playerIndex;
    private final ColorInfo m_outlineColor = new ColorInfo();
    private ModelSlotRenderData m_playerRenderData;
    private ShaderProgram m_thickenHShader;
    private ShaderProgram m_thickenVShader;
    private ShaderProgram m_blitShader;
    private final ObjectPool<Drawer> m_drawerPool = new ObjectPool<Drawer>(Drawer::new);

    public void startFrameMain(int n) {
        Drawer drawer = this.m_drawerPool.alloc();
        drawer.m_startFrame = true;
        drawer.m_playerIndex = n;
        SpriteRenderer.instance.drawGeneric(drawer);
    }

    public void endFrameMain(int n) {
        Drawer drawer = this.m_drawerPool.alloc();
        drawer.m_startFrame = false;
        drawer.m_playerIndex = n;
        SpriteRenderer.instance.drawGeneric(drawer);
    }

    public void startFrame(int n) {
        this.m_dirty = false;
        this.m_playerIndex = n;
        this.m_playerRenderData = null;
    }

    public void checkFBOs() {
        if (this.m_fboA != null && (this.m_fboA.getWidth() != Core.width || this.m_fboB.getHeight() != Core.height)) {
            this.m_fboA.destroy();
            this.m_fboB.destroy();
            this.m_fboC.destroy();
            this.m_fboA = null;
            this.m_fboB = null;
            this.m_fboC = null;
        }
        if (this.m_fboA == null) {
            Texture texture = new Texture(Core.width, Core.height, 16);
            this.m_fboA = new TextureFBO(texture, false);
            Texture texture2 = new Texture(Core.width, Core.height, 16);
            this.m_fboB = new TextureFBO(texture2, false);
            Texture texture3 = new Texture(Core.width, Core.height, 16);
            this.m_fboC = new TextureFBO(texture3, false);
        }
    }

    public void setPlayerRenderData(ModelSlotRenderData modelSlotRenderData) {
        this.m_playerRenderData = modelSlotRenderData;
    }

    public boolean beginRenderOutline(ColorInfo colorInfo) {
        this.m_outlineColor.set(colorInfo);
        if (this.m_dirty) {
            return false;
        }
        this.m_dirty = true;
        this.checkFBOs();
        return true;
    }

    public void endFrame(int n) {
        if (!this.m_dirty) {
            return;
        }
        this.m_playerIndex = n;
        if (this.m_thickenHShader == null) {
            this.m_thickenHShader = ShaderProgram.createShaderProgram("aim_outline_h", false, true);
            this.m_thickenVShader = ShaderProgram.createShaderProgram("aim_outline_v", false, true);
            this.m_blitShader = ShaderProgram.createShaderProgram("aim_outline_blit", false, true);
        }
        int n2 = IsoCamera.getScreenLeft(this.m_playerIndex);
        int n3 = IsoCamera.getScreenTop(this.m_playerIndex);
        int n4 = IsoCamera.getScreenWidth(this.m_playerIndex);
        int n5 = IsoCamera.getScreenHeight(this.m_playerIndex);
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        int n9 = n5;
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GLU.gluOrtho2D((float)0.0f, (float)n8, (float)n9, (float)0.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        float f = this.m_fboA.getWidth();
        float f2 = this.m_fboA.getHeight();
        float f3 = SpriteRenderer.instance.getPlayerZoomLevel();
        float f4 = PZMath.lerp(0.5f, 0.2f, f3 / 2.5f);
        this.m_fboB.startDrawing(true, true);
        GL11.glViewport((int)n6, (int)n7, (int)n8, (int)n9);
        this.m_thickenHShader.Start();
        this.m_thickenHShader.setVector2("u_resolution", f, f2);
        this.m_thickenHShader.setValue("u_radius", f4);
        this.m_thickenHShader.setVector4("u_color", this.m_outlineColor.r, this.m_outlineColor.g, this.m_outlineColor.b, this.m_outlineColor.a);
        this.renderTexture(this.m_fboA.getTexture(), n2, n3, n4, n5);
        this.m_thickenHShader.End();
        this.m_fboB.endDrawing();
        this.m_fboC.startDrawing(true, true);
        GL11.glViewport((int)n6, (int)n7, (int)n8, (int)n9);
        this.m_thickenVShader.Start();
        this.m_thickenVShader.setVector2("u_resolution", f, f2);
        this.m_thickenVShader.setValue("u_radius", f4);
        this.m_thickenVShader.setVector4("u_color", this.m_outlineColor.r, this.m_outlineColor.g, this.m_outlineColor.b, this.m_outlineColor.a);
        this.renderTexture(this.m_fboB.getTexture(), n2, n3, n4, n5);
        this.m_thickenVShader.End();
        this.m_fboC.endDrawing();
        if (this.m_playerRenderData != null) {
            CharacterModelCamera.instance.m_x = this.m_playerRenderData.x;
            CharacterModelCamera.instance.m_y = this.m_playerRenderData.y;
            CharacterModelCamera.instance.m_z = this.m_playerRenderData.z;
            CharacterModelCamera.instance.m_bInVehicle = this.m_playerRenderData.bInVehicle;
            CharacterModelCamera.instance.m_useAngle = this.m_playerRenderData.animPlayerAngle;
            CharacterModelCamera.instance.m_bUseWorldIso = true;
            CharacterModelCamera.instance.bDepthMask = false;
            ModelCamera.instance = CharacterModelCamera.instance;
            GL11.glViewport((int)n2, (int)n3, (int)n4, (int)n5);
            this.m_playerRenderData.performRenderCharacterOutline();
        }
        GL11.glViewport((int)n6, (int)n7, (int)n8, (int)n9);
        this.m_blitShader.Start();
        this.m_blitShader.setSamplerUnit("texture", 0);
        this.m_blitShader.setSamplerUnit("mask", 1);
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)this.m_fboA.getTexture().getID());
        GL13.glActiveTexture((int)33984);
        this.renderTexture(this.m_fboC.getTexture(), n2, n3, n4, n5);
        this.m_blitShader.End();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        SpriteRenderer.ringBuffer.restoreBoundTextures = true;
    }

    private void renderTexture(ITexture iTexture, int n, int n2, int n3, int n4) {
        iTexture.bind();
        float f = (float)n / (float)iTexture.getWidthHW();
        float f2 = (float)n2 / (float)iTexture.getHeightHW();
        float f3 = (float)(n + n3) / (float)iTexture.getWidthHW();
        float f4 = (float)(n2 + n4) / (float)iTexture.getHeightHW();
        n2 = 0;
        n = 0;
        GL11.glDepthMask((boolean)false);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)f, (float)f4);
        GL11.glVertex2i((int)n, (int)n2);
        GL11.glTexCoord2f((float)f3, (float)f4);
        GL11.glVertex2i((int)(n + n3), (int)n2);
        GL11.glTexCoord2f((float)f3, (float)f2);
        GL11.glVertex2i((int)(n + n3), (int)(n2 + n4));
        GL11.glTexCoord2f((float)f, (float)f2);
        GL11.glVertex2i((int)n, (int)(n2 + n4));
        GL11.glEnd();
        GL11.glDepthMask((boolean)true);
    }

    public void renderDebug() {
    }

    public static final class Drawer
    extends TextureDraw.GenericDrawer {
        boolean m_startFrame;
        int m_playerIndex;

        @Override
        public void render() {
            if (this.m_startFrame) {
                instance.startFrame(this.m_playerIndex);
            } else {
                instance.endFrame(this.m_playerIndex);
            }
        }

        @Override
        public void postRender() {
            ModelOutlines.instance.m_drawerPool.release(this);
        }
    }
}

