/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.model;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector3f;
import zombie.core.opengl.RenderThread;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.animation.AnimationClip;
import zombie.core.skinnedmodel.animation.Keyframe;
import zombie.core.skinnedmodel.animation.StaticAnimation;
import zombie.core.skinnedmodel.model.AnimationAsset;
import zombie.core.skinnedmodel.model.ModelMesh;
import zombie.core.skinnedmodel.model.ModelTxt;
import zombie.core.skinnedmodel.model.SkinningData;
import zombie.core.skinnedmodel.model.VertexBufferObject;
import zombie.util.SharedStrings;

public final class ModelLoader {
    public static final ModelLoader instance = new ModelLoader();
    private final ThreadLocal<SharedStrings> sharedStrings = ThreadLocal.withInitial(SharedStrings::new);

    protected ModelTxt loadTxt(String string2, boolean bl, boolean bl2, SkinningData skinningData) throws IOException {
        ModelTxt modelTxt = new ModelTxt();
        modelTxt.bStatic = bl;
        modelTxt.bReverse = bl2;
        VertexBufferObject.VertexFormat vertexFormat = new VertexBufferObject.VertexFormat(bl ? 4 : 6);
        vertexFormat.setElement(0, VertexBufferObject.VertexType.VertexArray, 12);
        vertexFormat.setElement(1, VertexBufferObject.VertexType.NormalArray, 12);
        vertexFormat.setElement(2, VertexBufferObject.VertexType.TangentArray, 12);
        vertexFormat.setElement(3, VertexBufferObject.VertexType.TextureCoordArray, 8);
        if (!bl) {
            vertexFormat.setElement(4, VertexBufferObject.VertexType.BlendWeightArray, 16);
            vertexFormat.setElement(5, VertexBufferObject.VertexType.BlendIndexArray, 16);
        }
        vertexFormat.calculate();
        try (FileReader fileReader = new FileReader(string2);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            SharedStrings sharedStrings = this.sharedStrings.get();
            LoadMode loadMode = LoadMode.Version;
            String string3 = null;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            boolean bl3 = false;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.indexOf(35) == 0) continue;
                if (string3.contains("Tangent")) {
                    if (bl) {
                        n2 += 2;
                    }
                    bl3 = true;
                }
                if (n2 > 0) {
                    --n2;
                    continue;
                }
                switch (loadMode) {
                    case Version: {
                        loadMode = LoadMode.ModelName;
                        break;
                    }
                    case ModelName: {
                        loadMode = LoadMode.VertexStrideElementCount;
                        break;
                    }
                    case VertexStrideElementCount: {
                        loadMode = LoadMode.VertexCount;
                        if (bl) {
                            n2 = 7;
                            break;
                        }
                        n2 = 13;
                        break;
                    }
                    case VertexCount: {
                        n3 = Integer.parseInt(string3);
                        loadMode = LoadMode.VertexBuffer;
                        modelTxt.vertices = new VertexBufferObject.VertexArray(vertexFormat, n3);
                        break;
                    }
                    case VertexBuffer: {
                        float f;
                        for (int i = 0; i < n3; ++i) {
                            String[] stringArray = string3.split(",");
                            float f2 = Float.parseFloat(stringArray[0].trim());
                            float f3 = Float.parseFloat(stringArray[1].trim());
                            float f4 = Float.parseFloat(stringArray[2].trim());
                            string3 = bufferedReader.readLine();
                            stringArray = string3.split(",");
                            float f5 = Float.parseFloat(stringArray[0].trim());
                            float f6 = Float.parseFloat(stringArray[1].trim());
                            float f7 = Float.parseFloat(stringArray[2].trim());
                            f = 0.0f;
                            float f8 = 0.0f;
                            float f9 = 0.0f;
                            if (bl3) {
                                string3 = bufferedReader.readLine();
                                stringArray = string3.split(",");
                                f = Float.parseFloat(stringArray[0].trim());
                                f8 = Float.parseFloat(stringArray[1].trim());
                                f9 = Float.parseFloat(stringArray[2].trim());
                            }
                            string3 = bufferedReader.readLine();
                            stringArray = string3.split(",");
                            float f10 = Float.parseFloat(stringArray[0].trim());
                            float f11 = Float.parseFloat(stringArray[1].trim());
                            float f12 = 0.0f;
                            float f13 = 0.0f;
                            float f14 = 0.0f;
                            float f15 = 0.0f;
                            int n7 = 0;
                            int n8 = 0;
                            int n9 = 0;
                            int n10 = 0;
                            if (!bl) {
                                string3 = bufferedReader.readLine();
                                stringArray = string3.split(",");
                                f12 = Float.parseFloat(stringArray[0].trim());
                                f13 = Float.parseFloat(stringArray[1].trim());
                                f14 = Float.parseFloat(stringArray[2].trim());
                                f15 = Float.parseFloat(stringArray[3].trim());
                                string3 = bufferedReader.readLine();
                                stringArray = string3.split(",");
                                n7 = Integer.parseInt(stringArray[0].trim());
                                n8 = Integer.parseInt(stringArray[1].trim());
                                n9 = Integer.parseInt(stringArray[2].trim());
                                n10 = Integer.parseInt(stringArray[3].trim());
                            }
                            string3 = bufferedReader.readLine();
                            modelTxt.vertices.setElement(i, 0, f2, f3, f4);
                            modelTxt.vertices.setElement(i, 1, f5, f6, f7);
                            modelTxt.vertices.setElement(i, 2, f, f8, f9);
                            modelTxt.vertices.setElement(i, 3, f10, f11);
                            if (bl) continue;
                            modelTxt.vertices.setElement(i, 4, f12, f13, f14, f15);
                            modelTxt.vertices.setElement(i, 5, n7, n8, n9, n10);
                        }
                        loadMode = LoadMode.NumberOfFaces;
                        break;
                    }
                    case NumberOfFaces: {
                        n4 = Integer.parseInt(string3);
                        modelTxt.elements = new int[n4 * 3];
                        loadMode = LoadMode.FaceData;
                        break;
                    }
                    case FaceData: {
                        for (int i = 0; i < n4; ++i) {
                            String[] stringArray = string3.split(",");
                            int n11 = Integer.parseInt(stringArray[0].trim());
                            int n12 = Integer.parseInt(stringArray[1].trim());
                            int n13 = Integer.parseInt(stringArray[2].trim());
                            if (bl2) {
                                modelTxt.elements[i * 3 + 2] = n11;
                                modelTxt.elements[i * 3 + 1] = n12;
                                modelTxt.elements[i * 3 + 0] = n13;
                            } else {
                                modelTxt.elements[i * 3 + 0] = n11;
                                modelTxt.elements[i * 3 + 1] = n12;
                                modelTxt.elements[i * 3 + 2] = n13;
                            }
                            string3 = bufferedReader.readLine();
                        }
                        loadMode = LoadMode.NumberOfBones;
                        break;
                    }
                    case NumberOfBones: {
                        n6 = Integer.parseInt(string3);
                        loadMode = LoadMode.SkeletonHierarchy;
                        break;
                    }
                    case SkeletonHierarchy: {
                        for (int i = 0; i < n6; ++i) {
                            int n14 = Integer.parseInt(string3);
                            string3 = bufferedReader.readLine();
                            int n15 = Integer.parseInt(string3);
                            string3 = bufferedReader.readLine();
                            String string4 = sharedStrings.get(string3);
                            string3 = bufferedReader.readLine();
                            modelTxt.SkeletonHierarchy.add(n15);
                            modelTxt.boneIndices.put(string4, n14);
                        }
                        loadMode = LoadMode.BindPose;
                        break;
                    }
                    case BindPose: {
                        for (int i = 0; i < n6; ++i) {
                            string3 = bufferedReader.readLine();
                            String string5 = bufferedReader.readLine();
                            String string6 = bufferedReader.readLine();
                            String string7 = bufferedReader.readLine();
                            modelTxt.bindPose.add(i, this.getMatrix(string3, string5, string6, string7));
                            string3 = bufferedReader.readLine();
                        }
                        loadMode = LoadMode.InvBindPose;
                        break;
                    }
                    case InvBindPose: {
                        for (int i = 0; i < n6; ++i) {
                            string3 = bufferedReader.readLine();
                            String string8 = bufferedReader.readLine();
                            String string9 = bufferedReader.readLine();
                            String string10 = bufferedReader.readLine();
                            modelTxt.invBindPose.add(i, this.getMatrix(string3, string8, string9, string10));
                            string3 = bufferedReader.readLine();
                        }
                        loadMode = LoadMode.SkinOffsetMatrices;
                        break;
                    }
                    case SkinOffsetMatrices: {
                        for (int i = 0; i < n6; ++i) {
                            string3 = bufferedReader.readLine();
                            String string11 = bufferedReader.readLine();
                            String string12 = bufferedReader.readLine();
                            String string13 = bufferedReader.readLine();
                            modelTxt.skinOffsetMatrices.add(i, this.getMatrix(string3, string11, string12, string13));
                            string3 = bufferedReader.readLine();
                        }
                        loadMode = LoadMode.NumberOfAnims;
                        break;
                    }
                    case NumberOfAnims: {
                        n5 = Integer.parseInt(string3);
                        loadMode = LoadMode.Anim;
                        break;
                    }
                    case Anim: {
                        float f;
                        ArrayList<Keyframe> arrayList = new ArrayList<Keyframe>();
                        String string14 = string3;
                        string3 = bufferedReader.readLine();
                        float f16 = Float.parseFloat(string3);
                        string3 = bufferedReader.readLine();
                        int n16 = Integer.parseInt(string3);
                        string3 = bufferedReader.readLine();
                        for (int i = 0; i < n16; ++i) {
                            Keyframe keyframe = new Keyframe();
                            int n17 = Integer.parseInt(string3);
                            string3 = bufferedReader.readLine();
                            String string15 = sharedStrings.get(string3);
                            string3 = bufferedReader.readLine();
                            f = Float.parseFloat(string3);
                            string3 = bufferedReader.readLine();
                            String string16 = bufferedReader.readLine();
                            Vector3f vector3f = this.getVector(string3);
                            Quaternion quaternion = this.getQuaternion(string16);
                            if (i < n16 - 1) {
                                string3 = bufferedReader.readLine();
                            }
                            keyframe.Bone = n17;
                            keyframe.BoneName = string15;
                            keyframe.Time = f;
                            keyframe.Rotation = quaternion;
                            keyframe.Position = new Vector3f((ReadableVector3f)vector3f);
                            arrayList.add(keyframe);
                        }
                        AnimationClip animationClip = new AnimationClip(f16, arrayList, string14, false);
                        arrayList.clear();
                        if (ModelManager.instance.bCreateSoftwareMeshes) {
                            animationClip.staticClip = new StaticAnimation(animationClip);
                        }
                        modelTxt.clips.put(string14, animationClip);
                    }
                }
            }
            if (!bl && skinningData != null) {
                try {
                    int[] nArray = new int[modelTxt.boneIndices.size()];
                    ArrayList<Integer> arrayList = modelTxt.SkeletonHierarchy;
                    HashMap<String, Integer> hashMap = modelTxt.boneIndices;
                    HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>(skinningData.BoneIndices);
                    ArrayList<Integer> arrayList2 = new ArrayList<Integer>(skinningData.SkeletonHierarchy);
                    hashMap.forEach((string, n) -> {
                        int n2 = hashMap2.getOrDefault(string, -1);
                        if (n2 == -1) {
                            n2 = hashMap2.size();
                            hashMap2.put((String)string, n2);
                            int n3 = (Integer)arrayList.get((int)n);
                            if (n3 >= 0) {
                                arrayList2.add(nArray[n3]);
                            } else {
                                n3 = -2;
                            }
                        }
                        nArray[n.intValue()] = n2;
                    });
                    modelTxt.boneIndices = hashMap2;
                    modelTxt.SkeletonHierarchy = arrayList2;
                    for (int i = 0; i < modelTxt.vertices.m_numVertices; ++i) {
                        int n18 = (int)modelTxt.vertices.getElementFloat(i, 5, 0);
                        int n19 = (int)modelTxt.vertices.getElementFloat(i, 5, 1);
                        int n20 = (int)modelTxt.vertices.getElementFloat(i, 5, 2);
                        int n21 = (int)modelTxt.vertices.getElementFloat(i, 5, 3);
                        if (n18 >= 0) {
                            n18 = nArray[n18];
                        }
                        if (n19 >= 0) {
                            n19 = nArray[n19];
                        }
                        if (n20 >= 0) {
                            n20 = nArray[n20];
                        }
                        if (n21 >= 0) {
                            n21 = nArray[n21];
                        }
                        modelTxt.vertices.setElement(i, 5, n18, n19, n20, n21);
                    }
                    for (AnimationClip animationClip : modelTxt.clips.values()) {
                        for (Keyframe keyframe : animationClip.getKeyframes()) {
                            keyframe.Bone = nArray[keyframe.Bone];
                        }
                    }
                    modelTxt.skinOffsetMatrices = this.RemapMatrices(nArray, modelTxt.skinOffsetMatrices, modelTxt.boneIndices.size());
                    modelTxt.bindPose = this.RemapMatrices(nArray, modelTxt.bindPose, modelTxt.boneIndices.size());
                    modelTxt.invBindPose = this.RemapMatrices(nArray, modelTxt.invBindPose, modelTxt.boneIndices.size());
                }
                catch (Exception exception) {
                    exception.toString();
                }
            }
        }
        return modelTxt;
    }

    protected void applyToMesh(ModelTxt modelTxt, ModelMesh modelMesh, SkinningData skinningData) {
        if (modelTxt.bStatic) {
            if (!ModelManager.NoOpenGL) {
                modelMesh.m_bHasVBO = true;
                RenderThread.queueInvokeOnRenderContext(() -> {
                    modelMesh.SetVertexBuffer(new VertexBufferObject(modelTxt.vertices, modelTxt.elements));
                    if (ModelManager.instance.bCreateSoftwareMeshes) {
                        modelMesh.softwareMesh.vb = modelMesh.vb;
                    }
                });
            }
        } else {
            modelMesh.skinningData = new SkinningData(modelTxt.clips, modelTxt.bindPose, modelTxt.invBindPose, modelTxt.skinOffsetMatrices, modelTxt.SkeletonHierarchy, modelTxt.boneIndices);
            if (!ModelManager.NoOpenGL) {
                modelMesh.m_bHasVBO = true;
                RenderThread.queueInvokeOnRenderContext(() -> {
                    modelMesh.SetVertexBuffer(new VertexBufferObject(modelTxt.vertices, modelTxt.elements, modelTxt.bReverse));
                    if (ModelManager.instance.bCreateSoftwareMeshes) {
                        // empty if block
                    }
                });
            }
        }
        if (skinningData != null) {
            modelMesh.skinningData.AnimationClips = skinningData.AnimationClips;
        }
    }

    protected void applyToAnimation(ModelTxt modelTxt, AnimationAsset animationAsset) {
        animationAsset.AnimationClips = modelTxt.clips;
        animationAsset.assetParams.animationsMesh.skinningData.AnimationClips.putAll(modelTxt.clips);
    }

    private ArrayList<Matrix4f> RemapMatrices(int[] nArray, ArrayList<Matrix4f> arrayList, int n) {
        int n2;
        ArrayList<Matrix4f> arrayList2 = new ArrayList<Matrix4f>(n);
        Matrix4f matrix4f = new Matrix4f();
        for (n2 = 0; n2 < n; ++n2) {
            arrayList2.add(matrix4f);
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            arrayList2.set(nArray[n2], arrayList.get(n2));
        }
        return arrayList2;
    }

    private Vector3f getVector(String string) {
        Vector3f vector3f = new Vector3f();
        String[] stringArray = string.split(",");
        vector3f.x = Float.parseFloat(stringArray[0]);
        vector3f.y = Float.parseFloat(stringArray[1]);
        vector3f.z = Float.parseFloat(stringArray[2]);
        return vector3f;
    }

    private Quaternion getQuaternion(String string) {
        Quaternion quaternion = new Quaternion();
        String[] stringArray = string.split(",");
        quaternion.x = Float.parseFloat(stringArray[0]);
        quaternion.y = Float.parseFloat(stringArray[1]);
        quaternion.z = Float.parseFloat(stringArray[2]);
        quaternion.w = Float.parseFloat(stringArray[3]);
        return quaternion;
    }

    private Matrix4f getMatrix(String string, String string2, String string3, String string4) {
        Matrix4f matrix4f = new Matrix4f();
        boolean bl = false;
        String[] stringArray = string.split(",");
        matrix4f.m00 = Float.parseFloat(stringArray[0]);
        matrix4f.m01 = Float.parseFloat(stringArray[1]);
        matrix4f.m02 = Float.parseFloat(stringArray[2]);
        matrix4f.m03 = Float.parseFloat(stringArray[3]);
        stringArray = string2.split(",");
        matrix4f.m10 = Float.parseFloat(stringArray[0]);
        matrix4f.m11 = Float.parseFloat(stringArray[1]);
        matrix4f.m12 = Float.parseFloat(stringArray[2]);
        matrix4f.m13 = Float.parseFloat(stringArray[3]);
        stringArray = string3.split(",");
        matrix4f.m20 = Float.parseFloat(stringArray[0]);
        matrix4f.m21 = Float.parseFloat(stringArray[1]);
        matrix4f.m22 = Float.parseFloat(stringArray[2]);
        matrix4f.m23 = Float.parseFloat(stringArray[3]);
        stringArray = string4.split(",");
        matrix4f.m30 = Float.parseFloat(stringArray[0]);
        matrix4f.m31 = Float.parseFloat(stringArray[1]);
        matrix4f.m32 = Float.parseFloat(stringArray[2]);
        matrix4f.m33 = Float.parseFloat(stringArray[3]);
        return matrix4f;
    }

    public static enum LoadMode {
        Version,
        ModelName,
        VertexStrideElementCount,
        VertexStrideSize,
        VertexStrideData,
        VertexCount,
        VertexBuffer,
        NumberOfFaces,
        FaceData,
        NumberOfBones,
        SkeletonHierarchy,
        BindPose,
        InvBindPose,
        SkinOffsetMatrices,
        NumberOfAnims,
        Anim;

    }
}

