/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Vector3fc;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector3f;
import zombie.GameTime;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.opengl.RenderThread;
import zombie.core.skinnedmodel.animation.AnimationPlayer;
import zombie.core.skinnedmodel.model.Model;
import zombie.core.skinnedmodel.model.ModelInstanceTextureInitializer;
import zombie.core.skinnedmodel.model.SkinningData;
import zombie.core.skinnedmodel.model.SoftwareModelMeshInstance;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.SmartTexture;
import zombie.core.textures.Texture;
import zombie.debug.DebugLog;
import zombie.iso.IsoCamera;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.Vector2;
import zombie.iso.weather.ClimateManager;
import zombie.network.GameClient;
import zombie.popman.ObjectPool;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.ModelAttachment;
import zombie.scripting.objects.ModelScript;
import zombie.util.StringUtils;

public class ModelInstance {
    public static float MODEL_LIGHT_MULT_OUTSIDE = 1.7f;
    public static float MODEL_LIGHT_MULT_ROOM = 1.7f;
    public Model model;
    public AnimationPlayer AnimPlayer;
    public SkinningData data;
    public Texture tex;
    public ModelInstanceTextureInitializer m_textureInitializer;
    public IsoGameCharacter character;
    public IsoMovingObject object;
    public float tintR = 1.0f;
    public float tintG = 1.0f;
    public float tintB = 1.0f;
    public ModelInstance parent;
    public int parentBone;
    public String parentBoneName = null;
    public float hue;
    public float depthBias;
    public ModelInstance matrixModel;
    public SoftwareModelMeshInstance softwareMesh;
    public final ArrayList<ModelInstance> sub = new ArrayList();
    private int instanceSkip;
    private ItemVisual itemVisual = null;
    public boolean bResetAfterRender = false;
    private Object m_owner = null;
    public int renderRefCount;
    private static final int INITIAL_SKIP_VALUE = Integer.MAX_VALUE;
    private int skipped = Integer.MAX_VALUE;
    public final Object m_lock = "ModelInstance Thread Lock";
    public ModelScript m_modelScript = null;
    public String attachmentNameSelf = null;
    public String attachmentNameParent = null;
    public float scale = 1.0f;
    public String maskVariableValue = null;
    public PlayerData[] playerData;
    private static final ColorInfo tempColorInfo = new ColorInfo();
    private static final ColorInfo tempColorInfo2 = new ColorInfo();

    public ModelInstance init(Model model, IsoGameCharacter isoGameCharacter, AnimationPlayer animationPlayer) {
        this.data = (SkinningData)model.Tag;
        this.model = model;
        this.tex = model.tex;
        if (!model.bStatic && animationPlayer == null) {
            animationPlayer = AnimationPlayer.alloc(model);
        }
        this.AnimPlayer = animationPlayer;
        this.character = isoGameCharacter;
        this.object = isoGameCharacter;
        return this;
    }

    public boolean isRendering() {
        return this.renderRefCount > 0;
    }

    public void reset() {
        if (this.tex instanceof SmartTexture) {
            Texture texture = this.tex;
            RenderThread.queueInvokeOnRenderContext(texture::destroy);
        }
        this.AnimPlayer = null;
        this.character = null;
        this.data = null;
        this.hue = 0.0f;
        this.itemVisual = null;
        this.matrixModel = null;
        this.model = null;
        this.object = null;
        this.parent = null;
        this.parentBone = 0;
        this.parentBoneName = null;
        this.skipped = Integer.MAX_VALUE;
        this.sub.clear();
        this.softwareMesh = null;
        this.tex = null;
        if (this.m_textureInitializer != null) {
            this.m_textureInitializer.release();
            this.m_textureInitializer = null;
        }
        this.tintR = 1.0f;
        this.tintG = 1.0f;
        this.tintB = 1.0f;
        this.bResetAfterRender = false;
        this.renderRefCount = 0;
        this.scale = 1.0f;
        this.m_owner = null;
        this.m_modelScript = null;
        this.attachmentNameSelf = null;
        this.attachmentNameParent = null;
        this.maskVariableValue = null;
        if (this.playerData != null) {
            PlayerData.pool.release((PlayerData[])this.playerData);
            Arrays.fill(this.playerData, null);
        }
    }

    public void LoadTexture(String string) {
        if (string == null || string.length() == 0) {
            this.tex = null;
            return;
        }
        this.tex = Texture.getSharedTexture("media/textures/" + string + ".png");
        if (this.tex == null) {
            if (string.equals("Vest_White")) {
                this.tex = Texture.getSharedTexture("media/textures/Shirt_White.png");
            } else if (string.contains("Hair")) {
                this.tex = Texture.getSharedTexture("media/textures/F_Hair_White.png");
            } else if (string.contains("Beard")) {
                this.tex = Texture.getSharedTexture("media/textures/F_Hair_White.png");
            } else {
                DebugLog.log("ERROR: model texture \"" + string + "\" wasn't found");
            }
        }
    }

    public void dismember(int n) {
        this.AnimPlayer.dismember(n);
    }

    public void UpdateDir() {
        if (this.AnimPlayer == null) {
            return;
        }
        this.AnimPlayer.UpdateDir(this.character);
    }

    public void Update() {
        float f;
        if (this.character != null) {
            f = this.character.DistTo(IsoPlayer.getInstance());
            if (!this.character.amputations.isEmpty() && f > 0.0f && this.AnimPlayer != null) {
                this.AnimPlayer.dismembered.clear();
                ArrayList<String> arrayList = this.character.amputations;
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = arrayList.get(i);
                    this.AnimPlayer.dismember(this.AnimPlayer.getSkinningData().BoneIndices.get(string));
                }
            }
            if (Math.abs((float)(this.character.speedMod - 0.5957f)) < 1.0E-4f) {
                boolean bl = false;
            }
        }
        this.instanceSkip = 0;
        if (this.AnimPlayer != null) {
            if (this.matrixModel == null) {
                if (this.skipped >= this.instanceSkip) {
                    if (this.skipped == Integer.MAX_VALUE) {
                        this.skipped = 1;
                    }
                    f = GameTime.instance.getTimeDelta() * (float)this.skipped;
                    this.AnimPlayer.Update(f);
                } else {
                    this.AnimPlayer.DoAngles();
                }
                this.AnimPlayer.parentPlayer = null;
            } else {
                this.AnimPlayer.parentPlayer = this.matrixModel.AnimPlayer;
            }
        }
        if (this.skipped >= this.instanceSkip) {
            this.skipped = 0;
        }
        ++this.skipped;
    }

    public void SetForceDir(Vector2 vector22) {
        if (this.AnimPlayer != null) {
            this.AnimPlayer.SetForceDir(vector22);
        }
    }

    public void setInstanceSkip(int n) {
        this.instanceSkip = n;
        for (int i = 0; i < this.sub.size(); ++i) {
            ModelInstance modelInstance = this.sub.get(i);
            modelInstance.instanceSkip = n;
        }
    }

    public void destroySmartTextures() {
        if (this.tex instanceof SmartTexture) {
            this.tex.destroy();
            this.tex = null;
        }
        for (int i = 0; i < this.sub.size(); ++i) {
            ModelInstance modelInstance = this.sub.get(i);
            modelInstance.destroySmartTextures();
        }
    }

    public void updateLights() {
        boolean bl;
        int n = IsoCamera.frameState.playerIndex;
        if (this.playerData == null) {
            this.playerData = new PlayerData[4];
        }
        boolean bl2 = bl = this.playerData[n] == null;
        if (this.playerData[n] == null) {
            this.playerData[n] = PlayerData.pool.alloc();
        }
        this.playerData[n].updateLights(this.character, bl);
    }

    public ItemVisual getItemVisual() {
        return this.itemVisual;
    }

    public void setItemVisual(ItemVisual itemVisual) {
        this.itemVisual = itemVisual;
    }

    public void applyModelScriptScale(String string) {
        this.m_modelScript = ScriptManager.instance.getModelScript(string);
        if (this.m_modelScript != null) {
            this.scale = this.m_modelScript.scale;
        }
    }

    public ModelAttachment getAttachment(int n) {
        return this.m_modelScript == null ? null : this.m_modelScript.getAttachment(n);
    }

    public ModelAttachment getAttachmentById(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return null;
        }
        return this.m_modelScript == null ? null : this.m_modelScript.getAttachmentById(string);
    }

    public Matrix4f getAttachmentMatrix(ModelAttachment modelAttachment, Matrix4f matrix4f) {
        matrix4f.translation((Vector3fc)modelAttachment.getOffset());
        org.joml.Vector3f vector3f = modelAttachment.getRotate();
        matrix4f.rotateXYZ(vector3f.x * ((float)java.lang.Math.PI / 180), vector3f.y * ((float)java.lang.Math.PI / 180), vector3f.z * ((float)java.lang.Math.PI / 180));
        return matrix4f;
    }

    public Matrix4f getAttachmentMatrix(int n, Matrix4f matrix4f) {
        ModelAttachment modelAttachment = this.getAttachment(n);
        if (modelAttachment == null) {
            return matrix4f.identity();
        }
        return this.getAttachmentMatrix(modelAttachment, matrix4f);
    }

    public Matrix4f getAttachmentMatrixById(String string, Matrix4f matrix4f) {
        ModelAttachment modelAttachment = this.getAttachmentById(string);
        if (modelAttachment == null) {
            return matrix4f.identity();
        }
        return this.getAttachmentMatrix(modelAttachment, matrix4f);
    }

    public void setOwner(Object object) {
        Objects.requireNonNull(object);
        assert (this.m_owner == null);
        this.m_owner = object;
    }

    public void clearOwner(Object object) {
        Objects.requireNonNull(object);
        assert (this.m_owner == object);
        this.m_owner = null;
    }

    public Object getOwner() {
        return this.m_owner;
    }

    public void setTextureInitializer(ModelInstanceTextureInitializer modelInstanceTextureInitializer) {
        this.m_textureInitializer = modelInstanceTextureInitializer;
    }

    public ModelInstanceTextureInitializer getTextureInitializer() {
        return this.m_textureInitializer;
    }

    public boolean hasTextureCreator() {
        return this.m_textureInitializer != null && this.m_textureInitializer.isDirty();
    }

    public static final class PlayerData {
        FrameLightInfo[] frameLights;
        ArrayList<IsoGridSquare.ResultLight> chosenLights;
        org.joml.Vector3f targetAmbient;
        org.joml.Vector3f currentAmbient;
        EffectLight[] effectLightsMain;
        private static final ObjectPool<PlayerData> pool = new ObjectPool<PlayerData>(PlayerData::new);

        private void registerFrameLight(IsoGridSquare.ResultLight resultLight) {
            this.chosenLights.add(resultLight);
        }

        private void initFrameLightsForFrame() {
            if (this.frameLights == null) {
                this.effectLightsMain = new EffectLight[5];
                for (int i = 0; i < 5; ++i) {
                    this.effectLightsMain[i] = new EffectLight();
                }
                this.frameLights = new FrameLightInfo[5];
                this.chosenLights = new ArrayList();
                this.targetAmbient = new org.joml.Vector3f();
                this.currentAmbient = new org.joml.Vector3f();
            }
            for (EffectLight effectLight : this.effectLightsMain) {
                effectLight.radius = -1;
            }
            this.chosenLights.clear();
        }

        private void completeFrameLightsForFrame() {
            int n;
            for (n = 0; n < 5; ++n) {
                if (this.frameLights[n] == null) continue;
                this.frameLights[n].foundThisFrame = false;
            }
            block1: for (n = 0; n < this.chosenLights.size(); ++n) {
                int n2;
                IsoGridSquare.ResultLight resultLight = this.chosenLights.get(n);
                boolean bl = false;
                int n3 = 0;
                for (n2 = 0; n2 < 5; ++n2) {
                    if (this.frameLights[n2] == null || !this.frameLights[n2].active || (resultLight.id != -1 ? resultLight.id != this.frameLights[n2].id : this.frameLights[n2].x != resultLight.x || this.frameLights[n2].y != resultLight.y || this.frameLights[n2].z != resultLight.z)) continue;
                    bl = true;
                    n3 = n2;
                    break;
                }
                if (bl) {
                    this.frameLights[n3].foundThisFrame = true;
                    this.frameLights[n3].x = resultLight.x;
                    this.frameLights[n3].y = resultLight.y;
                    this.frameLights[n3].z = resultLight.z;
                    this.frameLights[n3].flags = resultLight.flags;
                    this.frameLights[n3].radius = resultLight.radius;
                    this.frameLights[n3].targetColor.x = resultLight.r;
                    this.frameLights[n3].targetColor.y = resultLight.g;
                    this.frameLights[n3].targetColor.z = resultLight.b;
                    this.frameLights[n3].Stage = FrameLightBlendStatus.In;
                    continue;
                }
                for (n2 = 0; n2 < 5; ++n2) {
                    if (this.frameLights[n2] != null && this.frameLights[n2].active) continue;
                    if (this.frameLights[n2] == null) {
                        this.frameLights[n2] = new FrameLightInfo();
                    }
                    this.frameLights[n2].x = resultLight.x;
                    this.frameLights[n2].y = resultLight.y;
                    this.frameLights[n2].z = resultLight.z;
                    this.frameLights[n2].r = resultLight.r;
                    this.frameLights[n2].g = resultLight.g;
                    this.frameLights[n2].b = resultLight.b;
                    this.frameLights[n2].flags = resultLight.flags;
                    this.frameLights[n2].radius = resultLight.radius;
                    this.frameLights[n2].id = resultLight.id;
                    this.frameLights[n2].currentColor.x = 0.0f;
                    this.frameLights[n2].currentColor.y = 0.0f;
                    this.frameLights[n2].currentColor.z = 0.0f;
                    this.frameLights[n2].targetColor.x = resultLight.r;
                    this.frameLights[n2].targetColor.y = resultLight.g;
                    this.frameLights[n2].targetColor.z = resultLight.b;
                    this.frameLights[n2].Stage = FrameLightBlendStatus.In;
                    this.frameLights[n2].active = true;
                    this.frameLights[n2].foundThisFrame = true;
                    continue block1;
                }
            }
            float f = GameTime.getInstance().getMultiplier();
            for (int i = 0; i < 5; ++i) {
                FrameLightInfo frameLightInfo = this.frameLights[i];
                if (frameLightInfo == null || !frameLightInfo.active) continue;
                if (!frameLightInfo.foundThisFrame) {
                    frameLightInfo.targetColor.x = 0.0f;
                    frameLightInfo.targetColor.y = 0.0f;
                    frameLightInfo.targetColor.z = 0.0f;
                    frameLightInfo.Stage = FrameLightBlendStatus.Out;
                }
                frameLightInfo.currentColor.x = this.step(frameLightInfo.currentColor.x, frameLightInfo.targetColor.x, java.lang.Math.signum(frameLightInfo.targetColor.x - frameLightInfo.currentColor.x) / (60.0f * f));
                frameLightInfo.currentColor.y = this.step(frameLightInfo.currentColor.y, frameLightInfo.targetColor.y, java.lang.Math.signum(frameLightInfo.targetColor.y - frameLightInfo.currentColor.y) / (60.0f * f));
                frameLightInfo.currentColor.z = this.step(frameLightInfo.currentColor.z, frameLightInfo.targetColor.z, java.lang.Math.signum(frameLightInfo.targetColor.z - frameLightInfo.currentColor.z) / (60.0f * f));
                if (frameLightInfo.Stage != FrameLightBlendStatus.Out || !(frameLightInfo.currentColor.x < 0.01f) || !(frameLightInfo.currentColor.y < 0.01f) || !(frameLightInfo.currentColor.z < 0.01f)) continue;
                frameLightInfo.active = false;
            }
        }

        private void sortLights(IsoGameCharacter isoGameCharacter) {
            for (int i = 0; i < this.frameLights.length; ++i) {
                FrameLightInfo frameLightInfo3 = this.frameLights[i];
                if (frameLightInfo3 == null) continue;
                frameLightInfo3.distSq = !frameLightInfo3.active ? Float.MAX_VALUE : IsoUtils.DistanceToSquared(isoGameCharacter.x, isoGameCharacter.y, isoGameCharacter.z, (float)frameLightInfo3.x + 0.5f, (float)frameLightInfo3.y + 0.5f, frameLightInfo3.z);
            }
            Arrays.sort(this.frameLights, (frameLightInfo, frameLightInfo2) -> {
                boolean bl;
                boolean bl2 = frameLightInfo == null || frameLightInfo.radius == -1 || !frameLightInfo.active;
                boolean bl3 = bl = frameLightInfo2 == null || frameLightInfo2.radius == -1 || !frameLightInfo2.active;
                if (bl2 && bl) {
                    return 0;
                }
                if (bl2) {
                    return 1;
                }
                if (bl) {
                    return -1;
                }
                if (frameLightInfo.Stage.ordinal() < frameLightInfo2.Stage.ordinal()) {
                    return -1;
                }
                if (frameLightInfo.Stage.ordinal() > frameLightInfo2.Stage.ordinal()) {
                    return 1;
                }
                return (int)java.lang.Math.signum(frameLightInfo.distSq - frameLightInfo2.distSq);
            });
        }

        private void updateLights(IsoGameCharacter isoGameCharacter, boolean bl) {
            IsoGridSquare isoGridSquare;
            Object object;
            int n;
            this.initFrameLightsForFrame();
            if (isoGameCharacter == null) {
                return;
            }
            if (isoGameCharacter.getCurrentSquare() == null) {
                return;
            }
            IsoGridSquare.ILighting iLighting = isoGameCharacter.getCurrentSquare().lighting[IsoCamera.frameState.playerIndex];
            int n2 = Math.min((int)iLighting.resultLightCount(), (int)4);
            for (n = 0; n < n2; ++n) {
                object = iLighting.getResultLight(n);
                this.registerFrameLight((IsoGridSquare.ResultLight)object);
            }
            if (bl) {
                for (n = 0; n < this.frameLights.length; ++n) {
                    if (this.frameLights[n] == null) continue;
                    this.frameLights[n].active = false;
                }
            }
            this.completeFrameLightsForFrame();
            isoGameCharacter.getCurrentSquare().interpolateLight(tempColorInfo, isoGameCharacter.x % 1.0f, isoGameCharacter.y % 1.0f);
            this.targetAmbient.x = ModelInstance.tempColorInfo.r;
            this.targetAmbient.y = ModelInstance.tempColorInfo.g;
            this.targetAmbient.z = ModelInstance.tempColorInfo.b;
            if (isoGameCharacter.z - (float)((int)isoGameCharacter.z) > 0.2f && (isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare((int)isoGameCharacter.x, (int)isoGameCharacter.y, (int)isoGameCharacter.z + 1)) != null) {
                object = tempColorInfo2;
                isoGridSquare.lighting[IsoCamera.frameState.playerIndex].lightInfo();
                isoGridSquare.interpolateLight((ColorInfo)object, isoGameCharacter.x % 1.0f, isoGameCharacter.y % 1.0f);
                tempColorInfo.interp((ColorInfo)object, (isoGameCharacter.z - ((float)((int)isoGameCharacter.z) + 0.2f)) / 0.8f, tempColorInfo);
                this.targetAmbient.set(ModelInstance.tempColorInfo.r, ModelInstance.tempColorInfo.g, ModelInstance.tempColorInfo.b);
            }
            float f = GameTime.getInstance().getMultiplier();
            this.currentAmbient.x = this.step(this.currentAmbient.x, this.targetAmbient.x, (this.targetAmbient.x - this.currentAmbient.x) / (10.0f * f));
            this.currentAmbient.y = this.step(this.currentAmbient.y, this.targetAmbient.y, (this.targetAmbient.y - this.currentAmbient.y) / (10.0f * f));
            this.currentAmbient.z = this.step(this.currentAmbient.z, this.targetAmbient.z, (this.targetAmbient.z - this.currentAmbient.z) / (10.0f * f));
            if (bl) {
                this.setCurrentToTarget();
            }
            this.sortLights(isoGameCharacter);
            float f2 = 0.7f;
            for (int i = 0; i < 5; ++i) {
                FrameLightInfo frameLightInfo = this.frameLights[i];
                if (frameLightInfo == null || !frameLightInfo.active) continue;
                EffectLight effectLight = this.effectLightsMain[i];
                if ((frameLightInfo.flags & 1) != 0) {
                    effectLight.set(isoGameCharacter.x, isoGameCharacter.y, (int)isoGameCharacter.z + 1, frameLightInfo.currentColor.x * f2, frameLightInfo.currentColor.y * f2, frameLightInfo.currentColor.z * f2, frameLightInfo.radius);
                    continue;
                }
                if ((frameLightInfo.flags & 2) != 0) {
                    if (isoGameCharacter instanceof IsoPlayer) {
                        int n3 = GameClient.bClient ? ((IsoPlayer)isoGameCharacter).OnlineID + 1 : ((IsoPlayer)isoGameCharacter).PlayerIndex + 1;
                        int n4 = ((IsoPlayer)isoGameCharacter).PlayerIndex;
                        int n5 = n4 * 4 + 1;
                        int n6 = n4 * 4 + 3 + 1;
                        if (frameLightInfo.id >= n5 && frameLightInfo.id <= n6) continue;
                        effectLight.set(frameLightInfo.x, frameLightInfo.y, frameLightInfo.z, frameLightInfo.currentColor.x, frameLightInfo.currentColor.y, frameLightInfo.currentColor.z, frameLightInfo.radius);
                        continue;
                    }
                    effectLight.set(frameLightInfo.x, frameLightInfo.y, frameLightInfo.z, frameLightInfo.currentColor.x * 2.0f, frameLightInfo.currentColor.y, frameLightInfo.currentColor.z, frameLightInfo.radius);
                    continue;
                }
                effectLight.set((float)frameLightInfo.x + 0.5f, (float)frameLightInfo.y + 0.5f, (float)frameLightInfo.z + 0.5f, frameLightInfo.currentColor.x * f2, frameLightInfo.currentColor.y * f2, frameLightInfo.currentColor.z * f2, frameLightInfo.radius);
            }
            if (n2 <= 3 && isoGameCharacter instanceof IsoPlayer && isoGameCharacter.getTorchStrength() > 0.0f) {
                this.effectLightsMain[2].set(isoGameCharacter.x + isoGameCharacter.getForwardDirection().x * 0.5f, isoGameCharacter.y + isoGameCharacter.getForwardDirection().y * 0.5f, isoGameCharacter.z + 0.25f, 1.0f, 1.0f, 1.0f, 2);
            }
            float f3 = 0.0f;
            float f4 = 1.0f;
            float f5 = this.lerp(f3, f4, this.currentAmbient.x);
            float f6 = this.lerp(f3, f4, this.currentAmbient.y);
            float f7 = this.lerp(f3, f4, this.currentAmbient.z);
            if (isoGameCharacter.getCurrentSquare().isOutside()) {
                this.effectLightsMain[3].set(isoGameCharacter.x - 2.0f, isoGameCharacter.y - 2.0f, isoGameCharacter.z + 1.0f, (f5 *= MODEL_LIGHT_MULT_OUTSIDE) / 4.0f, (f6 *= MODEL_LIGHT_MULT_OUTSIDE) / 4.0f, (f7 *= MODEL_LIGHT_MULT_OUTSIDE) / 4.0f, 5000);
                this.effectLightsMain[4].set(isoGameCharacter.x + 2.0f, isoGameCharacter.y + 2.0f, isoGameCharacter.z + 1.0f, f5 / 4.0f, f6 / 4.0f, f7 / 4.0f, 5000);
            } else if (isoGameCharacter.getCurrentSquare().getRoom() != null) {
                this.effectLightsMain[3].set(isoGameCharacter.x - 2.0f, isoGameCharacter.y - 2.0f, isoGameCharacter.z + 1.0f, (f5 *= MODEL_LIGHT_MULT_ROOM) / 4.0f, (f6 *= MODEL_LIGHT_MULT_ROOM) / 4.0f, (f7 *= MODEL_LIGHT_MULT_ROOM) / 4.0f, 5000);
                this.effectLightsMain[4].set(isoGameCharacter.x + 2.0f, isoGameCharacter.y + 2.0f, isoGameCharacter.z + 1.0f, f5 / 4.0f, f6 / 4.0f, f7 / 4.0f, 5000);
            }
        }

        private float lerp(float f, float f2, float f3) {
            return f + (f2 - f) * f3;
        }

        private void setCurrentToTarget() {
            for (int i = 0; i < this.frameLights.length; ++i) {
                FrameLightInfo frameLightInfo = this.frameLights[i];
                if (frameLightInfo == null) continue;
                frameLightInfo.currentColor.set((ReadableVector3f)frameLightInfo.targetColor);
            }
            this.currentAmbient.set((Vector3fc)this.targetAmbient);
        }

        private float step(float f, float f2, float f3) {
            if (f < f2) {
                return ClimateManager.clamp(0.0f, f2, f + f3);
            }
            if (f > f2) {
                return ClimateManager.clamp(f2, 1.0f, f + f3);
            }
            return f;
        }
    }

    public static final class FrameLightInfo {
        public FrameLightBlendStatus Stage;
        public int id;
        public int x;
        public int y;
        public int z;
        public float distSq;
        public int radius;
        public float r;
        public float g;
        public float b;
        public int flags;
        public final Vector3f currentColor = new Vector3f();
        public final Vector3f targetColor = new Vector3f();
        public boolean active;
        public boolean foundThisFrame;
    }

    public static enum FrameLightBlendStatus {
        In,
        During,
        Out;

    }

    public static final class EffectLight {
        public float x;
        public float y;
        public float z;
        public float r;
        public float g;
        public float b;
        public int radius;

        public void set(float f, float f2, float f3, float f4, float f5, float f6, int n) {
            this.x = f;
            this.y = f2;
            this.z = f3;
            this.r = f4;
            this.g = f5;
            this.b = f6;
            this.radius = n;
        }
    }
}

