/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.model;

import java.nio.FloatBuffer;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjglx.BufferUtils;
import zombie.GameProfiler;
import zombie.asset.Asset;
import zombie.asset.AssetManager;
import zombie.asset.AssetPath;
import zombie.asset.AssetType;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.opengl.PZGLUtil;
import zombie.core.opengl.RenderThread;
import zombie.core.particle.MuzzleFlash;
import zombie.core.skinnedmodel.ModelCamera;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.animation.AnimationPlayer;
import zombie.core.skinnedmodel.model.MeshAssetManager;
import zombie.core.skinnedmodel.model.ModelInstance;
import zombie.core.skinnedmodel.model.ModelInstanceRenderData;
import zombie.core.skinnedmodel.model.ModelMesh;
import zombie.core.skinnedmodel.model.ModelSlotRenderData;
import zombie.core.skinnedmodel.model.SoftwareModelMesh;
import zombie.core.skinnedmodel.model.VehicleModelInstance;
import zombie.core.skinnedmodel.model.VehicleSubModelInstance;
import zombie.core.skinnedmodel.shader.Shader;
import zombie.core.skinnedmodel.shader.ShaderManager;
import zombie.core.textures.Texture;
import zombie.debug.DebugOptions;
import zombie.input.GameKeyboard;
import zombie.iso.IsoLightSource;
import zombie.iso.Vector3;
import zombie.iso.sprite.SkyBox;
import zombie.scripting.objects.ModelAttachment;
import zombie.util.Lambda;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;

public final class Model
extends Asset {
    public String Name;
    public final ModelMesh Mesh;
    public Shader Effect;
    public Object Tag;
    public boolean bStatic = false;
    public Texture tex = null;
    public SoftwareModelMesh softwareMesh;
    public static final FloatBuffer m_staticReusableFloatBuffer = BufferUtils.createFloatBuffer((int)128);
    private static final org.joml.Matrix4f IDENTITY = new org.joml.Matrix4f();
    public static final Color[] debugDrawColours = new Color[]{new Color(230, 25, 75), new Color(60, 180, 75), new Color(255, 225, 25), new Color(0, 130, 200), new Color(245, 130, 48), new Color(145, 30, 180), new Color(70, 240, 240), new Color(240, 50, 230), new Color(210, 245, 60), new Color(250, 190, 190), new Color(0, 128, 128), new Color(230, 190, 255), new Color(170, 110, 40), new Color(255, 250, 200), new Color(128, 0, 0), new Color(170, 255, 195), new Color(128, 128, 0), new Color(255, 215, 180), new Color(0, 0, 128), new Color(128, 128, 128), new Color(255, 255, 255), new Color(0, 0, 0)};
    public ModelAssetParams assetParams;
    static Vector3 tempo = new Vector3();
    public static final AssetType ASSET_TYPE = new AssetType("Model");

    public Model(AssetPath assetPath, AssetManager assetManager, ModelAssetParams modelAssetParams) {
        super(assetPath, assetManager);
        this.assetParams = modelAssetParams;
        this.bStatic = this.assetParams != null && this.assetParams.bStatic;
        ModelMesh.MeshAssetParams meshAssetParams = new ModelMesh.MeshAssetParams();
        meshAssetParams.bStatic = this.bStatic;
        meshAssetParams.animationsMesh = this.assetParams == null ? null : this.assetParams.animationsModel;
        this.Mesh = (ModelMesh)MeshAssetManager.instance.load(new AssetPath(modelAssetParams.meshName), meshAssetParams);
        if (!StringUtils.isNullOrWhitespace(modelAssetParams.textureName)) {
            this.tex = modelAssetParams.textureName.contains("media/") ? Texture.getSharedTexture(modelAssetParams.textureName, modelAssetParams.textureFlags) : Texture.getSharedTexture("media/textures/" + modelAssetParams.textureName + ".png", modelAssetParams.textureFlags);
        }
        if (!StringUtils.isNullOrWhitespace(modelAssetParams.shaderName)) {
            this.CreateShader(modelAssetParams.shaderName);
        }
        this.onCreated(this.Mesh.getState());
        this.addDependency(this.Mesh);
        if (this.isReady()) {
            this.Tag = this.Mesh.skinningData;
            this.softwareMesh = this.Mesh.softwareMesh;
            this.assetParams = null;
        }
    }

    public static void VectorToWorldCoords(IsoGameCharacter isoGameCharacter, Vector3 vector3) {
        AnimationPlayer animationPlayer = isoGameCharacter.getAnimationPlayer();
        float f = animationPlayer.getRenderedAngle();
        vector3.x = -vector3.x;
        vector3.rotatey(f);
        float f2 = vector3.y;
        vector3.y = vector3.z;
        vector3.z = f2 * 0.6f;
        vector3.x *= 1.5f;
        vector3.y *= 1.5f;
        vector3.x += isoGameCharacter.x;
        vector3.y += isoGameCharacter.y;
        vector3.z += isoGameCharacter.z;
    }

    public static void BoneToWorldCoords(IsoGameCharacter isoGameCharacter, int n, Vector3 vector3) {
        AnimationPlayer animationPlayer = isoGameCharacter.getAnimationPlayer();
        vector3.x = animationPlayer.modelTransforms[n].m03;
        vector3.y = animationPlayer.modelTransforms[n].m13;
        vector3.z = animationPlayer.modelTransforms[n].m23;
        Model.VectorToWorldCoords(isoGameCharacter, vector3);
    }

    public static void BoneYDirectionToWorldCoords(IsoGameCharacter isoGameCharacter, int n, Vector3 vector3, float f) {
        AnimationPlayer animationPlayer = isoGameCharacter.getAnimationPlayer();
        vector3.x = animationPlayer.modelTransforms[n].m01 * f;
        vector3.y = animationPlayer.modelTransforms[n].m11 * f;
        vector3.z = animationPlayer.modelTransforms[n].m21 * f;
        vector3.x += animationPlayer.modelTransforms[n].m03;
        vector3.y += animationPlayer.modelTransforms[n].m13;
        vector3.z += animationPlayer.modelTransforms[n].m23;
        Model.VectorToWorldCoords(isoGameCharacter, vector3);
    }

    public static void VectorToWorldCoords(ModelSlotRenderData modelSlotRenderData, Vector3 vector3) {
        float f = modelSlotRenderData.animPlayerAngle;
        vector3.x = -vector3.x;
        vector3.rotatey(f);
        float f2 = vector3.y;
        vector3.y = vector3.z;
        vector3.z = f2 * 0.6f;
        vector3.x *= 1.5f;
        vector3.y *= 1.5f;
        vector3.x += modelSlotRenderData.x;
        vector3.y += modelSlotRenderData.y;
        vector3.z += modelSlotRenderData.z;
    }

    public static void BoneToWorldCoords(ModelSlotRenderData modelSlotRenderData, int n, Vector3 vector3) {
        AnimationPlayer animationPlayer = modelSlotRenderData.animPlayer;
        vector3.x = animationPlayer.modelTransforms[n].m03;
        vector3.y = animationPlayer.modelTransforms[n].m13;
        vector3.z = animationPlayer.modelTransforms[n].m23;
        Model.VectorToWorldCoords(modelSlotRenderData, vector3);
    }

    public static void CharacterModelCameraBegin(ModelSlotRenderData modelSlotRenderData) {
        ModelCamera.instance.Begin();
        if (modelSlotRenderData.bInVehicle) {
            GL11.glMatrixMode((int)5888);
            GL11.glTranslatef((float)0.0f, (float)modelSlotRenderData.centerOfMassY, (float)0.0f);
            GL11.glMatrixMode((int)5888);
            GL11.glRotatef((float)modelSlotRenderData.vehicleAngleZ, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)modelSlotRenderData.vehicleAngleY, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)modelSlotRenderData.vehicleAngleX, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            int n = -1;
            GL11.glTranslatef((float)modelSlotRenderData.inVehicleX, (float)modelSlotRenderData.inVehicleY, (float)(modelSlotRenderData.inVehicleZ * (float)n));
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        }
    }

    public static void CharacterModelCameraEnd() {
        ModelCamera.instance.End();
    }

    public void DrawChar(ModelSlotRenderData modelSlotRenderData, ModelInstanceRenderData modelInstanceRenderData) {
        if (DebugOptions.instance.Character.Debug.Render.SkipCharacters.getValue()) {
            return;
        }
        if (modelSlotRenderData.character == IsoPlayer.getInstance()) {
            boolean bl = false;
        }
        if (modelSlotRenderData.alpha < 0.01f) {
            return;
        }
        if (modelSlotRenderData.animPlayer == null) {
            return;
        }
        if (Core.bDebug && GameKeyboard.isKeyDown(199)) {
            this.Effect = null;
        }
        if (this.Effect == null) {
            this.CreateShader("basicEffect");
        }
        Shader shader2 = this.Effect;
        GL11.glEnable((int)2884);
        GL11.glCullFace((int)1028);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glDepthFunc((int)513);
        GL11.glAlphaFunc((int)516, (float)0.01f);
        GL11.glBlendFunc((int)770, (int)771);
        if (Core.bDebug && DebugOptions.instance.ModelRenderWireframe.getValue()) {
            GL11.glPolygonMode((int)1032, (int)6913);
            GL11.glEnable((int)2848);
            GL11.glLineWidth((float)0.75f);
            Shader shader3 = ShaderManager.instance.getOrCreateShader("vehicle_wireframe", this.bStatic);
            if (shader3 != null) {
                shader3.Start();
                if (this.bStatic) {
                    shader3.setTransformMatrix(modelInstanceRenderData.xfrm, true);
                } else {
                    shader3.setMatrixPalette(modelInstanceRenderData.matrixPalette, true);
                }
                this.Mesh.Draw(shader3);
                shader3.End();
            }
            GL11.glPolygonMode((int)1032, (int)6914);
            GL11.glDisable((int)2848);
            return;
        }
        if (shader2 != null) {
            shader2.Start();
            shader2.startCharacter(modelSlotRenderData, modelInstanceRenderData);
        }
        if (!DebugOptions.instance.DebugDraw_SkipDrawNonSkinnedModel.getValue()) {
            GameProfiler.getInstance().invokeAndMeasure("Mesh.Draw.Call", shader2, this.Mesh, (shader, modelMesh) -> modelMesh.Draw((Shader)shader));
        }
        if (shader2 != null) {
            shader2.End();
        }
        this.drawMuzzleFlash(modelInstanceRenderData);
    }

    private void drawMuzzleFlash(ModelInstanceRenderData modelInstanceRenderData) {
        ModelAttachment modelAttachment;
        if (modelInstanceRenderData.m_muzzleFlash && (modelAttachment = modelInstanceRenderData.modelInstance.getAttachmentById("muzzle")) != null) {
            BaseVehicle.Matrix4fObjectPool matrix4fObjectPool = BaseVehicle.TL_matrix4f_pool.get();
            org.joml.Matrix4f matrix4f = ((org.joml.Matrix4f)matrix4fObjectPool.alloc()).set((Matrix4fc)modelInstanceRenderData.xfrm);
            matrix4f.transpose();
            org.joml.Matrix4f matrix4f2 = modelInstanceRenderData.modelInstance.getAttachmentMatrix(modelAttachment, (org.joml.Matrix4f)matrix4fObjectPool.alloc());
            matrix4f.mul((Matrix4fc)matrix4f2, matrix4f2);
            MuzzleFlash.render(matrix4f2);
            matrix4fObjectPool.release(matrix4f);
            matrix4fObjectPool.release(matrix4f2);
        }
    }

    private void drawVehicleLights(ModelSlotRenderData modelSlotRenderData) {
        int n;
        for (n = 7; n >= 0; --n) {
            GL13.glActiveTexture((int)(33984 + n));
            GL11.glDisable((int)3553);
        }
        GL11.glLineWidth((float)1.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glDisable((int)2929);
        for (n = 0; n < 3; ++n) {
            float f;
            ModelInstance.EffectLight effectLight = modelSlotRenderData.effectLights[n];
            if ((float)effectLight.radius <= 0.0f) continue;
            float f2 = effectLight.x;
            float f3 = effectLight.y;
            float f4 = f = effectLight.z;
            f = f3;
            f3 = f4;
            GL11.glBegin((int)1);
            GL11.glVertex3f((float)(f2 *= -54.0f), (float)(f3 *= 54.0f), (float)(f *= 54.0f));
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glEnd();
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
    }

    public static void drawBoneMtx(Matrix4f matrix4f) {
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glBegin((int)1);
        Model.drawBoneMtxInternal(matrix4f);
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2929);
    }

    private static void drawBoneMtxInternal(Matrix4f matrix4f) {
        float f = 0.5f;
        float f2 = 0.15f;
        float f3 = 0.1f;
        float f4 = matrix4f.m03;
        float f5 = matrix4f.m13;
        float f6 = matrix4f.m23;
        float f7 = matrix4f.m00;
        float f8 = matrix4f.m10;
        float f9 = matrix4f.m20;
        float f10 = matrix4f.m01;
        float f11 = matrix4f.m11;
        float f12 = matrix4f.m21;
        float f13 = matrix4f.m02;
        float f14 = matrix4f.m12;
        float f15 = matrix4f.m22;
        Model.drawArrowInternal(f4, f5, f6, f7, f8, f9, f13, f14, f15, f, f2, f3, 1.0f, 0.0f, 0.0f);
        Model.drawArrowInternal(f4, f5, f6, f10, f11, f12, f13, f14, f15, f, f2, f3, 0.0f, 1.0f, 0.0f);
        Model.drawArrowInternal(f4, f5, f6, f13, f14, f15, f7, f8, f9, f, f2, f3, 0.0f, 0.0f, 1.0f);
    }

    private static void drawArrowInternal(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15) {
        float f16 = 1.0f - f11;
        GL11.glColor3f((float)f13, (float)f14, (float)f15);
        GL11.glVertex3f((float)f, (float)f2, (float)f3);
        GL11.glVertex3f((float)(f + f4 * f10), (float)(f2 + f5 * f10), (float)(f3 + f6 * f10));
        GL11.glVertex3f((float)(f + f4 * f10), (float)(f2 + f5 * f10), (float)(f3 + f6 * f10));
        GL11.glVertex3f((float)(f + (f4 * f16 + f7 * f12) * f10), (float)(f2 + (f5 * f16 + f8 * f12) * f10), (float)(f3 + (f6 * f16 + f9 * f12) * f10));
        GL11.glVertex3f((float)(f + f4 * f10), (float)(f2 + f5 * f10), (float)(f3 + f6 * f10));
        GL11.glVertex3f((float)(f + (f4 * f16 - f7 * f12) * f10), (float)(f2 + (f5 * f16 - f8 * f12) * f10), (float)(f3 + (f6 * f16 - f9 * f12) * f10));
    }

    public void debugDrawLightSource(IsoLightSource isoLightSource, float f, float f2, float f3, float f4) {
        Model.debugDrawLightSource(isoLightSource.x, isoLightSource.y, isoLightSource.z, f, f2, f3, f4);
    }

    public static void debugDrawLightSource(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = f - f4 + 0.5f;
        float f9 = f2 - f5 + 0.5f;
        float f10 = f3 - f6 + 0.0f;
        float f11 = f8 *= 0.67f;
        float f12 = f9 *= 0.67f;
        f8 = (float)((double)f11 * Math.cos(f7) - (double)f12 * Math.sin(f7));
        f9 = (float)((double)f11 * Math.sin(f7) + (double)f12 * Math.cos(f7));
        f8 *= -1.0f;
        float f13 = f10;
        f10 = f9;
        f9 = f13;
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glBegin((int)1);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)f8, (float)f9, (float)f10);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)f8, (float)f9, (float)f10);
        GL11.glVertex3f((float)(f8 + 0.1f), (float)f9, (float)f10);
        GL11.glVertex3f((float)f8, (float)f9, (float)f10);
        GL11.glVertex3f((float)f8, (float)(f9 + 0.1f), (float)f10);
        GL11.glVertex3f((float)f8, (float)f9, (float)f10);
        GL11.glVertex3f((float)f8, (float)f9, (float)(f10 + 0.1f));
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
    }

    public void DrawVehicle(ModelSlotRenderData modelSlotRenderData, ModelInstanceRenderData modelInstanceRenderData) {
        if (DebugOptions.instance.ModelRenderSkipVehicles.getValue()) {
            return;
        }
        ModelInstance modelInstance = modelInstanceRenderData.modelInstance;
        float f = modelSlotRenderData.ambientR;
        Texture texture = modelInstanceRenderData.tex;
        float f2 = modelInstanceRenderData.tintR;
        float f3 = modelInstanceRenderData.tintG;
        float f4 = modelInstanceRenderData.tintB;
        PZGLUtil.checkGLErrorThrow("Model.drawVehicle Enter inst: %s, instTex: %s, slotData: %s", modelInstance, texture, modelSlotRenderData);
        GL11.glEnable((int)2884);
        GL11.glCullFace((int)(modelInstance.m_modelScript != null && modelInstance.m_modelScript.invertX ? 1029 : 1028));
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)513);
        ModelCamera.instance.Begin();
        GL11.glMatrixMode((int)5888);
        GL11.glTranslatef((float)0.0f, (float)modelSlotRenderData.centerOfMassY, (float)0.0f);
        Shader shader = this.Effect;
        PZGLUtil.pushAndMultMatrix(5888, modelInstanceRenderData.xfrm);
        if (Core.bDebug && DebugOptions.instance.ModelRenderWireframe.getValue()) {
            GL11.glPolygonMode((int)1032, (int)6913);
            GL11.glEnable((int)2848);
            GL11.glLineWidth((float)0.75f);
            shader = ShaderManager.instance.getOrCreateShader("vehicle_wireframe", this.bStatic);
            if (shader != null) {
                shader.Start();
                if (this.bStatic) {
                    shader.setTransformMatrix(IDENTITY, false);
                } else {
                    shader.setMatrixPalette(modelInstanceRenderData.matrixPalette, true);
                }
                this.Mesh.Draw(shader);
                shader.End();
            }
            GL11.glDisable((int)2848);
            PZGLUtil.popMatrix(5888);
            ModelCamera.instance.End();
            return;
        }
        if (shader != null) {
            shader.Start();
            this.setLights(modelSlotRenderData, 3);
            if (shader.isVehicleShader()) {
                VehicleModelInstance vehicleModelInstance = Type.tryCastTo(modelInstance, VehicleModelInstance.class);
                if (modelInstance instanceof VehicleSubModelInstance) {
                    vehicleModelInstance = Type.tryCastTo(modelInstance.parent, VehicleModelInstance.class);
                }
                shader.setTexture(vehicleModelInstance.tex, "Texture0", 0);
                GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
                shader.setTexture(vehicleModelInstance.textureRust, "TextureRust", 1);
                GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
                shader.setTexture(vehicleModelInstance.textureMask, "TextureMask", 2);
                GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
                shader.setTexture(vehicleModelInstance.textureLights, "TextureLights", 3);
                GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
                shader.setTexture(vehicleModelInstance.textureDamage1Overlay, "TextureDamage1Overlay", 4);
                GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
                shader.setTexture(vehicleModelInstance.textureDamage1Shell, "TextureDamage1Shell", 5);
                GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
                shader.setTexture(vehicleModelInstance.textureDamage2Overlay, "TextureDamage2Overlay", 6);
                GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
                shader.setTexture(vehicleModelInstance.textureDamage2Shell, "TextureDamage2Shell", 7);
                GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
                try {
                    if (Core.getInstance().getPerfReflectionsOnLoad()) {
                        shader.setTexture((Texture)SkyBox.getInstance().getTextureCurrent(), "TextureReflectionA", 8);
                        GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
                        GL11.glGetError();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (Core.getInstance().getPerfReflectionsOnLoad()) {
                        shader.setTexture((Texture)SkyBox.getInstance().getTexturePrev(), "TextureReflectionB", 9);
                        GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
                        GL11.glGetError();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                shader.setReflectionParam(SkyBox.getInstance().getTextureShift(), vehicleModelInstance.refWindows, vehicleModelInstance.refBody);
                shader.setTextureUninstall1(vehicleModelInstance.textureUninstall1);
                shader.setTextureUninstall2(vehicleModelInstance.textureUninstall2);
                shader.setTextureLightsEnables1(vehicleModelInstance.textureLightsEnables1);
                shader.setTextureLightsEnables2(vehicleModelInstance.textureLightsEnables2);
                shader.setTextureDamage1Enables1(vehicleModelInstance.textureDamage1Enables1);
                shader.setTextureDamage1Enables2(vehicleModelInstance.textureDamage1Enables2);
                shader.setTextureDamage2Enables1(vehicleModelInstance.textureDamage2Enables1);
                shader.setTextureDamage2Enables2(vehicleModelInstance.textureDamage2Enables2);
                shader.setMatrixBlood1(vehicleModelInstance.matrixBlood1Enables1, vehicleModelInstance.matrixBlood1Enables2);
                shader.setMatrixBlood2(vehicleModelInstance.matrixBlood2Enables1, vehicleModelInstance.matrixBlood2Enables2);
                shader.setTextureRustA(vehicleModelInstance.textureRustA);
                shader.setTexturePainColor(vehicleModelInstance.painColor, modelSlotRenderData.alpha);
                if (this.bStatic) {
                    shader.setTransformMatrix(IDENTITY, false);
                } else {
                    shader.setMatrixPalette(modelInstanceRenderData.matrixPalette, true);
                }
            } else if (modelInstance instanceof VehicleSubModelInstance) {
                GL13.glActiveTexture((int)33984);
                shader.setTexture(texture, "Texture", 0);
                shader.setShaderAlpha(modelSlotRenderData.alpha);
                if (this.bStatic) {
                    shader.setTransformMatrix(IDENTITY, false);
                }
            } else {
                GL13.glActiveTexture((int)33984);
                shader.setTexture(texture, "Texture", 0);
            }
            shader.setAmbient(f);
            shader.setTint(f2, f3, f4);
            this.Mesh.Draw(shader);
            shader.End();
        }
        if (Core.bDebug && DebugOptions.instance.ModelRenderLights.getValue() && modelInstanceRenderData == modelSlotRenderData.modelData.get(0)) {
            this.drawVehicleLights(modelSlotRenderData);
        }
        PZGLUtil.popMatrix(5888);
        ModelCamera.instance.End();
        PZGLUtil.checkGLErrorThrow("Model.drawVehicle Exit inst: %s, instTex: %s, slotData: %s", modelInstance, texture, modelSlotRenderData);
    }

    public static void debugDrawAxis(float f, float f2, float f3, float f4, float f5) {
        for (int i = 0; i < 8; ++i) {
            GL13.glActiveTexture((int)(33984 + i));
            GL11.glDisable((int)3553);
        }
        GL11.glDisable((int)2929);
        GL11.glLineWidth((float)f5);
        GL11.glBegin((int)1);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)f, (float)f2, (float)f3);
        GL11.glVertex3f((float)(f + f4), (float)f2, (float)f3);
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)f, (float)f2, (float)f3);
        GL11.glVertex3f((float)f, (float)(f2 + f4), (float)f3);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)f, (float)f2, (float)f3);
        GL11.glVertex3f((float)f, (float)f2, (float)(f3 + f4));
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2929);
        GL13.glActiveTexture((int)33984);
        GL11.glEnable((int)3553);
    }

    private void setLights(ModelSlotRenderData modelSlotRenderData, int n) {
        for (int i = 0; i < n; ++i) {
            ModelInstance.EffectLight effectLight = modelSlotRenderData.effectLights[i];
            this.Effect.setLight(i, effectLight.x, effectLight.y, effectLight.z, effectLight.r, effectLight.g, effectLight.b, effectLight.radius, modelSlotRenderData.animPlayerAngle, modelSlotRenderData.x, modelSlotRenderData.y, modelSlotRenderData.z, modelSlotRenderData.object);
        }
    }

    public void CreateShader(String string2) {
        if (ModelManager.NoOpenGL) {
            return;
        }
        Lambda.invoke(RenderThread::invokeOnRenderContext, this, string2, (model, string) -> {
            model.Effect = ShaderManager.instance.getOrCreateShader((String)string, model.bStatic);
        });
    }

    @Override
    public AssetType getType() {
        return ASSET_TYPE;
    }

    @Override
    protected void onBeforeReady() {
        super.onBeforeReady();
        this.Tag = this.Mesh.skinningData;
        this.softwareMesh = this.Mesh.softwareMesh;
        this.assetParams = null;
    }

    public static final class ModelAssetParams
    extends AssetManager.AssetParams {
        public String meshName;
        public String textureName;
        public int textureFlags;
        public String shaderName;
        public boolean bStatic = false;
        public ModelMesh animationsModel;
    }
}

