/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.model;

import jassimp.AiPostProcessSteps;
import jassimp.AiScene;
import jassimp.Jassimp;
import java.io.IOException;
import java.util.EnumSet;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.Vector4f;
import zombie.core.skinnedmodel.model.AnimationAsset;
import zombie.core.skinnedmodel.model.FileTask_AbstractLoadModel;
import zombie.core.skinnedmodel.model.ModelLoader;
import zombie.core.skinnedmodel.model.ModelMesh;
import zombie.core.skinnedmodel.model.ModelTxt;
import zombie.core.skinnedmodel.model.SkinningData;
import zombie.core.skinnedmodel.model.jassimp.JAssImpImporter;
import zombie.core.skinnedmodel.model.jassimp.ProcessedAiScene;
import zombie.core.skinnedmodel.model.jassimp.ProcessedAiSceneParams;
import zombie.debug.DebugLog;
import zombie.fileSystem.FileSystem;
import zombie.fileSystem.IFileTaskCallback;

public class FileTask_LoadAnimation
extends FileTask_AbstractLoadModel {
    private AnimationAsset m_anim;

    public FileTask_LoadAnimation(AnimationAsset animationAsset, FileSystem fileSystem, IFileTaskCallback iFileTaskCallback) {
        super(fileSystem, iFileTaskCallback, "media/anims", "media/anims_x");
        this.m_anim = animationAsset;
    }

    @Override
    public String getRawFileName() {
        return this.m_anim.getPath().getPath();
    }

    @Override
    public String getErrorMessage() {
        return this.m_fileName;
    }

    @Override
    public void done() {
    }

    @Override
    public ProcessedAiScene loadX() throws IOException {
        DebugLog.Animation.debugln("Loading: %s", this.m_fileName);
        EnumSet<AiPostProcessSteps> enumSet = EnumSet.of(AiPostProcessSteps.MAKE_LEFT_HANDED, AiPostProcessSteps.REMOVE_REDUNDANT_MATERIALS);
        AiScene aiScene = Jassimp.importFile((String)this.m_fileName, enumSet);
        JAssImpImporter.LoadMode loadMode = JAssImpImporter.LoadMode.AnimationOnly;
        ModelMesh modelMesh = this.m_anim.assetParams.animationsMesh;
        SkinningData skinningData = modelMesh == null ? null : modelMesh.skinningData;
        ProcessedAiSceneParams processedAiSceneParams = ProcessedAiSceneParams.create();
        processedAiSceneParams.scene = aiScene;
        processedAiSceneParams.mode = loadMode;
        processedAiSceneParams.skinnedTo = skinningData;
        ProcessedAiScene processedAiScene = ProcessedAiScene.process(processedAiSceneParams);
        JAssImpImporter.takeOutTheTrash(aiScene);
        return processedAiScene;
    }

    @Override
    public ProcessedAiScene loadFBX() throws IOException {
        DebugLog.Animation.debugln("Loading: %s", this.m_fileName);
        EnumSet<AiPostProcessSteps> enumSet = EnumSet.of(AiPostProcessSteps.MAKE_LEFT_HANDED, AiPostProcessSteps.REMOVE_REDUNDANT_MATERIALS);
        AiScene aiScene = Jassimp.importFile((String)this.m_fileName, enumSet);
        JAssImpImporter.LoadMode loadMode = JAssImpImporter.LoadMode.AnimationOnly;
        ModelMesh modelMesh = this.m_anim.assetParams.animationsMesh;
        SkinningData skinningData = modelMesh == null ? null : modelMesh.skinningData;
        Quaternion quaternion = new Quaternion();
        Vector4f vector4f = new Vector4f(1.0f, 0.0f, 0.0f, -1.5707964f);
        quaternion.setFromAxisAngle(vector4f);
        ProcessedAiSceneParams processedAiSceneParams = ProcessedAiSceneParams.create();
        processedAiSceneParams.scene = aiScene;
        processedAiSceneParams.mode = loadMode;
        processedAiSceneParams.skinnedTo = skinningData;
        processedAiSceneParams.animBonesScaleModifier = 0.01f;
        processedAiSceneParams.animBonesRotateModifier = quaternion;
        ProcessedAiScene processedAiScene = ProcessedAiScene.process(processedAiSceneParams);
        JAssImpImporter.takeOutTheTrash(aiScene);
        return processedAiScene;
    }

    @Override
    public ModelTxt loadTxt() throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        ModelMesh modelMesh = this.m_anim.assetParams.animationsMesh;
        SkinningData skinningData = modelMesh == null ? null : modelMesh.skinningData;
        return ModelLoader.instance.loadTxt(this.m_fileName, bl, bl2, skinningData);
    }
}

