/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import zombie.characterTextures.BloodBodyPartType;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.util.Pool;

public final class CharacterMask {
    private final boolean[] m_visibleFlags = CharacterMask.createFlags(Part.values().length, true);

    public boolean isBloodBodyPartVisible(BloodBodyPartType bloodBodyPartType) {
        for (Part part : bloodBodyPartType.getCharacterMaskParts()) {
            if (!this.isPartVisible(part)) continue;
            return true;
        }
        return false;
    }

    private static boolean[] createFlags(int n, boolean bl) {
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = bl;
        }
        return blArray;
    }

    public void setAllVisible(boolean bl) {
        Arrays.fill(this.m_visibleFlags, bl);
    }

    public void copyFrom(CharacterMask characterMask) {
        System.arraycopy(characterMask.m_visibleFlags, 0, this.m_visibleFlags, 0, this.m_visibleFlags.length);
    }

    public void setPartVisible(Part part, boolean bl) {
        if (part.hasSubdivisions()) {
            for (Part part2 : part.subDivisions()) {
                this.setPartVisible(part2, bl);
            }
        } else {
            this.m_visibleFlags[part.getValue()] = bl;
        }
    }

    public void setPartsVisible(ArrayList<Integer> arrayList, boolean bl) {
        for (int i = 0; i < arrayList.size(); ++i) {
            int n = arrayList.get(i);
            Part part = Part.fromInt(n);
            if (part == null) {
                if (!DebugLog.isEnabled(DebugType.Clothing)) continue;
                DebugLog.Clothing.warn("MaskValue out of bounds: " + n);
                continue;
            }
            this.setPartVisible(part, bl);
        }
    }

    public boolean isPartVisible(Part part) {
        if (part == null) {
            return false;
        }
        if (part.hasSubdivisions()) {
            boolean bl = true;
            for (int i = 0; bl && i < part.subDivisions().length; ++i) {
                Part part2 = part.subDivisions()[i];
                bl = this.m_visibleFlags[part2.getValue()];
            }
            return bl;
        }
        return this.m_visibleFlags[part.getValue()];
    }

    public boolean isTorsoVisible() {
        return this.isPartVisible(Part.Torso);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{VisibleFlags:(" + this.contentsToString() + ")}";
    }

    public String contentsToString() {
        if (this.isAllVisible()) {
            return "All Visible";
        }
        if (this.isNothingVisible()) {
            return "Nothing Visible";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int i = 0; i < Part.leaves().length; ++i) {
            Part part = Part.leaves()[i];
            if (!this.isPartVisible(part)) continue;
            if (n > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append((Object)part);
            ++n;
        }
        return stringBuilder.toString();
    }

    private boolean isAll(boolean bl) {
        boolean bl2 = true;
        int n = Part.leaves().length;
        for (int i = 0; bl2 && i < n; ++i) {
            Part part = Part.leaves()[i];
            bl2 = this.isPartVisible(part) == bl;
        }
        return bl2;
    }

    public boolean isNothingVisible() {
        return this.isAll(false);
    }

    public boolean isAllVisible() {
        return this.isAll(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachVisible(Consumer<Part> consumer) {
        try {
            for (int i = 0; i < Part.leaves().length; ++i) {
                Part part = Part.leaves()[i];
                if (!this.isPartVisible(part)) continue;
                consumer.accept(part);
            }
        }
        finally {
            Pool.tryRelease(consumer);
        }
    }

    public static enum Part {
        Head(0),
        Torso(1, true),
        Pelvis(2, true),
        LeftArm(3),
        LeftHand(4),
        RightArm(5),
        RightHand(6),
        LeftLeg(7),
        LeftFoot(8),
        RightLeg(9),
        RightFoot(10),
        Dress(11),
        Chest(12, Torso),
        Waist(13, Torso),
        Belt(14, Pelvis),
        Crotch(15, Pelvis);

        private final int value;
        private final Part parent;
        private final boolean isSubdivided;
        private Part[] subDivisions;
        private BloodBodyPartType[] m_bloodBodyPartTypes;
        private static final Part[] s_leaves;

        private Part(int n2) {
            this.value = n2;
            this.parent = null;
            this.isSubdivided = false;
        }

        private Part(int n2, Part part) {
            this.value = n2;
            this.parent = part;
            this.isSubdivided = false;
        }

        private Part(int n2, boolean bl) {
            this.value = n2;
            this.parent = null;
            this.isSubdivided = bl;
        }

        public static int count() {
            return Part.values().length;
        }

        public static Part[] leaves() {
            return s_leaves;
        }

        public static Part fromInt(int n) {
            return n >= 0 && n < Part.count() ? Part.values()[n] : null;
        }

        public int getValue() {
            return this.value;
        }

        public Part getParent() {
            return this.parent;
        }

        public boolean isSubdivision() {
            return this.parent != null;
        }

        public boolean hasSubdivisions() {
            return this.isSubdivided;
        }

        public Part[] subDivisions() {
            if (this.subDivisions != null) {
                return this.subDivisions;
            }
            if (!this.isSubdivided) {
                this.subDivisions = new Part[0];
            }
            ArrayList<Part> arrayList = new ArrayList<Part>();
            for (Part part : Part.values()) {
                if (part.parent != this) continue;
                arrayList.add(part);
            }
            this.subDivisions = arrayList.toArray(new Part[0]);
            return this.subDivisions;
        }

        private static Part[] leavesInternal() {
            ArrayList<Part> arrayList = new ArrayList<Part>();
            for (Part part : Part.values()) {
                if (part.hasSubdivisions()) continue;
                arrayList.add(part);
            }
            return arrayList.toArray(new Part[0]);
        }

        public BloodBodyPartType[] getBloodBodyPartTypes() {
            if (this.m_bloodBodyPartTypes != null) {
                return this.m_bloodBodyPartTypes;
            }
            ArrayList<BloodBodyPartType> arrayList = new ArrayList<BloodBodyPartType>();
            switch (this) {
                case Head: {
                    arrayList.add(BloodBodyPartType.Head);
                    break;
                }
                case Torso: {
                    arrayList.add(BloodBodyPartType.Torso_Upper);
                    arrayList.add(BloodBodyPartType.Torso_Lower);
                    break;
                }
                case Pelvis: {
                    arrayList.add(BloodBodyPartType.UpperLeg_L);
                    arrayList.add(BloodBodyPartType.UpperLeg_R);
                    arrayList.add(BloodBodyPartType.Groin);
                    break;
                }
                case LeftArm: {
                    arrayList.add(BloodBodyPartType.UpperArm_L);
                    arrayList.add(BloodBodyPartType.ForeArm_L);
                    break;
                }
                case LeftHand: {
                    arrayList.add(BloodBodyPartType.Hand_L);
                    break;
                }
                case RightArm: {
                    arrayList.add(BloodBodyPartType.UpperArm_R);
                    arrayList.add(BloodBodyPartType.ForeArm_R);
                    break;
                }
                case RightHand: {
                    arrayList.add(BloodBodyPartType.Hand_R);
                    break;
                }
                case LeftLeg: {
                    arrayList.add(BloodBodyPartType.UpperLeg_L);
                    arrayList.add(BloodBodyPartType.LowerLeg_L);
                    break;
                }
                case LeftFoot: {
                    arrayList.add(BloodBodyPartType.Foot_L);
                    break;
                }
                case RightLeg: {
                    arrayList.add(BloodBodyPartType.UpperLeg_R);
                    arrayList.add(BloodBodyPartType.LowerLeg_R);
                    break;
                }
                case RightFoot: {
                    arrayList.add(BloodBodyPartType.Foot_R);
                    break;
                }
                case Dress: {
                    break;
                }
                case Chest: {
                    arrayList.add(BloodBodyPartType.Torso_Upper);
                    break;
                }
                case Waist: {
                    arrayList.add(BloodBodyPartType.Torso_Lower);
                    break;
                }
                case Belt: {
                    arrayList.add(BloodBodyPartType.UpperLeg_L);
                    arrayList.add(BloodBodyPartType.UpperLeg_R);
                    break;
                }
                case Crotch: {
                    arrayList.add(BloodBodyPartType.Groin);
                }
            }
            this.m_bloodBodyPartTypes = new BloodBodyPartType[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                this.m_bloodBodyPartTypes[i] = (BloodBodyPartType)((Object)arrayList.get(i));
            }
            return this.m_bloodBodyPartTypes;
        }

        static {
            s_leaves = Part.leavesInternal();
        }
    }
}

