/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.animation.sharedskele;

import org.lwjgl.util.vector.Matrix4f;
import zombie.core.math.PZMath;
import zombie.core.skinnedmodel.animation.AnimTrackSampler;
import zombie.debug.DebugOptions;

public class SharedSkeleAnimationTrack
implements AnimTrackSampler {
    private int m_numFrames;
    private float m_totalTime;
    private boolean m_isLooped;
    private BoneTrack[] m_boneTracks;
    private float m_currentTime = 0.0f;

    public void set(AnimTrackSampler animTrackSampler, float f) {
        float f2 = animTrackSampler.getTotalTime();
        boolean bl = animTrackSampler.isLooped();
        int n = animTrackSampler.getNumBones();
        this.m_totalTime = f2;
        this.m_numFrames = PZMath.max((int)(f2 * f + 0.99f), 1);
        this.m_isLooped = bl;
        this.m_boneTracks = new BoneTrack[n];
        for (int i = 0; i < n; ++i) {
            this.m_boneTracks[i] = new BoneTrack();
            this.m_boneTracks[i].m_animationData = new float[this.m_numFrames * 16];
        }
        Matrix4f matrix4f = new Matrix4f();
        float f3 = f2 / (float)(this.m_numFrames - 1);
        for (int i = 0; i < this.m_numFrames; ++i) {
            float f4 = f3 * (float)i;
            animTrackSampler.moveToTime(f4);
            for (int j = 0; j < n; ++j) {
                animTrackSampler.getBoneMatrix(j, matrix4f);
                int n2 = i * 16;
                BoneTrack boneTrack = this.m_boneTracks[j];
                float[] fArray = boneTrack.m_animationData;
                fArray[n2] = matrix4f.m00;
                fArray[n2 + 1] = matrix4f.m01;
                fArray[n2 + 2] = matrix4f.m02;
                fArray[n2 + 3] = matrix4f.m03;
                fArray[n2 + 4] = matrix4f.m10;
                fArray[n2 + 5] = matrix4f.m11;
                fArray[n2 + 6] = matrix4f.m12;
                fArray[n2 + 7] = matrix4f.m13;
                fArray[n2 + 8] = matrix4f.m20;
                fArray[n2 + 9] = matrix4f.m21;
                fArray[n2 + 10] = matrix4f.m22;
                fArray[n2 + 11] = matrix4f.m23;
                fArray[n2 + 12] = matrix4f.m30;
                fArray[n2 + 13] = matrix4f.m31;
                fArray[n2 + 14] = matrix4f.m32;
                fArray[n2 + 15] = matrix4f.m33;
            }
        }
    }

    @Override
    public float getTotalTime() {
        return this.m_totalTime;
    }

    @Override
    public boolean isLooped() {
        return this.m_isLooped;
    }

    @Override
    public void moveToTime(float f) {
        this.m_currentTime = f;
    }

    @Override
    public float getCurrentTime() {
        return this.m_currentTime;
    }

    @Override
    public void getBoneMatrix(int n, Matrix4f matrix4f) {
        float f = this.m_totalTime;
        int n2 = this.m_numFrames;
        float f2 = this.getCurrentTime();
        float f3 = f2 / f;
        float f4 = f3 * (float)(n2 - 1);
        if (this.isLooped()) {
            this.sampleAtTime_Looped(matrix4f, n, f4);
        } else {
            this.sampleAtTime_NonLooped(matrix4f, n, f4);
        }
    }

    @Override
    public int getNumBones() {
        return this.m_boneTracks != null ? this.m_boneTracks.length : 0;
    }

    private void sampleAtTime_NonLooped(Matrix4f matrix4f, int n, float f) {
        int n2 = (int)f;
        float f2 = f - (float)n2;
        int n3 = PZMath.clamp(n2, 0, this.m_numFrames - 1);
        int n4 = PZMath.clamp(n3 + 1, 0, this.m_numFrames - 1);
        boolean bl = DebugOptions.instance.Animation.SharedSkeles.AllowLerping.getValue();
        this.sampleBoneData(n, n3, n4, f2, bl, matrix4f);
    }

    private void sampleAtTime_Looped(Matrix4f matrix4f, int n, float f) {
        int n2 = (int)f;
        float f2 = f - (float)n2;
        int n3 = n2 % this.m_numFrames;
        int n4 = (n3 + 1) % this.m_numFrames;
        boolean bl = DebugOptions.instance.Animation.SharedSkeles.AllowLerping.getValue();
        this.sampleBoneData(n, n3, n4, f2, bl, matrix4f);
    }

    private void sampleBoneData(int n, int n2, int n3, float f, boolean bl, Matrix4f matrix4f) {
        int n4 = n2 * 16;
        BoneTrack boneTrack = this.m_boneTracks[n];
        float[] fArray = boneTrack.m_animationData;
        if (n2 != n3 && bl) {
            int n5 = n3 * 16;
            matrix4f.m00 = PZMath.lerp(fArray[n4], fArray[n5], f);
            matrix4f.m01 = PZMath.lerp(fArray[n4 + 1], fArray[n5 + 1], f);
            matrix4f.m02 = PZMath.lerp(fArray[n4 + 2], fArray[n5 + 2], f);
            matrix4f.m03 = PZMath.lerp(fArray[n4 + 3], fArray[n5 + 3], f);
            matrix4f.m10 = PZMath.lerp(fArray[n4 + 4], fArray[n5 + 4], f);
            matrix4f.m11 = PZMath.lerp(fArray[n4 + 5], fArray[n5 + 5], f);
            matrix4f.m12 = PZMath.lerp(fArray[n4 + 6], fArray[n5 + 6], f);
            matrix4f.m13 = PZMath.lerp(fArray[n4 + 7], fArray[n5 + 7], f);
            matrix4f.m20 = PZMath.lerp(fArray[n4 + 8], fArray[n5 + 8], f);
            matrix4f.m21 = PZMath.lerp(fArray[n4 + 9], fArray[n5 + 9], f);
            matrix4f.m22 = PZMath.lerp(fArray[n4 + 10], fArray[n5 + 10], f);
            matrix4f.m23 = PZMath.lerp(fArray[n4 + 11], fArray[n5 + 11], f);
            matrix4f.m30 = PZMath.lerp(fArray[n4 + 12], fArray[n5 + 12], f);
            matrix4f.m31 = PZMath.lerp(fArray[n4 + 13], fArray[n5 + 13], f);
            matrix4f.m32 = PZMath.lerp(fArray[n4 + 14], fArray[n5 + 14], f);
            matrix4f.m33 = PZMath.lerp(fArray[n4 + 15], fArray[n5 + 15], f);
        } else {
            matrix4f.m00 = fArray[n4];
            matrix4f.m01 = fArray[n4 + 1];
            matrix4f.m02 = fArray[n4 + 2];
            matrix4f.m03 = fArray[n4 + 3];
            matrix4f.m10 = fArray[n4 + 4];
            matrix4f.m11 = fArray[n4 + 5];
            matrix4f.m12 = fArray[n4 + 6];
            matrix4f.m13 = fArray[n4 + 7];
            matrix4f.m20 = fArray[n4 + 8];
            matrix4f.m21 = fArray[n4 + 9];
            matrix4f.m22 = fArray[n4 + 10];
            matrix4f.m23 = fArray[n4 + 11];
            matrix4f.m30 = fArray[n4 + 12];
            matrix4f.m31 = fArray[n4 + 13];
            matrix4f.m32 = fArray[n4 + 14];
            matrix4f.m33 = fArray[n4 + 15];
        }
    }

    private static class BoneTrack {
        private float[] m_animationData;

        private BoneTrack() {
        }
    }
}

