/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.animation.debug;

import java.io.PrintStream;
import java.util.HashMap;
import zombie.ZomboidFileSystem;
import zombie.core.skinnedmodel.animation.debug.AnimationPlayerRecorder;
import zombie.util.list.PZArrayUtil;

public abstract class GenericNameValueRecordingFrame {
    protected String[] m_columnNames = new String[0];
    protected final HashMap<String, Integer> m_nameIndices = new HashMap();
    protected boolean m_headerDirty = false;
    protected final String m_fileKey;
    protected PrintStream m_outHeader = null;
    protected PrintStream m_outValues = null;
    private String m_headerFilePath = null;
    private String m_valuesFilePath = null;
    protected int m_frameNumber = -1;
    protected static final String delim = ",";
    protected final String m_valuesFileNameSuffix;
    private String m_previousLine = null;
    private int m_previousFrameNo = -1;
    protected final StringBuilder m_lineBuffer = new StringBuilder();

    public GenericNameValueRecordingFrame(String string, String string2) {
        this.m_fileKey = string;
        this.m_valuesFileNameSuffix = string2;
    }

    protected int addColumnInternal(String string) {
        int n = this.m_columnNames.length;
        this.m_columnNames = PZArrayUtil.add(this.m_columnNames, string);
        this.m_nameIndices.put(string, n);
        this.m_headerDirty = true;
        this.onColumnAdded();
        return n;
    }

    public int getOrCreateColumn(String string) {
        if (this.m_nameIndices.containsKey(string)) {
            return this.m_nameIndices.get(string);
        }
        return this.addColumnInternal(string);
    }

    public void setFrameNumber(int n) {
        this.m_frameNumber = n;
    }

    public int getColumnCount() {
        return this.m_columnNames.length;
    }

    public String getNameAt(int n) {
        return this.m_columnNames[n];
    }

    public abstract String getValueAt(int var1);

    protected void openHeader(boolean bl) {
        this.m_outHeader = AnimationPlayerRecorder.openFileStream(this.m_fileKey + "_header", bl, string -> {
            this.m_headerFilePath = string;
        });
    }

    protected void openValuesFile(boolean bl) {
        this.m_outValues = AnimationPlayerRecorder.openFileStream(this.m_fileKey + this.m_valuesFileNameSuffix, bl, string -> {
            this.m_valuesFilePath = string;
        });
    }

    public void writeLine() {
        if (this.m_headerDirty || this.m_outHeader == null) {
            this.m_headerDirty = false;
            this.writeHeader();
        }
        this.writeData();
    }

    public void close() {
        if (this.m_outHeader != null) {
            this.m_outHeader.close();
            this.m_outHeader = null;
        }
        if (this.m_outValues != null) {
            this.m_outValues.close();
            this.m_outValues = null;
        }
    }

    public void closeAndDiscard() {
        this.close();
        ZomboidFileSystem.instance.tryDeleteFile(this.m_headerFilePath);
        this.m_headerFilePath = null;
        ZomboidFileSystem.instance.tryDeleteFile(this.m_valuesFilePath);
        this.m_valuesFilePath = null;
    }

    protected abstract void onColumnAdded();

    public abstract void reset();

    protected void writeHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("frameNo");
        this.writeHeader(stringBuilder);
        this.openHeader(false);
        this.m_outHeader.println(stringBuilder);
    }

    protected void writeHeader(StringBuilder stringBuilder) {
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            GenericNameValueRecordingFrame.appendCell(stringBuilder, this.getNameAt(i));
        }
    }

    protected void writeData() {
        if (this.m_outValues == null) {
            this.openValuesFile(false);
        }
        StringBuilder stringBuilder = this.m_lineBuffer;
        stringBuilder.setLength(0);
        this.writeData(stringBuilder);
        if (this.m_previousLine != null && this.m_previousLine.contentEquals(stringBuilder)) {
            return;
        }
        this.m_outValues.print(this.m_frameNumber);
        this.m_outValues.println(stringBuilder);
        this.m_previousLine = stringBuilder.toString();
        this.m_previousFrameNo = this.m_frameNumber;
    }

    protected void writeData(StringBuilder stringBuilder) {
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            GenericNameValueRecordingFrame.appendCell(stringBuilder, this.getValueAt(i));
        }
    }

    public static StringBuilder appendCell(StringBuilder stringBuilder) {
        return stringBuilder.append(delim);
    }

    public static StringBuilder appendCell(StringBuilder stringBuilder, String string) {
        return stringBuilder.append(delim).append(string);
    }

    public static StringBuilder appendCell(StringBuilder stringBuilder, float f) {
        return stringBuilder.append(delim).append(f);
    }

    public static StringBuilder appendCell(StringBuilder stringBuilder, int n) {
        return stringBuilder.append(delim).append(n);
    }

    public static StringBuilder appendCell(StringBuilder stringBuilder, long l) {
        return stringBuilder.append(delim).append(l);
    }

    public static StringBuilder appendCellQuot(StringBuilder stringBuilder, String string) {
        return stringBuilder.append(delim).append('\"').append(string).append('\"');
    }
}

