/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.animation.debug;

import zombie.core.skinnedmodel.advancedanimation.IAnimationVariableSlot;
import zombie.core.skinnedmodel.advancedanimation.IAnimationVariableSource;
import zombie.core.skinnedmodel.animation.debug.GenericNameValueRecordingFrame;
import zombie.debug.DebugLog;
import zombie.util.list.PZArrayUtil;

public final class AnimationVariableRecordingFrame
extends GenericNameValueRecordingFrame {
    private String[] m_variableValues = new String[0];

    public AnimationVariableRecordingFrame(String string) {
        super(string, "_values");
    }

    public void logVariables(IAnimationVariableSource iAnimationVariableSource) {
        for (IAnimationVariableSlot iAnimationVariableSlot : iAnimationVariableSource.getGameVariables()) {
            this.logVariable(iAnimationVariableSlot.getKey(), iAnimationVariableSlot.getValueString());
        }
    }

    @Override
    protected void onColumnAdded() {
        this.m_variableValues = PZArrayUtil.add(this.m_variableValues, null);
    }

    public void logVariable(String string, String string2) {
        int n = this.getOrCreateColumn(string);
        if (this.m_variableValues[n] != null) {
            DebugLog.General.error("Value for %s already set: %f, new value: %f", string, this.m_variableValues[n], string2);
        }
        this.m_variableValues[n] = string2;
    }

    @Override
    public String getValueAt(int n) {
        return this.m_variableValues[n];
    }

    @Override
    public void reset() {
        int n = this.m_variableValues.length;
        for (int i = 0; i < n; ++i) {
            this.m_variableValues[i] = null;
        }
    }
}

