/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.animation.debug;

import java.util.ArrayList;
import java.util.List;
import zombie.ai.State;
import zombie.ai.StateMachine;
import zombie.characters.action.ActionState;
import zombie.core.skinnedmodel.advancedanimation.AnimState;
import zombie.core.skinnedmodel.animation.debug.GenericNameWeightRecordingFrame;
import zombie.iso.Vector3;
import zombie.util.list.PZArrayUtil;

public final class AnimationNodeRecordingFrame
extends GenericNameWeightRecordingFrame {
    private String m_actionStateName;
    private final ArrayList<String> m_actionSubStateNames = new ArrayList();
    private String m_aiStateName;
    private String m_animStateName;
    private final ArrayList<String> m_animSubStateNames = new ArrayList();
    private final ArrayList<String> m_aiSubStateNames = new ArrayList();
    private final Vector3 m_characterToPlayerDiff = new Vector3();

    public AnimationNodeRecordingFrame(String string) {
        super(string);
    }

    public void logActionState(ActionState actionState, List<ActionState> list) {
        this.m_actionStateName = actionState != null ? actionState.getName() : null;
        PZArrayUtil.arrayConvert(this.m_actionSubStateNames, list, ActionState::getName);
    }

    public void logAIState(State state, List<StateMachine.SubstateSlot> list) {
        this.m_aiStateName = state != null ? state.getName() : null;
        PZArrayUtil.arrayConvert(this.m_aiSubStateNames, list, substateSlot -> !substateSlot.isEmpty() ? substateSlot.getState().getName() : "");
    }

    public void logAnimState(AnimState animState) {
        this.m_animStateName = animState != null ? animState.m_Name : null;
    }

    public void logCharacterToPlayerDiff(Vector3 vector3) {
        this.m_characterToPlayerDiff.set(vector3);
    }

    @Override
    public void writeHeader(StringBuilder stringBuilder) {
        AnimationNodeRecordingFrame.appendCell(stringBuilder, "toPlayer.x");
        AnimationNodeRecordingFrame.appendCell(stringBuilder, "toPlayer.y");
        AnimationNodeRecordingFrame.appendCell(stringBuilder, "actionState");
        AnimationNodeRecordingFrame.appendCell(stringBuilder, "actionState.sub[0]");
        AnimationNodeRecordingFrame.appendCell(stringBuilder, "actionState.sub[1]");
        AnimationNodeRecordingFrame.appendCell(stringBuilder, "aiState");
        AnimationNodeRecordingFrame.appendCell(stringBuilder, "aiState.sub[0]");
        AnimationNodeRecordingFrame.appendCell(stringBuilder, "aiState.sub[1]");
        AnimationNodeRecordingFrame.appendCell(stringBuilder, "animState");
        AnimationNodeRecordingFrame.appendCell(stringBuilder, "animState.sub[0]");
        AnimationNodeRecordingFrame.appendCell(stringBuilder, "animState.sub[1]");
        AnimationNodeRecordingFrame.appendCell(stringBuilder, "nodeWeights.begin");
        super.writeHeader(stringBuilder);
    }

    @Override
    protected void writeData(StringBuilder stringBuilder) {
        AnimationNodeRecordingFrame.appendCell(stringBuilder, this.m_characterToPlayerDiff.x);
        AnimationNodeRecordingFrame.appendCell(stringBuilder, this.m_characterToPlayerDiff.y);
        AnimationNodeRecordingFrame.appendCellQuot(stringBuilder, this.m_actionStateName);
        AnimationNodeRecordingFrame.appendCellQuot(stringBuilder, PZArrayUtil.getOrDefault(this.m_actionSubStateNames, 0, ""));
        AnimationNodeRecordingFrame.appendCellQuot(stringBuilder, PZArrayUtil.getOrDefault(this.m_actionSubStateNames, 1, ""));
        AnimationNodeRecordingFrame.appendCellQuot(stringBuilder, this.m_aiStateName);
        AnimationNodeRecordingFrame.appendCellQuot(stringBuilder, PZArrayUtil.getOrDefault(this.m_aiSubStateNames, 0, ""));
        AnimationNodeRecordingFrame.appendCellQuot(stringBuilder, PZArrayUtil.getOrDefault(this.m_aiSubStateNames, 1, ""));
        AnimationNodeRecordingFrame.appendCellQuot(stringBuilder, this.m_animStateName);
        AnimationNodeRecordingFrame.appendCellQuot(stringBuilder, PZArrayUtil.getOrDefault(this.m_animSubStateNames, 0, ""));
        AnimationNodeRecordingFrame.appendCellQuot(stringBuilder, PZArrayUtil.getOrDefault(this.m_animSubStateNames, 1, ""));
        AnimationNodeRecordingFrame.appendCell(stringBuilder);
        super.writeData(stringBuilder);
    }
}

