/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.animation;

import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector3f;
import zombie.core.skinnedmodel.HelperFunctions;
import zombie.core.skinnedmodel.animation.AnimTrackSampler;
import zombie.core.skinnedmodel.animation.AnimationBoneBinding;
import zombie.core.skinnedmodel.animation.AnimationPlayer;
import zombie.core.skinnedmodel.animation.AnimationTrack;
import zombie.core.skinnedmodel.animation.BoneTransform;
import zombie.core.skinnedmodel.animation.Keyframe;
import zombie.core.skinnedmodel.model.SkinningBone;
import zombie.core.skinnedmodel.model.SkinningData;
import zombie.debug.DebugOptions;
import zombie.util.Pool;
import zombie.util.PooledObject;
import zombie.util.list.PZArrayUtil;

public class ModelTransformSampler
extends PooledObject
implements AnimTrackSampler {
    private AnimationPlayer m_sourceAnimPlayer;
    private AnimationTrack m_track;
    private float m_currentTime = 0.0f;
    private SkinningData m_skinningData;
    private BoneTransform[] m_boneTransforms;
    private Matrix4f[] m_boneModelTransforms;
    private static final Pool<ModelTransformSampler> s_pool = new Pool<ModelTransformSampler>(ModelTransformSampler::new);

    private void init(AnimationPlayer animationPlayer, AnimationTrack animationTrack) {
        this.m_sourceAnimPlayer = animationPlayer;
        this.m_track = AnimationTrack.createClone(animationTrack, AnimationTrack::alloc);
        SkinningData skinningData = this.m_sourceAnimPlayer.getSkinningData();
        int n = skinningData.numBones();
        this.m_skinningData = skinningData;
        this.m_boneModelTransforms = PZArrayUtil.newInstance(Matrix4f.class, this.m_boneModelTransforms, n, Matrix4f::new);
        this.m_boneTransforms = PZArrayUtil.newInstance(BoneTransform.class, this.m_boneTransforms, n, BoneTransform::alloc);
    }

    public static ModelTransformSampler alloc(AnimationPlayer animationPlayer, AnimationTrack animationTrack) {
        ModelTransformSampler modelTransformSampler = s_pool.alloc();
        modelTransformSampler.init(animationPlayer, animationTrack);
        return modelTransformSampler;
    }

    @Override
    public void onReleased() {
        this.m_sourceAnimPlayer = null;
        this.m_track = Pool.tryRelease(this.m_track);
        this.m_skinningData = null;
        this.m_boneTransforms = Pool.tryRelease(this.m_boneTransforms);
    }

    @Override
    public float getTotalTime() {
        return this.m_track.getDuration();
    }

    @Override
    public boolean isLooped() {
        return this.m_track.isLooping();
    }

    @Override
    public void moveToTime(float f) {
        this.m_currentTime = f;
        this.m_track.setCurrentTimeValue(f);
        this.m_track.Update(0.0f);
        for (int i = 0; i < this.m_boneTransforms.length; ++i) {
            this.updateBoneAnimationTransform(i);
        }
    }

    private void updateBoneAnimationTransform(int n) {
        boolean bl;
        Vector3f vector3f;
        Vector3f vector3f2 = L_updateBoneAnimationTransform.pos;
        Quaternion quaternion = L_updateBoneAnimationTransform.rot;
        Vector3f vector3f3 = L_updateBoneAnimationTransform.scale;
        Keyframe keyframe = L_updateBoneAnimationTransform.key;
        AnimationBoneBinding animationBoneBinding = this.m_sourceAnimPlayer.getCounterRotationBone();
        boolean bl2 = animationBoneBinding != null && animationBoneBinding.getBone() != null && animationBoneBinding.getBone().Index == n;
        keyframe.setIdentity();
        AnimationTrack animationTrack = this.m_track;
        this.getTrackTransform(n, animationTrack, vector3f2, quaternion, vector3f3);
        if (bl2 && animationTrack.getUseDeferredRotation()) {
            if (DebugOptions.instance.Character.Debug.Animate.ZeroCounterRotationBone.getValue()) {
                var9_9 = L_updateBoneAnimationTransform.rotAxis;
                vector3f = L_updateBoneAnimationTransform.rotMat;
                vector3f.setIdentity();
                var9_9.set(0.0f, 1.0f, 0.0f);
                vector3f.rotate(-1.5707964f, var9_9);
                var9_9.set(1.0f, 0.0f, 0.0f);
                vector3f.rotate(-1.5707964f, var9_9);
                HelperFunctions.getRotation((Matrix4f)vector3f, quaternion);
            } else {
                var9_9 = HelperFunctions.ToEulerAngles(quaternion, L_updateBoneAnimationTransform.rotEulers);
                HelperFunctions.ToQuaternion(var9_9.x, var9_9.y, 1.5707963705062866, quaternion);
            }
        }
        boolean bl3 = bl = animationTrack.getDeferredMovementBoneIdx() == n;
        if (bl) {
            vector3f = animationTrack.getCurrentDeferredCounterPosition(L_updateBoneAnimationTransform.deferredPos);
            vector3f2.x += vector3f.x;
            vector3f2.y += vector3f.y;
            vector3f2.z += vector3f.z;
        }
        keyframe.Position.set((ReadableVector3f)vector3f2);
        keyframe.Rotation.set((ReadableVector4f)quaternion);
        keyframe.Scale.set((ReadableVector3f)vector3f3);
        this.m_boneTransforms[n].set(keyframe.Position, keyframe.Rotation, keyframe.Scale);
    }

    private void getTrackTransform(int n, AnimationTrack animationTrack, Vector3f vector3f, Quaternion quaternion, Vector3f vector3f2) {
        animationTrack.get(n, vector3f, quaternion, vector3f2);
    }

    @Override
    public float getCurrentTime() {
        return this.m_currentTime;
    }

    @Override
    public void getBoneMatrix(int n, Matrix4f matrix4f) {
        if (n == 0) {
            this.m_boneTransforms[0].getMatrix(this.m_boneModelTransforms[0]);
            matrix4f.load(this.m_boneModelTransforms[0]);
            return;
        }
        SkinningBone skinningBone = this.m_skinningData.getBoneAt(n);
        SkinningBone skinningBone2 = skinningBone.Parent;
        BoneTransform.mul(this.m_boneTransforms[skinningBone.Index], this.m_boneModelTransforms[skinningBone2.Index], this.m_boneModelTransforms[skinningBone.Index]);
        matrix4f.load(this.m_boneModelTransforms[skinningBone.Index]);
    }

    @Override
    public int getNumBones() {
        return this.m_skinningData.numBones();
    }

    public static class L_updateBoneAnimationTransform {
        public static final Vector3f pos = new Vector3f();
        public static final Quaternion rot = new Quaternion();
        public static final Vector3f scale = new Vector3f();
        public static final Keyframe key = new Keyframe(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f));
        public static final Vector3f rotAxis = new Vector3f();
        public static final Matrix4f rotMat = new Matrix4f();
        public static final Vector3f rotEulers = new Vector3f();
        public static final Vector3f deferredPos = new Vector3f();
    }
}

