/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.animation;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector3f;
import zombie.core.PerformanceSettings;
import zombie.core.math.PZMath;
import zombie.core.profiling.PerformanceProfileProbe;
import zombie.core.skinnedmodel.HelperFunctions;
import zombie.core.skinnedmodel.advancedanimation.AnimBoneWeight;
import zombie.core.skinnedmodel.advancedanimation.PooledAnimBoneWeightArray;
import zombie.core.skinnedmodel.animation.AnimationClip;
import zombie.core.skinnedmodel.animation.BoneAxis;
import zombie.core.skinnedmodel.animation.IAnimListener;
import zombie.core.skinnedmodel.animation.Keyframe;
import zombie.core.skinnedmodel.model.SkinningBone;
import zombie.core.skinnedmodel.model.SkinningData;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.iso.Vector2;
import zombie.network.GameServer;
import zombie.network.ServerGUI;
import zombie.util.Lambda;
import zombie.util.Pool;
import zombie.util.PooledArrayObject;
import zombie.util.PooledFloatArrayObject;
import zombie.util.PooledObject;
import zombie.util.StringUtils;
import zombie.util.lambda.Consumers;
import zombie.util.list.PZArrayUtil;

public final class AnimationTrack
extends PooledObject {
    public boolean IsPlaying;
    protected AnimationClip CurrentClip;
    public int priority;
    private float currentTimeValue;
    private float previousTimeValue;
    public boolean SyncTrackingEnabled;
    public boolean reverse;
    private boolean bLooping;
    private final KeyframeSpan[] m_pose = new KeyframeSpan[60];
    private final KeyframeSpan m_deferredPoseSpan = new KeyframeSpan();
    public float SpeedDelta;
    public float BlendDelta;
    public float blendFieldWeight;
    public String name;
    public float earlyBlendOutTime;
    public boolean triggerOnNonLoopedAnimFadeOutEvent;
    private int m_layerIdx;
    private PooledArrayObject<AnimBoneWeight> m_boneWeightBindings;
    private PooledFloatArrayObject m_boneWeights;
    private final ArrayList<IAnimListener> listeners = new ArrayList();
    private final ArrayList<IAnimListener> listenersInvoking = new ArrayList();
    private SkinningBone m_deferredBone;
    private BoneAxis m_deferredBoneAxis;
    private boolean m_useDeferredRotation;
    private final DeferredMotionData m_deferredMotion = new DeferredMotionData();
    private static final Pool<AnimationTrack> s_pool = new Pool<AnimationTrack>(AnimationTrack::new);

    public static AnimationTrack alloc() {
        return s_pool.alloc();
    }

    protected AnimationTrack() {
        PZArrayUtil.arrayPopulate(this.m_pose, KeyframeSpan::new);
        this.resetInternal();
    }

    private AnimationTrack resetInternal() {
        this.IsPlaying = false;
        this.CurrentClip = null;
        this.priority = 0;
        this.currentTimeValue = 0.0f;
        this.previousTimeValue = 0.0f;
        this.SyncTrackingEnabled = true;
        this.reverse = false;
        this.bLooping = false;
        PZArrayUtil.forEach(this.m_pose, KeyframeSpan::clear);
        this.m_deferredPoseSpan.clear();
        this.SpeedDelta = 1.0f;
        this.BlendDelta = 0.0f;
        this.blendFieldWeight = 0.0f;
        this.name = "!Empty!";
        this.earlyBlendOutTime = 0.0f;
        this.triggerOnNonLoopedAnimFadeOutEvent = false;
        this.m_layerIdx = -1;
        Pool.tryRelease(this.m_boneWeightBindings);
        this.m_boneWeightBindings = null;
        Pool.tryRelease(this.m_boneWeights);
        this.m_boneWeights = null;
        this.listeners.clear();
        this.listenersInvoking.clear();
        this.m_deferredBone = null;
        this.m_deferredBoneAxis = BoneAxis.Y;
        this.m_useDeferredRotation = false;
        this.m_deferredMotion.reset();
        return this;
    }

    public void get(int n, Vector3f vector3f, Quaternion quaternion, Vector3f vector3f2) {
        this.m_pose[n].lerp(this.getCurrentTime(), vector3f, quaternion, vector3f2);
    }

    private Keyframe getDeferredMovementFrameAt(int n, float f, Keyframe keyframe) {
        KeyframeSpan keyframeSpan = this.getKeyframeSpan(n, f, this.m_deferredPoseSpan);
        return keyframeSpan.lerp(f, keyframe);
    }

    private KeyframeSpan getKeyframeSpan(int n, float f, KeyframeSpan keyframeSpan) {
        Keyframe[] keyframeArray;
        if (!keyframeSpan.isBone(n)) {
            keyframeSpan.clear();
        }
        if ((keyframeArray = this.CurrentClip.getBoneFramesAt(n)).length == 0) {
            keyframeSpan.clear();
            return keyframeSpan;
        }
        if (keyframeSpan.containsTime(f)) {
            return keyframeSpan;
        }
        Keyframe keyframe = keyframeArray[keyframeArray.length - 1];
        if (f >= keyframe.Time) {
            keyframeSpan.fromIdx = keyframeArray.length - 2;
            keyframeSpan.toIdx = keyframeArray.length - 1;
            keyframeSpan.from = keyframeArray[keyframeSpan.fromIdx];
            keyframeSpan.to = keyframeArray[keyframeSpan.toIdx];
            return keyframeSpan;
        }
        Keyframe keyframe2 = keyframeArray[0];
        if (f <= keyframe2.Time) {
            keyframeSpan.clear();
            keyframeSpan.toIdx = 0;
            keyframeSpan.to = keyframe2;
            return keyframeSpan;
        }
        int n2 = 0;
        if (keyframeSpan.isSpan() && keyframeSpan.to.Time <= f) {
            n2 = keyframeSpan.toIdx;
        }
        keyframeSpan.clear();
        for (int i = n2; i < keyframeArray.length - 1; ++i) {
            Keyframe keyframe3 = keyframeArray[i];
            Keyframe keyframe4 = keyframeArray[i + 1];
            if (!(keyframe3.Time <= f) || !(f <= keyframe4.Time)) continue;
            keyframeSpan.fromIdx = i;
            keyframeSpan.toIdx = i + 1;
            keyframeSpan.from = keyframe3;
            keyframeSpan.to = keyframe4;
            break;
        }
        return keyframeSpan;
    }

    public void removeListener(IAnimListener iAnimListener) {
        this.listeners.remove(iAnimListener);
    }

    public void Update(float f) {
        try {
            this.UpdateKeyframes(f);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void UpdateKeyframes(float f) {
        s_performance.updateKeyframes.invokeAndMeasure(this, Float.valueOf(f), AnimationTrack::updateKeyframesInternal);
    }

    private void updateKeyframesInternal(float f) {
        if (this.CurrentClip == null) {
            throw new RuntimeException("AnimationPlayer.Update was called before startClip");
        }
        if (f > 0.0f) {
            this.TickCurrentTime(f);
        }
        if (!GameServer.bServer || ServerGUI.isCreated()) {
            this.updatePose();
        }
        this.updateDeferredValues();
    }

    private void updatePose() {
        s_performance.updatePose.invokeAndMeasure(this, AnimationTrack::updatePoseInternal);
    }

    private void updatePoseInternal() {
        float f = this.getCurrentTime();
        for (int i = 0; i < 60; ++i) {
            this.getKeyframeSpan(i, f, this.m_pose[i]);
        }
    }

    private void updateDeferredValues() {
        s_performance.updateDeferredValues.invokeAndMeasure(this, AnimationTrack::updateDeferredValuesInternal);
    }

    private void updateDeferredValuesInternal() {
        if (this.m_deferredBone == null) {
            return;
        }
        DeferredMotionData deferredMotionData = this.m_deferredMotion;
        deferredMotionData.m_deferredRotationDiff = 0.0f;
        deferredMotionData.m_deferredMovementDiff.set(0.0f, 0.0f);
        deferredMotionData.m_counterRotatedMovementDiff.set(0.0f, 0.0f);
        float f = this.getReversibleTimeValue(this.previousTimeValue);
        float f2 = this.getReversibleTimeValue(this.currentTimeValue);
        if (this.isLooping() && f > f2) {
            float f3 = this.getDuration();
            this.appendDeferredValues(deferredMotionData, f, f3);
            f = 0.0f;
        }
        this.appendDeferredValues(deferredMotionData, f, f2);
    }

    private void appendDeferredValues(DeferredMotionData deferredMotionData, float f, float f2) {
        Keyframe keyframe = this.getDeferredMovementFrameAt(this.m_deferredBone.Index, f, L_updateDeferredValues.prevKeyFrame);
        Keyframe keyframe2 = this.getDeferredMovementFrameAt(this.m_deferredBone.Index, f2, L_updateDeferredValues.keyFrame);
        if (!GameServer.bServer) {
            deferredMotionData.m_prevDeferredRotation = this.getDeferredTwistRotation(keyframe.Rotation);
            deferredMotionData.m_targetDeferredRotationQ.set((ReadableVector4f)keyframe2.Rotation);
            deferredMotionData.m_targetDeferredRotation = this.getDeferredTwistRotation(keyframe2.Rotation);
            float f3 = PZMath.getClosestAngle(deferredMotionData.m_prevDeferredRotation, deferredMotionData.m_targetDeferredRotation);
            deferredMotionData.m_deferredRotationDiff += f3;
        }
        this.getDeferredMovement(keyframe.Position, deferredMotionData.m_prevDeferredMovement);
        deferredMotionData.m_targetDeferredPosition.set((ReadableVector3f)keyframe2.Position);
        this.getDeferredMovement(keyframe2.Position, deferredMotionData.m_targetDeferredMovement);
        Vector2 vector22 = L_updateDeferredValues.diff.set(deferredMotionData.m_targetDeferredMovement.x - deferredMotionData.m_prevDeferredMovement.x, deferredMotionData.m_targetDeferredMovement.y - deferredMotionData.m_prevDeferredMovement.y);
        Vector2 vector23 = L_updateDeferredValues.crDiff.set(vector22);
        if (this.getUseDeferredRotation()) {
            float f4 = vector23.normalize();
            vector23.rotate(-(deferredMotionData.m_targetDeferredRotation + 1.5707964f));
            vector23.scale(-f4);
        }
        deferredMotionData.m_deferredMovementDiff.x += vector22.x;
        deferredMotionData.m_deferredMovementDiff.y += vector22.y;
        deferredMotionData.m_counterRotatedMovementDiff.x += vector23.x;
        deferredMotionData.m_counterRotatedMovementDiff.y += vector23.y;
    }

    public float getDeferredTwistRotation(Quaternion quaternion) {
        if (this.m_deferredBoneAxis == BoneAxis.Z) {
            return HelperFunctions.getRotationZ(quaternion);
        }
        if (this.m_deferredBoneAxis == BoneAxis.Y) {
            return HelperFunctions.getRotationY(quaternion);
        }
        DebugLog.Animation.error("BoneAxis unhandled: %s", String.valueOf((Object)this.m_deferredBoneAxis));
        return 0.0f;
    }

    public Vector2 getDeferredMovement(Vector3f vector3f, Vector2 vector22) {
        if (this.m_deferredBoneAxis == BoneAxis.Y) {
            vector22.set(vector3f.x, -vector3f.z);
        } else {
            vector22.set(vector3f.x, vector3f.y);
        }
        return vector22;
    }

    public Vector3f getCurrentDeferredCounterPosition(Vector3f vector3f) {
        this.getCurrentDeferredPosition(vector3f);
        if (this.m_deferredBoneAxis == BoneAxis.Y) {
            vector3f.set(-vector3f.x, 0.0f, vector3f.z);
        } else {
            vector3f.set(-vector3f.x, -vector3f.y, 0.0f);
        }
        return vector3f;
    }

    public float getCurrentDeferredRotation() {
        return this.m_deferredMotion.m_targetDeferredRotation;
    }

    public Vector3f getCurrentDeferredPosition(Vector3f vector3f) {
        vector3f.set((ReadableVector3f)this.m_deferredMotion.m_targetDeferredPosition);
        return vector3f;
    }

    public int getDeferredMovementBoneIdx() {
        if (this.m_deferredBone != null) {
            return this.m_deferredBone.Index;
        }
        return -1;
    }

    public float getCurrentTime() {
        return this.getReversibleTimeValue(this.currentTimeValue);
    }

    public float getPreviousTime() {
        return this.getReversibleTimeValue(this.previousTimeValue);
    }

    private float getReversibleTimeValue(float f) {
        if (this.reverse) {
            return this.getDuration() - f;
        }
        return f;
    }

    protected void TickCurrentTime(float f) {
        s_performance.tickCurrentTime.invokeAndMeasure(this, Float.valueOf(f), AnimationTrack::tickCurrentTimeInternal);
    }

    private void tickCurrentTimeInternal(float f) {
        float f2;
        f *= this.SpeedDelta;
        if (!this.IsPlaying) {
            f = 0.0f;
        }
        float f3 = this.getDuration();
        this.previousTimeValue = this.currentTimeValue;
        this.currentTimeValue += f;
        if (this.bLooping) {
            if (this.previousTimeValue == 0.0f && this.currentTimeValue > 0.0f) {
                this.invokeOnAnimStartedEvent();
            }
            if (this.currentTimeValue >= f3) {
                this.invokeOnLoopedAnimEvent();
                this.currentTimeValue %= f3;
                this.invokeOnAnimStartedEvent();
            }
            return;
        }
        if (this.currentTimeValue < 0.0f) {
            this.currentTimeValue = 0.0f;
        }
        if (this.previousTimeValue == 0.0f && this.currentTimeValue > 0.0f) {
            this.invokeOnAnimStartedEvent();
        }
        if (this.triggerOnNonLoopedAnimFadeOutEvent && this.previousTimeValue < (f2 = f3 - this.earlyBlendOutTime) && f2 <= this.currentTimeValue) {
            this.invokeOnNonLoopedAnimFadeOutEvent();
        }
        if (this.currentTimeValue > f3) {
            this.currentTimeValue = f3;
        }
        if (this.previousTimeValue < f3 && this.currentTimeValue >= f3) {
            this.invokeOnLoopedAnimEvent();
            this.invokeOnNonLoopedAnimFinishedEvent();
        }
    }

    public float getDuration() {
        if (this.hasClip()) {
            return this.CurrentClip.Duration;
        }
        return 0.0f;
    }

    private void invokeListeners(Consumer<IAnimListener> consumer) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.listenersInvoking.clear();
        this.listenersInvoking.addAll(this.listeners);
        for (int i = 0; i < this.listenersInvoking.size(); ++i) {
            IAnimListener iAnimListener = this.listenersInvoking.get(i);
            consumer.accept(iAnimListener);
        }
    }

    private <T1> void invokeListeners(T1 T1, Consumers.Params1.ICallback<IAnimListener, T1> iCallback2) {
        Lambda.capture(this, T1, iCallback2, (genericStack, animationTrack, object, iCallback) -> animationTrack.invokeListeners(genericStack.consumer(object, iCallback)));
    }

    protected void invokeOnAnimStartedEvent() {
        this.invokeListeners(this, IAnimListener::onAnimStarted);
    }

    protected void invokeOnLoopedAnimEvent() {
        this.invokeListeners(this, IAnimListener::onLoopedAnim);
    }

    protected void invokeOnNonLoopedAnimFadeOutEvent() {
        this.invokeListeners(this, IAnimListener::onNonLoopedAnimFadeOut);
    }

    protected void invokeOnNonLoopedAnimFinishedEvent() {
        this.invokeListeners(this, IAnimListener::onNonLoopedAnimFinished);
    }

    @Override
    public void onReleased() {
        if (!this.listeners.isEmpty()) {
            this.listenersInvoking.clear();
            this.listenersInvoking.addAll(this.listeners);
            for (int i = 0; i < this.listenersInvoking.size(); ++i) {
                IAnimListener iAnimListener = this.listenersInvoking.get(i);
                iAnimListener.onTrackDestroyed(this);
            }
            this.listeners.clear();
            this.listenersInvoking.clear();
        }
        this.reset();
    }

    public Vector2 getDeferredMovementDiff(Vector2 vector22) {
        vector22.set(this.m_deferredMotion.m_counterRotatedMovementDiff);
        return vector22;
    }

    public float getDeferredRotationDiff() {
        return this.m_deferredMotion.m_deferredRotationDiff;
    }

    public float getClampedBlendDelta() {
        return PZMath.clamp(this.BlendDelta, 0.0f, 1.0f);
    }

    public void addListener(IAnimListener iAnimListener) {
        this.listeners.add(iAnimListener);
    }

    public void startClip(AnimationClip animationClip, boolean bl) {
        if (animationClip == null) {
            throw new NullPointerException("Supplied clip is null.");
        }
        this.reset();
        this.IsPlaying = true;
        this.bLooping = bl;
        this.CurrentClip = animationClip;
    }

    public AnimationTrack reset() {
        return this.resetInternal();
    }

    public void setBoneWeights(List<AnimBoneWeight> list) {
        this.m_boneWeightBindings = PooledAnimBoneWeightArray.toArray(list);
        this.m_boneWeights = null;
    }

    public void initBoneWeights(SkinningData skinningData) {
        if (this.hasBoneMask()) {
            return;
        }
        if (this.m_boneWeightBindings == null) {
            return;
        }
        if (this.m_boneWeightBindings.isEmpty()) {
            this.m_boneWeights = PooledFloatArrayObject.alloc(0);
            return;
        }
        this.m_boneWeights = PooledFloatArrayObject.alloc(skinningData.numBones());
        PZArrayUtil.arraySet(this.m_boneWeights.array(), 0.0f);
        for (int i = 0; i < this.m_boneWeightBindings.length(); ++i) {
            AnimBoneWeight animBoneWeight = this.m_boneWeightBindings.get(i);
            this.initWeightBinding(skinningData, animBoneWeight);
        }
    }

    protected void initWeightBinding(SkinningData skinningData, AnimBoneWeight animBoneWeight) {
        if (animBoneWeight == null || StringUtils.isNullOrEmpty(animBoneWeight.boneName)) {
            return;
        }
        String string = animBoneWeight.boneName;
        SkinningBone skinningBone2 = skinningData.getBone(string);
        if (skinningBone2 == null) {
            DebugLog.Animation.error("Bone not found: %s", string);
            return;
        }
        float f2 = animBoneWeight.weight;
        this.assignBoneWeight(f2, skinningBone2.Index);
        if (animBoneWeight.includeDescendants) {
            Lambda.forEach(skinningBone2::forEachDescendant, this, Float.valueOf(f2), (skinningBone, animationTrack, f) -> animationTrack.assignBoneWeight(f.floatValue(), skinningBone.Index));
        }
    }

    private void assignBoneWeight(float f, int n) {
        if (!this.hasBoneMask()) {
            throw new NullPointerException("Bone weights array not initialized.");
        }
        float f2 = this.m_boneWeights.get(n);
        this.m_boneWeights.set(n, Math.max(f, f2));
    }

    public float getBoneWeight(int n) {
        if (!this.hasBoneMask()) {
            return 1.0f;
        }
        if (DebugOptions.instance.Character.Debug.Animate.NoBoneMasks.getValue()) {
            return 1.0f;
        }
        return PZArrayUtil.getOrDefault(this.m_boneWeights.array(), n, 0.0f);
    }

    public float getDeferredBoneWeight() {
        if (this.m_deferredBone == null) {
            return 0.0f;
        }
        return this.getBoneWeight(this.m_deferredBone.Index);
    }

    public void setLayerIdx(int n) {
        this.m_layerIdx = n;
    }

    public int getLayerIdx() {
        return this.m_layerIdx;
    }

    public boolean hasBoneMask() {
        return this.m_boneWeights != null;
    }

    public boolean isLooping() {
        return this.bLooping;
    }

    public void setDeferredBone(SkinningBone skinningBone, BoneAxis boneAxis) {
        this.m_deferredBone = skinningBone;
        this.m_deferredBoneAxis = boneAxis;
    }

    public void setUseDeferredRotation(boolean bl) {
        this.m_useDeferredRotation = bl;
    }

    public boolean getUseDeferredRotation() {
        return this.m_useDeferredRotation;
    }

    public boolean isFinished() {
        return !this.bLooping && this.getDuration() > 0.0f && this.currentTimeValue >= this.getDuration();
    }

    public float getCurrentTimeValue() {
        return this.currentTimeValue;
    }

    public void setCurrentTimeValue(float f) {
        this.currentTimeValue = f;
    }

    public float getPreviousTimeValue() {
        return this.previousTimeValue;
    }

    public void setPreviousTimeValue(float f) {
        this.previousTimeValue = f;
    }

    public void rewind(float f) {
        this.advance(-f);
    }

    public void scaledRewind(float f) {
        this.scaledAdvance(-f);
    }

    public void scaledAdvance(float f) {
        this.advance(f * this.SpeedDelta);
    }

    public void advance(float f) {
        this.currentTimeValue = PZMath.wrap(this.currentTimeValue + f, 0.0f, this.getDuration());
        this.previousTimeValue = PZMath.wrap(this.previousTimeValue + f, 0.0f, this.getDuration());
    }

    public void advanceFraction(float f) {
        this.advance(this.getDuration() * f);
    }

    public void moveCurrentTimeValueTo(float f) {
        float f2 = f - this.currentTimeValue;
        this.advance(f2);
    }

    public void moveCurrentTimeValueToFraction(float f) {
        float f2 = this.getDuration() * f;
        this.moveCurrentTimeValueTo(f2);
    }

    public float getCurrentTimeFraction() {
        if (this.hasClip()) {
            return this.currentTimeValue / this.getDuration();
        }
        return 0.0f;
    }

    public boolean hasClip() {
        return this.CurrentClip != null;
    }

    public AnimationClip getClip() {
        return this.CurrentClip;
    }

    public int getPriority() {
        return this.priority;
    }

    public static AnimationTrack createClone(AnimationTrack animationTrack, Supplier<AnimationTrack> supplier) {
        AnimationTrack animationTrack2 = supplier.get();
        animationTrack2.IsPlaying = animationTrack.IsPlaying;
        animationTrack2.CurrentClip = animationTrack.CurrentClip;
        animationTrack2.priority = animationTrack.priority;
        animationTrack2.currentTimeValue = animationTrack.currentTimeValue;
        animationTrack2.previousTimeValue = animationTrack.previousTimeValue;
        animationTrack2.SyncTrackingEnabled = animationTrack.SyncTrackingEnabled;
        animationTrack2.reverse = animationTrack.reverse;
        animationTrack2.bLooping = animationTrack.bLooping;
        animationTrack2.SpeedDelta = animationTrack.SpeedDelta;
        animationTrack2.BlendDelta = animationTrack.BlendDelta;
        animationTrack2.blendFieldWeight = animationTrack.blendFieldWeight;
        animationTrack2.name = animationTrack.name;
        animationTrack2.earlyBlendOutTime = animationTrack.earlyBlendOutTime;
        animationTrack2.triggerOnNonLoopedAnimFadeOutEvent = animationTrack.triggerOnNonLoopedAnimFadeOutEvent;
        animationTrack2.m_layerIdx = animationTrack.m_layerIdx;
        animationTrack2.m_boneWeightBindings = PooledAnimBoneWeightArray.toArray(animationTrack.m_boneWeightBindings);
        animationTrack2.m_boneWeights = PooledFloatArrayObject.toArray(animationTrack.m_boneWeights);
        animationTrack2.m_deferredBone = animationTrack.m_deferredBone;
        animationTrack2.m_deferredBoneAxis = animationTrack.m_deferredBoneAxis;
        animationTrack2.m_useDeferredRotation = animationTrack.m_useDeferredRotation;
        return animationTrack2;
    }

    private static class KeyframeSpan {
        Keyframe from;
        Keyframe to;
        int fromIdx = -1;
        int toIdx = -1;

        private KeyframeSpan() {
        }

        void clear() {
            this.from = null;
            this.to = null;
            this.fromIdx = -1;
            this.toIdx = -1;
        }

        Keyframe lerp(float f, Keyframe keyframe) {
            keyframe.setIdentity();
            if (this.from == null && this.to == null) {
                return keyframe;
            }
            if (this.to == null) {
                keyframe.set(this.from);
                return keyframe;
            }
            if (this.from == null) {
                keyframe.set(this.to);
                return keyframe;
            }
            return Keyframe.lerp(this.from, this.to, f, keyframe);
        }

        void lerp(float f, Vector3f vector3f, Quaternion quaternion, Vector3f vector3f2) {
            if (this.from == null && this.to == null) {
                Keyframe.setIdentity(vector3f, quaternion, vector3f2);
                return;
            }
            if (this.to == null) {
                this.from.get(vector3f, quaternion, vector3f2);
                return;
            }
            if (this.from == null) {
                this.to.get(vector3f, quaternion, vector3f2);
                return;
            }
            if (!PerformanceSettings.InterpolateAnims) {
                this.to.get(vector3f, quaternion, vector3f2);
                return;
            }
            Keyframe.lerp(this.from, this.to, f, vector3f, quaternion, vector3f2);
        }

        boolean isSpan() {
            return this.from != null && this.to != null;
        }

        boolean isPost() {
            return (this.from == null || this.to == null) && this.from != this.to;
        }

        boolean isEmpty() {
            return this.from == null && this.to == null;
        }

        boolean containsTime(float f) {
            return this.isSpan() && this.from.Time <= f && f <= this.to.Time;
        }

        public boolean isBone(int n) {
            return this.from != null && this.from.Bone == n || this.to != null && this.to.Bone == n;
        }
    }

    private static class DeferredMotionData {
        float m_targetDeferredRotation;
        float m_prevDeferredRotation;
        final Quaternion m_targetDeferredRotationQ = new Quaternion();
        final Vector3f m_targetDeferredPosition = new Vector3f();
        final Vector2 m_prevDeferredMovement = new Vector2();
        final Vector2 m_targetDeferredMovement = new Vector2();
        float m_deferredRotationDiff;
        final Vector2 m_deferredMovementDiff = new Vector2();
        final Vector2 m_counterRotatedMovementDiff = new Vector2();

        private DeferredMotionData() {
        }

        public void reset() {
            this.m_deferredRotationDiff = 0.0f;
            this.m_targetDeferredRotation = 0.0f;
            this.m_prevDeferredRotation = 0.0f;
            this.m_targetDeferredRotationQ.setIdentity();
            this.m_targetDeferredMovement.set(0.0f, 0.0f);
            this.m_targetDeferredPosition.set(0.0f, 0.0f, 0.0f);
            this.m_prevDeferredMovement.set(0.0f, 0.0f);
            this.m_deferredMovementDiff.set(0.0f, 0.0f);
            this.m_counterRotatedMovementDiff.set(0.0f, 0.0f);
        }
    }

    private static class s_performance {
        static final PerformanceProfileProbe tickCurrentTime = new PerformanceProfileProbe("AnimationTrack.tickCurrentTime");
        static final PerformanceProfileProbe updateKeyframes = new PerformanceProfileProbe("AnimationTrack.updateKeyframes");
        static final PerformanceProfileProbe updateDeferredValues = new PerformanceProfileProbe("AnimationTrack.updateDeferredValues");
        static final PerformanceProfileProbe updatePose = new PerformanceProfileProbe("AnimationTrack.updatePose");

        private s_performance() {
        }
    }

    private static class L_updateDeferredValues {
        static final Keyframe keyFrame = new Keyframe(new Vector3f(), new Quaternion(), new Vector3f(1.0f, 1.0f, 1.0f));
        static final Keyframe prevKeyFrame = new Keyframe(new Vector3f(), new Quaternion(), new Vector3f(1.0f, 1.0f, 1.0f));
        static final Vector2 crDiff = new Vector2();
        static final Vector2 diff = new Vector2();

        private L_updateDeferredValues() {
        }
    }

    private static class l_updatePoseInternal {
        static final KeyframeSpan span = new KeyframeSpan();

        private l_updatePoseInternal() {
        }
    }

    private static class l_getDeferredMovementFrameAt {
        static final KeyframeSpan span = new KeyframeSpan();

        private l_getDeferredMovementFrameAt() {
        }
    }
}

