/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.advancedanimation;

import java.util.Map;
import java.util.TreeMap;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableGenericSlot;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableHandle;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableSlotCallbackBool;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableSlotCallbackFloat;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableSlotCallbackInt;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableSlotCallbackString;
import zombie.core.skinnedmodel.advancedanimation.IAnimationVariableMap;
import zombie.core.skinnedmodel.advancedanimation.IAnimationVariableSlot;
import zombie.util.StringUtils;
import zombie.util.list.PZArrayUtil;

public class AnimationVariableSource
implements IAnimationVariableMap {
    private final Map<String, IAnimationVariableSlot> m_GameVariables = new TreeMap<String, IAnimationVariableSlot>(String.CASE_INSENSITIVE_ORDER);
    private IAnimationVariableSlot[] m_cachedGameVariableSlots = new IAnimationVariableSlot[0];

    @Override
    public IAnimationVariableSlot getVariable(AnimationVariableHandle animationVariableHandle) {
        if (animationVariableHandle == null) {
            return null;
        }
        int n = animationVariableHandle.getVariableIndex();
        if (n < 0) {
            return null;
        }
        if (this.m_cachedGameVariableSlots != null && n < this.m_cachedGameVariableSlots.length) {
            IAnimationVariableSlot iAnimationVariableSlot = this.m_cachedGameVariableSlots[n];
            if (iAnimationVariableSlot == null) {
                this.m_cachedGameVariableSlots[n] = this.m_GameVariables.get(animationVariableHandle.getVariableName());
                iAnimationVariableSlot = this.m_cachedGameVariableSlots[n];
            }
            return iAnimationVariableSlot;
        }
        IAnimationVariableSlot iAnimationVariableSlot = this.m_GameVariables.get(animationVariableHandle.getVariableName());
        if (iAnimationVariableSlot == null) {
            return null;
        }
        IAnimationVariableSlot[] iAnimationVariableSlotArray = new IAnimationVariableSlot[n + 1];
        IAnimationVariableSlot[] iAnimationVariableSlotArray2 = this.m_cachedGameVariableSlots;
        if (iAnimationVariableSlotArray2 != null) {
            this.m_cachedGameVariableSlots = PZArrayUtil.arrayCopy(iAnimationVariableSlotArray2, iAnimationVariableSlotArray, 0, iAnimationVariableSlotArray2.length);
        }
        iAnimationVariableSlotArray[n] = iAnimationVariableSlot;
        this.m_cachedGameVariableSlots = iAnimationVariableSlotArray;
        return iAnimationVariableSlot;
    }

    @Override
    public IAnimationVariableSlot getVariable(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return null;
        }
        String string2 = string.trim();
        return this.m_GameVariables.get(string2);
    }

    @Override
    public IAnimationVariableSlot getOrCreateVariable(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return null;
        }
        String string2 = string.trim();
        IAnimationVariableSlot iAnimationVariableSlot = this.m_GameVariables.get(string2);
        if (iAnimationVariableSlot == null) {
            iAnimationVariableSlot = new AnimationVariableGenericSlot(string2.toLowerCase());
            this.setVariable(iAnimationVariableSlot);
        }
        return iAnimationVariableSlot;
    }

    @Override
    public void setVariable(IAnimationVariableSlot iAnimationVariableSlot) {
        this.m_GameVariables.put(iAnimationVariableSlot.getKey(), iAnimationVariableSlot);
    }

    public void setVariable(String string, AnimationVariableSlotCallbackBool.CallbackGetStrongTyped callbackGetStrongTyped) {
        this.setVariable(new AnimationVariableSlotCallbackBool(string, callbackGetStrongTyped));
    }

    public void setVariable(String string, AnimationVariableSlotCallbackBool.CallbackGetStrongTyped callbackGetStrongTyped, AnimationVariableSlotCallbackBool.CallbackSetStrongTyped callbackSetStrongTyped) {
        this.setVariable(new AnimationVariableSlotCallbackBool(string, callbackGetStrongTyped, callbackSetStrongTyped));
    }

    public void setVariable(String string, AnimationVariableSlotCallbackString.CallbackGetStrongTyped callbackGetStrongTyped) {
        this.setVariable(new AnimationVariableSlotCallbackString(string, callbackGetStrongTyped));
    }

    public void setVariable(String string, AnimationVariableSlotCallbackString.CallbackGetStrongTyped callbackGetStrongTyped, AnimationVariableSlotCallbackString.CallbackSetStrongTyped callbackSetStrongTyped) {
        this.setVariable(new AnimationVariableSlotCallbackString(string, callbackGetStrongTyped, callbackSetStrongTyped));
    }

    public void setVariable(String string, AnimationVariableSlotCallbackFloat.CallbackGetStrongTyped callbackGetStrongTyped) {
        this.setVariable(new AnimationVariableSlotCallbackFloat(string, callbackGetStrongTyped));
    }

    public void setVariable(String string, AnimationVariableSlotCallbackFloat.CallbackGetStrongTyped callbackGetStrongTyped, AnimationVariableSlotCallbackFloat.CallbackSetStrongTyped callbackSetStrongTyped) {
        this.setVariable(new AnimationVariableSlotCallbackFloat(string, callbackGetStrongTyped, callbackSetStrongTyped));
    }

    public void setVariable(String string, AnimationVariableSlotCallbackInt.CallbackGetStrongTyped callbackGetStrongTyped) {
        this.setVariable(new AnimationVariableSlotCallbackInt(string, callbackGetStrongTyped));
    }

    public void setVariable(String string, AnimationVariableSlotCallbackInt.CallbackGetStrongTyped callbackGetStrongTyped, AnimationVariableSlotCallbackInt.CallbackSetStrongTyped callbackSetStrongTyped) {
        this.setVariable(new AnimationVariableSlotCallbackInt(string, callbackGetStrongTyped, callbackSetStrongTyped));
    }

    public void setVariable(String string, boolean bl, AnimationVariableSlotCallbackBool.CallbackGetStrongTyped callbackGetStrongTyped) {
        this.setVariable(new AnimationVariableSlotCallbackBool(string, bl, callbackGetStrongTyped));
    }

    public void setVariable(String string, boolean bl, AnimationVariableSlotCallbackBool.CallbackGetStrongTyped callbackGetStrongTyped, AnimationVariableSlotCallbackBool.CallbackSetStrongTyped callbackSetStrongTyped) {
        this.setVariable(new AnimationVariableSlotCallbackBool(string, bl, callbackGetStrongTyped, callbackSetStrongTyped));
    }

    public void setVariable(String string, String string2, AnimationVariableSlotCallbackString.CallbackGetStrongTyped callbackGetStrongTyped) {
        this.setVariable(new AnimationVariableSlotCallbackString(string, string2, callbackGetStrongTyped));
    }

    public void setVariable(String string, String string2, AnimationVariableSlotCallbackString.CallbackGetStrongTyped callbackGetStrongTyped, AnimationVariableSlotCallbackString.CallbackSetStrongTyped callbackSetStrongTyped) {
        this.setVariable(new AnimationVariableSlotCallbackString(string, string2, callbackGetStrongTyped, callbackSetStrongTyped));
    }

    public void setVariable(String string, float f, AnimationVariableSlotCallbackFloat.CallbackGetStrongTyped callbackGetStrongTyped) {
        this.setVariable(new AnimationVariableSlotCallbackFloat(string, f, callbackGetStrongTyped));
    }

    public void setVariable(String string, float f, AnimationVariableSlotCallbackFloat.CallbackGetStrongTyped callbackGetStrongTyped, AnimationVariableSlotCallbackFloat.CallbackSetStrongTyped callbackSetStrongTyped) {
        this.setVariable(new AnimationVariableSlotCallbackFloat(string, f, callbackGetStrongTyped, callbackSetStrongTyped));
    }

    public void setVariable(String string, int n, AnimationVariableSlotCallbackInt.CallbackGetStrongTyped callbackGetStrongTyped) {
        this.setVariable(new AnimationVariableSlotCallbackInt(string, n, callbackGetStrongTyped));
    }

    public void setVariable(String string, int n, AnimationVariableSlotCallbackInt.CallbackGetStrongTyped callbackGetStrongTyped, AnimationVariableSlotCallbackInt.CallbackSetStrongTyped callbackSetStrongTyped) {
        this.setVariable(new AnimationVariableSlotCallbackInt(string, n, callbackGetStrongTyped, callbackSetStrongTyped));
    }

    @Override
    public void setVariable(String string, String string2) {
        this.getOrCreateVariable(string).setValue(string2);
    }

    @Override
    public void setVariable(String string, boolean bl) {
        this.getOrCreateVariable(string).setValue(bl);
    }

    @Override
    public void setVariable(String string, float f) {
        this.getOrCreateVariable(string).setValue(f);
    }

    @Override
    public void clearVariable(String string) {
        IAnimationVariableSlot iAnimationVariableSlot = this.getVariable(string);
        if (iAnimationVariableSlot != null) {
            iAnimationVariableSlot.clear();
        }
    }

    @Override
    public void clearVariables() {
        for (IAnimationVariableSlot iAnimationVariableSlot : this.getGameVariables()) {
            iAnimationVariableSlot.clear();
        }
    }

    @Override
    public String getVariableString(String string) {
        IAnimationVariableSlot iAnimationVariableSlot = this.getVariable(string);
        return iAnimationVariableSlot != null ? iAnimationVariableSlot.getValueString() : "";
    }

    @Override
    public float getVariableFloat(String string, float f) {
        IAnimationVariableSlot iAnimationVariableSlot = this.getVariable(string);
        return iAnimationVariableSlot != null ? iAnimationVariableSlot.getValueFloat() : f;
    }

    @Override
    public boolean getVariableBoolean(String string) {
        IAnimationVariableSlot iAnimationVariableSlot = this.getVariable(string);
        return iAnimationVariableSlot != null && iAnimationVariableSlot.getValueBool();
    }

    @Override
    public boolean getVariableBoolean(String string, boolean bl) {
        IAnimationVariableSlot iAnimationVariableSlot = this.getVariable(string);
        return iAnimationVariableSlot != null ? iAnimationVariableSlot.getValueBool() : bl;
    }

    @Override
    public Iterable<IAnimationVariableSlot> getGameVariables() {
        return this.m_GameVariables.values();
    }

    @Override
    public boolean isVariable(String string, String string2) {
        return StringUtils.equalsIgnoreCase(this.getVariableString(string), string2);
    }

    @Override
    public boolean containsVariable(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return false;
        }
        String string2 = string.trim();
        return this.m_GameVariables.containsKey(string2);
    }
}

