/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.advancedanimation;

import zombie.core.math.PZMath;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableSlot;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableType;

public final class AnimationVariableSlotFloat
extends AnimationVariableSlot {
    private float m_value = 0.0f;

    public AnimationVariableSlotFloat(String string) {
        super(string);
    }

    @Override
    public String getValueString() {
        return String.valueOf(this.m_value);
    }

    @Override
    public float getValueFloat() {
        return this.m_value;
    }

    @Override
    public boolean getValueBool() {
        return this.m_value != 0.0f;
    }

    @Override
    public void setValue(String string) {
        this.m_value = PZMath.tryParseFloat(string, 0.0f);
    }

    @Override
    public void setValue(float f) {
        this.m_value = f;
    }

    @Override
    public void setValue(boolean bl) {
        this.m_value = bl ? 1.0f : 0.0f;
    }

    @Override
    public AnimationVariableType getType() {
        return AnimationVariableType.Float;
    }

    @Override
    public boolean canConvertFrom(String string) {
        return PZMath.canParseFloat(string);
    }

    @Override
    public void clear() {
        this.m_value = 0.0f;
    }
}

