/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.advancedanimation;

import zombie.core.skinnedmodel.advancedanimation.AnimationVariableSlot;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableType;
import zombie.util.StringUtils;

public final class AnimationVariableSlotBool
extends AnimationVariableSlot {
    private boolean m_value;

    public AnimationVariableSlotBool(String string) {
        super(string);
    }

    @Override
    public String getValueString() {
        return this.m_value ? "true" : "false";
    }

    @Override
    public float getValueFloat() {
        return this.m_value ? 1.0f : 0.0f;
    }

    @Override
    public boolean getValueBool() {
        return this.m_value;
    }

    @Override
    public void setValue(String string) {
        this.m_value = StringUtils.tryParseBoolean(string);
    }

    @Override
    public void setValue(float f) {
        this.m_value = (double)f != 0.0;
    }

    @Override
    public void setValue(boolean bl) {
        this.m_value = bl;
    }

    @Override
    public AnimationVariableType getType() {
        return AnimationVariableType.Boolean;
    }

    @Override
    public boolean canConvertFrom(String string) {
        return StringUtils.isBoolean(string);
    }

    @Override
    public void clear() {
        this.m_value = false;
    }
}

