/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.advancedanimation;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import zombie.ZomboidFileSystem;
import zombie.core.skinnedmodel.advancedanimation.AnimState;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;

public final class AnimationSet {
    protected static final HashMap<String, AnimationSet> setMap = new HashMap();
    public final HashMap<String, AnimState> states = new HashMap();
    public String m_Name = "";

    public static AnimationSet GetAnimationSet(String string, boolean bl) {
        AnimationSet animationSet = setMap.get(string);
        if (animationSet != null && !bl) {
            return animationSet;
        }
        animationSet = new AnimationSet();
        animationSet.Load(string);
        setMap.put(string, animationSet);
        return animationSet;
    }

    public static void Reset() {
        for (AnimationSet animationSet : setMap.values()) {
            animationSet.clear();
        }
        setMap.clear();
    }

    public AnimState GetState(String string) {
        AnimState animState = this.states.get(string.toLowerCase(Locale.ENGLISH));
        if (animState != null) {
            return animState;
        }
        DebugLog.Animation.warn("AnimState not found: " + string);
        animState = new AnimState();
        return animState;
    }

    public boolean containsState(String string) {
        return this.states.containsKey(string.toLowerCase(Locale.ENGLISH));
    }

    public boolean Load(String string) {
        String[] stringArray;
        if (DebugLog.isEnabled(DebugType.Animation)) {
            DebugLog.Animation.println("Loading AnimSet: " + string);
        }
        this.m_Name = string;
        for (String string2 : stringArray = ZomboidFileSystem.instance.resolveAllDirectories("media/AnimSets/" + string, file -> true, false)) {
            String string3 = new File(string2).getName();
            AnimState animState = AnimState.Parse(string3, string2);
            animState.m_Set = this;
            this.states.put(string3, animState);
        }
        return true;
    }

    private void clear() {
        for (AnimState animState : this.states.values()) {
            animState.clear();
        }
        this.states.clear();
    }
}

