/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.advancedanimation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import zombie.DebugFileWatcher;
import zombie.GameProfiler;
import zombie.Lua.LuaManager;
import zombie.PredicatedFileWatcher;
import zombie.ZomboidFileSystem;
import zombie.characters.CharacterActionAnims;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.core.skinnedmodel.advancedanimation.AnimCondition;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.core.skinnedmodel.advancedanimation.AnimLayer;
import zombie.core.skinnedmodel.advancedanimation.AnimNode;
import zombie.core.skinnedmodel.advancedanimation.AnimState;
import zombie.core.skinnedmodel.advancedanimation.AnimationSet;
import zombie.core.skinnedmodel.advancedanimation.IAnimEventCallback;
import zombie.core.skinnedmodel.advancedanimation.IAnimatable;
import zombie.core.skinnedmodel.advancedanimation.IAnimationVariableSlot;
import zombie.core.skinnedmodel.advancedanimation.LiveAnimNode;
import zombie.core.skinnedmodel.advancedanimation.debug.AnimatorDebugMonitor;
import zombie.core.skinnedmodel.animation.debug.AnimationPlayerRecorder;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.gameStates.ChooseGameInfo;
import zombie.util.Lambda;
import zombie.util.PZXmlParserException;
import zombie.util.PZXmlUtil;
import zombie.util.list.PZArrayList;
import zombie.util.list.PZArrayUtil;

public final class AdvancedAnimator
implements IAnimEventCallback {
    private IAnimatable character;
    public AnimationSet animSet;
    public final ArrayList<IAnimEventCallback> animCallbackHandlers = new ArrayList();
    private AnimLayer m_rootLayer = null;
    private final List<SubLayerSlot> m_subLayers = new ArrayList<SubLayerSlot>();
    public static float s_MotionScale = 0.76f;
    public static float s_RotationScale = 0.76f;
    private AnimatorDebugMonitor debugMonitor;
    private static long animSetModificationTime = -1L;
    private static long actionGroupModificationTime = -1L;
    private AnimationPlayerRecorder m_recorder = null;

    public static void systemInit() {
        DebugFileWatcher.instance.add(new PredicatedFileWatcher("media/AnimSets", AdvancedAnimator::isAnimSetFilePath, AdvancedAnimator::onAnimSetsRefreshTriggered));
        DebugFileWatcher.instance.add(new PredicatedFileWatcher("media/actiongroups", AdvancedAnimator::isActionGroupFilePath, AdvancedAnimator::onActionGroupsRefreshTriggered));
        AdvancedAnimator.LoadDefaults();
    }

    private static boolean isAnimSetFilePath(String string) {
        if (string == null) {
            return false;
        }
        if (!string.endsWith(".xml")) {
            return false;
        }
        ArrayList<String> arrayList = ZomboidFileSystem.instance.getModIDs();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i);
            ChooseGameInfo.Mod mod = ChooseGameInfo.getModDetails(string2);
            if (mod == null || mod.animSetsFile == null || !string.startsWith(mod.animSetsFile.getPath())) continue;
            return true;
        }
        String string3 = ZomboidFileSystem.instance.getAnimSetsPath();
        return string.startsWith(string3);
    }

    private static boolean isActionGroupFilePath(String string) {
        if (string == null) {
            return false;
        }
        if (!string.endsWith(".xml")) {
            return false;
        }
        ArrayList<String> arrayList = ZomboidFileSystem.instance.getModIDs();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i);
            ChooseGameInfo.Mod mod = ChooseGameInfo.getModDetails(string2);
            if (mod == null || mod.actionGroupsFile == null || !string.startsWith(mod.actionGroupsFile.getPath())) continue;
            return true;
        }
        String string3 = ZomboidFileSystem.instance.getActionGroupsPath();
        return string.startsWith(string3);
    }

    private static void onActionGroupsRefreshTriggered(String string) {
        DebugLog.General.println("DebugFileWatcher Hit. ActionGroups: " + string);
        actionGroupModificationTime = System.currentTimeMillis() + 1000L;
    }

    private static void onAnimSetsRefreshTriggered(String string) {
        DebugLog.General.println("DebugFileWatcher Hit. AnimSets: " + string);
        animSetModificationTime = System.currentTimeMillis() + 1000L;
    }

    public static void checkModifiedFiles() {
        if (animSetModificationTime != -1L && animSetModificationTime < System.currentTimeMillis()) {
            DebugLog.General.println("Refreshing AnimSets.");
            animSetModificationTime = -1L;
            AdvancedAnimator.LoadDefaults();
            LuaManager.GlobalObject.refreshAnimSets(true);
        }
        if (actionGroupModificationTime != -1L && actionGroupModificationTime < System.currentTimeMillis()) {
            DebugLog.General.println("Refreshing action groups.");
            actionGroupModificationTime = -1L;
            LuaManager.GlobalObject.reloadActionGroups();
        }
    }

    private static void LoadDefaults() {
        try {
            Element element = PZXmlUtil.parseXml("media/AnimSets/Defaults.xml");
            String string = element.getElementsByTagName("MotionScale").item(0).getTextContent();
            s_MotionScale = Float.parseFloat(string);
            String string2 = element.getElementsByTagName("RotationScale").item(0).getTextContent();
            s_RotationScale = Float.parseFloat(string2);
        }
        catch (PZXmlParserException pZXmlParserException) {
            DebugLog.General.error("Exception thrown: " + pZXmlParserException);
            pZXmlParserException.printStackTrace();
        }
    }

    public String GetDebug() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GameState: ");
        if (this.character instanceof IsoGameCharacter) {
            IsoGameCharacter isoGameCharacter = (IsoGameCharacter)this.character;
            stringBuilder.append(isoGameCharacter.getCurrentState() == null ? "null" : isoGameCharacter.getCurrentState().getClass().getSimpleName()).append("\n");
        }
        if (this.m_rootLayer != null) {
            stringBuilder.append("Layer: ").append(0).append("\n");
            stringBuilder.append(this.m_rootLayer.GetDebugString()).append("\n");
        }
        stringBuilder.append("Variables:\n");
        stringBuilder.append("Weapon: ").append(this.character.getVariableString("weapon")).append("\n");
        stringBuilder.append("Aim: ").append(this.character.getVariableString("aim")).append("\n");
        for (IAnimationVariableSlot iAnimationVariableSlot : this.character.getGameVariables()) {
            stringBuilder.append("  ").append(iAnimationVariableSlot.getKey()).append(" : ").append(iAnimationVariableSlot.getValueString()).append("\n");
        }
        return stringBuilder.toString();
    }

    public void OnAnimDataChanged(boolean bl) {
        if (bl && this.character instanceof IsoGameCharacter) {
            IsoGameCharacter isoGameCharacter = (IsoGameCharacter)this.character;
            ++isoGameCharacter.getStateMachine().activeStateChanged;
            isoGameCharacter.setDefaultState();
            if (isoGameCharacter instanceof IsoZombie) {
                isoGameCharacter.setOnFloor(false);
            }
            --isoGameCharacter.getStateMachine().activeStateChanged;
        }
        this.SetAnimSet(AnimationSet.GetAnimationSet(this.character.GetAnimSetName(), false));
        if (this.character.getAnimationPlayer() != null) {
            this.character.getAnimationPlayer().reset();
        }
        if (this.m_rootLayer != null) {
            this.m_rootLayer.Reset();
        }
        for (int i = 0; i < this.m_subLayers.size(); ++i) {
            SubLayerSlot subLayerSlot = this.m_subLayers.get(i);
            subLayerSlot.animLayer.Reset();
        }
    }

    public void Reload() {
    }

    public void init(IAnimatable iAnimatable) {
        this.character = iAnimatable;
        this.m_rootLayer = new AnimLayer(iAnimatable, this);
    }

    public void SetAnimSet(AnimationSet animationSet) {
        this.animSet = animationSet;
    }

    @Override
    public void OnAnimEvent(AnimLayer animLayer, AnimEvent animEvent) {
        for (int i = 0; i < this.animCallbackHandlers.size(); ++i) {
            IAnimEventCallback iAnimEventCallback = this.animCallbackHandlers.get(i);
            iAnimEventCallback.OnAnimEvent(animLayer, animEvent);
        }
    }

    public String getCurrentStateName() {
        return this.m_rootLayer == null ? null : this.m_rootLayer.getCurrentStateName();
    }

    public boolean containsState(String string) {
        return this.animSet != null && this.animSet.containsState(string);
    }

    public void SetState(String string) {
        this.SetState(string, PZArrayList.emptyList());
    }

    public void SetState(String string2, List<String> list) {
        if (this.animSet == null) {
            DebugLog.Animation.error("(" + string2 + ") Cannot set state. AnimSet is null.");
            return;
        }
        if (!this.animSet.containsState(string2)) {
            DebugLog.Animation.error("State not found: " + string2);
        }
        this.m_rootLayer.TransitionTo(this.animSet.GetState(string2), false);
        PZArrayUtil.forEach(this.m_subLayers, subLayerSlot -> {
            subLayerSlot.shouldBeActive = false;
        });
        Lambda.forEachFrom(PZArrayUtil::forEach, list, this, (string, advancedAnimator) -> {
            SubLayerSlot subLayerSlot = advancedAnimator.getOrCreateSlot((String)string);
            subLayerSlot.transitionTo(advancedAnimator.animSet.GetState((String)string), false);
        });
        PZArrayUtil.forEach(this.m_subLayers, SubLayerSlot::applyTransition);
    }

    protected SubLayerSlot getOrCreateSlot(String string) {
        SubLayerSlot subLayerSlot;
        int n;
        SubLayerSlot subLayerSlot2 = null;
        int n2 = this.m_subLayers.size();
        for (n = 0; n < n2; ++n) {
            subLayerSlot = this.m_subLayers.get(n);
            if (!subLayerSlot.animLayer.isCurrentState(string)) continue;
            subLayerSlot2 = subLayerSlot;
            break;
        }
        if (subLayerSlot2 != null) {
            return subLayerSlot2;
        }
        n2 = this.m_subLayers.size();
        for (n = 0; n < n2; ++n) {
            subLayerSlot = this.m_subLayers.get(n);
            if (!subLayerSlot.animLayer.isStateless()) continue;
            subLayerSlot2 = subLayerSlot;
            break;
        }
        if (subLayerSlot2 != null) {
            return subLayerSlot2;
        }
        SubLayerSlot subLayerSlot3 = new SubLayerSlot(this.m_rootLayer, this.character, this);
        this.m_subLayers.add(subLayerSlot3);
        return subLayerSlot3;
    }

    public void update() {
        GameProfiler.getInstance().invokeAndMeasure("AdvancedAnimator.Update", this, AdvancedAnimator::updateInternal);
    }

    private void updateInternal() {
        AnimLayer[] animLayerArray;
        int n;
        if (this.character.getAnimationPlayer() == null) {
            return;
        }
        if (!this.character.getAnimationPlayer().isReady()) {
            return;
        }
        if (this.animSet == null) {
            return;
        }
        if (!this.m_rootLayer.hasState()) {
            this.m_rootLayer.TransitionTo(this.animSet.GetState("Idle"), true);
        }
        this.m_rootLayer.Update();
        for (n = 0; n < this.m_subLayers.size(); ++n) {
            animLayerArray = this.m_subLayers.get(n);
            animLayerArray.update();
        }
        if (this.debugMonitor != null && this.character instanceof IsoGameCharacter) {
            n = 1 + this.getActiveSubLayerCount();
            animLayerArray = new AnimLayer[n];
            animLayerArray[0] = this.m_rootLayer;
            n = 0;
            for (int i = 0; i < this.m_subLayers.size(); ++i) {
                SubLayerSlot subLayerSlot = this.m_subLayers.get(i);
                if (!subLayerSlot.shouldBeActive) continue;
                animLayerArray[1 + n] = subLayerSlot.animLayer;
                ++n;
            }
            this.debugMonitor.update((IsoGameCharacter)this.character, animLayerArray);
        }
    }

    public void render() {
        if (this.character.getAnimationPlayer() == null) {
            return;
        }
        if (!this.character.getAnimationPlayer().isReady()) {
            return;
        }
        if (this.animSet == null) {
            return;
        }
        if (!this.m_rootLayer.hasState()) {
            return;
        }
        this.m_rootLayer.render();
    }

    public void printDebugCharacterActions(String string) {
        AnimState animState;
        if (this.animSet != null && (animState = this.animSet.GetState("actions")) != null) {
            boolean bl = false;
            boolean bl2 = false;
            for (CharacterActionAnims characterActionAnims : CharacterActionAnims.values()) {
                String string2;
                bl = false;
                if (characterActionAnims == CharacterActionAnims.None) {
                    string2 = string;
                    bl = true;
                } else {
                    string2 = characterActionAnims.toString();
                }
                boolean bl3 = false;
                for (AnimNode animNode : animState.m_Nodes) {
                    for (AnimCondition animCondition : animNode.m_Conditions) {
                        if (animCondition.m_Type != AnimCondition.Type.STRING || !animCondition.m_Name.toLowerCase().equals("performingaction") || !animCondition.m_StringValue.equalsIgnoreCase(string2)) continue;
                        bl3 = true;
                        break;
                    }
                    if (!bl3) continue;
                    break;
                }
                if (bl3) {
                    if (!bl) continue;
                    bl2 = true;
                    continue;
                }
                DebugLog.log("WARNING: did not find node with condition 'PerformingAction = " + string2 + "' in player/actions/");
            }
            if (bl2) {
                if (DebugLog.isEnabled(DebugType.Animation)) {
                    DebugLog.Animation.debugln("SUCCESS - Current 'actions' TargetNode: '" + string + "' was found.");
                }
            } else if (DebugLog.isEnabled(DebugType.Animation)) {
                DebugLog.Animation.debugln("FAIL - Current 'actions' TargetNode: '" + string + "' not found.");
            }
        }
    }

    public ArrayList<String> debugGetVariables() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.animSet != null) {
            for (Map.Entry<String, AnimState> entry : this.animSet.states.entrySet()) {
                AnimState animState = entry.getValue();
                for (AnimNode animNode : animState.m_Nodes) {
                    for (AnimCondition animCondition : animNode.m_Conditions) {
                        if (animCondition.m_Name == null || arrayList.contains(animCondition.m_Name.toLowerCase())) continue;
                        arrayList.add(animCondition.m_Name.toLowerCase());
                    }
                }
            }
        }
        return arrayList;
    }

    public AnimatorDebugMonitor getDebugMonitor() {
        return this.debugMonitor;
    }

    public void setDebugMonitor(AnimatorDebugMonitor animatorDebugMonitor) {
        this.debugMonitor = animatorDebugMonitor;
    }

    public IAnimatable getCharacter() {
        return this.character;
    }

    public void updateSpeedScale(String string, float f) {
        if (this.m_rootLayer != null) {
            List<LiveAnimNode> list = this.m_rootLayer.getLiveAnimNodes();
            for (int i = 0; i < list.size(); ++i) {
                LiveAnimNode liveAnimNode = list.get(i);
                if (!liveAnimNode.isActive() || liveAnimNode.getSourceNode() == null || !string.equals(liveAnimNode.getSourceNode().m_SpeedScaleVariable)) continue;
                liveAnimNode.getSourceNode().m_SpeedScale = "" + f;
                for (int j = 0; j < liveAnimNode.m_AnimationTracks.size(); ++j) {
                    liveAnimNode.m_AnimationTracks.get((int)j).SpeedDelta = f;
                }
            }
        }
    }

    public boolean containsAnyIdleNodes() {
        int n;
        if (this.m_rootLayer == null) {
            return false;
        }
        boolean bl = false;
        List<LiveAnimNode> list = this.m_rootLayer.getLiveAnimNodes();
        for (n = 0; n < list.size() && !bl; ++n) {
            bl = list.get(n).isIdleAnimActive();
        }
        for (n = 0; n < this.getSubLayerCount(); ++n) {
            AnimLayer animLayer = this.getSubLayerAt(n);
            list = animLayer.getLiveAnimNodes();
            for (int i = 0; i < list.size() && (bl = list.get(i).isIdleAnimActive()); ++i) {
            }
        }
        return bl;
    }

    public AnimLayer getRootLayer() {
        return this.m_rootLayer;
    }

    public int getSubLayerCount() {
        return this.m_subLayers.size();
    }

    public AnimLayer getSubLayerAt(int n) {
        return this.m_subLayers.get((int)n).animLayer;
    }

    public int getActiveSubLayerCount() {
        int n = 0;
        for (int i = 0; i < this.m_subLayers.size(); ++i) {
            SubLayerSlot subLayerSlot = this.m_subLayers.get(i);
            if (!subLayerSlot.shouldBeActive) continue;
            ++n;
        }
        return n;
    }

    public void setRecorder(AnimationPlayerRecorder animationPlayerRecorder) {
        this.m_recorder = animationPlayerRecorder;
    }

    public boolean isRecording() {
        return this.m_recorder != null && this.m_recorder.isRecording();
    }

    public static class SubLayerSlot {
        public boolean shouldBeActive = false;
        public final AnimLayer animLayer;

        public SubLayerSlot(AnimLayer animLayer, IAnimatable iAnimatable, IAnimEventCallback iAnimEventCallback) {
            this.animLayer = new AnimLayer(animLayer, iAnimatable, iAnimEventCallback);
        }

        public void update() {
            this.animLayer.Update();
        }

        public void transitionTo(AnimState animState, boolean bl) {
            this.animLayer.TransitionTo(animState, bl);
            this.shouldBeActive = animState != null;
        }

        public void applyTransition() {
            if (!this.shouldBeActive) {
                this.transitionTo(null, false);
            }
        }
    }
}

