/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel;

public final class Vector3 {
    private float x;
    private float y;
    private float z;

    public Vector3() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Vector3(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public Vector3(Vector3 vector3) {
        this.set(vector3);
    }

    public float x() {
        return this.x;
    }

    public Vector3 x(float f) {
        this.x = f;
        return this;
    }

    public float y() {
        return this.y;
    }

    public Vector3 y(float f) {
        this.y = f;
        return this;
    }

    public float z() {
        return this.z;
    }

    public Vector3 z(float f) {
        this.z = f;
        return this;
    }

    public Vector3 set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        return this;
    }

    public Vector3 set(Vector3 vector3) {
        return this.set(vector3.x(), vector3.y(), vector3.z());
    }

    public Vector3 reset() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        return this;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vector3 normalize() {
        float f = this.length();
        this.x /= f;
        this.y /= f;
        this.z /= f;
        return this;
    }

    public float dot(Vector3 vector3) {
        return this.x * vector3.x + this.y * vector3.y + this.z * vector3.z;
    }

    public Vector3 cross(Vector3 vector3) {
        return new Vector3(this.y() * vector3.z() - vector3.y() * this.z(), vector3.z() * this.x() - this.z() * vector3.x(), this.x() * vector3.y() - vector3.x() * this.y());
    }

    public Vector3 add(float f, float f2, float f3) {
        this.x += f;
        this.y += f2;
        this.z += f3;
        return this;
    }

    public Vector3 add(Vector3 vector3) {
        return this.add(vector3.x(), vector3.y(), vector3.z());
    }

    public Vector3 sub(float f, float f2, float f3) {
        this.x -= f;
        this.y -= f2;
        this.z -= f3;
        return this;
    }

    public Vector3 sub(Vector3 vector3) {
        return this.sub(vector3.x(), vector3.y(), vector3.z());
    }

    public Vector3 mul(float f) {
        return this.mul(f, f, f);
    }

    public Vector3 mul(float f, float f2, float f3) {
        this.x *= f;
        this.y *= f2;
        this.z *= f3;
        return this;
    }

    public Vector3 mul(Vector3 vector3) {
        return this.mul(vector3.x(), vector3.y(), vector3.z());
    }
}

