/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel;

import java.nio.FloatBuffer;
import org.lwjglx.BufferUtils;
import zombie.core.skinnedmodel.Vector3;

public class Matrix4 {
    private FloatBuffer matrix = FloatBuffer.allocate(16);
    public static Matrix4 Identity = new Matrix4();
    private FloatBuffer direct;

    public Matrix4() {
    }

    public Matrix4(float[] fArray) {
        this();
        this.put(fArray);
    }

    public Matrix4(Matrix4 matrix4) {
        this();
        this.put(matrix4);
    }

    public Matrix4 clear() {
        for (int i = 0; i < 16; ++i) {
            this.matrix.put(i, 0.0f);
        }
        return this;
    }

    public Matrix4 clearToIdentity() {
        return this.clear().put(0, 1.0f).put(5, 1.0f).put(10, 1.0f).put(15, 1.0f);
    }

    public Matrix4 clearToOrtho(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.clear().put(0, 2.0f / (f2 - f)).put(5, 2.0f / (f4 - f3)).put(10, -2.0f / (f6 - f5)).put(12, -(f2 + f) / (f2 - f)).put(13, -(f4 + f3) / (f4 - f3)).put(14, -(f6 + f5) / (f6 - f5)).put(15, 1.0f);
    }

    public Matrix4 clearToPerspective(float f, float f2, float f3, float f4, float f5) {
        float f6 = 1.0f / (float)Math.tan(f / 2.0f);
        return this.clear().put(0, f6 / (f2 / f3)).put(5, f6).put(10, (f5 + f4) / (f4 - f5)).put(14, 2.0f * f5 * f4 / (f4 - f5)).put(11, -1.0f);
    }

    public float get(int n) {
        return this.matrix.get(n);
    }

    public Matrix4 put(int n, float f) {
        this.matrix.put(n, f);
        return this;
    }

    public Matrix4 put(int n, Vector3 vector3, float f) {
        this.put(n * 4 + 0, vector3.x());
        this.put(n * 4 + 1, vector3.y());
        this.put(n * 4 + 2, vector3.z());
        this.put(n * 4 + 3, f);
        return this;
    }

    public Matrix4 put(float[] fArray) {
        if (fArray.length < 16) {
            throw new IllegalArgumentException("float array must have at least 16 values.");
        }
        this.matrix.position(0);
        this.matrix.put(fArray, 0, 16);
        return this;
    }

    public Matrix4 put(Matrix4 matrix4) {
        FloatBuffer floatBuffer = matrix4.getBuffer();
        while (floatBuffer.hasRemaining()) {
            this.matrix.put(floatBuffer.get());
        }
        return this;
    }

    public Matrix4 mult(float[] fArray) {
        float[] fArray2 = new float[16];
        for (int i = 0; i < 16; i += 4) {
            fArray2[i + 0] = this.get(0) * fArray[i] + this.get(4) * fArray[i + 1] + this.get(8) * fArray[i + 2] + this.get(12) * fArray[i + 3];
            fArray2[i + 1] = this.get(1) * fArray[i] + this.get(5) * fArray[i + 1] + this.get(9) * fArray[i + 2] + this.get(13) * fArray[i + 3];
            fArray2[i + 2] = this.get(2) * fArray[i] + this.get(6) * fArray[i + 1] + this.get(10) * fArray[i + 2] + this.get(14) * fArray[i + 3];
            fArray2[i + 3] = this.get(3) * fArray[i] + this.get(7) * fArray[i + 1] + this.get(11) * fArray[i + 2] + this.get(15) * fArray[i + 3];
        }
        this.put(fArray2);
        return this;
    }

    public Matrix4 mult(Matrix4 matrix4) {
        float[] fArray = new float[16];
        for (int i = 0; i < 16; i += 4) {
            fArray[i + 0] = this.get(0) * matrix4.get(i) + this.get(4) * matrix4.get(i + 1) + this.get(8) * matrix4.get(i + 2) + this.get(12) * matrix4.get(i + 3);
            fArray[i + 1] = this.get(1) * matrix4.get(i) + this.get(5) * matrix4.get(i + 1) + this.get(9) * matrix4.get(i + 2) + this.get(13) * matrix4.get(i + 3);
            fArray[i + 2] = this.get(2) * matrix4.get(i) + this.get(6) * matrix4.get(i + 1) + this.get(10) * matrix4.get(i + 2) + this.get(14) * matrix4.get(i + 3);
            fArray[i + 3] = this.get(3) * matrix4.get(i) + this.get(7) * matrix4.get(i + 1) + this.get(11) * matrix4.get(i + 2) + this.get(15) * matrix4.get(i + 3);
        }
        this.put(fArray);
        return this;
    }

    public Matrix4 transpose() {
        float f = this.get(1);
        this.put(1, this.get(4));
        this.put(4, f);
        f = this.get(2);
        this.put(2, this.get(8));
        this.put(8, f);
        f = this.get(3);
        this.put(3, this.get(12));
        this.put(12, f);
        f = this.get(7);
        this.put(7, this.get(13));
        this.put(13, f);
        f = this.get(11);
        this.put(11, this.get(14));
        this.put(14, f);
        f = this.get(6);
        this.put(6, this.get(9));
        this.put(9, f);
        return this;
    }

    public Matrix4 translate(float f, float f2, float f3) {
        float[] fArray = new float[16];
        fArray[0] = 1.0f;
        fArray[5] = 1.0f;
        fArray[10] = 1.0f;
        fArray[15] = 1.0f;
        fArray[12] = f;
        fArray[13] = f2;
        fArray[14] = f3;
        return this.mult(fArray);
    }

    public Matrix4 translate(Vector3 vector3) {
        return this.translate(vector3.x(), vector3.y(), vector3.z());
    }

    public Matrix4 scale(float f, float f2, float f3) {
        float[] fArray = new float[16];
        fArray[0] = f;
        fArray[5] = f2;
        fArray[10] = f3;
        fArray[15] = 1.0f;
        return this.mult(fArray);
    }

    public Matrix4 scale(Vector3 vector3) {
        return this.scale(vector3.x(), vector3.y(), vector3.z());
    }

    public Matrix4 rotate(float f, float f2, float f3, float f4) {
        float f5 = (float)Math.cos(f);
        float f6 = (float)Math.sin(f);
        float f7 = 1.0f - f5;
        Vector3 vector3 = new Vector3(f2, f3, f4).normalize();
        float[] fArray = new float[16];
        fArray[0] = vector3.x() * vector3.x() + (1.0f - vector3.x() * vector3.x()) * f5;
        fArray[4] = vector3.x() * vector3.y() * f7 - vector3.z() * f6;
        fArray[8] = vector3.x() * vector3.z() * f7 + vector3.y() * f6;
        fArray[1] = vector3.y() * vector3.x() * f7 + vector3.z() * f6;
        fArray[5] = vector3.y() * vector3.y() + (1.0f - vector3.y() * vector3.y()) * f5;
        fArray[9] = vector3.y() * vector3.z() * f7 - vector3.x() * f6;
        fArray[2] = vector3.z() * vector3.x() * f7 - vector3.y() * f6;
        fArray[6] = vector3.z() * vector3.y() * f7 + vector3.x() * f6;
        fArray[10] = vector3.z() * vector3.z() + (1.0f - vector3.z() * vector3.z()) * f5;
        fArray[15] = 1.0f;
        return this.mult(fArray);
    }

    public Matrix4 rotate(float f, Vector3 vector3) {
        return this.rotate(f, vector3.x(), vector3.y(), vector3.z());
    }

    public FloatBuffer getBuffer() {
        if (this.direct == null) {
            this.direct = BufferUtils.createFloatBuffer((int)16);
        }
        this.direct.clear();
        this.direct.put(this.matrix.position(16).flip());
        this.direct.flip();
        return this.direct;
    }

    static {
        Identity.clearToIdentity();
    }
}

