/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Stack;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.vector.Matrix4f;
import zombie.characters.AttachedItems.AttachedModelName;
import zombie.characters.AttachedItems.AttachedModelNames;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.ImmutableColor;
import zombie.core.SpriteRenderer;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.core.opengl.RenderThread;
import zombie.core.skinnedmodel.CharacterTextures;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.advancedanimation.AnimatedModel;
import zombie.core.skinnedmodel.population.ClothingItem;
import zombie.core.skinnedmodel.visual.HumanVisual;
import zombie.core.skinnedmodel.visual.IHumanVisual;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureDraw;
import zombie.core.textures.TextureFBO;
import zombie.debug.DebugOptions;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoObjectPicker;
import zombie.iso.Vector2;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoMannequin;
import zombie.popman.ObjectPool;
import zombie.util.StringUtils;
import zombie.vehicles.UI3DScene;

public final class DeadBodyAtlas {
    public static final int ATLAS_SIZE = 1024;
    private TextureFBO fbo;
    public static final DeadBodyAtlas instance = new DeadBodyAtlas();
    private static final Vector2 tempVector2 = new Vector2();
    private final HashMap<String, BodyTexture> EntryMap = new HashMap();
    private final ArrayList<Atlas> AtlasList = new ArrayList();
    private final BodyParams bodyParams = new BodyParams();
    private int updateCounter = -1;
    private final Checksummer checksummer = new Checksummer();
    private static final Stack<RenderJob> JobPool = new Stack();
    private final DebugDrawInWorld[] debugDrawInWorld = new DebugDrawInWorld[3];
    private long debugDrawTime;
    private final ArrayList<RenderJob> RenderJobs = new ArrayList();
    private final CharacterTextureVisual characterTextureVisualFemale = new CharacterTextureVisual(true);
    private final CharacterTextureVisual characterTextureVisualMale = new CharacterTextureVisual(false);
    private final CharacterTextures characterTexturesFemale = new CharacterTextures();
    private final CharacterTextures characterTexturesMale = new CharacterTextures();
    private final ObjectPool<BodyTextureDrawer> bodyTextureDrawerPool = new ObjectPool<BodyTextureDrawer>(BodyTextureDrawer::new);

    public void lightingUpdate(int n, boolean bl) {
        if (n != this.updateCounter && bl) {
            this.updateCounter = n;
        }
    }

    public BodyTexture getBodyTexture(IsoDeadBody isoDeadBody) {
        this.bodyParams.init(isoDeadBody);
        return this.getBodyTexture(this.bodyParams);
    }

    public BodyTexture getBodyTexture(IsoZombie isoZombie) {
        this.bodyParams.init(isoZombie);
        return this.getBodyTexture(this.bodyParams);
    }

    public BodyTexture getBodyTexture(IsoMannequin isoMannequin) {
        this.bodyParams.init(isoMannequin);
        return this.getBodyTexture(this.bodyParams);
    }

    public BodyTexture getBodyTexture(boolean bl, String string, String string2, IsoDirections isoDirections, int n, float f) {
        CharacterTextures characterTextures = bl ? this.characterTexturesFemale : this.characterTexturesMale;
        BodyTexture bodyTexture = characterTextures.getTexture(string, string2, isoDirections, n);
        if (bodyTexture != null) {
            return bodyTexture;
        }
        this.bodyParams.init(bl ? this.characterTextureVisualFemale : this.characterTextureVisualMale, isoDirections, string, string2, f);
        this.bodyParams.variables.put("zombieWalkType", "1");
        BodyTexture bodyTexture2 = this.getBodyTexture(this.bodyParams);
        characterTextures.addTexture(string, string2, isoDirections, n, bodyTexture2);
        return bodyTexture2;
    }

    public BodyTexture getBodyTexture(BodyParams bodyParams) {
        String string = this.getBodyKey(bodyParams);
        BodyTexture bodyTexture = this.EntryMap.get(string);
        if (bodyTexture != null) {
            return bodyTexture;
        }
        AtlasEntry atlasEntry = new AtlasEntry();
        atlasEntry.key = string;
        atlasEntry.lightKey = this.getLightKey(bodyParams);
        atlasEntry.updateCounter = this.updateCounter;
        bodyTexture = new BodyTexture();
        bodyTexture.entry = atlasEntry;
        this.EntryMap.put(string, bodyTexture);
        this.RenderJobs.add(RenderJob.getNew().init(bodyParams, atlasEntry));
        return bodyTexture;
    }

    public void checkLights(Texture texture, IsoDeadBody isoDeadBody) {
        if (texture == null) {
            return;
        }
        BodyTexture bodyTexture = this.EntryMap.get(texture.getName());
        if (bodyTexture == null) {
            return;
        }
        AtlasEntry atlasEntry = bodyTexture.entry;
        if (atlasEntry == null || atlasEntry.tex != texture) {
            return;
        }
        if (atlasEntry.updateCounter == this.updateCounter) {
            return;
        }
        atlasEntry.updateCounter = this.updateCounter;
        this.bodyParams.init(isoDeadBody);
        String string = this.getLightKey(this.bodyParams);
        if (atlasEntry.lightKey.equals(string)) {
            return;
        }
        this.EntryMap.remove(atlasEntry.key);
        atlasEntry.key = this.getBodyKey(this.bodyParams);
        atlasEntry.lightKey = string;
        texture.setNameOnly(atlasEntry.key);
        this.EntryMap.put(atlasEntry.key, bodyTexture);
        RenderJob renderJob = RenderJob.getNew().init(this.bodyParams, atlasEntry);
        renderJob.bClearThisSlotOnly = true;
        this.RenderJobs.add(renderJob);
        this.render();
    }

    public void checkLights(Texture texture, IsoZombie isoZombie) {
        if (texture == null) {
            return;
        }
        BodyTexture bodyTexture = this.EntryMap.get(texture.getName());
        if (bodyTexture == null) {
            return;
        }
        AtlasEntry atlasEntry = bodyTexture.entry;
        if (atlasEntry == null || atlasEntry.tex != texture) {
            return;
        }
        if (atlasEntry.updateCounter == this.updateCounter) {
            return;
        }
        atlasEntry.updateCounter = this.updateCounter;
        this.bodyParams.init(isoZombie);
        String string = this.getLightKey(this.bodyParams);
        if (atlasEntry.lightKey.equals(string)) {
            return;
        }
        this.EntryMap.remove(atlasEntry.key);
        atlasEntry.key = this.getBodyKey(this.bodyParams);
        atlasEntry.lightKey = string;
        texture.setNameOnly(atlasEntry.key);
        this.EntryMap.put(atlasEntry.key, bodyTexture);
        RenderJob renderJob = RenderJob.getNew().init(this.bodyParams, atlasEntry);
        renderJob.bClearThisSlotOnly = true;
        this.RenderJobs.add(renderJob);
        this.render();
    }

    private void assignEntryToAtlas(AtlasEntry atlasEntry, int n, int n2) {
        if (atlasEntry.atlas != null) {
            return;
        }
        for (int i = 0; i < this.AtlasList.size(); ++i) {
            Atlas atlas = this.AtlasList.get(i);
            if (atlas.isFull() || atlas.ENTRY_WID != n || atlas.ENTRY_HGT != n2) continue;
            atlas.addEntry(atlasEntry);
            return;
        }
        Atlas atlas = new Atlas(1024, 1024, n, n2);
        atlas.addEntry(atlasEntry);
        this.AtlasList.add(atlas);
    }

    private String getBodyKey(BodyParams bodyParams) {
        if (bodyParams.humanVisual == this.characterTextureVisualFemale.humanVisual) {
            return "SZF_" + bodyParams.animSetName + "_" + bodyParams.stateName + "_" + bodyParams.dir + "_" + bodyParams.trackTime;
        }
        if (bodyParams.humanVisual == this.characterTextureVisualMale.humanVisual) {
            return "SZM_" + bodyParams.animSetName + "_" + bodyParams.stateName + "_" + bodyParams.dir + "_" + bodyParams.trackTime;
        }
        try {
            this.checksummer.reset();
            HumanVisual humanVisual = bodyParams.humanVisual;
            this.checksummer.update((byte)bodyParams.dir.index());
            this.checksummer.update((int)(PZMath.wrap(bodyParams.angle, 0.0f, (float)Math.PI * 2) * 57.295776f));
            this.checksummer.update(humanVisual.getHairModel());
            this.checksummer.update(humanVisual.getBeardModel());
            this.checksummer.update(humanVisual.getSkinColor());
            this.checksummer.update(humanVisual.getSkinTexture());
            this.checksummer.update((int)(humanVisual.getTotalBlood() * 100.0f));
            this.checksummer.update(bodyParams.primaryHandItem);
            this.checksummer.update(bodyParams.secondaryHandItem);
            for (int i = 0; i < bodyParams.attachedModelNames.size(); ++i) {
                AttachedModelName attachedModelName = bodyParams.attachedModelNames.get(i);
                this.checksummer.update(attachedModelName.attachmentNameSelf);
                this.checksummer.update(attachedModelName.attachmentNameParent);
                this.checksummer.update(attachedModelName.modelName);
                this.checksummer.update((int)(attachedModelName.bloodLevel * 100.0f));
            }
            this.checksummer.update(bodyParams.bFemale);
            this.checksummer.update(bodyParams.bZombie);
            this.checksummer.update(bodyParams.bSkeleton);
            this.checksummer.update(bodyParams.animSetName);
            this.checksummer.update(bodyParams.stateName);
            ItemVisuals itemVisuals = bodyParams.itemVisuals;
            for (int i = 0; i < itemVisuals.size(); ++i) {
                ItemVisual itemVisual = (ItemVisual)itemVisuals.get(i);
                ClothingItem clothingItem = itemVisual.getClothingItem();
                if (clothingItem == null) continue;
                this.checksummer.update(itemVisual.getBaseTexture(clothingItem));
                this.checksummer.update(itemVisual.getTextureChoice(clothingItem));
                this.checksummer.update(itemVisual.getTint(clothingItem));
                this.checksummer.update(clothingItem.getModel(humanVisual.isFemale()));
                this.checksummer.update((int)(itemVisual.getTotalBlood() * 100.0f));
            }
            this.checksummer.update(bodyParams.fallOnFront);
            this.checksummer.update(bodyParams.bStanding);
            this.checksummer.update(bodyParams.bOutside);
            this.checksummer.update(bodyParams.bRoom);
            float f = (float)((int)(bodyParams.ambient.r * 10.0f)) / 10.0f;
            this.checksummer.update((byte)(f * 255.0f));
            float f2 = (float)((int)(bodyParams.ambient.g * 10.0f)) / 10.0f;
            this.checksummer.update((byte)(f2 * 255.0f));
            float f3 = (float)((int)(bodyParams.ambient.b * 10.0f)) / 10.0f;
            this.checksummer.update((byte)(f3 * 255.0f));
            this.checksummer.update((int)bodyParams.trackTime);
            for (int i = 0; i < bodyParams.lights.length; ++i) {
                this.checksummer.update(bodyParams.lights[i], bodyParams.x, bodyParams.y, bodyParams.z);
            }
            return this.checksummer.checksumToString();
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
            return "bogus";
        }
    }

    private String getLightKey(BodyParams bodyParams) {
        try {
            this.checksummer.reset();
            this.checksummer.update(bodyParams.bOutside);
            this.checksummer.update(bodyParams.bRoom);
            float f = (float)((int)(bodyParams.ambient.r * 10.0f)) / 10.0f;
            this.checksummer.update((byte)(f * 255.0f));
            float f2 = (float)((int)(bodyParams.ambient.g * 10.0f)) / 10.0f;
            this.checksummer.update((byte)(f2 * 255.0f));
            float f3 = (float)((int)(bodyParams.ambient.b * 10.0f)) / 10.0f;
            this.checksummer.update((byte)(f3 * 255.0f));
            for (int i = 0; i < bodyParams.lights.length; ++i) {
                this.checksummer.update(bodyParams.lights[i], bodyParams.x, bodyParams.y, bodyParams.z);
            }
            return this.checksummer.checksumToString();
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
            return "bogus";
        }
    }

    public void render() {
        Object object;
        int n;
        for (n = 0; n < this.AtlasList.size(); ++n) {
            object = this.AtlasList.get(n);
            if (!((Atlas)object).clear) continue;
            SpriteRenderer.instance.drawGeneric(new ClearAtlasTexture((Atlas)object));
        }
        if (this.RenderJobs.isEmpty()) {
            return;
        }
        for (n = 0; n < this.RenderJobs.size(); ++n) {
            object = this.RenderJobs.get(n);
            if (((RenderJob)object).done == 1 && ((RenderJob)object).renderRefCount > 0) continue;
            if (((RenderJob)object).done == 1 && ((RenderJob)object).renderRefCount == 0) {
                this.RenderJobs.remove(n--);
                assert (!JobPool.contains(object));
                JobPool.push((RenderJob)object);
                continue;
            }
            if (!((RenderJob)object).renderMain()) continue;
            ++((RenderJob)object).renderRefCount;
            SpriteRenderer.instance.drawGeneric((TextureDraw.GenericDrawer)object);
        }
    }

    public void renderDebug() {
        if (Core.bDebug && DebugOptions.instance.DeadBodyAtlasRender.getValue()) {
            int n;
            if (JobPool.isEmpty()) {
                return;
            }
            if (((RenderJob)DeadBodyAtlas.JobPool.get((int)(DeadBodyAtlas.JobPool.size() - 1))).entry.atlas == null) {
                return;
            }
            if (this.debugDrawInWorld[0] == null) {
                for (n = 0; n < this.debugDrawInWorld.length; ++n) {
                    this.debugDrawInWorld[n] = new DebugDrawInWorld();
                }
            }
            n = SpriteRenderer.instance.getMainStateIndex();
            long l = System.currentTimeMillis();
            if (l - this.debugDrawTime < 500L) {
                RenderJob renderJob = JobPool.pop();
                renderJob.done = 0;
                renderJob.bClearThisSlotOnly = true;
                this.RenderJobs.add(renderJob);
            } else if (l - this.debugDrawTime < 1000L) {
                RenderJob renderJob = JobPool.pop();
                renderJob.done = 0;
                renderJob.renderMain();
                this.debugDrawInWorld[n].init(renderJob);
                SpriteRenderer.instance.drawGeneric(this.debugDrawInWorld[n]);
            } else {
                this.debugDrawTime = l;
            }
        }
    }

    public void renderUI() {
        if (Core.bDebug && DebugOptions.instance.DeadBodyAtlasRender.getValue()) {
            int n = 512 / Core.TileScale;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < this.AtlasList.size(); ++i) {
                int n4;
                Atlas atlas = this.AtlasList.get(i);
                SpriteRenderer.instance.renderi(null, n2, n3, n, n, 1.0f, 1.0f, 1.0f, 0.75f, null);
                SpriteRenderer.instance.renderi(atlas.tex, n2, n3, n, n, 1.0f, 1.0f, 1.0f, 1.0f, null);
                float f = (float)n / (float)atlas.tex.getWidth();
                for (n4 = 0; n4 <= atlas.tex.getWidth() / atlas.ENTRY_WID; ++n4) {
                    SpriteRenderer.instance.renderline(null, (int)((float)n2 + (float)(n4 * atlas.ENTRY_WID) * f), n3, (int)((float)n2 + (float)(n4 * atlas.ENTRY_WID) * f), n3 + n, 0.5f, 0.5f, 0.5f, 1.0f);
                }
                for (n4 = 0; n4 <= atlas.tex.getHeight() / atlas.ENTRY_HGT; ++n4) {
                    SpriteRenderer.instance.renderline(null, n2, (int)((float)(n3 + n) - (float)(n4 * atlas.ENTRY_HGT) * f), n2 + n, (int)((float)(n3 + n) - (float)(n4 * atlas.ENTRY_HGT) * f), 0.5f, 0.5f, 0.5f, 1.0f);
                }
                if ((n3 += n) + n <= Core.getInstance().getScreenHeight()) continue;
                n3 = 0;
                n2 += n;
            }
            SpriteRenderer.instance.renderi(null, n2, n3, n, n, 1.0f, 1.0f, 1.0f, 0.5f, null);
            SpriteRenderer.instance.renderi((Texture)ModelManager.instance.bitmap.getTexture(), n2, n3, n, n, 1.0f, 1.0f, 1.0f, 1.0f, null);
        }
    }

    public void Reset() {
        if (this.fbo != null) {
            this.fbo.destroyLeaveTexture();
            this.fbo = null;
        }
        this.AtlasList.forEach(Atlas::Reset);
        this.AtlasList.clear();
        this.EntryMap.clear();
        this.characterTexturesFemale.clear();
        this.characterTexturesMale.clear();
        JobPool.forEach(RenderJob::Reset);
        JobPool.clear();
        this.RenderJobs.clear();
    }

    private void toBodyAtlas(RenderJob renderJob) {
        int n;
        int n2;
        int n3;
        int n4;
        GL11.glPushAttrib((int)2048);
        if (this.fbo.getTexture() != renderJob.entry.atlas.tex) {
            this.fbo.setTexture(renderJob.entry.atlas.tex);
        }
        this.fbo.startDrawing();
        GL11.glViewport((int)0, (int)0, (int)this.fbo.getWidth(), (int)this.fbo.getHeight());
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        int n5 = renderJob.entry.atlas.tex.getWidth();
        int n6 = renderJob.entry.atlas.tex.getHeight();
        GLU.gluOrtho2D((float)0.0f, (float)n5, (float)n6, (float)0.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3089);
        if (renderJob.entry.atlas.clear) {
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glClear((int)16640);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            renderJob.entry.atlas.clear = false;
        }
        if (renderJob.bClearThisSlotOnly) {
            GL11.glEnable((int)3089);
            GL11.glScissor((int)renderJob.entry.x, (int)(1024 - renderJob.entry.y - renderJob.entry.h), (int)renderJob.entry.w, (int)renderJob.entry.h);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glClear((int)16640);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            n4 = SpriteRenderer.instance.getRenderingPlayerIndex();
            n3 = n4 == 0 || n4 == 2 ? 0 : Core.getInstance().getOffscreenTrueWidth() / 2;
            n2 = n4 == 0 || n4 == 1 ? 0 : Core.getInstance().getOffscreenTrueHeight() / 2;
            n = Core.getInstance().getOffscreenTrueWidth();
            int n7 = Core.getInstance().getOffscreenTrueHeight();
            if (IsoPlayer.numPlayers > 1) {
                n /= 2;
            }
            if (IsoPlayer.numPlayers > 2) {
                n7 /= 2;
            }
            GL11.glScissor((int)n3, (int)n2, (int)n, (int)n7);
            GL11.glDisable((int)3089);
        }
        n4 = ModelManager.instance.bitmap.getTexture().getWidth() / 8 * Core.TileScale;
        n3 = ModelManager.instance.bitmap.getTexture().getHeight() / 8 * Core.TileScale;
        n2 = renderJob.entry.x - (n4 - renderJob.entry.atlas.ENTRY_WID) / 2;
        n = renderJob.entry.y - (n3 - renderJob.entry.atlas.ENTRY_HGT) / 2;
        ModelManager.instance.bitmap.getTexture().bind();
        GL11.glBegin((int)7);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2i((int)n2, (int)n);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2i((int)(n2 + n4), (int)n);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2i((int)(n2 + n4), (int)(n + n3));
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2i((int)n2, (int)(n + n3));
        GL11.glEnd();
        Texture.lastTextureID = 0;
        GL11.glBindTexture((int)3553, (int)0);
        this.fbo.endDrawing();
        GL11.glEnable((int)3089);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        renderJob.entry.ready = true;
        renderJob.done = 1;
    }

    private static final class BodyParams {
        HumanVisual humanVisual;
        final ItemVisuals itemVisuals = new ItemVisuals();
        IsoDirections dir;
        float angle;
        boolean bFemale;
        boolean bZombie;
        boolean bSkeleton;
        String animSetName;
        String stateName;
        final HashMap<String, String> variables = new HashMap();
        boolean bStanding;
        String primaryHandItem;
        String secondaryHandItem;
        final AttachedModelNames attachedModelNames = new AttachedModelNames();
        float x;
        float y;
        float z;
        float trackTime;
        boolean bOutside;
        boolean bRoom;
        final ColorInfo ambient = new ColorInfo();
        boolean fallOnFront = false;
        final IsoGridSquare.ResultLight[] lights = new IsoGridSquare.ResultLight[5];

        BodyParams() {
            for (int i = 0; i < this.lights.length; ++i) {
                this.lights[i] = new IsoGridSquare.ResultLight();
            }
        }

        void init(BodyParams bodyParams) {
            this.humanVisual = bodyParams.humanVisual;
            this.itemVisuals.clear();
            this.itemVisuals.addAll(bodyParams.itemVisuals);
            this.dir = bodyParams.dir;
            this.angle = bodyParams.angle;
            this.bFemale = bodyParams.bFemale;
            this.bZombie = bodyParams.bZombie;
            this.bSkeleton = bodyParams.bSkeleton;
            this.animSetName = bodyParams.animSetName;
            this.stateName = bodyParams.stateName;
            this.variables.clear();
            this.variables.putAll(bodyParams.variables);
            this.bStanding = bodyParams.bStanding;
            this.primaryHandItem = bodyParams.primaryHandItem;
            this.secondaryHandItem = bodyParams.secondaryHandItem;
            this.attachedModelNames.copyFrom(bodyParams.attachedModelNames);
            this.x = bodyParams.x;
            this.y = bodyParams.y;
            this.z = bodyParams.z;
            this.trackTime = bodyParams.trackTime;
            this.fallOnFront = bodyParams.fallOnFront;
            this.bOutside = bodyParams.bOutside;
            this.bRoom = bodyParams.bRoom;
            this.ambient.set(bodyParams.ambient.r, bodyParams.ambient.g, bodyParams.ambient.b, 1.0f);
            for (int i = 0; i < this.lights.length; ++i) {
                this.lights[i].copyFrom(bodyParams.lights[i]);
            }
        }

        void init(IsoDeadBody isoDeadBody) {
            this.humanVisual = isoDeadBody.getHumanVisual();
            isoDeadBody.getItemVisuals(this.itemVisuals);
            this.dir = isoDeadBody.dir;
            this.angle = isoDeadBody.getAngle();
            this.bFemale = isoDeadBody.isFemale();
            this.bZombie = isoDeadBody.isZombie();
            this.bSkeleton = isoDeadBody.isSkeleton();
            this.primaryHandItem = null;
            this.secondaryHandItem = null;
            this.attachedModelNames.initFrom(isoDeadBody.getAttachedItems());
            this.animSetName = "zombie";
            this.stateName = "onground";
            this.variables.clear();
            this.bStanding = false;
            if (isoDeadBody.getPrimaryHandItem() != null || isoDeadBody.getSecondaryHandItem() != null) {
                if (isoDeadBody.getPrimaryHandItem() != null && !StringUtils.isNullOrEmpty(isoDeadBody.getPrimaryHandItem().getStaticModel())) {
                    this.primaryHandItem = isoDeadBody.getPrimaryHandItem().getStaticModel();
                }
                if (isoDeadBody.getSecondaryHandItem() != null && !StringUtils.isNullOrEmpty(isoDeadBody.getSecondaryHandItem().getStaticModel())) {
                    this.secondaryHandItem = isoDeadBody.getSecondaryHandItem().getStaticModel();
                }
                this.animSetName = "player";
                this.stateName = "deadbody";
            }
            this.x = isoDeadBody.x;
            this.y = isoDeadBody.y;
            this.z = isoDeadBody.z;
            this.trackTime = 0.0f;
            this.fallOnFront = isoDeadBody.isFallOnFront();
            this.bOutside = isoDeadBody.square != null && isoDeadBody.square.isOutside();
            this.bRoom = isoDeadBody.square != null && isoDeadBody.square.getRoom() != null;
            this.initAmbient(isoDeadBody.square);
            this.initLights(isoDeadBody.square);
        }

        void init(IsoZombie isoZombie) {
            this.humanVisual = isoZombie.getHumanVisual();
            isoZombie.getItemVisuals(this.itemVisuals);
            this.dir = isoZombie.dir;
            this.angle = isoZombie.getAnimAngleRadians();
            this.bFemale = isoZombie.isFemale();
            this.bZombie = true;
            this.bSkeleton = isoZombie.isSkeleton();
            this.primaryHandItem = null;
            this.secondaryHandItem = null;
            this.attachedModelNames.initFrom(isoZombie.getAttachedItems());
            this.animSetName = "zombie";
            this.stateName = "onground";
            this.variables.clear();
            this.bStanding = false;
            this.x = isoZombie.x;
            this.y = isoZombie.y;
            this.z = isoZombie.z;
            this.trackTime = 0.0f;
            this.fallOnFront = isoZombie.isFallOnFront();
            this.bOutside = isoZombie.getCurrentSquare() != null && isoZombie.getCurrentSquare().isOutside();
            this.bRoom = isoZombie.getCurrentSquare() != null && isoZombie.getCurrentSquare().getRoom() != null;
            this.initAmbient(isoZombie.getCurrentSquare());
            this.initLights(isoZombie.getCurrentSquare());
        }

        void init(IsoMannequin isoMannequin) {
            this.humanVisual = isoMannequin.getHumanVisual();
            isoMannequin.getItemVisuals(this.itemVisuals);
            this.dir = isoMannequin.dir;
            this.angle = this.dir.ToVector().getDirection();
            this.bFemale = isoMannequin.isFemale();
            this.bZombie = isoMannequin.isZombie();
            this.bSkeleton = isoMannequin.isSkeleton();
            this.primaryHandItem = null;
            this.secondaryHandItem = null;
            this.attachedModelNames.clear();
            this.animSetName = isoMannequin.getAnimSetName();
            this.stateName = isoMannequin.getAnimStateName();
            this.variables.clear();
            isoMannequin.getVariables(this.variables);
            this.bStanding = true;
            this.x = isoMannequin.getX();
            this.y = isoMannequin.getY();
            this.z = isoMannequin.getZ();
            this.trackTime = 0.0f;
            this.fallOnFront = false;
            this.bOutside = isoMannequin.square != null && isoMannequin.square.isOutside();
            this.bRoom = isoMannequin.square != null && isoMannequin.square.getRoom() != null;
            this.initAmbient(isoMannequin.square);
            this.initLights(null);
        }

        void init(IHumanVisual iHumanVisual, IsoDirections isoDirections, String string, String string2, float f) {
            this.humanVisual = iHumanVisual.getHumanVisual();
            iHumanVisual.getItemVisuals(this.itemVisuals);
            this.dir = isoDirections;
            this.angle = isoDirections.ToVector().getDirection();
            this.bFemale = iHumanVisual.isFemale();
            this.bZombie = iHumanVisual.isZombie();
            this.bSkeleton = iHumanVisual.isSkeleton();
            this.primaryHandItem = null;
            this.secondaryHandItem = null;
            this.attachedModelNames.clear();
            this.animSetName = string;
            this.stateName = string2;
            this.variables.clear();
            this.bStanding = true;
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 0.0f;
            this.trackTime = f;
            this.fallOnFront = false;
            this.bOutside = true;
            this.bRoom = false;
            this.ambient.set(1.0f, 1.0f, 1.0f, 1.0f);
            this.initLights(null);
        }

        void initAmbient(IsoGridSquare isoGridSquare) {
            this.ambient.set(1.0f, 1.0f, 1.0f, 1.0f);
        }

        void initLights(IsoGridSquare isoGridSquare) {
            for (int i = 0; i < this.lights.length; ++i) {
                this.lights[i].radius = 0;
            }
            if (isoGridSquare != null) {
                IsoGridSquare.ILighting iLighting = isoGridSquare.lighting[0];
                int n = iLighting.resultLightCount();
                for (int i = 0; i < n; ++i) {
                    this.lights[i].copyFrom(iLighting.getResultLight(i));
                }
            }
        }

        void Reset() {
            this.humanVisual = null;
            this.itemVisuals.clear();
            Arrays.fill(this.lights, null);
        }
    }

    private static final class Checksummer {
        private MessageDigest md;
        private final StringBuilder sb = new StringBuilder();

        private Checksummer() {
        }

        public void reset() throws NoSuchAlgorithmException {
            if (this.md == null) {
                this.md = MessageDigest.getInstance("MD5");
            }
            this.md.reset();
        }

        public void update(byte by) {
            this.md.update(by);
        }

        public void update(boolean bl) {
            this.md.update((byte)(bl ? 1 : 0));
        }

        public void update(int n) {
            this.md.update((byte)(n & 0xFF));
            this.md.update((byte)(n >> 8 & 0xFF));
            this.md.update((byte)(n >> 16 & 0xFF));
            this.md.update((byte)(n >> 24 & 0xFF));
        }

        public void update(String string) {
            if (string == null || string.isEmpty()) {
                return;
            }
            this.md.update(string.getBytes());
        }

        public void update(ImmutableColor immutableColor) {
            this.update((byte)(immutableColor.r * 255.0f));
            this.update((byte)(immutableColor.g * 255.0f));
            this.update((byte)(immutableColor.b * 255.0f));
        }

        public void update(IsoGridSquare.ResultLight resultLight, float f, float f2, float f3) {
            if (resultLight == null || resultLight.radius <= 0) {
                return;
            }
            this.update((int)((float)resultLight.x - f));
            this.update((int)((float)resultLight.y - f2));
            this.update((int)((float)resultLight.z - f3));
            this.update((byte)(resultLight.r * 255.0f));
            this.update((byte)(resultLight.g * 255.0f));
            this.update((byte)(resultLight.b * 255.0f));
            this.update((byte)resultLight.radius);
        }

        public String checksumToString() {
            byte[] byArray = this.md.digest();
            this.sb.setLength(0);
            for (int i = 0; i < byArray.length; ++i) {
                this.sb.append(byArray[i] & 0xFF);
            }
            return this.sb.toString();
        }
    }

    private static final class DebugDrawInWorld
    extends TextureDraw.GenericDrawer {
        RenderJob job;
        boolean bRendered;

        private DebugDrawInWorld() {
        }

        public void init(RenderJob renderJob) {
            this.job = renderJob;
            this.bRendered = false;
        }

        @Override
        public void render() {
            this.job.animatedModel.DoRenderToWorld(this.job.body.x, this.job.body.y, this.job.body.z, this.job.m_animPlayerAngle);
            this.bRendered = true;
        }

        @Override
        public void postRender() {
            if (this.job.animatedModel == null) {
                return;
            }
            if (this.bRendered) {
                assert (!JobPool.contains(this.job));
                JobPool.push(this.job);
            } else {
                assert (!JobPool.contains(this.job));
                JobPool.push(this.job);
            }
            this.job.animatedModel.postRender(this.bRendered);
        }
    }

    private static final class CharacterTextureVisual
    implements IHumanVisual {
        final HumanVisual humanVisual = new HumanVisual(this);
        boolean bFemale;

        CharacterTextureVisual(boolean bl) {
            this.bFemale = bl;
            this.humanVisual.setHairModel("");
            this.humanVisual.setBeardModel("");
        }

        @Override
        public HumanVisual getHumanVisual() {
            return this.humanVisual;
        }

        @Override
        public void getItemVisuals(ItemVisuals itemVisuals) {
            itemVisuals.clear();
        }

        @Override
        public boolean isFemale() {
            return this.bFemale;
        }

        @Override
        public boolean isZombie() {
            return true;
        }

        @Override
        public boolean isSkeleton() {
            return false;
        }
    }

    public static final class BodyTexture {
        AtlasEntry entry;

        public void render(float f, float f2, float f3, float f4, float f5, float f6) {
            if (!this.entry.ready || !this.entry.tex.isReady()) {
                SpriteRenderer.instance.drawGeneric(DeadBodyAtlas.instance.bodyTextureDrawerPool.alloc().init(this, f, f2, f3, f4, f5, f6));
                return;
            }
            this.entry.tex.render(f - (float)this.entry.w / 2.0f - this.entry.offsetX, f2 - (float)this.entry.h / 2.0f - this.entry.offsetY, this.entry.w, this.entry.h, f3, f4, f5, f6, null);
        }

        public void renderObjectPicker(float f, float f2, ColorInfo colorInfo, IsoGridSquare isoGridSquare, IsoObject isoObject) {
            if (!this.entry.ready) {
                return;
            }
            IsoObjectPicker.Instance.Add((int)(f - (float)(this.entry.w / 2)), (int)(f2 - (float)(this.entry.h / 2)), this.entry.w, this.entry.h, isoGridSquare, isoObject, false, 1.0f, 1.0f);
        }
    }

    private static final class AtlasEntry {
        public Atlas atlas;
        public String key;
        public String lightKey;
        public int updateCounter;
        public int x;
        public int y;
        public int w;
        public int h;
        public float offsetX;
        public float offsetY;
        public Texture tex;
        public boolean ready = false;

        private AtlasEntry() {
        }

        public void Reset() {
            this.atlas = null;
            this.tex.destroy();
            this.tex = null;
            this.ready = false;
        }
    }

    private static final class RenderJob
    extends TextureDraw.GenericDrawer {
        static float SIZEV = 42.75f;
        public final BodyParams body = new BodyParams();
        public AtlasEntry entry;
        public AnimatedModel animatedModel;
        public float m_animPlayerAngle;
        public int done = 0;
        public int renderRefCount;
        public boolean bClearThisSlotOnly;
        int entryW;
        int entryH;
        final int[] m_viewport = new int[4];
        final org.joml.Matrix4f m_matri4f = new org.joml.Matrix4f();
        final org.joml.Matrix4f m_projection = new org.joml.Matrix4f();
        final org.joml.Matrix4f m_modelView = new org.joml.Matrix4f();
        final Vector3f m_scenePos = new Vector3f();
        final float[] m_bounds = new float[4];
        final float[] m_offset = new float[2];

        private RenderJob() {
        }

        public static RenderJob getNew() {
            if (JobPool.isEmpty()) {
                return new RenderJob();
            }
            return JobPool.pop();
        }

        public RenderJob init(BodyParams bodyParams, AtlasEntry atlasEntry) {
            this.body.init(bodyParams);
            this.entry = atlasEntry;
            if (this.animatedModel == null) {
                this.animatedModel = new AnimatedModel();
                this.animatedModel.setAnimate(false);
            }
            this.animatedModel.setAnimSetName(bodyParams.animSetName);
            this.animatedModel.setState(bodyParams.stateName);
            this.animatedModel.setPrimaryHandModelName(bodyParams.primaryHandItem);
            this.animatedModel.setSecondaryHandModelName(bodyParams.secondaryHandItem);
            this.animatedModel.setAttachedModelNames(bodyParams.attachedModelNames);
            this.animatedModel.setAmbient(bodyParams.ambient, bodyParams.bOutside, bodyParams.bRoom);
            this.animatedModel.setLights(bodyParams.lights, bodyParams.x, bodyParams.y, bodyParams.z);
            this.animatedModel.setModelData(bodyParams.humanVisual, bodyParams.itemVisuals);
            this.animatedModel.setAngle(tempVector2.setLengthAndDirection(bodyParams.angle, 1.0f));
            this.animatedModel.setVariable("FallOnFront", bodyParams.fallOnFront);
            bodyParams.variables.forEach((string, string2) -> this.animatedModel.setVariable((String)string, (String)string2));
            this.animatedModel.setTrackTime(bodyParams.trackTime);
            this.animatedModel.update();
            this.bClearThisSlotOnly = false;
            this.done = 0;
            this.renderRefCount = 0;
            return this;
        }

        public boolean renderMain() {
            if (this.animatedModel.isReadyToRender()) {
                this.animatedModel.renderMain();
                this.m_animPlayerAngle = this.animatedModel.getAnimationPlayer().getRenderedAngle();
                return true;
            }
            return false;
        }

        @Override
        public void render() {
            if (this.done == 1) {
                return;
            }
            GL11.glDepthMask((boolean)true);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glDisable((int)3089);
            GL11.glPushAttrib((int)2048);
            ModelManager.instance.bitmap.startDrawing(true, true);
            GL11.glViewport((int)0, (int)0, (int)ModelManager.instance.bitmap.getWidth(), (int)ModelManager.instance.bitmap.getHeight());
            this.calcModelOffset(this.m_offset);
            this.animatedModel.setOffset(this.m_offset[0], 0.0f, this.m_offset[1]);
            this.animatedModel.DoRender(0, 0, ModelManager.instance.bitmap.getTexture().getWidth(), ModelManager.instance.bitmap.getTexture().getHeight(), SIZEV, this.m_animPlayerAngle);
            if (this.animatedModel.isRendered()) {
                this.renderAABB();
            }
            ModelManager.instance.bitmap.endDrawing();
            GL11.glPopAttrib();
            if (!this.animatedModel.isRendered()) {
                return;
            }
            instance.assignEntryToAtlas(this.entry, this.entryW, this.entryH);
            instance.toBodyAtlas(this);
        }

        @Override
        public void postRender() {
            if (this.animatedModel == null) {
                return;
            }
            this.animatedModel.postRender(this.done == 1);
            assert (this.renderRefCount > 0);
            --this.renderRefCount;
        }

        void calcMatrices(org.joml.Matrix4f matrix4f, org.joml.Matrix4f matrix4f2, float f, float f2) {
            int n = ModelManager.instance.bitmap.getWidth();
            int n2 = ModelManager.instance.bitmap.getHeight();
            float f3 = SIZEV;
            float f4 = (float)n / (float)n2;
            boolean bl = true;
            matrix4f.identity();
            if (bl) {
                matrix4f.ortho(-f3 * f4, f3 * f4, f3, -f3, -100.0f, 100.0f);
            } else {
                matrix4f.ortho(-f3 * f4, f3 * f4, -f3, f3, -100.0f, 100.0f);
            }
            float f5 = (float)Math.sqrt(2048.0);
            matrix4f.scale(-f5, f5, f5);
            matrix4f2.identity();
            boolean bl2 = true;
            if (bl2) {
                matrix4f2.rotate(0.5235988f, 1.0f, 0.0f, 0.0f);
                matrix4f2.rotate(this.m_animPlayerAngle + 0.7853982f, 0.0f, 1.0f, 0.0f);
            } else {
                matrix4f2.rotate(this.m_animPlayerAngle, 0.0f, 1.0f, 0.0f);
            }
            matrix4f2.translate(f, 0.0f, f2);
        }

        void calcModelBounds(float[] fArray) {
            float f = Float.MAX_VALUE;
            float f2 = Float.MAX_VALUE;
            float f3 = -3.4028235E38f;
            float f4 = -3.4028235E38f;
            for (int i = 0; i < this.animatedModel.getAnimationPlayer().modelTransforms.length; ++i) {
                if (i == 44) continue;
                Matrix4f matrix4f = this.animatedModel.getAnimationPlayer().modelTransforms[i];
                this.sceneToUI(matrix4f.m03, matrix4f.m13, matrix4f.m23, this.m_projection, this.m_modelView, this.m_scenePos);
                f = PZMath.min(f, this.m_scenePos.x);
                f3 = PZMath.max(f3, this.m_scenePos.x);
                f2 = PZMath.min(f2, this.m_scenePos.y);
                f4 = PZMath.max(f4, this.m_scenePos.y);
            }
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray[3] = f4;
        }

        void calcModelOffset(float[] fArray) {
            int n = ModelManager.instance.bitmap.getWidth();
            int n2 = ModelManager.instance.bitmap.getHeight();
            float f = 0.0f;
            float f2 = this.body.bStanding ? -0.0f : 0.0f;
            this.calcMatrices(this.m_projection, this.m_modelView, f, f2);
            this.calcModelBounds(this.m_bounds);
            float f3 = this.m_bounds[0];
            float f4 = this.m_bounds[1];
            float f5 = this.m_bounds[2];
            float f6 = this.m_bounds[3];
            this.uiToScene(this.m_projection, this.m_modelView, f3, f4, this.m_scenePos);
            float f7 = this.m_scenePos.x;
            float f8 = this.m_scenePos.z;
            float f9 = ((float)n - (f5 - f3)) / 2.0f;
            float f10 = ((float)n2 - (f6 - f4)) / 2.0f;
            this.uiToScene(this.m_projection, this.m_modelView, f9, f10, this.m_scenePos);
            fArray[0] = 1.0f * (f += this.m_scenePos.x - f7) + 0.0f;
            fArray[1] = 1.0f * (f2 += this.m_scenePos.z - f8) + 0.0f;
            this.entry.offsetX = (f9 - f3) / (8.0f / (float)Core.TileScale);
            this.entry.offsetY = (f10 - f4) / (8.0f / (float)Core.TileScale);
        }

        void renderAABB() {
            this.calcMatrices(this.m_projection, this.m_modelView, this.m_offset[0], this.m_offset[1]);
            this.calcModelBounds(this.m_bounds);
            float f = this.m_bounds[0];
            float f2 = this.m_bounds[1];
            float f3 = this.m_bounds[2];
            float f4 = this.m_bounds[3];
            int n = ModelManager.instance.bitmap.getWidth();
            int n2 = ModelManager.instance.bitmap.getHeight();
            float f5 = 128.0f;
            f -= f5;
            f2 -= f5;
            f3 += f5;
            f4 += f5;
            f = (float)Math.floor(f / 128.0f) * 128.0f;
            f3 = (float)Math.ceil(f3 / 128.0f) * 128.0f;
            f2 = (float)Math.floor(f2 / 128.0f) * 128.0f;
            f4 = (float)Math.ceil(f4 / 128.0f) * 128.0f;
            this.entryW = (int)(f3 - f) / (8 / Core.TileScale);
            this.entryH = (int)(f4 - f2) / (8 / Core.TileScale);
        }

        UI3DScene.Ray getCameraRay(float f, float f2, org.joml.Matrix4f matrix4f, org.joml.Matrix4f matrix4f2, UI3DScene.Ray ray) {
            org.joml.Matrix4f matrix4f3 = L_getCameraRay.matrix4f;
            matrix4f3.set((Matrix4fc)matrix4f);
            matrix4f3.mul((Matrix4fc)matrix4f2);
            matrix4f3.invert();
            this.m_viewport[0] = 0;
            this.m_viewport[1] = 0;
            this.m_viewport[2] = ModelManager.instance.bitmap.getWidth();
            this.m_viewport[3] = ModelManager.instance.bitmap.getHeight();
            Vector3f vector3f = matrix4f3.unprojectInv(f, f2, 0.0f, this.m_viewport, L_getCameraRay.ray_start);
            Vector3f vector3f2 = matrix4f3.unprojectInv(f, f2, 1.0f, this.m_viewport, L_getCameraRay.ray_end);
            ray.origin.set((Vector3fc)vector3f);
            ray.direction.set((Vector3fc)vector3f2.sub((Vector3fc)vector3f).normalize());
            return ray;
        }

        Vector3f sceneToUI(float f, float f2, float f3, org.joml.Matrix4f matrix4f, org.joml.Matrix4f matrix4f2, Vector3f vector3f) {
            org.joml.Matrix4f matrix4f3 = this.m_matri4f;
            matrix4f3.set((Matrix4fc)matrix4f);
            matrix4f3.mul((Matrix4fc)matrix4f2);
            this.m_viewport[0] = 0;
            this.m_viewport[1] = 0;
            this.m_viewport[2] = ModelManager.instance.bitmap.getWidth();
            this.m_viewport[3] = ModelManager.instance.bitmap.getHeight();
            matrix4f3.project(f, f2, f3, this.m_viewport, vector3f);
            return vector3f;
        }

        Vector3f uiToScene(org.joml.Matrix4f matrix4f, org.joml.Matrix4f matrix4f2, float f, float f2, Vector3f vector3f) {
            UI3DScene.Plane plane = L_uiToScene.plane;
            plane.point.set(0.0f);
            plane.normal.set(0.0f, 1.0f, 0.0f);
            UI3DScene.Ray ray = this.getCameraRay(f, f2, matrix4f, matrix4f2, L_uiToScene.ray);
            if (UI3DScene.intersect_ray_plane(plane, ray, vector3f) != 1) {
                vector3f.set(0.0f);
            }
            return vector3f;
        }

        public void Reset() {
            this.body.Reset();
            this.entry = null;
            if (this.animatedModel != null) {
                this.animatedModel.releaseAnimationPlayer();
                this.animatedModel = null;
            }
        }

        static final class L_getCameraRay {
            static final org.joml.Matrix4f matrix4f = new org.joml.Matrix4f();
            static final Vector3f ray_start = new Vector3f();
            static final Vector3f ray_end = new Vector3f();

            L_getCameraRay() {
            }
        }

        static final class L_uiToScene {
            static final UI3DScene.Plane plane = new UI3DScene.Plane();
            static final UI3DScene.Ray ray = new UI3DScene.Ray();

            L_uiToScene() {
            }
        }
    }

    private final class Atlas {
        public final int ENTRY_WID;
        public final int ENTRY_HGT;
        public Texture tex;
        public final ArrayList<AtlasEntry> EntryList = new ArrayList();
        public boolean clear = true;

        public Atlas(int n, int n2, int n3, int n4) {
            this.ENTRY_WID = n3;
            this.ENTRY_HGT = n4;
            this.tex = new Texture(n, n2, 16);
            if (DeadBodyAtlas.this.fbo != null) {
                return;
            }
            DeadBodyAtlas.this.fbo = new TextureFBO(this.tex, false);
        }

        public boolean isFull() {
            int n = this.tex.getWidth() / this.ENTRY_WID;
            int n2 = this.tex.getHeight() / this.ENTRY_HGT;
            return this.EntryList.size() >= n * n2;
        }

        public AtlasEntry addBody(String string) {
            int n = this.tex.getWidth() / this.ENTRY_WID;
            int n2 = this.EntryList.size();
            int n3 = n2 % n;
            int n4 = n2 / n;
            AtlasEntry atlasEntry = new AtlasEntry();
            atlasEntry.atlas = this;
            atlasEntry.key = string;
            atlasEntry.x = n3 * this.ENTRY_WID;
            atlasEntry.y = n4 * this.ENTRY_HGT;
            atlasEntry.w = this.ENTRY_WID;
            atlasEntry.h = this.ENTRY_HGT;
            atlasEntry.tex = this.tex.split(string, atlasEntry.x, this.tex.getHeight() - (atlasEntry.y + this.ENTRY_HGT), atlasEntry.w, atlasEntry.h);
            atlasEntry.tex.setName(string);
            this.EntryList.add(atlasEntry);
            return atlasEntry;
        }

        public void addEntry(AtlasEntry atlasEntry) {
            int n = this.tex.getWidth() / this.ENTRY_WID;
            int n2 = this.EntryList.size();
            int n3 = n2 % n;
            int n4 = n2 / n;
            atlasEntry.atlas = this;
            atlasEntry.x = n3 * this.ENTRY_WID;
            atlasEntry.y = n4 * this.ENTRY_HGT;
            atlasEntry.w = this.ENTRY_WID;
            atlasEntry.h = this.ENTRY_HGT;
            atlasEntry.tex = this.tex.split(atlasEntry.key, atlasEntry.x, this.tex.getHeight() - (atlasEntry.y + this.ENTRY_HGT), atlasEntry.w, atlasEntry.h);
            atlasEntry.tex.setName(atlasEntry.key);
            this.EntryList.add(atlasEntry);
        }

        public void Reset() {
            this.EntryList.forEach(AtlasEntry::Reset);
            this.EntryList.clear();
            if (!this.tex.isDestroyed()) {
                RenderThread.invokeOnRenderContext(() -> GL11.glDeleteTextures((int)this.tex.getID()));
            }
            this.tex = null;
        }
    }

    private static final class ClearAtlasTexture
    extends TextureDraw.GenericDrawer {
        Atlas m_atlas;

        ClearAtlasTexture(Atlas atlas) {
            this.m_atlas = atlas;
        }

        @Override
        public void render() {
            TextureFBO textureFBO = DeadBodyAtlas.instance.fbo;
            if (textureFBO == null || this.m_atlas.tex == null) {
                return;
            }
            if (!this.m_atlas.clear) {
                return;
            }
            if (textureFBO.getTexture() != this.m_atlas.tex) {
                textureFBO.setTexture(this.m_atlas.tex);
            }
            textureFBO.startDrawing(false, false);
            GL11.glPushAttrib((int)2048);
            GL11.glViewport((int)0, (int)0, (int)textureFBO.getWidth(), (int)textureFBO.getHeight());
            GL11.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            int n = this.m_atlas.tex.getWidth();
            int n2 = this.m_atlas.tex.getHeight();
            GLU.gluOrtho2D((float)0.0f, (float)n, (float)n2, (float)0.0f);
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glDisable((int)3089);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glClear((int)16640);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            textureFBO.endDrawing();
            GL11.glEnable((int)3089);
            GL11.glMatrixMode((int)5889);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glPopMatrix();
            GL11.glPopAttrib();
            this.m_atlas.clear = false;
        }
    }

    private static final class BodyTextureDrawer
    extends TextureDraw.GenericDrawer {
        BodyTexture bodyTexture;
        float x;
        float y;
        float r;
        float g;
        float b;
        float a;

        private BodyTextureDrawer() {
        }

        BodyTextureDrawer init(BodyTexture bodyTexture, float f, float f2, float f3, float f4, float f5, float f6) {
            this.bodyTexture = bodyTexture;
            this.x = f;
            this.y = f2;
            this.r = f3;
            this.g = f4;
            this.b = f5;
            this.a = f6;
            return this;
        }

        @Override
        public void render() {
            AtlasEntry atlasEntry = this.bodyTexture.entry;
            if (!atlasEntry.ready || !atlasEntry.tex.isReady()) {
                return;
            }
            int n = (int)(this.x - (float)atlasEntry.w / 2.0f - atlasEntry.offsetX);
            int n2 = (int)(this.y - (float)atlasEntry.h / 2.0f - atlasEntry.offsetY);
            int n3 = atlasEntry.w;
            int n4 = atlasEntry.h;
            atlasEntry.tex.bind();
            GL11.glBegin((int)7);
            GL11.glColor4f((float)this.r, (float)this.g, (float)this.b, (float)this.a);
            GL11.glTexCoord2f((float)atlasEntry.tex.xStart, (float)atlasEntry.tex.yStart);
            GL11.glVertex2i((int)n, (int)n2);
            GL11.glTexCoord2f((float)atlasEntry.tex.xEnd, (float)atlasEntry.tex.yStart);
            GL11.glVertex2i((int)(n + n3), (int)n2);
            GL11.glTexCoord2f((float)atlasEntry.tex.xEnd, (float)atlasEntry.tex.yEnd);
            GL11.glVertex2i((int)(n + n3), (int)(n2 + n4));
            GL11.glTexCoord2f((float)atlasEntry.tex.xStart, (float)atlasEntry.tex.yEnd);
            GL11.glVertex2i((int)n, (int)(n2 + n4));
            GL11.glEnd();
            SpriteRenderer.ringBuffer.restoreBoundTextures = true;
        }

        @Override
        public void postRender() {
            this.bodyTexture = null;
            DeadBodyAtlas.instance.bodyTextureDrawerPool.release(this);
        }
    }
}

