/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.raknet;

import fmod.FMODSoundBuffer;
import fmod.FMOD_DriverInfo;
import fmod.FMOD_RESULT;
import fmod.fmod.FMODManager;
import fmod.javafmod;
import fmod.javafmodJNI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import se.krka.kahlua.vm.JavaFunction;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.LuaCallFrame;
import se.krka.kahlua.vm.Platform;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.RakVoice;
import zombie.core.raknet.UdpConnection;
import zombie.core.raknet.VoiceDebug;
import zombie.core.raknet.VoiceManagerData;
import zombie.debug.DebugLog;
import zombie.debug.LogSeverity;
import zombie.input.GameKeyboard;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.Radio;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoUtils;
import zombie.iso.objects.IsoRadio;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.network.FakeClientManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.MPStatistics;
import zombie.network.PacketTypes;
import zombie.network.ServerOptions;
import zombie.radio.devices.DeviceData;
import zombie.vehicles.VehiclePart;

public class VoiceManager {
    private static final int FMOD_SOUND_MODE = FMODManager.FMOD_OPENUSER | FMODManager.FMOD_LOOP_NORMAL | FMODManager.FMOD_CREATESTREAM;
    public static final int modePPT = 1;
    public static final int modeVAD = 2;
    public static final int modeMute = 3;
    public static final int VADModeQuality = 1;
    public static final int VADModeLowBitrate = 2;
    public static final int VADModeAggressive = 3;
    public static final int VADModeVeryAggressive = 4;
    public static final int AGCModeAdaptiveAnalog = 1;
    public static final int AGCModeAdaptiveDigital = 2;
    public static final int AGCModeFixedDigital = 3;
    private static final int bufferSize = 192;
    private static final int complexity = 1;
    private static boolean serverVOIPEnable = true;
    private static int sampleRate = 16000;
    private static int period = 300;
    private static int buffering = 8000;
    private static float minDistance;
    private static float maxDistance;
    private static boolean is3D;
    private boolean isEnable = true;
    private boolean isModeVAD = false;
    private boolean isModePPT = false;
    private int vadMode = 3;
    private int agcMode = 2;
    private int volumeMic;
    private int volumePlayers;
    public static boolean VoipDisabled;
    private boolean isServer;
    private static FMODSoundBuffer FMODReceiveBuffer;
    private int FMODVoiceRecordDriverId;
    private long FMODChannelGroup = 0L;
    private long FMODRecordSound = 0L;
    private Semaphore recDevSemaphore;
    private boolean initialiseRecDev = false;
    private boolean initialisedRecDev = false;
    private long indicatorIsVoice = 0L;
    private Thread thread;
    private boolean bQuit;
    private long timeLast;
    private boolean isDebug = false;
    private boolean isDebugLoopback = false;
    private boolean isDebugLoopbackLong = false;
    public static VoiceManager instance;
    byte[] buf = new byte[192];
    private final Object notifier = new Object();
    private boolean bIsClient = false;
    private boolean bTestingMicrophone = false;
    private long testingMicrophoneMS = 0L;
    private final Long recBuf_Current_read = new Long(0L);
    private static long timestamp;

    public static VoiceManager getInstance() {
        return instance;
    }

    public void DeinitRecSound() {
        this.initialisedRecDev = false;
        if (this.FMODRecordSound != 0L) {
            javafmod.FMOD_RecordSound_Release((long)this.FMODRecordSound);
            this.FMODRecordSound = 0L;
        }
        FMODReceiveBuffer = null;
    }

    public void ResetRecSound() {
        int n;
        if (this.initialisedRecDev && this.FMODRecordSound != 0L && (n = javafmod.FMOD_System_RecordStop((int)this.FMODVoiceRecordDriverId)) != FMOD_RESULT.FMOD_OK.ordinal()) {
            DebugLog.Voice.warn("FMOD_System_RecordStop result=%d", n);
        }
        this.DeinitRecSound();
        this.FMODRecordSound = javafmod.FMOD_System_CreateRecordSound((long)this.FMODVoiceRecordDriverId, (long)(FMODManager.FMOD_2D | FMODManager.FMOD_OPENUSER | FMODManager.FMOD_SOFTWARE), (long)FMODManager.FMOD_SOUND_FORMAT_PCM16, (long)sampleRate, (int)this.agcMode);
        if (this.FMODRecordSound == 0L) {
            DebugLog.Voice.warn("FMOD_System_CreateSound result=%d", this.FMODRecordSound);
        }
        javafmod.FMOD_System_SetRecordVolume((long)(1L - Math.round(Math.pow(1.4, 11 - this.volumeMic))));
        if (this.initialiseRecDev && (n = javafmod.FMOD_System_RecordStart((int)this.FMODVoiceRecordDriverId, (long)this.FMODRecordSound, (boolean)true)) != FMOD_RESULT.FMOD_OK.ordinal()) {
            DebugLog.Voice.warn("FMOD_System_RecordStart result=%d", n);
        }
        javafmod.FMOD_System_SetVADMode((int)(this.vadMode - 1));
        FMODReceiveBuffer = new FMODSoundBuffer(this.FMODRecordSound);
        this.initialisedRecDev = true;
    }

    public void VoiceRestartClient(boolean bl) {
        if (GameClient.connection != null) {
            if (bl) {
                this.loadConfig();
                this.VoiceConnectReq(GameClient.connection.getConnectedGUID());
            } else {
                this.threadSafeCode(this::DeinitRecSound);
                this.VoiceConnectClose(GameClient.connection.getConnectedGUID());
                this.loadConfig();
            }
        } else {
            this.loadConfig();
            if (bl) {
                this.InitRecDeviceForTest();
            } else {
                this.threadSafeCode(this::DeinitRecSound);
            }
        }
    }

    void VoiceInitClient() {
        this.isServer = false;
        this.recDevSemaphore = new Semaphore(1);
        FMODReceiveBuffer = null;
        RakVoice.RVInit(192);
        RakVoice.SetComplexity(1);
    }

    void VoiceInitServer(boolean bl, int n, int n2, int n3, int n4, double d, double d2, boolean bl2) {
        this.isServer = true;
        if (!(n2 == 2 | n2 == 5 | n2 == 10 | n2 == 20 | n2 == 40 | n2 == 60)) {
            DebugLog.Voice.error("Invalid period=%d", n2);
            return;
        }
        if (!(n == 8000 | n == 16000 | n == 24000)) {
            DebugLog.Voice.error("Invalid sample rate=%d", n);
            return;
        }
        if (n3 < 0 | n3 > 10) {
            DebugLog.Voice.error("Invalid quality=%d", n3);
            return;
        }
        if (n4 < 0 | n4 > 32000) {
            DebugLog.Voice.error("Invalid buffering=%d", n4);
            return;
        }
        sampleRate = n;
        RakVoice.RVInitServer(bl, n, n2, n3, n4, (float)d, (float)d2, bl2);
    }

    void VoiceConnectAccept(long l) {
        if (this.isEnable) {
            DebugLog.Voice.debugln("uuid=%x", l);
        }
    }

    void InitRecDeviceForTest() {
        this.threadSafeCode(this::ResetRecSound);
    }

    void VoiceOpenChannelReply(long l, ByteBuffer byteBuffer) {
        if (this.isEnable) {
            DebugLog.Voice.debugln("uuid=%d", l);
            if (this.isServer) {
                return;
            }
            try {
                if (GameClient.bClient) {
                    serverVOIPEnable = byteBuffer.getInt() != 0;
                    sampleRate = byteBuffer.getInt();
                    period = byteBuffer.getInt();
                    byteBuffer.getInt();
                    buffering = byteBuffer.getInt();
                    minDistance = byteBuffer.getFloat();
                    maxDistance = byteBuffer.getFloat();
                    is3D = byteBuffer.getInt() != 0;
                } else {
                    serverVOIPEnable = RakVoice.GetServerVOIPEnable();
                    sampleRate = RakVoice.GetSampleRate();
                    period = RakVoice.GetSendFramePeriod();
                    buffering = RakVoice.GetBuffering();
                    minDistance = RakVoice.GetMinDistance();
                    maxDistance = RakVoice.GetMaxDistance();
                    is3D = RakVoice.GetIs3D();
                }
            }
            catch (Exception exception) {
                DebugLog.Voice.printException(exception, "RakVoice params set failed", LogSeverity.Error);
                return;
            }
            DebugLog.Voice.debugln("enabled=%b, sample-rate=%d, period=%d, complexity=%d, buffering=%d, is3D=%b", serverVOIPEnable, sampleRate, period, 1, buffering, is3D);
            try {
                this.recDevSemaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            int n = is3D ? FMODManager.FMOD_3D | FMOD_SOUND_MODE : FMOD_SOUND_MODE;
            for (VoiceManagerData voiceManagerData : VoiceManagerData.data) {
                if (voiceManagerData.userplaysound == 0L) continue;
                javafmod.FMOD_Sound_SetMode((long)voiceManagerData.userplaysound, (int)n);
            }
            long l2 = javafmod.FMOD_System_SetRawPlayBufferingPeriod((long)buffering);
            if (l2 != (long)FMOD_RESULT.FMOD_OK.ordinal()) {
                DebugLog.Voice.warn("FMOD_System_SetRawPlayBufferingPeriod result=%d", l2);
            }
            this.ResetRecSound();
            this.recDevSemaphore.release();
            if (this.isDebug) {
                VoiceDebug.createAndShowGui();
            }
        }
    }

    public void VoiceConnectReq(long l) {
        if (this.isEnable) {
            DebugLog.Voice.debugln("uuid=%x", l);
            VoiceManagerData.data.clear();
            RakVoice.RequestVoiceChannel(l);
        }
    }

    public void VoiceConnectClose(long l) {
        if (this.isEnable) {
            DebugLog.Voice.debugln("uuid=%x", l);
            RakVoice.CloseVoiceChannel(l);
        }
    }

    public void setMode(int n) {
        if (n == 3) {
            this.isModeVAD = false;
            this.isModePPT = false;
        } else if (n == 1) {
            this.isModeVAD = false;
            this.isModePPT = true;
        } else if (n == 2) {
            this.isModeVAD = true;
            this.isModePPT = false;
        }
    }

    public void setVADMode(int n) {
        if (n < 1 | n > 4) {
            return;
        }
        this.vadMode = n;
        if (!this.initialisedRecDev) {
            return;
        }
        this.threadSafeCode(() -> javafmod.FMOD_System_SetVADMode((int)(this.vadMode - 1)));
    }

    public void setAGCMode(int n) {
        if (n < 1 | n > 3) {
            return;
        }
        this.agcMode = n;
        if (!this.initialisedRecDev) {
            return;
        }
        this.threadSafeCode(this::ResetRecSound);
    }

    public void setVolumePlayers(int n) {
        if (n < 0 | n > 11) {
            return;
        }
        this.volumePlayers = n <= 10 ? n : 12;
        if (!this.initialisedRecDev) {
            return;
        }
        ArrayList<VoiceManagerData> arrayList = VoiceManagerData.data;
        for (int i = 0; i < arrayList.size(); ++i) {
            VoiceManagerData voiceManagerData = arrayList.get(i);
            if (voiceManagerData == null || voiceManagerData.userplaychannel == 0L) continue;
            javafmod.FMOD_Channel_SetVolume((long)voiceManagerData.userplaychannel, (float)((float)((double)this.volumePlayers * 0.2)));
        }
    }

    public void setVolumeMic(int n) {
        if (n < 0 | n > 11) {
            return;
        }
        this.volumeMic = n <= 10 ? n : 12;
        if (!this.initialisedRecDev) {
            return;
        }
        this.threadSafeCode(() -> javafmod.FMOD_System_SetRecordVolume((long)(1L - Math.round(Math.pow(1.4, 11 - this.volumeMic)))));
    }

    public static void playerSetMute(String string) {
        ArrayList<IsoPlayer> arrayList = GameClient.instance.getPlayers();
        for (int i = 0; i < arrayList.size(); ++i) {
            IsoPlayer isoPlayer = arrayList.get(i);
            if (!string.equals(isoPlayer.username)) continue;
            VoiceManagerData voiceManagerData = VoiceManagerData.get(isoPlayer.OnlineID);
            isoPlayer.isVoiceMute = voiceManagerData.userplaymute = !voiceManagerData.userplaymute;
            break;
        }
    }

    public static boolean playerGetMute(String string) {
        ArrayList<IsoPlayer> arrayList = GameClient.instance.getPlayers();
        for (int i = 0; i < arrayList.size(); ++i) {
            IsoPlayer isoPlayer = arrayList.get(i);
            if (!string.equals(isoPlayer.username)) continue;
            boolean bl = VoiceManagerData.get((short)isoPlayer.OnlineID).userplaymute;
            return bl;
        }
        return true;
    }

    public void LuaRegister(Platform platform, KahluaTable kahluaTable) {
        KahluaTable kahluaTable2 = platform.newTable();
        kahluaTable2.rawset((Object)"playerSetMute", (Object)new JavaFunction(){

            public int call(LuaCallFrame luaCallFrame, int n) {
                Object object = luaCallFrame.get(1);
                VoiceManager.playerSetMute((String)object);
                return 1;
            }
        });
        kahluaTable2.rawset((Object)"playerGetMute", (Object)new JavaFunction(){

            public int call(LuaCallFrame luaCallFrame, int n) {
                Object object = luaCallFrame.get(1);
                luaCallFrame.push((Object)VoiceManager.playerGetMute((String)object));
                return 1;
            }
        });
        kahluaTable2.rawset((Object)"RecordDevices", (Object)new JavaFunction(){

            public int call(LuaCallFrame luaCallFrame, int n) {
                if (Core.SoundDisabled || VoipDisabled) {
                    KahluaTable kahluaTable = luaCallFrame.getPlatform().newTable();
                    luaCallFrame.push((Object)kahluaTable);
                    return 1;
                }
                int n2 = javafmod.FMOD_System_GetRecordNumDrivers();
                KahluaTable kahluaTable = luaCallFrame.getPlatform().newTable();
                for (int i = 0; i < n2; ++i) {
                    FMOD_DriverInfo fMOD_DriverInfo = new FMOD_DriverInfo();
                    javafmod.FMOD_System_GetRecordDriverInfo((int)i, (FMOD_DriverInfo)fMOD_DriverInfo);
                    kahluaTable.rawset(i + 1, (Object)fMOD_DriverInfo.name);
                }
                luaCallFrame.push((Object)kahluaTable);
                return 1;
            }
        });
        kahluaTable.rawset((Object)"VoiceManager", (Object)kahluaTable2);
    }

    private void setUserPlaySound(long l, float f) {
        f = IsoUtils.clamp(f * IsoUtils.lerp(this.volumePlayers, 0.0f, 12.0f), 0.0f, 1.0f);
        javafmod.FMOD_Channel_SetVolume((long)l, (float)f);
    }

    private long getUserPlaySound(short s) {
        VoiceManagerData voiceManagerData = VoiceManagerData.get(s);
        if (voiceManagerData.userplaychannel == 0L) {
            voiceManagerData.userplaysound = 0L;
            int n = is3D ? FMODManager.FMOD_3D | FMOD_SOUND_MODE : FMOD_SOUND_MODE;
            voiceManagerData.userplaysound = javafmod.FMOD_System_CreateRAWPlaySound((long)n, (long)FMODManager.FMOD_SOUND_FORMAT_PCM16, (long)sampleRate);
            if (voiceManagerData.userplaysound == 0L) {
                DebugLog.Voice.warn("FMOD_System_CreateSound result=%d", voiceManagerData.userplaysound);
            }
            voiceManagerData.userplaychannel = javafmod.FMOD_System_PlaySound((long)voiceManagerData.userplaysound, (boolean)false);
            if (voiceManagerData.userplaychannel == 0L) {
                DebugLog.Voice.warn("FMOD_System_PlaySound result=%d", voiceManagerData.userplaychannel);
            }
            javafmod.FMOD_Channel_SetVolume((long)voiceManagerData.userplaychannel, (float)((float)((double)this.volumePlayers * 0.2)));
            if (is3D) {
                javafmod.FMOD_Channel_Set3DMinMaxDistance((long)voiceManagerData.userplaychannel, (float)(minDistance / 2.0f), (float)maxDistance);
            }
            javafmod.FMOD_Channel_SetChannelGroup((long)voiceManagerData.userplaychannel, (long)this.FMODChannelGroup);
        }
        return voiceManagerData.userplaysound;
    }

    public void InitVMClient() {
        if (Core.SoundDisabled || VoipDisabled) {
            this.isEnable = false;
            this.initialiseRecDev = false;
            this.initialisedRecDev = false;
            DebugLog.Voice.debugln("Disabled");
            return;
        }
        int n = javafmod.FMOD_System_GetRecordNumDrivers();
        this.FMODVoiceRecordDriverId = Core.getInstance().getOptionVoiceRecordDevice() - 1;
        if (this.FMODVoiceRecordDriverId < 0 && n > 0) {
            Core.getInstance().setOptionVoiceRecordDevice(1);
            this.FMODVoiceRecordDriverId = Core.getInstance().getOptionVoiceRecordDevice() - 1;
        }
        if (n < 1) {
            DebugLog.Voice.debugln("Microphone not found");
            this.initialiseRecDev = false;
        } else if (this.FMODVoiceRecordDriverId < 0 | this.FMODVoiceRecordDriverId >= n) {
            DebugLog.Voice.warn("Invalid record device");
            this.initialiseRecDev = false;
        } else {
            this.initialiseRecDev = true;
        }
        this.isEnable = Core.getInstance().getOptionVoiceEnable();
        this.setMode(Core.getInstance().getOptionVoiceMode());
        this.vadMode = Core.getInstance().getOptionVoiceVADMode();
        this.volumeMic = Core.getInstance().getOptionVoiceVolumeMic();
        this.volumePlayers = Core.getInstance().getOptionVoiceVolumePlayers();
        this.FMODChannelGroup = javafmod.FMOD_System_CreateChannelGroup((String)"VOIP");
        this.VoiceInitClient();
        this.FMODRecordSound = 0L;
        if (this.isEnable) {
            this.InitRecDeviceForTest();
        }
        if (this.isDebug) {
            VoiceDebug.createAndShowGui();
        }
        this.timeLast = System.currentTimeMillis();
        this.bQuit = false;
        this.thread = new Thread(){

            @Override
            public void run() {
                while (!VoiceManager.this.bQuit) {
                    try {
                        VoiceManager.this.UpdateVMClient();
                        4.sleep(period / 2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        };
        this.thread.setName("VoiceManagerClient");
        this.thread.start();
    }

    public void loadConfig() {
        this.isEnable = Core.getInstance().getOptionVoiceEnable();
        this.setMode(Core.getInstance().getOptionVoiceMode());
        this.vadMode = Core.getInstance().getOptionVoiceVADMode();
        this.volumeMic = Core.getInstance().getOptionVoiceVolumeMic();
        this.volumePlayers = Core.getInstance().getOptionVoiceVolumePlayers();
    }

    public void UpdateRecordDevice() {
        if (!this.initialisedRecDev) {
            return;
        }
        this.threadSafeCode(this::UpdateRecordDeviceInternal);
    }

    private void UpdateRecordDeviceInternal() {
        int n = javafmod.FMOD_System_RecordStop((int)this.FMODVoiceRecordDriverId);
        if (n != FMOD_RESULT.FMOD_OK.ordinal()) {
            DebugLog.Voice.warn("FMOD_System_RecordStop result=%d", n);
        }
        this.FMODVoiceRecordDriverId = Core.getInstance().getOptionVoiceRecordDevice() - 1;
        if (this.FMODVoiceRecordDriverId < 0) {
            DebugLog.Voice.error("No record device found");
            return;
        }
        n = javafmod.FMOD_System_RecordStart((int)this.FMODVoiceRecordDriverId, (long)this.FMODRecordSound, (boolean)true);
        if (n != FMOD_RESULT.FMOD_OK.ordinal()) {
            DebugLog.Voice.warn("FMOD_System_RecordStart result=%d", n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DeinitVMClient() {
        Object object;
        if (this.thread != null) {
            this.bQuit = true;
            object = this.notifier;
            synchronized (object) {
                this.notifier.notify();
            }
            while (this.thread.isAlive()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.thread = null;
        }
        this.DeinitRecSound();
        object = VoiceManagerData.data;
        for (int i = 0; i < ((ArrayList)object).size(); ++i) {
            VoiceManagerData voiceManagerData = (VoiceManagerData)((ArrayList)object).get(i);
            if (voiceManagerData.userplaychannel != 0L) {
                javafmod.FMOD_Channel_Stop((long)voiceManagerData.userplaychannel);
            }
            if (voiceManagerData.userplaysound == 0L) continue;
            javafmod.FMOD_RAWPlaySound_Release((long)voiceManagerData.userplaysound);
            voiceManagerData.userplaysound = 0L;
        }
        VoiceManagerData.data.clear();
    }

    public void setTestingMicrophone(boolean bl) {
        if (bl) {
            this.testingMicrophoneMS = System.currentTimeMillis();
        }
        if (bl != this.bTestingMicrophone) {
            this.bTestingMicrophone = bl;
            this.notifyThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyThread() {
        Object object = this.notifier;
        synchronized (object) {
            this.notifier.notify();
        }
    }

    public void update() {
        long l;
        if (GameServer.bServer) {
            return;
        }
        if (this.bTestingMicrophone && (l = System.currentTimeMillis()) - this.testingMicrophoneMS > 1000L) {
            this.setTestingMicrophone(false);
        }
        if (GameClient.bClient && GameClient.connection != null || FakeClientManager.isVOIPEnabled()) {
            if (!this.bIsClient) {
                this.bIsClient = true;
                this.notifyThread();
            }
        } else if (this.bIsClient) {
            this.bIsClient = false;
            this.notifyThread();
        }
    }

    private float getCanHearAllVolume(float f) {
        return f > minDistance ? IsoUtils.clamp(1.0f - IsoUtils.lerp(f, minDistance, maxDistance), 0.2f, 1.0f) : 1.0f;
    }

    private void threadSafeCode(Runnable runnable) {
        while (true) {
            try {
                this.recDevSemaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        try {
            runnable.run();
        }
        finally {
            this.recDevSemaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void UpdateVMClient() throws InterruptedException {
        long l;
        int n;
        ArrayList<IsoPlayer> arrayList;
        while (!(this.bQuit || this.bIsClient || this.bTestingMicrophone)) {
            arrayList = this.notifier;
            synchronized (arrayList) {
                try {
                    this.notifier.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (!serverVOIPEnable) {
            return;
        }
        if (IsoPlayer.getInstance() != null) {
            boolean bl = IsoPlayer.getInstance().isSpeek = System.currentTimeMillis() - this.indicatorIsVoice <= 300L;
        }
        if (this.initialiseRecDev) {
            this.recDevSemaphore.acquire();
            javafmod.FMOD_System_GetRecordPosition((int)this.FMODVoiceRecordDriverId, (Long)this.recBuf_Current_read);
            if (FMODReceiveBuffer != null) {
                while (FMODReceiveBuffer.pull(this.recBuf_Current_read.longValue())) {
                    if (IsoPlayer.getInstance() != null && GameClient.connection != null || FakeClientManager.isVOIPEnabled()) {
                        if (is3D && IsoPlayer.getInstance().isDead()) continue;
                        if (this.isModePPT) {
                            if (GameKeyboard.isKeyDown(Core.getInstance().getKey("Enable voice transmit"))) {
                                RakVoice.SendFrame(GameClient.connection.connectedGUID, IsoPlayer.getInstance().OnlineID, FMODReceiveBuffer.buf(), FMODReceiveBuffer.get_size());
                                this.indicatorIsVoice = System.currentTimeMillis();
                            } else if (FakeClientManager.isVOIPEnabled()) {
                                RakVoice.SendFrame(FakeClientManager.getConnectedGUID(), FakeClientManager.getOnlineID(), FMODReceiveBuffer.buf(), FMODReceiveBuffer.get_size());
                                this.indicatorIsVoice = System.currentTimeMillis();
                            }
                        }
                        if (this.isModeVAD && FMODReceiveBuffer.get_vad() != 0L) {
                            RakVoice.SendFrame(GameClient.connection.connectedGUID, IsoPlayer.getInstance().OnlineID, FMODReceiveBuffer.buf(), FMODReceiveBuffer.get_size());
                            this.indicatorIsVoice = System.currentTimeMillis();
                        }
                    }
                    if (this.isDebug) {
                        if (GameClient.IDToPlayerMap.values().size() > 0) {
                            VoiceDebug.updateGui(null, FMODReceiveBuffer);
                        } else if (this.isDebugLoopback) {
                            VoiceDebug.updateGui(null, FMODReceiveBuffer);
                        } else {
                            VoiceDebug.updateGui(null, FMODReceiveBuffer);
                        }
                    }
                    if (!this.isDebugLoopback) continue;
                    javafmod.FMOD_System_RAWPlayData((long)this.getUserPlaySound((short)0), (byte[])FMODReceiveBuffer.buf(), (long)FMODReceiveBuffer.get_size());
                }
            }
            this.recDevSemaphore.release();
        }
        arrayList = GameClient.instance.getPlayers();
        ArrayList<VoiceManagerData> arrayList2 = VoiceManagerData.data;
        for (int i = 0; i < arrayList2.size(); ++i) {
            VoiceManagerData voiceManagerData = arrayList2.get(i);
            boolean bl = false;
            for (n = 0; n < arrayList.size(); ++n) {
                IsoPlayer isoPlayer = arrayList.get(n);
                if (isoPlayer.OnlineID != voiceManagerData.index) continue;
                bl = true;
                break;
            }
            if (this.isDebugLoopback & voiceManagerData.index == 0) break;
            if (!(voiceManagerData.userplaychannel != 0L & !bl)) continue;
            javafmod.FMOD_Channel_Stop((long)voiceManagerData.userplaychannel);
            voiceManagerData.userplaychannel = 0L;
        }
        if ((l = System.currentTimeMillis() - this.timeLast) >= (long)period) {
            this.timeLast += l;
            if (IsoPlayer.getInstance() == null) {
                return;
            }
            VoiceManagerData.VoiceDataSource voiceDataSource = VoiceManagerData.VoiceDataSource.Unknown;
            n = 0;
            for (IsoPlayer isoPlayer : arrayList) {
                IsoPlayer isoPlayer2;
                if (isoPlayer == (isoPlayer2 = IsoPlayer.getInstance()) || isoPlayer.getOnlineID() == -1) continue;
                VoiceManagerData voiceManagerData = VoiceManagerData.get(isoPlayer.getOnlineID());
                while (RakVoice.ReceiveFrame(isoPlayer.getOnlineID(), this.buf)) {
                    voiceManagerData.voicetimeout = 10L;
                    if (voiceManagerData.userplaymute) continue;
                    float f = IsoUtils.DistanceTo(isoPlayer2.getX(), isoPlayer2.getY(), isoPlayer.getX(), isoPlayer.getY());
                    if (isoPlayer2.isCanHearAll()) {
                        javafmodJNI.FMOD_Channel_Set3DLevel((long)voiceManagerData.userplaychannel, (float)0.0f);
                        javafmod.FMOD_Channel_Set3DAttributes((long)voiceManagerData.userplaychannel, (float)isoPlayer2.x, (float)isoPlayer2.y, (float)isoPlayer2.z, (float)0.0f, (float)0.0f, (float)0.0f);
                        this.setUserPlaySound(voiceManagerData.userplaychannel, this.getCanHearAllVolume(f));
                        voiceDataSource = VoiceManagerData.VoiceDataSource.Cheat;
                        n = 0;
                    } else {
                        VoiceManagerData.RadioData radioData = this.checkForNearbyRadios(voiceManagerData);
                        if (radioData != null && radioData.deviceData != null) {
                            javafmodJNI.FMOD_Channel_Set3DLevel((long)voiceManagerData.userplaychannel, (float)0.0f);
                            javafmod.FMOD_Channel_Set3DAttributes((long)voiceManagerData.userplaychannel, (float)isoPlayer2.x, (float)isoPlayer2.y, (float)isoPlayer2.z, (float)0.0f, (float)0.0f, (float)0.0f);
                            this.setUserPlaySound(voiceManagerData.userplaychannel, radioData.deviceData.getDeviceVolume());
                            radioData.deviceData.doReceiveMPSignal(radioData.lastReceiveDistance);
                            voiceDataSource = VoiceManagerData.VoiceDataSource.Radio;
                            n = radioData.freq;
                        } else {
                            if (radioData == null) {
                                javafmodJNI.FMOD_Channel_Set3DLevel((long)voiceManagerData.userplaychannel, (float)0.0f);
                                javafmod.FMOD_Channel_Set3DAttributes((long)voiceManagerData.userplaychannel, (float)isoPlayer2.x, (float)isoPlayer2.y, (float)isoPlayer2.z, (float)0.0f, (float)0.0f, (float)0.0f);
                                javafmod.FMOD_Channel_SetVolume((long)voiceManagerData.userplaychannel, (float)0.0f);
                                voiceDataSource = VoiceManagerData.VoiceDataSource.Unknown;
                            } else {
                                if (is3D) {
                                    javafmodJNI.FMOD_Channel_Set3DLevel((long)voiceManagerData.userplaychannel, (float)IsoUtils.lerp(f, 0.0f, minDistance));
                                    javafmod.FMOD_Channel_Set3DAttributes((long)voiceManagerData.userplaychannel, (float)isoPlayer.x, (float)isoPlayer.y, (float)isoPlayer.z, (float)0.0f, (float)0.0f, (float)0.0f);
                                } else {
                                    javafmodJNI.FMOD_Channel_Set3DLevel((long)voiceManagerData.userplaychannel, (float)0.0f);
                                    javafmod.FMOD_Channel_Set3DAttributes((long)voiceManagerData.userplaychannel, (float)isoPlayer2.x, (float)isoPlayer2.y, (float)isoPlayer2.z, (float)0.0f, (float)0.0f, (float)0.0f);
                                }
                                this.setUserPlaySound(voiceManagerData.userplaychannel, IsoUtils.smoothstep(maxDistance, minDistance, radioData.lastReceiveDistance));
                                voiceDataSource = VoiceManagerData.VoiceDataSource.Voice;
                            }
                            n = 0;
                            if (f > maxDistance) {
                                VoiceManager.logFrame(isoPlayer2, isoPlayer, f);
                            }
                        }
                    }
                    javafmod.FMOD_System_RAWPlayData((long)this.getUserPlaySound(isoPlayer.getOnlineID()), (byte[])this.buf, (long)this.buf.length);
                    if (!this.isDebugLoopbackLong) continue;
                    RakVoice.SendFrame(GameClient.connection.connectedGUID, isoPlayer2.getOnlineID(), this.buf, this.buf.length);
                }
                if (voiceManagerData.voicetimeout == 0L) {
                    isoPlayer.isSpeek = false;
                    continue;
                }
                --voiceManagerData.voicetimeout;
                isoPlayer.isSpeek = true;
            }
            MPStatistics.setVOIPSource(voiceDataSource, n);
        }
    }

    private static void logFrame(IsoPlayer isoPlayer, IsoPlayer isoPlayer2, float f) {
        long l = System.currentTimeMillis();
        if (l > timestamp) {
            timestamp = l + 5000L;
            DebugLog.Multiplayer.warn(String.format("\"%s\" (%b) received VOIP frame from \"%s\" (%b) at distance=%f", isoPlayer.getUsername(), isoPlayer.isCanHearAll(), isoPlayer2.getUsername(), isoPlayer2.isCanHearAll(), Float.valueOf(f)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VoiceManagerData.RadioData checkForNearbyRadios(VoiceManagerData voiceManagerData) {
        IsoPlayer isoPlayer = IsoPlayer.getInstance();
        VoiceManagerData voiceManagerData2 = VoiceManagerData.get(isoPlayer.OnlineID);
        if (voiceManagerData2.isCanHearAll) {
            voiceManagerData2.radioData.get((int)0).lastReceiveDistance = 0.0f;
            return voiceManagerData2.radioData.get(0);
        }
        ArrayList<VoiceManagerData.RadioData> arrayList = voiceManagerData2.radioData;
        synchronized (arrayList) {
            for (int i = 1; i < voiceManagerData2.radioData.size(); ++i) {
                ArrayList<VoiceManagerData.RadioData> arrayList2 = voiceManagerData.radioData;
                synchronized (arrayList2) {
                    for (int j = 1; j < voiceManagerData.radioData.size(); ++j) {
                        if (voiceManagerData2.radioData.get((int)i).freq != voiceManagerData.radioData.get((int)j).freq) continue;
                        float f = voiceManagerData2.radioData.get((int)i).x - voiceManagerData.radioData.get((int)j).x;
                        float f2 = voiceManagerData2.radioData.get((int)i).y - voiceManagerData.radioData.get((int)j).y;
                        voiceManagerData2.radioData.get((int)i).lastReceiveDistance = (float)Math.sqrt(f * f + f2 * f2);
                        if (!(voiceManagerData2.radioData.get((int)i).lastReceiveDistance < voiceManagerData.radioData.get((int)j).distance)) continue;
                        return voiceManagerData2.radioData.get(i);
                    }
                    continue;
                }
            }
        }
        arrayList = voiceManagerData2.radioData;
        synchronized (arrayList) {
            ArrayList<VoiceManagerData.RadioData> arrayList3 = voiceManagerData.radioData;
            synchronized (arrayList3) {
                if (!voiceManagerData.radioData.isEmpty() && !voiceManagerData2.radioData.isEmpty()) {
                    float f = voiceManagerData2.radioData.get((int)0).x - voiceManagerData.radioData.get((int)0).x;
                    float f3 = voiceManagerData2.radioData.get((int)0).y - voiceManagerData.radioData.get((int)0).y;
                    voiceManagerData2.radioData.get((int)0).lastReceiveDistance = (float)Math.sqrt(f * f + f3 * f3);
                    if (voiceManagerData2.radioData.get((int)0).lastReceiveDistance < voiceManagerData.radioData.get((int)0).distance) {
                        return voiceManagerData2.radioData.get(0);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void UpdateChannelsRoaming(UdpConnection udpConnection) {
        IsoPlayer isoPlayer = IsoPlayer.getInstance();
        if (isoPlayer.OnlineID == -1) {
            return;
        }
        VoiceManagerData voiceManagerData = VoiceManagerData.get(isoPlayer.OnlineID);
        boolean bl = false;
        Object object = voiceManagerData.radioData;
        synchronized (object) {
            voiceManagerData.radioData.clear();
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                int n;
                IsoPlayer object2 = IsoPlayer.players[i];
                if (object2 == null) continue;
                bl |= object2.isCanHearAll();
                voiceManagerData.radioData.add(new VoiceManagerData.RadioData(RakVoice.GetMaxDistance(), object2.x, object2.y));
                for (n = 0; n < object2.getInventory().getItems().size(); ++n) {
                    DeviceData deviceData;
                    InventoryItem inventoryItem = object2.getInventory().getItems().get(n);
                    if (!(inventoryItem instanceof Radio) || (deviceData = ((Radio)inventoryItem).getDeviceData()) == null || !deviceData.getIsTurnedOn()) continue;
                    voiceManagerData.radioData.add(new VoiceManagerData.RadioData(deviceData, object2.x, object2.y));
                }
                n = (int)object2.getX() - 4;
                while ((float)n < object2.getX() + 5.0f) {
                    int n2 = (int)object2.getY() - 4;
                    while ((float)n2 < object2.getY() + 5.0f) {
                        int n3 = (int)object2.getZ() - 1;
                        while ((float)n3 < object2.getZ() + 1.0f) {
                            IsoGridSquare isoGridSquare = IsoCell.getInstance().getGridSquare(n, n2, n3);
                            if (isoGridSquare != null) {
                                VehiclePart vehiclePart;
                                DeviceData deviceData;
                                Object object3;
                                int n4;
                                if (isoGridSquare.getObjects() != null) {
                                    for (n4 = 0; n4 < isoGridSquare.getObjects().size(); ++n4) {
                                        object3 = isoGridSquare.getObjects().get(n4);
                                        if (!(object3 instanceof IsoRadio) || (deviceData = ((IsoRadio)object3).getDeviceData()) == null || !deviceData.getIsTurnedOn()) continue;
                                        voiceManagerData.radioData.add(new VoiceManagerData.RadioData(deviceData, (float)isoGridSquare.x, (float)isoGridSquare.y));
                                    }
                                }
                                if (isoGridSquare.getWorldObjects() != null) {
                                    for (n4 = 0; n4 < isoGridSquare.getWorldObjects().size(); ++n4) {
                                        object3 = isoGridSquare.getWorldObjects().get(n4);
                                        if (((IsoWorldInventoryObject)object3).getItem() == null || !(((IsoWorldInventoryObject)object3).getItem() instanceof Radio) || (deviceData = ((Radio)((IsoWorldInventoryObject)object3).getItem()).getDeviceData()) == null || !deviceData.getIsTurnedOn()) continue;
                                        voiceManagerData.radioData.add(new VoiceManagerData.RadioData(deviceData, (float)isoGridSquare.x, (float)isoGridSquare.y));
                                    }
                                }
                                if (isoGridSquare.getVehicleContainer() != null && isoGridSquare == isoGridSquare.getVehicleContainer().getSquare() && (vehiclePart = isoGridSquare.getVehicleContainer().getPartById("Radio")) != null && (object3 = vehiclePart.getDeviceData()) != null && ((DeviceData)object3).getIsTurnedOn()) {
                                    voiceManagerData.radioData.add(new VoiceManagerData.RadioData((DeviceData)object3, (float)isoGridSquare.x, (float)isoGridSquare.y));
                                }
                            }
                            ++n3;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        object = udpConnection.startPacket();
        PacketTypes.PacketType.SyncRadioData.doPacket((ByteBufferWriter)object);
        ((ByteBufferWriter)object).putByte((byte)(bl ? 1 : 0));
        ((ByteBufferWriter)object).putInt(voiceManagerData.radioData.size() * 4);
        for (VoiceManagerData.RadioData radioData : voiceManagerData.radioData) {
            ((ByteBufferWriter)object).putInt(radioData.freq);
            ((ByteBufferWriter)object).putInt((int)radioData.distance);
            ((ByteBufferWriter)object).putInt(radioData.x);
            ((ByteBufferWriter)object).putInt(radioData.y);
        }
        PacketTypes.PacketType.SyncRadioData.send(udpConnection);
    }

    void InitVMServer() {
        this.VoiceInitServer(ServerOptions.instance.VoiceEnable.getValue(), 24000, 20, 5, 8000, ServerOptions.instance.VoiceMinDistance.getValue(), ServerOptions.instance.VoiceMaxDistance.getValue(), ServerOptions.instance.Voice3D.getValue());
    }

    public int getMicVolumeIndicator() {
        if (FMODReceiveBuffer == null) {
            return 0;
        }
        return (int)FMODReceiveBuffer.get_loudness();
    }

    public boolean getMicVolumeError() {
        if (FMODReceiveBuffer == null) {
            return true;
        }
        return FMODReceiveBuffer.get_interror();
    }

    public boolean getServerVOIPEnable() {
        return serverVOIPEnable;
    }

    public void VMServerBan(short s, boolean bl) {
        RakVoice.SetVoiceBan(s, bl);
    }

    static {
        is3D = false;
        VoipDisabled = false;
        instance = new VoiceManager();
        timestamp = 0L;
    }
}

